/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.bean;

import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.iam.bean.IdpAuthResult;
import com.xdja.pams.scms.entity.Device;
import java.util.List;

public class IdpResult {
    private boolean success;
    private Info info;
    private Error error;

    public static IdpResult success(IdpAuthResult result) {
        Info info = Info.make(result);
        return IdpResult.make(true, info, null);
    }

    public static IdpResult error(ErrorCode errorCode) {
        Error error = new Error();
        error.desc = errorCode.desc;
        error.errCode = errorCode.errCode;
        error.errMsg = errorCode.errMsg;
        return IdpResult.make(false, null, error);
    }

    private static IdpResult make(boolean success, Info info, Error error) {
        IdpResult idpResult = new IdpResult();
        idpResult.success = success;
        idpResult.info = info;
        idpResult.error = error;
        return idpResult;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public static enum ErrorCode {
        PARAM_LOSE(16385, "missing_required_parameters", "\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570"),
        PARAM_ILLEGAL(16386, "illegal_request_parameter", "\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570"),
        SERVER_INTERNAL_EXCEPTION(16388, "server_internal_exception", "\u670d\u52a1\u5185\u90e8\u5f02\u5e38"),
        VERIFY_SIGN_FAIL(16902, "verify_sign_fail", "\u9a8c\u7b7e\u5931\u8d25"),
        CERT_STATUS_ERR(16907, "cert_status_error", "\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38"),
        UNKNOWN_USER(16916, "unknown_user", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef"),
        PERSON_CARD_NOT_MATCH(16917, "personcard_not_match", "\u4eba\u5458\u5b89\u5168\u5361\u4e0d\u5339\u914d"),
        CARD_NOT_EXIT(16918, "card_not_exist", "\u5b89\u5168\u5361\u4e0d\u5b58\u5728");

        private int errCode;
        private String errMsg;
        private String desc;

        private ErrorCode(int i, String msg, String desc) {
            this.errCode = i;
            this.errMsg = msg;
            this.desc = desc;
        }

        public int getErrCode() {
            return this.errCode;
        }

        public void setErrCode(int errCode) {
            this.errCode = errCode;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static class Error {
        private Integer errCode;
        private String errMsg;
        private String desc;

        public Integer getErrCode() {
            return this.errCode;
        }

        public void setErrCode(Integer errCode) {
            this.errCode = errCode;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    public static class Info {
        private String id;
        private String name;
        private String uname;
        private String name_brief_spell;
        private String sex;
        private String mobile;
        private String code;
        private String identifier;
        private String personType;
        private String position;
        private String note;
        private String chipId;
        private String chipType;
        private String sn;
        private String imei;
        private String imsi;
        private String ecCode;

        private static Info make(IdpAuthResult result) {
            Person person;
            Info info = new Info();
            Device device = result.getDevice();
            if (device != null) {
                info.chipId = device.getHardNo();
                String localType = device.getType();
                if (localType.equals("2")) {
                    info.chipType = "2";
                }
                if (localType.equals("3")) {
                    info.chipType = "1";
                }
                if (localType.equals("4")) {
                    info.chipType = "4";
                }
                if (localType.equals("6")) {
                    info.chipType = "3";
                }
                if (localType.equals("9")) {
                    info.chipType = "5";
                }
                info.sn = device.getSn();
                info.imei = device.getImei();
                info.imsi = device.getImsi();
            }
            if ((person = result.getPerson()) != null) {
                info.id = person.getId();
                info.name = person.getName();
                info.uname = person.getName();
                info.name_brief_spell = person.getNameBriefSpell();
                String gender = person.getSex();
                info.sex = gender.equals("1") ? "1" : "2";
                List<Mobile> mobiles = result.getMobiles();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mobiles.size(); ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(mobiles.get(i).getMobile());
                }
                info.mobile = sb.toString();
                info.code = person.getCode();
                info.identifier = person.getIdentifier();
                info.personType = person.getPersonType();
                info.position = person.getPosition();
            }
            return info;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUname() {
            return this.uname;
        }

        public void setUname(String uname) {
            this.uname = uname;
        }

        public String getName_brief_spell() {
            return this.name_brief_spell;
        }

        public void setName_brief_spell(String name_brief_spell) {
            this.name_brief_spell = name_brief_spell;
        }

        public String getSex() {
            return this.sex;
        }

        public void setSex(String sex) {
            this.sex = sex;
        }

        public String getMobile() {
            return this.mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getPersonType() {
            return this.personType;
        }

        public void setPersonType(String personType) {
            this.personType = personType;
        }

        public String getPosition() {
            return this.position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public String getNote() {
            return this.note;
        }

        public void setNote(String note) {
            this.note = note;
        }

        public String getChipId() {
            return this.chipId;
        }

        public void setChipId(String chipId) {
            this.chipId = chipId;
        }

        public String getChipType() {
            return this.chipType;
        }

        public void setChipType(String chipType) {
            this.chipType = chipType;
        }

        public String getSn() {
            return this.sn;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public String getImei() {
            return this.imei;
        }

        public void setImei(String imei) {
            this.imei = imei;
        }

        public String getImsi() {
            return this.imsi;
        }

        public void setImsi(String imsi) {
            this.imsi = imsi;
        }

        public String getEcCode() {
            return this.ecCode;
        }

        public void setEcCode(String ecCode) {
            this.ecCode = ecCode;
        }
    }
}

