/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.helper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Func {
    private static Logger logger = LoggerFactory.getLogger(Func.class);
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytes2Hex(byte[] b) {
        StringBuilder s = new StringBuilder(b.length * 2);
        for (int n = 0; n < b.length; ++n) {
            s.append(bcdLookup[b[n] >>> 4 & 0xF]);
            s.append(bcdLookup[b[n] & 0xF]);
        }
        return s.toString();
    }

    public static byte[] hex2Bytes(String src) throws NumberFormatException {
        byte[] bytes = new byte[src.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(src.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static X509Certificate getCertFromB64(String b64) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        byte[] bsCert = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            bsCert = decoder.decodeBuffer(b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            cf = CertificateFactory.getInstance("X.509");
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            ((InputStream)inStream).close();
            return x509Cert;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static X509Certificate getCertFromFile(File file) {
        X509Certificate x509Cert = null;
        x509Cert = Func.getCertFromStandFile(file);
        if (x509Cert == null) {
            x509Cert = Func.getCertFromB64File(file);
        }
        return x509Cert;
    }

    private static X509Certificate getCertFromStandFile(File file) {
        CertificateFactory cf = null;
        FileInputStream fis = null;
        X509Certificate x509Cert = null;
        try {
            fis = new FileInputStream(file);
            cf = CertificateFactory.getInstance("X.509");
            x509Cert = (X509Certificate)cf.generateCertificate(fis);
            fis.close();
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromStandFile " + file.getName() + " error: " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    private static X509Certificate getCertFromB64File(File file) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            FileInputStream fis = new FileInputStream(file);
            byte[] bsCert = decoder.decodeBuffer((InputStream)fis);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            cf = CertificateFactory.getInstance("X.509");
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            ((InputStream)inStream).close();
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromB64File " + file.getName() + " error: " + e.toString());
            e.printStackTrace();
            return null;
        }
    }

    public static String certToB64(Certificate cert) {
        String certb64 = null;
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            certb64 = encoder.encode(cert.getEncoded());
        }
        catch (Exception e) {
            logger.error("certToB64 error:" + e.toString());
            e.printStackTrace();
        }
        return certb64;
    }

    public static byte[] join(byte[] a1, byte[] a2) {
        byte[] result = new byte[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static byte[] hmac_sm3(byte[] key, byte[] M) {
        int i;
        int b = 512;
        int N = b / 8;
        byte[] ipad = new byte[N];
        byte[] opad = new byte[N];
        for (i = 0; i < N; ++i) {
            ipad[i] = 54;
            opad[i] = 92;
        }
        byte[] K0 = new byte[N - key.length];
        byte[] K = Func.join(K0, key);
        logger.debug("K\t" + new String(Hex.encodeHex((byte[])K)));
        byte[] S1 = new byte[N];
        for (i = 0; i < N; ++i) {
            S1[i] = (byte)(K[i] ^ ipad[i]);
        }
        logger.debug("S1\t" + new String(Hex.encodeHex((byte[])S1)));
        byte[] T1 = Func.join(S1, M);
        logger.debug("T1\t" + new String(Hex.encodeHex((byte[])T1)));
        SM3Digest sm3 = new SM3Digest();
        sm3.update(T1);
        byte[] H = sm3.doFinal();
        logger.debug("H\t" + new String(Hex.encodeHex((byte[])H)));
        byte[] S2 = new byte[N];
        for (i = 0; i < N; ++i) {
            S2[i] = (byte)(K[i] ^ opad[i]);
        }
        byte[] T2 = Func.join(S2, H);
        sm3.update(T2);
        byte[] MAC = sm3.doFinal();
        return MAC;
    }

    public static synchronized String genRandom32Hex() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static void main(String[] args) {
        byte[] key = new byte[16];
        for (int i = 0; i < key.length; ++i) {
            key[i] = 1;
        }
        byte[] data = new byte[114];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 1;
        }
        byte[] mac = Func.hmac_sm3(key, data);
        System.out.println(Hex.encodeHex((byte[])mac));
        for (int i = 0; i < 1000; ++i) {
            System.out.println(Func.genRandom32Hex());
        }
    }
}

