/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.helper;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.iam.bean.IdpException;
import com.xdja.pams.iam.bean.IdpParam;
import com.xdja.pams.iam.bean.IdpResult;
import com.xdja.pams.iam.helper.Func;
import com.xdja.pams.iam.helper.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamCheckHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamCheckHelper.class);
    private String paramJson;
    private IdpParam param;
    private String secret;

    public ParamCheckHelper(String paramJson) {
        this.paramJson = paramJson;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void checkParam() {
        String[] modes;
        if (Util.varCheckEmp(this.paramJson)) {
            throw new IdpException(IdpResult.ErrorCode.PARAM_LOSE);
        }
        try {
            this.param = (IdpParam)JSON.parseObject((String)this.paramJson, IdpParam.class);
        }
        catch (Exception e) {
            throw new IdpException(IdpResult.ErrorCode.PARAM_ILLEGAL, (Throwable)e);
        }
        this.checkResponse();
        String mode = this.param.getAuthMode();
        if (Util.varCheckEmp(mode)) {
            throw new IdpException(IdpResult.ErrorCode.PARAM_LOSE);
        }
        for (String m : modes = mode.split(",")) {
            if (m.equals("1") || m.equals("2")) continue;
            throw new IdpException(IdpResult.ErrorCode.PARAM_ILLEGAL);
        }
        for (String m : modes) {
            if (m.equals("1")) {
                this.checkSafeCard();
            }
            if (!m.equals("2")) continue;
            this.checkUserPwd();
        }
    }

    private void checkResponse() {
        if (Util.varCheckEmp(this.param.getResponse())) {
            throw new IdpException(IdpResult.ErrorCode.PARAM_LOSE);
        }
        try {
            if (Util.varCheckEmp(this.secret)) {
                throw new RuntimeException("idp secret \u6ca1\u6709\u914d\u7f6e");
            }
            String response = this.spellParam();
            String hexString = Tools.Bytes2HexString(Func.hmac_sm3(this.secret.getBytes(), response.getBytes()));
            if (!hexString.equals(this.param.getResponse())) {
                throw new IdpException(IdpResult.ErrorCode.PARAM_ILLEGAL);
            }
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
            throw new IdpException(IdpResult.ErrorCode.SERVER_INTERNAL_EXCEPTION);
        }
    }

    private void checkUserPwd() {
        if (Util.varCheckEmp(this.param.getUname()) || Util.varCheckEmp(this.param.getPwd())) {
            throw new IdpException(IdpResult.ErrorCode.PARAM_LOSE);
        }
    }

    private void checkSafeCard() {
        if (Util.varCheckEmp(this.param.getChipId()) || Util.varCheckEmp(this.param.getSign()) || Util.varCheckEmp(this.param.getChallenge())) {
            throw new IdpException(IdpResult.ErrorCode.PARAM_LOSE);
        }
    }

    private String spellParam() {
        ResponseBuilder builder = new ResponseBuilder();
        builder.append(this.param.getUname()).append(this.param.getPwd()).append(this.param.getMobile()).append(this.param.getCode()).append(this.param.getIdentifier()).append(this.param.getChipId()).append(this.param.getSn()).append(this.param.getChallenge()).append(this.param.getSign()).append(this.param.getAuthMode());
        return builder.build();
    }

    private static class ResponseBuilder {
        private StringBuilder sb = new StringBuilder();

        private ResponseBuilder() {
        }

        ResponseBuilder append(String param) {
            this.sb.append(param == null ? "" : param).append(":");
            return this;
        }

        String build() {
            String s = this.sb.toString();
            if (s.endsWith(":")) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
    }
}

