/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.manager;

import com.xdja.pams.common.util.Util;
import com.xdja.pams.iam.bean.IdpAuthResult;
import com.xdja.pams.iam.bean.IdpException;
import com.xdja.pams.iam.bean.IdpParam;
import com.xdja.pams.iam.bean.IdpResult;
import com.xdja.pams.iam.manager.IdpAuthManager;
import com.xdja.pams.iam.sign.SignHelper;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;

public class SafeCardIdpAuthManager
implements IdpAuthManager {
    private IdpParam param;
    private DeviceService deviceService;

    public SafeCardIdpAuthManager(IdpParam param, DeviceService deviceService) {
        this.param = param;
        this.deviceService = deviceService;
    }

    @Override
    public void auth(IdpAuthResult result) throws IdpException {
        Device device = this.deviceService.getByCardNO(this.param.getChipId());
        if (device == null) {
            throw new IdpException(IdpResult.ErrorCode.CARD_NOT_EXIT);
        }
        if (!"3".equals(device.getState())) {
            throw new IdpException(IdpResult.ErrorCode.CERT_STATUS_ERR);
        }
        String cert = device.getCertificate();
        if (Util.varCheckEmp(cert)) {
            throw new IdpException(IdpResult.ErrorCode.CERT_STATUS_ERR);
        }
        SignHelper helper = new SignHelper(device.getCertificate(), this.param.getChallenge(), this.param.getSign());
        if (!helper.checkSign()) {
            throw new IdpException(IdpResult.ErrorCode.VERIFY_SIGN_FAIL);
        }
        result.setDevice(device);
    }
}

