/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.sign;

import com.xdja.cssp.sm2cipher.sm2.cipher.Base64Util;
import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.springframework.util.StringUtils;

public class CertUtil {
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtil.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            return (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getPubKey(String str, int caAlg) {
        String pubKey;
        System.out.println("\u8fdb\u5165CertUtil->getPubKey: str:\n" + str);
        X509Certificate x509Cert = CertUtil.getCertFromStr(str);
        if (caAlg == 1) {
            RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
            pubKey = rsa.getModulus().toString(16).toUpperCase();
        } else {
            ECPublicKey sm2 = (ECPublicKey)x509Cert.getPublicKey();
            String x = sm2.getW().getAffineX().toString(16);
            String y = sm2.getW().getAffineY().toString(16);
            System.out.println("x:" + x.length());
            System.out.println("y:" + y.length());
            if (x.length() == 63) {
                x = "0" + x;
            }
            if (x.length() == 62) {
                x = "00" + x;
            }
            if (y.length() == 63) {
                y = "0" + y;
            }
            if (y.length() == 62) {
                y = "00" + y;
            }
            pubKey = x + y;
        }
        byte[] pub = CertUtil.hex2byte(pubKey);
        return new String(Base64Util.encode((byte[])pub));
    }

    public static int getAlgType(String str) {
        X509Certificate x509Cert = CertUtil.getCertFromStr(str);
        return CertUtil.getAlgType(x509Cert);
    }

    public static int getAlgType(X509Certificate x509Cert) {
        String algName = x509Cert.getSigAlgName();
        if (StringUtils.hasText((String)algName)) {
            return algName.contains("RSA") ? 1 : 2;
        }
        throw new RuntimeException("\u6ca1\u6709\u83b7\u53d6\u5230\u52a0\u5bc6\u7b97\u6cd5");
    }

    public static String getPubKey(X509Certificate x509Cert, int caAlg) {
        String pubKey;
        System.out.println("\u8fdb\u5165CertUtil->getPubKey: str:\n");
        if (caAlg == 1) {
            RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
            pubKey = rsa.getModulus().toString(16).toUpperCase();
        } else {
            ECPublicKey sm2 = (ECPublicKey)x509Cert.getPublicKey();
            String x = sm2.getW().getAffineX().toString(16);
            String y = sm2.getW().getAffineY().toString(16);
            System.out.println("x:" + x.length());
            System.out.println("y:" + y.length());
            if (x.length() == 63) {
                x = "0" + x;
            }
            if (x.length() == 62) {
                x = "00" + x;
            }
            if (y.length() == 63) {
                y = "0" + y;
            }
            if (y.length() == 62) {
                y = "00" + y;
            }
            pubKey = x + y;
        }
        byte[] pub = CertUtil.hex2byte(pubKey);
        return new String(Base64Util.encode((byte[])pub));
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = CertUtil.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromFullStr(str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromStr16(str);
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            return (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            return (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            System.err.println("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String getSn(X509Certificate cert) {
        return cert.getSerialNumber().toString(16).toLowerCase();
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {
            certb64 = CertUtil.bytesToFullB64(cert.getEncoded());
        }
        catch (Exception e) {
            System.err.println("certToFullB64 error:" + e.toString());
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        try {
            String certb64 = new String(Base64.encode((byte[])certder));
            return "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n-----END CERTIFICATE-----\n";
        }
        catch (Exception e) {
            System.err.println("certDerToFullB64 error:" + e.toString());
            return null;
        }
    }

    public static String warpCert(String certb64) {
        return "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n-----END CERTIFICATE-----\n";
    }

    public static boolean isSignCert(X509Certificate cert) {
        boolean[] result = cert.getKeyUsage();
        return result[0] && result[1];
    }

    public static void main(String[] args) {
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

