/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.sign;

import com.xdja.cssp.sm2cipher.sm2.cipher.Base64Util;
import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.iam.bean.IdpException;
import com.xdja.pams.iam.bean.IdpResult;
import com.xdja.pams.iam.helper.Tools;
import com.xdja.pams.iam.sign.ALG_TYPE;
import com.xdja.pams.iam.sign.CertUtil;
import com.xdja.pams.iam.sign.SignUtils;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SignHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignHelper.class);
    private String cert;
    private String challenge;
    private String sign;
    private X509Certificate certificate;
    private String algType;
    private String pubKey;

    public SignHelper(String cert, String challenge, String sign) {
        this.cert = cert;
        this.challenge = challenge;
        this.sign = sign;
    }

    public boolean checkSign() {
        try {
            this.certificate = CertUtil.getCertFromStr(this.cert);
            int at = CertUtil.getAlgType(this.certificate);
            this.algType = String.valueOf(at);
            this.pubKey = CertUtil.getPubKey(this.certificate, at);
            return SignUtils.verifySignByKeyData(this.algType, this.pubKey, this.challenge.getBytes(), Base64Util.decode((String)this.sign));
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u9a8c\u7b7e\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            } else {
                LOGGER.error("\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
            }
            return false;
        }
    }

    private void getCertificate() {
        try {
            this.certificate = CertUtil.getCertFromB64(this.cert);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bc1\u4e66\u8f6c\u5316\u5f02\u5e38");
        }
    }

    private void getAlgType() {
        String algName = this.certificate.getSigAlgName();
        if (StringUtils.hasText((String)algName)) {
            this.algType = algName.contains("RSA") ? "1" : "2";
            return;
        }
        LOGGER.error("\u83b7\u53d6\u83b7\u53d6\u7b97\u6cd5\u5f02\u5e38");
        throw new IdpException(IdpResult.ErrorCode.SERVER_INTERNAL_EXCEPTION);
    }

    private void getPubKey() {
        try {
            if (this.algType.equals(ALG_TYPE.rsa.value)) {
                RSAPublicKey rsa = (RSAPublicKey)this.certificate.getPublicKey();
                this.pubKey = rsa.getModulus().toString(16).toUpperCase();
            } else {
                ECPublicKey sm2 = (ECPublicKey)this.certificate.getPublicKey();
                String x = sm2.getW().getAffineX().toString(16);
                String y = sm2.getW().getAffineY().toString(16);
                System.out.println("x:" + x.length());
                System.out.println("y:" + y.length());
                if (x.length() == 63) {
                    x = "0" + x;
                }
                if (x.length() == 62) {
                    x = "00" + x;
                }
                if (y.length() == 63) {
                    y = "0" + y;
                }
                if (y.length() == 62) {
                    y = "00" + y;
                }
                this.pubKey = x + y;
            }
            byte[] pub = Tools.hex2byte(this.pubKey);
            Base64Encrypt base64Encrypt = new Base64Encrypt();
            this.pubKey = base64Encrypt.encodeStr(pub);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("\u83b7\u53d6\u516c\u94a5\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            } else {
                LOGGER.error("\u83b7\u53d6\u516c\u94a5\u5931\u8d25:{}", (Object)e.getMessage());
            }
            throw new IdpException(IdpResult.ErrorCode.SERVER_INTERNAL_EXCEPTION, (Throwable)e);
        }
    }
}

