/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.iam.sign;

import com.xdja.cssp.sm2cipher.sm2.cipher.ConvertUtil;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2CipherImpl;
import com.xdja.pams.iam.sign.ALG_TYPE;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtils.class);

    public static boolean verifySignByKey(String alg, PublicKey publicKey, byte[] data, byte[] signature) {
        try {
            if (ALG_TYPE.rsa.value.equals(alg)) {
                return SignUtils.rsaVerifySignByKey(publicKey, data, signature);
            }
            return SignUtils.sm2VerifySignByKey(publicKey, data, signature);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
            return false;
        }
    }

    public static byte[] signByKey(String alg, PrivateKey privateKey, byte[] data) {
        try {
            if (ALG_TYPE.rsa.value.equals(alg)) {
                return SignUtils.rsaSign(privateKey, data);
            }
            return SignUtils.sm2Sign(privateKey, data);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
            return null;
        }
    }

    public static byte[] signByKey(String alg, String basePriKey, byte[] data) {
        try {
            if (ALG_TYPE.rsa.value.equals(alg)) {
                throw new IllegalArgumentException("unsupport sign alg SHA-1WITHRSA");
            }
            return SignUtils.sm2SignByKeyData(basePriKey, data);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
            return null;
        }
    }

    public static boolean verifySignByKeyData(String alg, String publicKey, byte[] data, byte[] signature) {
        try {
            if (ALG_TYPE.rsa.value.equals(alg)) {
                return SignUtils.rsaVerifySignByKeyData(publicKey, data, signature);
            }
            return SignUtils.sm2VerifySignByKeyData(publicKey, data, signature);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            } else {
                LOGGER.error(e.getMessage());
            }
            return false;
        }
    }

    private static boolean rsaVerifySignByKey(PublicKey publicKey, byte[] data, byte[] signature) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, publicKey);
        cipher.update(signature);
        byte[] plainHash = cipher.doFinal();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] oriHash = messageDigest.digest(data);
        for (int i = 0; i < plainHash.length; ++i) {
            if (plainHash[i] == oriHash[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean rsaVerifySignByKeyData(String keyData, byte[] data, byte[] signature) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        PublicKey publicKey = SignUtils.getPublickKey(keyData);
        cipher.init(2, publicKey);
        cipher.update(signature);
        byte[] plainHash = cipher.doFinal();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] oriHash = messageDigest.digest(data);
        for (int i = 0; i < plainHash.length; ++i) {
            if (plainHash[i] == oriHash[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean sm2VerifySignByKey(PublicKey publicKey, byte[] original, byte[] sign) throws IllegalArgumentException {
        if (publicKey == null || original == null || sign == null || original.length <= 0 || sign.length <= 0) {
            throw new IllegalArgumentException("param error: publicKey,sign,original can not be null");
        }
        SM2CipherImpl cipher = new SM2CipherImpl();
        boolean flag = cipher.verify((ECPublicKey)publicKey, sign, original);
        return flag;
    }

    private static boolean sm2VerifySignByKeyData(String base64Key, byte[] original, byte[] sign) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)base64Key) || original == null || sign == null || original.length <= 0 || sign.length <= 0) {
            throw new IllegalArgumentException("param error: publicKey,sign,original can not be null");
        }
        SM2CipherImpl cipher = new SM2CipherImpl();
        byte[] rdata = new byte[32];
        byte[] sdata = new byte[32];
        System.arraycopy(sign, 0, rdata, 0, 32);
        System.arraycopy(sign, 32, sdata, 0, 32);
        BigInteger[] rs = new BigInteger[]{new BigInteger(1, rdata), new BigInteger(1, sdata)};
        boolean flag = cipher.verify(base64Key, rs, original);
        return flag;
    }

    private static PublicKey getPublickKey(String modulus) throws Exception {
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(new BigInteger(1, Base64.decode((byte[])modulus.getBytes())), new BigInteger("65537", 10));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return factory.generatePublic(publicKeySpec);
    }

    private static byte[] sm2Sign(PrivateKey privateKey, byte[] original) throws IllegalArgumentException {
        if (privateKey == null || original == null || original.length <= 0) {
            throw new IllegalArgumentException("param error: privateKey,original can not be null");
        }
        SM2CipherImpl cipher = new SM2CipherImpl();
        return cipher.sign((ECPrivateKey)privateKey, original);
    }

    private static byte[] sm2SignByKeyData(String base64PriKey, byte[] original) throws IllegalArgumentException {
        if (base64PriKey == null || original == null || original.length <= 0) {
            throw new IllegalArgumentException("param error: privateKey,original can not be null");
        }
        byte[] result = new byte[64];
        SM2CipherImpl cipher = new SM2CipherImpl();
        BigInteger[] rs = cipher.sign(base64PriKey, original);
        byte[] rData = ConvertUtil.hexStringToBytes((String)rs[0].toString(16));
        System.arraycopy(rData, 0, result, 32 - rData.length, rData.length);
        byte[] sData = ConvertUtil.hexStringToBytes((String)rs[1].toString(16));
        System.arraycopy(sData, 0, result, 64 - sData.length, sData.length);
        return result;
    }

    private static byte[] rsaSign(PrivateKey privateKey, byte[] data) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(data);
        byte[] digestData = messageDigest.digest();
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, privateKey);
        return cipher.doFinal(digestData);
    }
}

