/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.jwzs.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.jwzs.bean.FLFGBean;
import com.xdja.pams.jwzs.dao.FlfgDao;
import com.xdja.pams.jwzs.entity.FLFG;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FlfgDaoImpl
implements FlfgDao {
    @Autowired
    private BaseDao baseDao;
    private static final Logger log = LoggerFactory.getLogger(FlfgDaoImpl.class);

    @Override
    public FLFG queryById(int id) {
        return (FLFG)this.baseDao.getObjectById(FLFG.class, Integer.valueOf(id));
    }

    @Override
    public List<FLFG> queryList(FLFGBean fLFGBean, Page page) {
        StringBuilder select = new StringBuilder("from FLFG where 1=1 ");
        ArrayList<Object> list = new ArrayList<Object>();
        if (fLFGBean != null) {
            if (StringUtils.isNotBlank((CharSequence)fLFGBean.getContent())) {
                select.append(" and c_content like ?");
                list.add("%" + fLFGBean.getContent() + "%");
            }
            if (fLFGBean.getPid() >= 0) {
                select.append(" and n_pid = ?");
                list.add(fLFGBean.getPid());
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new Object[0]);
        }
        log.info(selectCount);
        return this.baseDao.getListByHQL(selectCount, select.toString() + "order by xh", values, page);
    }

    @Override
    public FLFG save(FLFG bean) {
        this.baseDao.create(bean);
        return bean;
    }

    @Override
    public void update(FLFG bean) {
        this.baseDao.update(bean);
    }

    @Override
    public void delete(FLFG bean) {
        this.baseDao.delete(bean);
    }

    @Override
    public void deleteAndChild(String id) {
        String sql = "delete t_flfg  where  n_id in (select n_id from t_flfg connect by prior n_id = n_pid start with n_id = ?)";
        this.baseDao.updateBySql(sql, new String[]{id});
    }
}

