/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.login.entity;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.login.util.FuncComparator;
import com.xdja.pams.upms.entity.SysPower;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operator
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Operator.class);
    private Person person;
    private String loginIp;
    private Map<String, SysPower> topFunctions;
    private String controlDeps = "";
    private String controlPolices = "";

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    public Map<String, SysPower> getTopMenu() {
        return this.topFunctions;
    }

    public List<SysPower> getTopFunctions() {
        ArrayList<SysPower> result = new ArrayList<SysPower>(this.topFunctions.values());
        Collections.sort(result, new FuncComparator());
        return result;
    }

    public void setTopFunctions(Map<String, SysPower> functions) {
        this.topFunctions = new HashMap<String, SysPower>();
        for (SysPower function : functions.values()) {
            if ("0".equals(function.getParent_id())) {
                this.topFunctions.put(function.getId(), function);
                continue;
            }
            SysPower parentFunc = functions.get(function.getParent_id());
            if (parentFunc == null) {
                log.warn("\u83dc\u5355" + function.getName() + "\u7684\u4e0a\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u4e0a\u7ea7\u83dc\u5355id\u662f" + function.getParent_id() + "\u3002");
                continue;
            }
            Map<String, SysPower> children = parentFunc.getChildren();
            if (children == null) {
                children = new HashMap<String, SysPower>();
                parentFunc.setChildren(children);
            }
            children.put(function.getId(), function);
        }
    }

    public void setTopFunctions(Map<String, SysPower> functions, String type) {
        this.topFunctions = new HashMap<String, SysPower>();
        for (SysPower function : functions.values()) {
            if (type.equals(function.getParent_id())) {
                this.topFunctions.put(function.getId(), function);
                continue;
            }
            SysPower parentFunc = functions.get(function.getParent_id());
            if (parentFunc == null) {
                log.warn("\u83dc\u5355" + function.getName() + "\u7684\u4e0a\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u4e0a\u7ea7\u83dc\u5355id\u662f" + function.getParent_id() + "\u3002");
                continue;
            }
            Map<String, SysPower> children = parentFunc.getChildren();
            if (children == null) {
                children = new HashMap<String, SysPower>();
                parentFunc.setChildren(children);
            }
            children.put(function.getId(), function);
        }
    }

    public String getControlDeps() {
        return this.controlDeps;
    }

    public String getControlPolices() {
        return this.controlPolices;
    }

    public void setControlDeps(String controlDeps) {
        this.controlDeps = controlDeps;
    }

    public void setControlPolices(String controlPolices) {
        this.controlPolices = controlPolices;
    }
}

