/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.control;

import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.report.bean.PersonReportBean;
import com.xdja.pams.report.bean.QueryForm;
import com.xdja.pams.report.bean.ReportDataGrid;
import com.xdja.pams.report.entity.ReplyContent;
import com.xdja.pams.report.entity.RequestContent;
import com.xdja.pams.report.service.CustomReportService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class CustomReportAction
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CustomReportService customReportService;
    private static final Logger log = LoggerFactory.getLogger(CustomReportAction.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private DepManageService dep;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigPbService scps;

    @RequestMapping(value={"/report/CustomReportAction/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            Date date = new Date();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, -1);
            date = cal.getTime();
            String ToDate = Util.getDate("yyyy-MM-dd", date);
            cal.setTime(date);
            cal.add(2, -1);
            date = cal.getTime();
            String fromDate = Util.getDate("yyyy-MM-dd", date);
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)ToDate);
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/report/CustomReportAction/queryReportTittle.do"})
    public void queryReportTittle(HttpServletRequest request, QueryForm queryForm, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            ReportDataGrid dataGrid = this.customReportService.getReportTittles(queryForm);
            rtnResult.setRtnCode("0");
            rtnResult.setData(dataGrid);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/report/CustomReportAction/queryReportData.do"})
    public void queryReportData(HttpServletRequest request, QueryForm queryForm, HttpServletResponse response) {
        log.info(".........................");
        Page page = new Page(Integer.parseInt(queryForm.getPage()), Integer.parseInt(queryForm.getRows()));
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            queryForm.setCtlDepStr(this.operator.getControlDeps());
            queryForm.setControlPolices(this.operator.getControlPolices());
            List dataList = this.customReportService.queryReportDateList(queryForm, page);
            data.put("total", page.getTotal());
            data.put("rows", dataList);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            data.put("total", page.getTotal());
            data.put("rows", new ArrayList());
        }
        Util.writeUtf8Text(response, Util.toJsonStr(data));
    }

    @RequestMapping(value={"/report/CustomReportAction/exportReport.do"})
    public void exportReport(HttpServletRequest request, QueryForm queryForm, HttpServletResponse response, ModelMap map) {
        try {
            String title = MessageManager.getProMessage(this.message, "report.custom.export.depList.title");
            String sheetName = MessageManager.getProMessage(this.message, "report.custom.export.depList.sheetName");
            String fileName = this.scps.getValueByCode("expReportDepFileName");
            fileName = Util.toUtf8String(fileName) + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            String[] appendStr = queryForm.getAppendStr().split(",");
            Page page = new Page(Integer.parseInt(appendStr[0]), Integer.parseInt(appendStr[1]));
            queryForm.setCtlDepStr(this.operator.getControlDeps());
            queryForm.setControlPolices(this.operator.getControlPolices());
            String[] heanderNames = null;
            String[] keys = null;
            String[][] codeValues = this.customReportService.getReportItems(queryForm.getSearchItemGroups());
            log.info("zds:" + Util.toJsonStr(codeValues));
            int codeValuesLength = codeValues.length;
            int appendLength = 0;
            if ("0".equals(queryForm.getSearchType())) {
                appendLength = 2;
                heanderNames = new String[codeValuesLength += appendLength];
                keys = new String[codeValuesLength];
                keys[0] = "DEPNAME";
                heanderNames[0] = MessageManager.getProMessage(this.message, "report.custom.page.title.depName");
            } else {
                appendLength = 5;
                heanderNames = new String[codeValuesLength += appendLength];
                keys = new String[codeValuesLength];
                keys[0] = "NAME";
                heanderNames[0] = MessageManager.getProMessage(this.message, "report.custom.page.title.personName");
                keys[1] = "CODE";
                heanderNames[1] = MessageManager.getProMessage(this.message, "report.custom.page.title.personCode");
                keys[2] = "MOBILE";
                heanderNames[2] = MessageManager.getProMessage(this.message, "report.custom.page.title.personMobile");
                keys[3] = "DEPNAME";
                heanderNames[3] = MessageManager.getProMessage(this.message, "report.custom.page.title.depName");
            }
            for (int i = 0; i < codeValuesLength - appendLength; ++i) {
                log.info(codeValues[i][0] + codeValues[i][1]);
                keys[i + appendLength - 1] = codeValues[i][0];
                heanderNames[i + appendLength - 1] = codeValues[i][1];
            }
            keys[codeValuesLength - 1] = "TOTAL";
            heanderNames[codeValuesLength - 1] = MessageManager.getProMessage(this.message, "report.custom.page.title.totalCount");
            List dates = this.customReportService.queryReportDateList(queryForm, page);
            ExcelUtil.exportExcel(title, (OutputStream)response.getOutputStream(), sheetName, dates, heanderNames, keys);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text(response, MessageManager.getProMessage(this.message, "exp.error.msg") + ":" + e.getMessage());
        }
    }

    @RequestMapping(value={"/report/CustomReportAction/toDetail.do"})
    public String toDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "report/custom/default/member";
    }

    @RequestMapping(value={"/report/CustomReportAction/queryDetail.do"})
    public void queryDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryForm queryForm) {
        int operateResult = 1;
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryForm.getPage()), Integer.parseInt(queryForm.getRows()));
            List<PersonReportBean> reportList = this.customReportService.getGprsBackList(queryForm, page);
            result.put("total", page.getTotal());
            for (int i = 0; i < reportList.size(); ++i) {
                PersonReportBean record = reportList.get(i);
                record.setName(this.userManageService.getUserByCode(record.getC_JH()).getName());
                record.setDepName(this.dep.getDepartmentByCode(record.getC_DWBM()).getName());
                record.setC_RQ(Util.getDate("yyyy-MM-dd HH:mm:ss", record.getD_RQ()));
                record.setWorkName(this.commonCodePbService.getCodeNameByCode(record.getC_YWLX(), queryForm.getSearchItemGroups()));
            }
            result.put("rows", reportList);
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u67e5\u8be2\u5355\u4f4d\u6210\u5458\u8be6\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/report/CustomReportAction/getRequest.do"})
    public String getRequest(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        String downloadDir = "download/";
        String path = request.getSession().getServletContext().getRealPath(downloadDir);
        RequestContent requestContent = this.customReportService.queryRequestContent(id, path);
        map.put((Object)"requestType", (Object)requestContent.getType());
        map.put((Object)"nodeList", requestContent.getNodeList());
        return "report/custom/default/requestContent";
    }

    @RequestMapping(value={"/report/CustomReportAction/getReply.do"})
    public String getReply(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReplyContent replyContent = this.customReportService.queryReplyContent(id);
        map.put((Object)"replyContent", (Object)replyContent);
        return "report/custom/default/replyContent";
    }

    @RequestMapping(value={"/report/CustomReportAction/exportDetail.do"})
    public void exportDetail(HttpServletRequest request, HttpServletResponse response, QueryForm queryForm) {
        if ("1".equals(queryForm.getSearchType())) {
            queryForm.setDepId(null);
            queryForm.setCode(queryForm.getSearchValue());
            queryForm.setPolice(null);
            queryForm.setPosition(null);
        }
        if ("2".equals(queryForm.getSearchType())) {
            queryForm.setDepId(null);
            queryForm.setName(queryForm.getSearchValue());
            queryForm.setPolice(null);
            queryForm.setPosition(null);
        }
        try {
            Page page = new Page(1, Integer.parseInt(this.scps.getValueByCode("maxExcelCount")));
            List<PersonReportBean> reportList = this.customReportService.getGprsBackList(queryForm, page);
            for (int i = 0; i < reportList.size(); ++i) {
                PersonReportBean record = reportList.get(i);
                record.setName(this.userManageService.getUserByCode(record.getC_JH()).getName());
                record.setDepName(this.dep.getDepartmentByCode(record.getC_DWBM()).getName());
                record.setWorkName(this.commonCodePbService.getCodeNameByCode(record.getC_YWLX(), queryForm.getSearchItemGroups()));
            }
            String fileName = this.scps.getValueByCode("detail_report_export_name");
            fileName = Util.toUtf8String(fileName);
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xls");
            response.setContentType("application/vnd.ms-excel");
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.code"));
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.name"));
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.mobile"));
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.dep"));
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.workname"));
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.operateTime"));
            titleList.add(MessageManager.getProMessage(this.message, "report.custom.page.info.ipAddress"));
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), this.scps.getValueByCode("detail_report_export_name"), this.scps.getValueByCode("detail_report_export_name"), reportList, titleList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5355\u4f4d\u6210\u5458\u64cd\u4f5c\u660e\u7ec6EXCEL\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }
}

