/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ReportConditionBean;
import com.xdja.pams.rptms.dao.ReportManagerDao;
import com.xdja.pams.rptms.entity.Report;
import com.xdja.pams.rptms.entity.ReportCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ReportManagerDaoImpl
implements ReportManagerDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<Report> queryReportList(ReportBean reportBean, Page page) {
        StringBuffer hqlStr = new StringBuffer();
        ArrayList<String> paramList = new ArrayList<String>();
        hqlStr.append("from Report obj where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)reportBean.getReportName())) {
            hqlStr.append("and obj.reportName like ? ");
            paramList.add("%" + reportBean.getReportName() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)reportBean.getReportType())) {
            hqlStr.append("and obj.reportType = ? ");
            paramList.add(reportBean.getReportType());
        }
        hqlStr.append("order by obj.createDate desc ");
        String sCount = "select count(*) ";
        return this.baseDao.getListByHQL(sCount + hqlStr.toString(), hqlStr.toString(), paramList.toArray(), page);
    }

    @Override
    public Report addReport(Report report) {
        this.baseDao.create(report);
        return report;
    }

    @Override
    public Report getReportById(String reportId) {
        return (Report)this.baseDao.getObjectById(Report.class, (Serializable)((Object)reportId));
    }

    @Override
    public void editReport(Report report) {
        this.baseDao.update(report);
    }

    @Override
    public List<ReportCondition> queryReportConditionList(ReportConditionBean reportConditionBean, Page page) {
        StringBuffer hqlStr = new StringBuffer();
        ArrayList paramList = new ArrayList();
        hqlStr.append("from Report obj where 1=1 ");
        hqlStr.append("order by obj.create_date desc ");
        String sCount = "select count(*) ";
        return this.baseDao.getListByHQL(sCount + hqlStr.toString(), hqlStr.toString(), paramList.toArray(), page);
    }

    @Override
    public ReportCondition addReportCondition(ReportCondition reportCondition) {
        this.baseDao.create(reportCondition);
        return reportCondition;
    }

    @Override
    public ReportCondition getReportParameterById(String reportConditionId) {
        return (ReportCondition)this.baseDao.getObjectById(ReportCondition.class, (Serializable)((Object)reportConditionId));
    }

    @Override
    public void editReportCondition(ReportCondition reportCondition) {
        this.baseDao.update(reportCondition);
    }

    @Override
    public void delReportCondition(ReportCondition reportCondition) {
        this.baseDao.delete(reportCondition);
    }
}

