/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.rptms.service.impl;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.rptms.bean.ConditionBean;
import com.xdja.pams.rptms.bean.QueryReportTimerBean;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ReportConditionBean;
import com.xdja.pams.rptms.dao.ReportConditionDao;
import com.xdja.pams.rptms.dao.ReportManagerDao;
import com.xdja.pams.rptms.entity.Report;
import com.xdja.pams.rptms.entity.ReportChart;
import com.xdja.pams.rptms.entity.ReportCondition;
import com.xdja.pams.rptms.entity.ReportExp;
import com.xdja.pams.rptms.service.ConditionManagerService;
import com.xdja.pams.rptms.service.DatasourceMangerService;
import com.xdja.pams.rptms.service.ReportManagerService;
import com.xdja.pams.rptms.service.ReportTemplateManageService;
import com.xdja.pams.rptms.service.TimerReportService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.upms.entity.SysPower;
import com.xdja.pams.upms.service.SysPowerService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReportManagerServiceImpl
implements ReportManagerService {
    @Autowired
    private ReportManagerDao reportManagerDao;
    @Autowired
    private ReportConditionDao reportConditionDao;
    @Autowired
    private ConditionManagerService conditionManagerService;
    @Autowired
    private DatasourceMangerService datasourceService;
    @Autowired
    private TimerReportService timerReportService;
    @Autowired
    private ReportTemplateManageService reportTemplateManageService;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SysPowerService sysPowerService;
    private static final Logger log = LoggerFactory.getLogger(ReportManagerServiceImpl.class);

    @Override
    public List<ReportBean> queryReportList(ReportBean reportBean, Page page) {
        log.debug("$$$$$$$$$$\u62a5\u8868\u67e5\u8be2<\u5f00\u59cb>$$$$$$$$$$");
        ArrayList<ReportBean> reportBeanList = new ArrayList<ReportBean>();
        List<Report> reportList = this.reportManagerDao.queryReportList(reportBean, page);
        String codeValue = "";
        ReportBean tmpReportBean = null;
        for (Report report : reportList) {
            tmpReportBean = new ReportBean();
            BeanUtils.copyProperties((Object)report, (Object)tmpReportBean);
            codeValue = this.commonCodePbService.getCodeNameByCode(tmpReportBean.getReportType(), "reportType");
            tmpReportBean.setReportTypeName(codeValue);
            if (tmpReportBean.getReportFileId() != null) {
                codeValue = this.reportTemplateManageService.queryReportTemplateById(tmpReportBean.getReportFileId()).getName();
                tmpReportBean.setReportFileName(codeValue);
            }
            reportBeanList.add(tmpReportBean);
        }
        log.debug("$$$$$$$$$$\u62a5\u8868\u67e5\u8be2<\u7ed3\u675f>$$$$$$$$$$");
        return reportBeanList;
    }

    @Override
    @Transactional
    public Report addReport(ReportBean reportBean) {
        log.debug("$$$$$$$$$$\u6dfb\u52a0\u62a5\u8868<\u5f00\u59cb>$$$$$$$$$$");
        Report report = new Report();
        BeanUtils.copyProperties((Object)reportBean, (Object)report);
        report = this.reportManagerDao.addReport(report);
        ArrayList<ReportExp> expFileList = new ArrayList<ReportExp>();
        String expFiles = reportBean.getExpFiles();
        if (expFiles != null) {
            String[] tmpStr = expFiles.split(",");
            ReportExp reportExp = null;
            for (String str : tmpStr) {
                reportExp = new ReportExp();
                reportExp.setReportExpType(str);
                reportExp.setReportId(report.getReportId());
                expFileList.add(reportExp);
            }
        }
        report.setExpFileList(expFileList);
        this.reportManagerDao.editReport(report);
        String codeValue = "";
        SysPower newSysPower = new SysPower();
        log.debug("$\u6dfb\u52a0\u62a5\u8868\u6a21\u5757.....start....");
        codeValue = this.systemConfigPbService.getValueByCode("reportModuleParentId");
        if (codeValue == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.configNotFind") + ":" + "reportModuleParentId");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.configNotFind"));
        }
        newSysPower.setParent_id(codeValue);
        newSysPower.setName(reportBean.getReportName());
        newSysPower.setLink("/rptms/ViewReportControler/");
        newSysPower.setLink_do("/rptms/ViewReportControler/index.do?reportId=" + report.getReportId());
        newSysPower.setLink_page("rptms/viewreport/default/index");
        newSysPower.setOrdernum("99");
        newSysPower.setPower_type("1");
        newSysPower.setType("0");
        newSysPower.setStatus("1");
        newSysPower = this.sysPowerService.addModule(newSysPower);
        log.debug("$\u6dfb\u52a0\u62a5\u8868\u6a21\u5757.....end....");
        SysPower subSysPower = new SysPower();
        subSysPower.setParent_id(newSysPower.getId());
        subSysPower.setName("\u6dfb\u52a0\u5b9a\u65f6\u62a5\u8868");
        newSysPower.setOrdernum("99");
        subSysPower.setPower_type("1");
        subSysPower.setType("1");
        subSysPower.setStatus("1");
        this.sysPowerService.addModule(subSysPower);
        log.debug("$\u6dfb\u52a0\u5b9a\u65f6\u62a5\u8868\u6309\u94ae.");
        log.debug("$$$$$$$$$$\u6dfb\u52a0\u62a5\u8868<\u7ed3\u675f>$$$$$$$$$$");
        return report;
    }

    @Override
    public ReportBean getReportById(String reportId) {
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u4fe1\u606f<\u5f00\u59cb>$$$$$$$$$$");
        ReportBean reportBean = new ReportBean();
        Report report = this.reportManagerDao.getReportById(reportId);
        if (report == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit") + ":" + reportId);
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit"));
        }
        BeanUtils.copyProperties((Object)report, (Object)reportBean);
        if (report.getReportChart() != null) {
            BeanUtils.copyProperties((Object)report.getReportChart(), (Object)reportBean);
        }
        String codeValue = "";
        codeValue = this.commonCodePbService.getCodeNameByCode(String.valueOf(reportBean.getReportType()), "reportType");
        reportBean.setReportTypeName(codeValue);
        if (reportBean.getReportFileId() != null) {
            codeValue = this.reportTemplateManageService.queryReportTemplateById(reportBean.getReportFileId()).getName();
            reportBean.setReportFileName(codeValue);
        }
        if (!reportBean.getExpFileList().isEmpty()) {
            List<ReportExp> list = reportBean.getExpFileList();
            StringBuffer sb = new StringBuffer();
            for (ReportExp reportExp : list) {
                sb.append(reportExp.getReportExpType()).append(",");
            }
            reportBean.setExpFiles(sb.substring(0, sb.lastIndexOf(",")));
        }
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u4fe1\u606f<\u7ed3\u675f>$$$$$$$$$$");
        return reportBean;
    }

    @Override
    @Transactional
    public void editReportInfo(ReportBean reportBean) {
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u4fe1\u606f<\u5f00\u59cb>$$$$$$$$$$");
        SysPower sysPower = new SysPower();
        Report report = this.reportManagerDao.getReportById(reportBean.getReportId());
        if (report == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit") + ":" + reportBean.getReportId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit"));
        }
        String codeValue = this.systemConfigPbService.getValueByCode("reportModuleParentId");
        if (codeValue == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.configNotFind") + ":" + "reportModuleParentId");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.configNotFind"));
        }
        sysPower.setParent_id(codeValue);
        sysPower.setLink("/rptms/ViewReportControler/");
        sysPower.setLink_do("/rptms/ViewReportControler/index.do?reportId=" + report.getReportId());
        sysPower.setLink_page("rptms/viewreport/default/index");
        report.setReportName(reportBean.getReportName());
        report.setDatasourceId(reportBean.getDatasourceId());
        report.setReportFileId(reportBean.getReportFileId());
        report.setReportSql(reportBean.getReportSql());
        report.setFlagPagination(reportBean.getFlagPagination());
        report.setNote(reportBean.getNote());
        report.setReportType(reportBean.getReportType());
        ArrayList<ReportExp> expFileList = new ArrayList<ReportExp>();
        String expFiles = reportBean.getExpFiles();
        if (expFiles != null) {
            String[] tmpStr = expFiles.split(",");
            ReportExp reportExp = null;
            for (String str : tmpStr) {
                reportExp = new ReportExp();
                reportExp.setReportExpType(str);
                reportExp.setReportId(report.getReportId());
                expFileList.add(reportExp);
            }
        }
        report.setExpFileList(expFileList);
        this.reportManagerDao.editReport(report);
        SysPower findSysPower = null;
        log.debug("$\u4fee\u6539\u62a5\u8868\u6a21\u5757\u540d\u79f0.....start....");
        List<SysPower> sysPowerList = this.sysPowerService.querySysPowerList(sysPower, null);
        if (!sysPowerList.isEmpty()) {
            Iterator<SysPower> iterator = sysPowerList.iterator();
            while (iterator.hasNext()) {
                SysPower tmpSysPower;
                findSysPower = tmpSysPower = iterator.next();
            }
        }
        if (findSysPower == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportModuleExit") + ":" + sysPower.getLink_do());
        } else {
            findSysPower.setName(report.getReportName());
            this.sysPowerService.updateModule(findSysPower);
        }
        log.debug("$\u4fee\u6539\u62a5\u8868\u6a21\u5757\u540d\u79f0.....end....");
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u4fe1\u606f<\u7ed3\u675f>$$$$$$$$$$");
    }

    @Override
    @Transactional
    public ReportCondition addReportParameter(ReportConditionBean reportConditionBean) {
        log.debug("$$$$$$$$$$\u6dfb\u52a0\u62a5\u8868\u53c2\u6570<\u5f00\u59cb>$$$$$$$$$$");
        ConditionBean conditionBean = this.conditionManagerService.getConditionById(reportConditionBean.getConditionId());
        if (conditionBean == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit") + ":" + reportConditionBean.getConditionId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit"));
        }
        ReportConditionBean tempReportConditionBean = new ReportConditionBean();
        tempReportConditionBean.setConditionId(reportConditionBean.getConditionId());
        tempReportConditionBean.setReportId(reportConditionBean.getReportId());
        List<ReportCondition> reportConditionList = this.reportConditionDao.queryReportConditionList(tempReportConditionBean, null);
        if (reportConditionList != null && reportConditionList.size() > 0) {
            log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit") + ":" + reportConditionBean.getConditionId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit"));
        }
        ReportCondition reportCondition = new ReportCondition();
        BeanUtils.copyProperties((Object)reportConditionBean, (Object)reportCondition);
        reportCondition = this.reportConditionDao.addReportCondition(reportCondition);
        log.debug("$$$$$$$$$$\u6dfb\u52a0\u62a5\u8868\u53c2\u6570<\u7ed3\u675f>$$$$$$$$$$");
        return reportCondition;
    }

    @Override
    public List<ReportConditionBean> queryReportParameterList(ReportConditionBean reportConditionBean, Page page) {
        log.debug("$$$$$$$$$$\u62a5\u8868\u53c2\u6570\u67e5\u8be2<\u5f00\u59cb>$$$$$$$$$$");
        ArrayList<ReportConditionBean> reportConditionBeanList = new ArrayList<ReportConditionBean>();
        List<ReportCondition> reportConditionList = this.reportConditionDao.queryReportConditionList(reportConditionBean, page);
        ReportConditionBean tmpReportConditionBean = null;
        ConditionBean conditionBean = null;
        for (ReportCondition reportCondition : reportConditionList) {
            tmpReportConditionBean = new ReportConditionBean();
            BeanUtils.copyProperties((Object)reportCondition, (Object)tmpReportConditionBean);
            conditionBean = this.conditionManagerService.getConditionById(tmpReportConditionBean.getConditionId());
            tmpReportConditionBean.setConditionName(conditionBean.getConditionName());
            tmpReportConditionBean.setConditionType(conditionBean.getConditionType());
            tmpReportConditionBean.setConditionTypeName(conditionBean.getConditionTypeName());
            tmpReportConditionBean.setConditionShowId(conditionBean.getConditionShowId());
            reportConditionBeanList.add(tmpReportConditionBean);
        }
        log.debug("$$$$$$$$$$\u62a5\u8868\u53c2\u6570\u67e5\u8be2<\u7ed3\u675f>$$$$$$$$$$");
        return reportConditionBeanList;
    }

    @Override
    public ReportConditionBean getReportParameterById(String reportConditionId) {
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u4fe1\u606f<\u5f00\u59cb>$$$$$$$$$$");
        ReportConditionBean reportConditionBean = new ReportConditionBean();
        ReportCondition reprotCondition = this.reportConditionDao.getReportParameterById(reportConditionId);
        if (reprotCondition == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportParameterExit") + ":" + reportConditionId);
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportParameterExit"));
        }
        BeanUtils.copyProperties((Object)reprotCondition, (Object)reportConditionBean);
        ConditionBean conditionBean = this.conditionManagerService.getConditionById(reportConditionBean.getConditionId());
        reportConditionBean.setConditionName(conditionBean.getConditionName());
        reportConditionBean.setConditionType(conditionBean.getConditionType());
        reportConditionBean.setConditionTypeName(conditionBean.getConditionTypeName());
        reportConditionBean.setConditionShowId(conditionBean.getConditionShowId());
        log.debug("$$$$$$$$$$\u83b7\u53d6\u62a5\u8868\u53c2\u6570\u4fe1\u606f<\u7ed3\u675f>$$$$$$$$$$");
        return reportConditionBean;
    }

    @Override
    @Transactional
    public void editReportParameter(ReportConditionBean reportConditionBean) {
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u53c2\u6570\u4fe1\u606f<\u5f00\u59cb>$$$$$$$$$$");
        ReportCondition reportCondition = this.reportConditionDao.getReportParameterById(reportConditionBean.getReportConditionId());
        if (reportCondition == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportParameterExit") + ":" + reportConditionBean.getReportConditionId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportParameterExit"));
        }
        ConditionBean conditionBean = this.conditionManagerService.getConditionById(reportConditionBean.getConditionId());
        if (conditionBean == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit") + ":" + reportConditionBean.getConditionId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.noSuchConditonExit"));
        }
        ReportConditionBean tempReportConditionBean = new ReportConditionBean();
        tempReportConditionBean.setConditionId(reportConditionBean.getConditionId());
        tempReportConditionBean.setReportId(reportConditionBean.getReportId());
        List<ReportCondition> reportConditionList = this.reportConditionDao.queryReportConditionList(tempReportConditionBean, null);
        if (reportConditionList != null) {
            for (ReportCondition tmp : reportConditionList) {
                if (tmp.getReportConditionId().equals(reportCondition.getReportConditionId())) continue;
                log.error(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit") + ":" + reportConditionBean.getConditionId());
                throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.conditionManager.error.conditonExit"));
            }
        }
        reportCondition.setConditionId(reportConditionBean.getConditionId());
        reportCondition.setReportId(reportConditionBean.getReportId());
        reportCondition.setFlagCondition(reportConditionBean.getFlagCondition());
        reportCondition.setFlagConditionName(reportConditionBean.getFlagConditionName());
        reportCondition.setFlagRequired(reportConditionBean.getFlagRequired());
        reportCondition.setSeq(reportConditionBean.getSeq());
        this.reportConditionDao.editReportCondition(reportCondition);
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u53c2\u6570\u4fe1\u606f<\u7ed3\u675f>$$$$$$$$$$");
    }

    @Override
    @Transactional
    public void delReportParameter(ReportConditionBean reportConditionBean) {
        log.debug("$$$$$$$$$$\u5220\u9664\u62a5\u8868\u53c2\u6570<\u5f00\u59cb>$$$$$$$$$$");
        ReportCondition oldReprotCondition = this.reportConditionDao.getReportParameterById(reportConditionBean.getReportConditionId());
        if (oldReprotCondition == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportParameterExit") + ":" + reportConditionBean.getReportConditionId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportParameterExit"));
        }
        this.reportConditionDao.delReportCondition(oldReprotCondition);
        log.debug("$$$$$$$$$$\u5220\u9664\u62a5\u8868\u53c2\u6570<\u7ed3\u675f>$$$$$$$$$$");
    }

    @Override
    @Transactional
    public void editReportOther(ReportBean reportBean) {
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u5176\u4ed6\u914d\u7f6e\u9879<\u5f00\u59cb>$$$$$$$$$$");
        Report report = this.reportManagerDao.getReportById(reportBean.getReportId());
        if (report == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit") + ":" + reportBean.getReportId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit"));
        }
        report.setReportAppendJs(reportBean.getReportAppendJs());
        report.setReportInitJs(reportBean.getReportInitJs());
        report.setColumnCode(reportBean.getColumnCode());
        report.setColumnName(reportBean.getColumnName());
        this.reportManagerDao.editReport(report);
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u5176\u4ed6\u914d\u7f6e\u9879<\u7ed3\u675f>$$$$$$$$$$");
    }

    @Override
    @Transactional
    public void enableOrDisableReport(ReportBean reportBean) {
        log.debug("$$$$$$$$$$\u542f\u7981\u7528\u62a5\u8868<\u5f00\u59cb>$$$$$$$$$$");
        SysPower sysPower = new SysPower();
        Report report = this.reportManagerDao.getReportById(reportBean.getReportId());
        if (report == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit") + ":" + reportBean.getReportId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit"));
        }
        String codeValue = this.systemConfigPbService.getValueByCode("reportModuleParentId");
        if (codeValue == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.configNotFind") + ":" + "reportModuleParentId");
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.configNotFind"));
        }
        sysPower.setParent_id(codeValue);
        sysPower.setLink("/rptms/ViewReportControler/");
        sysPower.setLink_do("/rptms/ViewReportControler/index.do?reportId=" + report.getReportId());
        sysPower.setLink_page("rptms/viewreport/default/index");
        report.setFlag(reportBean.getFlag());
        this.reportManagerDao.editReport(report);
        SysPower findSysPower = null;
        log.debug("$\u542f\u7981\u7528\u62a5\u8868\u6a21\u5757.....start....");
        List<SysPower> sysPowerList = this.sysPowerService.querySysPowerList(sysPower, null);
        if (!sysPowerList.isEmpty()) {
            Iterator<SysPower> iterator = sysPowerList.iterator();
            while (iterator.hasNext()) {
                SysPower tmpSysPower;
                findSysPower = tmpSysPower = iterator.next();
            }
        }
        if (findSysPower == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportModuleExit") + ":" + sysPower.getLink_do());
        } else {
            if ("0".equals(report.getFlag())) {
                findSysPower.setStatus("1");
            } else {
                findSysPower.setStatus("0");
            }
            this.sysPowerService.updateModule(findSysPower);
        }
        log.debug("$\u542f\u7981\u7528\u62a5\u8868\u6a21\u5757.....end....");
        log.debug("$$$$$$$$$$\u542f\u7981\u7528\u62a5\u8868<\u7ed3\u675f>$$$$$$$$$$");
    }

    @Transactional
    private void deleteTimerReport(String eportId) {
        log.debug("\u5220\u9664\u5b9a\u65f6\u62a5\u8868.....start....");
        QueryReportTimerBean queryTimerReportBean = new QueryReportTimerBean();
        queryTimerReportBean.setReportId(eportId);
        List<QueryReportTimerBean> queryReportTimerBeanList = this.timerReportService.queryTimerReportsList(queryTimerReportBean, null);
        if (queryReportTimerBeanList != null) {
            for (QueryReportTimerBean tmpBean : queryReportTimerBeanList) {
                this.timerReportService.deleteReportTimer(this.timerReportService.queryTimerReportById(tmpBean.getId()));
            }
        }
        log.debug("\u5220\u9664\u5b9a\u65f6\u62a5\u8868.....end....");
    }

    @Override
    @Transactional
    public void editReportChart(ReportBean reportBean) {
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u56fe\u8868\u914d\u7f6e\u9879<\u5f00\u59cb>$$$$$$$$$$");
        Report report = this.reportManagerDao.getReportById(reportBean.getReportId());
        if (report == null) {
            log.error(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit") + ":" + reportBean.getReportId());
            throw new RuntimeException(MessageManager.getProMessage(this.message, "rptms.reportManager.error.noSuchReportExit"));
        }
        ReportChart reportChart = report.getReportChart();
        if (reportChart == null) {
            reportChart = new ReportChart();
        }
        reportChart.setCategoryColumnName(reportBean.getCategoryColumnName());
        reportChart.setCategoryName(reportBean.getCategoryName());
        reportChart.setChartType(reportBean.getChartType());
        reportChart.setTitle(reportBean.getTitle());
        reportChart.setValueColumnName(reportBean.getValueColumnName());
        reportChart.setValueName(reportBean.getValueName());
        reportChart.setPercentageValueColumnName(reportBean.getPercentageValueColumnName());
        reportChart.setPercentageValueName(reportBean.getPercentageValueName());
        reportChart.setShowChartButton(reportBean.getShowChartButton());
        reportChart.setSubReportURL(reportBean.getSubReportURL());
        reportChart.setReport(report);
        report.setReportChart(reportChart);
        this.reportManagerDao.editReport(report);
        log.debug("$$$$$$$$$$\u4fee\u6539\u62a5\u8868\u56fe\u8868\u914d\u7f6e\u9879<\u7ed3\u675f>$$$$$$$$$$");
    }
}

