/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pccm {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pccm.class);
    private String config;
    private Map<String, TypeItem> types;
    private List<TGroup> groups;
    private int max;
    private static Map<String, String> cardTypeName;

    private Pccm(String config) {
        this.config = config;
    }

    public static Pccm init(String config, Map<String, String> typeName) {
        if (config == null || "".equals(config) || "unlimited".equals(config)) {
            return null;
        }
        if ((config = config.replaceAll("\\s", "")).startsWith("|")) {
            config = config.substring(1);
        }
        if (config.endsWith("|")) {
            config = config.substring(0, config.length() - 1);
        }
        if (cardTypeName == null && typeName != null) {
            cardTypeName = typeName;
        } else {
            cardTypeName = new HashMap<String, String>();
            cardTypeName.put("1", "SIM");
            cardTypeName.put("2", "usbKey");
            cardTypeName.put("3", "TF");
            cardTypeName.put("4", "ACE");
            cardTypeName.put("6", "\u8d34\u819c\u5361");
            cardTypeName.put("9", "\u8f6f\u8bc1\u4e66");
        }
        return new Pccm(config);
    }

    public boolean judgeResult(String[] already, String target) {
        if (!this.prepare(already, target)) {
            return false;
        }
        int pastTimes = already.length;
        for (int i = 1; i <= pastTimes; ++i) {
            String pastType = already[i - 1];
            TypeItem item = this.types.get(pastType);
            if (item == null) continue;
            item.num.subtract();
            ArrayList<TGroup> newGroups = new ArrayList<TGroup>();
            for (TGroup group : this.groups) {
                if (group.isGroupWeedOut()) continue;
                newGroups.add(group);
            }
            this.groups = newGroups;
            this.reCalculate(this.max - i);
        }
        TypeItem item = this.types.get(target);
        int chance = item.num.num;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u672c\u6b21\u7533\u8bf7 {} \u5df2\u7ecf\u8d85\u51fa\u5141\u8bb8\u6570\u91cf\u8303\u56f4", (Object)cardTypeName.get(target));
        }
        return chance > 0;
    }

    private boolean prepare(String[] already, String target) {
        if (this.config.contains(target)) {
            this.types = this.initTypes();
            this.groups = this.getGroups();
            this.max = this.getMax();
            if (already.length >= this.max) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u672c\u6b21\u7533\u8bf7 {} \u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u5141\u8bb8\u6570\u91cf[{}]:{}", new Object[]{cardTypeName.get(target), this.max, already.length});
                }
                return false;
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u672c\u6b21\u7533\u8bf7 {} \u4e0d\u5728\u5141\u8bb8\u8303\u56f4", (Object)cardTypeName.get(target));
        }
        return false;
    }

    private void reCalculate(int opportunities) {
        Set<Map.Entry<String, TypeItem>> entries = this.types.entrySet();
        for (Map.Entry<String, TypeItem> entry : entries) {
            entry.getValue().num.restore();
        }
        for (TGroup group : this.groups) {
            List items = group.items;
            for (TypeItem item : items) {
                String type = item.type;
                TypeItem itemInTypes = this.types.get(type);
                itemInTypes.num.add();
            }
        }
        Set<Map.Entry<String, TypeItem>> entries2 = this.types.entrySet();
        for (Map.Entry<String, TypeItem> entry : entries2) {
            if (entry.getValue().num.num <= opportunities) continue;
            entry.getValue().num.num = opportunities;
        }
    }

    private Map<String, TypeItem> initTypes() {
        HashMap<String, TypeItem> typeItemMap = new HashMap<String, TypeItem>();
        int length = this.config.length();
        for (int i = 0; i < length; ++i) {
            char c = this.config.charAt(i);
            if (c == '|') continue;
            String s = String.valueOf(c);
            TypeItem typeItem = (TypeItem)typeItemMap.get(s);
            if (typeItem == null) {
                typeItem = new TypeItem(s, new TNum(1));
                typeItemMap.put(s, typeItem);
                continue;
            }
            typeItem.num.add();
        }
        return typeItemMap;
    }

    private List<TGroup> getGroups() {
        String[] split;
        ArrayList<TGroup> tGroups = new ArrayList<TGroup>();
        for (String gString : split = this.config.split("\\|")) {
            if ("".equals(gString)) continue;
            TGroup group = new TGroup();
            this.makeGroup(gString, group);
            tGroups.add(group);
        }
        return tGroups;
    }

    private void makeGroup(String gString, TGroup group) {
        int length = gString.length();
        for (int i = 0; i < length; ++i) {
            char c = gString.charAt(i);
            String type = String.valueOf(c);
            group.items.add(new TypeItem(type, this.types.get(type).num));
        }
    }

    private int getMax() {
        return this.groups.size();
    }

    private static class TNum {
        private int num;

        private TNum(int num) {
            this.num = num;
        }

        private void add() {
            ++this.num;
        }

        private void subtract() {
            --this.num;
        }

        private void restore() {
            this.num = 0;
        }
    }

    private static class TypeItem {
        private String type;
        private TNum num;

        private TypeItem(String type, TNum tNum) {
            this.type = type;
            this.num = tNum;
        }
    }

    private static class TGroup {
        private List<TypeItem> items = new ArrayList<TypeItem>();

        private TGroup() {
        }

        private boolean isGroupWeedOut() {
            for (TypeItem item : this.items) {
                if (item.num.num != 0) continue;
                return true;
            }
            return false;
        }
    }
}

