/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.ApplyForm;
import com.xdja.pams.scms.bean.CertInAirRtn;
import com.xdja.pams.scms.dao.ApproveRecordDao;
import com.xdja.pams.scms.dao.DeviceWorkflowDao;
import com.xdja.pams.scms.entity.ApproveRecordBean;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.DeviceWorkflow;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.ApplyTerminalService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.wfms.bean.WorkflowFlowBean;
import com.xdja.pams.wfms.service.WorkflowUtilService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplyTerminalServiceImpl
implements ApplyTerminalService {
    @Autowired
    private DeviceService devieService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private DeviceWorkflowDao dwd;
    @Autowired
    private WorkflowUtilService wus;
    @Autowired
    private UserManageService ums;
    @Autowired
    private DepManageService dms;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    ApproveRecordDao ard;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;

    @Override
    @Transactional
    public void ApplyTerminal(ApplyForm applyForm) {
        List<Device> deviceList = applyForm.getDeviceList();
        DeviceWorkflow dw = new DeviceWorkflow();
        String applyUserId = null;
        for (Device device : deviceList) {
            CertInAirRtn certInAirRtn = this.issuingDoubleCertInAirService.pccmCheck(device.getPersonId(), device.getType());
            if (!"0".equals(certInAirRtn.getFlag())) {
                throw new RuntimeException(CertInAirRtn.FLAG_MAP.get(certInAirRtn.getFlag()));
            }
            applyUserId = device.getPersonId();
            this.devieService.saveDeviceForWorkflow(device);
        }
        dw.setCreateDate(Util.getDate("yyyy-MM-dd HH:mm:ss"));
        dw.setCreatorId(applyForm.getUserId());
        dw.setCreatorName(applyForm.getUserName());
        dw.setDeviceList(deviceList);
        dw.setOperatorId(applyForm.getUserId());
        dw.setOperatorName(applyForm.getUserName());
        dw.setApplyUserId(applyUserId);
        dw.setOperatorDate(Util.getDate("yyyy-MM-dd HH:mm:ss"));
        this.dwd.saveDeviceWorkflow(dw);
        HashMap<String, String> variables = new HashMap<String, String>();
        this.identityService.setAuthenticatedUserId(applyForm.getUserId());
        variables.put(applyForm.getGroupId(), applyForm.getFlowUser());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("safeCard", dw.getId(), variables);
        String processInstanceId = processInstance.getId();
        dw.setProcessInstanceId(processInstanceId);
        List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnListForStart("safeCard");
        String btnName = "";
        if (wfbList != null && wfbList.size() == 1) {
            btnName = wfbList.get(0).getBtnName();
        }
        ApproveRecordBean entity = new ApproveRecordBean();
        entity.setUserId(applyForm.getUserId());
        entity.setUserName(applyForm.getUserName());
        entity.setApproveDate(new Date());
        entity.setApproveResult(btnName);
        entity.setApproveContent(btnName);
        entity.setProcessInstanceId(processInstanceId);
        entity.setTaskDefinitionId("startevent");
        this.ard.addApproveRecord(entity);
    }

    @Override
    @Transactional
    public void ApplyTerminalByDep(ApplyForm applyForm) {
        QueryPersonBean queryBean = new QueryPersonBean();
        queryBean.setDepId(applyForm.getApplyDepId());
        queryBean.setIsContain(applyForm.getIsContain());
        List<Person> persons = null;
        if ("one".equals(this.scps.getValueByCode("cardcount"))) {
            persons = this.ums.queryNotCardPerson(queryBean);
            if (persons == null || persons.isEmpty()) {
                throw new RuntimeException(MessageManager.getProMessage(this.message, "scms.device.apply.error.deppersonallapply"));
            }
        } else {
            persons = this.ums.queryPerson(queryBean);
            if (persons == null || persons.isEmpty()) {
                throw new RuntimeException(MessageManager.getProMessage(this.message, "scms.device.apply.error.depnotfindperson"));
            }
        }
        ArrayList<ApplyForm> applyForms = new ArrayList<ApplyForm>();
        for (Person person : persons) {
            ApplyForm af = new ApplyForm();
            BeanUtils.copyProperties((Object)applyForm, (Object)af);
            List<Device> devices = af.getDeviceList();
            ArrayList<Device> deviceNews = new ArrayList<Device>();
            af.setDeviceList(deviceNews);
            for (Device device : devices) {
                Device deviceNew = new Device();
                BeanUtils.copyProperties((Object)device, (Object)deviceNew);
                deviceNew.setPersonId(person.getId());
                List<Mobile> pms = person.getMobiledList();
                if (pms == null || pms.size() < 1) {
                    throw new RuntimeException(MessageManager.getProMessage(this.message, "scms.device.apply.error.notfindmobile", new String[]{person.getCode()}));
                }
                deviceNew.setMobile(person.getMobiledList().get(0));
                deviceNew.setApplyDate(new Date());
                Terminal terminalNew = new Terminal();
                BeanUtils.copyProperties((Object)device.getTerminal(), (Object)terminalNew);
                deviceNew.setTerminal(terminalNew);
                deviceNews.add(deviceNew);
            }
            applyForms.add(af);
        }
        for (ApplyForm afp : applyForms) {
            this.ApplyTerminal(afp);
        }
    }

    @Override
    @Transactional
    public void applyTerminalWithoutFlowByDep(ApplyForm applyForm) {
        QueryPersonBean queryBean = new QueryPersonBean();
        queryBean.setDepId(applyForm.getApplyDepId());
        queryBean.setIsContain(applyForm.getIsContain());
        List<Person> persons = null;
        if ("one".equals(this.scps.getValueByCode("cardcount"))) {
            persons = this.ums.queryNotCardPerson(queryBean);
            if (persons == null || persons.isEmpty()) {
                throw new RuntimeException(MessageManager.getProMessage(this.message, "scms.device.apply.error.deppersonallapply"));
            }
        } else {
            persons = this.ums.queryPerson(queryBean);
            if (persons == null || persons.isEmpty()) {
                throw new RuntimeException(MessageManager.getProMessage(this.message, "scms.device.apply.error.depnotfindperson"));
            }
        }
        ArrayList<ApplyForm> applyForms = new ArrayList<ApplyForm>();
        for (Person person : persons) {
            ApplyForm af = new ApplyForm();
            BeanUtils.copyProperties((Object)applyForm, (Object)af);
            List<Device> devices = af.getDeviceList();
            ArrayList<Device> deviceNews = new ArrayList<Device>();
            af.setDeviceList(deviceNews);
            for (Device device : devices) {
                Device deviceNew = new Device();
                BeanUtils.copyProperties((Object)device, (Object)deviceNew);
                deviceNew.setPersonId(person.getId());
                List<Mobile> pms = person.getMobiledList();
                if (pms == null || pms.size() < 1) {
                    throw new RuntimeException(MessageManager.getProMessage(this.message, "scms.device.apply.error.notfindmobile", new String[]{person.getCode()}));
                }
                deviceNew.setMobile(person.getMobiledList().get(0));
                deviceNew.setApplyDate(new Date());
                Terminal terminalNew = new Terminal();
                BeanUtils.copyProperties((Object)device.getTerminal(), (Object)terminalNew);
                deviceNew.setTerminal(terminalNew);
                deviceNews.add(deviceNew);
            }
            applyForms.add(af);
        }
        for (ApplyForm afp : applyForms) {
            this.applyTerminalWithoutFlow(afp);
        }
    }

    @Override
    @Transactional
    public void applyTerminalWithoutFlow(ApplyForm applyForm) {
        List<Device> deviceList = applyForm.getDeviceList();
        String cardState = "1";
        String isNeedAddMobile = this.scps.getValueByCode("userCardMobileAdd");
        if ("1".equals(isNeedAddMobile)) {
            cardState = "6";
        }
        if (deviceList != null && !deviceList.isEmpty()) {
            for (Device device : deviceList) {
                CertInAirRtn certInAirRtn = this.issuingDoubleCertInAirService.pccmCheck(device.getPersonId(), device.getType());
                if (!"0".equals(certInAirRtn.getFlag())) {
                    throw new RuntimeException(CertInAirRtn.FLAG_MAP.get(certInAirRtn.getFlag()));
                }
                device.setState(cardState);
                Date now = new Date();
                device.setBindingDate(now);
                device.setApplyDate(now);
                device.setBindingState(this.userManageService.getBingDingState(device.getType()));
                device.setLockState("0");
                device.setFlag("1");
                this.devieService.save(device);
            }
        }
    }
}

