/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.enaas.bean.EnaasResponse;
import com.xdja.pams.enaas.service.EnaasService;
import com.xdja.pams.scms.bean.ApplyForm;
import com.xdja.pams.scms.bean.CertInAirRtn;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.bean.DeviceBean;
import com.xdja.pams.scms.bean.PersonImei;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.bean.TRInfo;
import com.xdja.pams.scms.dao.DeviceDao;
import com.xdja.pams.scms.dao.DeviceWorkflowDao;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.DeviceWorkflow;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.ApplyTerminalService;
import com.xdja.pams.scms.service.DevicePbService;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.scms.service.TerminalReportService;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.sso.bean.SynQueryParam;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.wfms.bean.WorkflowFlowBean;
import com.xdja.pams.wfms.service.WorkflowUtilService;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class DeviceServiceImpl
implements DeviceService,
DevicePbService {
    private static final Logger log = LoggerFactory.getLogger(DeviceServiceImpl.class);
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private TerminalLogService terminalLogService;
    @Autowired
    private TerminalReportService terminalReportService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DeviceWorkflowDao dwd;
    @Autowired
    private WorkflowUtilService wus;
    @Autowired
    private ApplyTerminalService applyTerminalService;
    @Autowired
    private EnaasService enaasService;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private IssuingDoubleCertInAirService issuingDoubleCertInAirService;

    @Override
    public List<Device> query(QueryForm form, Page page) {
        List<Device> deviceList = this.deviceDao.query(form, page);
        if (deviceList == null) {
            deviceList = new ArrayList<Device>();
        }
        return deviceList;
    }

    @Override
    public List<Device> queryDeviceByImeiImsiIccid(QueryForm form, Page page) {
        return this.deviceDao.queryDeviceByImeiImsiIccid(form, page);
    }

    @Override
    public List<Device> getApproveCard() {
        return this.deviceDao.getApproveCard();
    }

    @Override
    public Device save(Device device) {
        this.deviceDao.save(device);
        return device;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Device save(Device device, Person person) {
        String sysModel = this.systemConfigService.getValueByCode("sysModel");
        if (null == sysModel || sysModel.indexOf("1") < 0 && sysModel.indexOf("0") < 0) {
            device.setState("3");
            this.deviceDao.save(device);
        } else if (null != sysModel && sysModel.indexOf("1") >= 0 && sysModel.indexOf("0") < 0) {
            device.setState("1");
            this.deviceDao.save(device);
        } else if (null != sysModel && sysModel.indexOf("0") >= 0) {
            String isNeedFlow = this.systemConfigService.getValueByCode("scms_cardapply_needflow");
            if (!"1".equals(isNeedFlow)) {
                String cardState = "1";
                String isNeedAddMobile = this.systemConfigService.getValueByCode("userCardMobileAdd");
                if ("1".equals(isNeedAddMobile)) {
                    cardState = "6";
                }
                device.setState(cardState);
                Date now = new Date();
                device.setBindingDate(now);
                device.setApplyDate(now);
                device.setBindingState(this.userManageService.getBingDingState(device.getType()));
                device.setLockState("0");
                device.setFlag("1");
                this.deviceDao.save(device);
            } else {
                List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnListForStart("safeCard");
                String groupId = "";
                if (wfbList != null && wfbList.size() > 0) {
                    WorkflowFlowBean wfb = wfbList.get(0);
                    groupId = wfb.getTaskGroupCode();
                }
                device.setState("0");
                ApplyForm applyForm = new ApplyForm();
                ArrayList<Device> deviceList = new ArrayList<Device>();
                deviceList.add(device);
                applyForm.setDeviceList(deviceList);
                applyForm.setPersonId(person.getId());
                applyForm.setUserId(person.getCreatorId());
                Person user = this.userManageService.queryPersonById(person.getCreatorId());
                applyForm.setUserName(user.getName());
                applyForm.setFlowUser(this.userManageService.getWorkFlowUser(person.getId(), groupId));
                applyForm.setGroupId(groupId);
                this.applyTerminalService.ApplyTerminal(applyForm);
            }
        }
        return device;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void save(List<Device> devices, Person person) {
        String sysModel = this.systemConfigService.getValueByCode("sysModel");
        if (null == sysModel || sysModel.indexOf("1") < 0 && sysModel.indexOf("0") < 0) {
            for (Device device : devices) {
                device.setState("3");
                this.deviceDao.save(device);
            }
        } else if (null != sysModel && sysModel.indexOf("1") >= 0 && sysModel.indexOf("0") < 0) {
            for (Device device : devices) {
                device.setState("1");
                this.deviceDao.save(device);
            }
        } else if (null != sysModel && sysModel.indexOf("0") >= 0) {
            String isNeedFlow = this.systemConfigService.getValueByCode("scms_cardapply_needflow");
            if (!"1".equals(isNeedFlow)) {
                String cardState = "1";
                String isNeedAddMobile = this.systemConfigService.getValueByCode("userCardMobileAdd");
                if ("1".equals(isNeedAddMobile)) {
                    cardState = "6";
                }
                for (Device device : devices) {
                    device.setState(cardState);
                    Date now = new Date();
                    device.setBindingDate(now);
                    device.setApplyDate(now);
                    device.setBindingState(this.userManageService.getBingDingState(device.getType()));
                    device.setLockState("0");
                    device.setFlag("1");
                    this.deviceDao.save(device);
                }
            } else {
                List<WorkflowFlowBean> wfbList = this.wus.getWorkFlowBtnListForStart("safeCard");
                String groupId = "";
                if (wfbList != null && wfbList.size() > 0) {
                    WorkflowFlowBean wfb = wfbList.get(0);
                    groupId = wfb.getTaskGroupCode();
                }
                for (Device device : devices) {
                    device.setState("0");
                    this.deviceDao.save(device);
                }
                ApplyForm applyForm = new ApplyForm();
                ArrayList<Device> deviceList = new ArrayList<Device>();
                deviceList.addAll(devices);
                applyForm.setDeviceList(deviceList);
                applyForm.setPersonId(person.getId());
                applyForm.setUserId(person.getCreatorId());
                Person user = this.userManageService.queryPersonById(person.getCreatorId());
                applyForm.setUserName(user.getName());
                applyForm.setFlowUser(this.userManageService.getWorkFlowUser(person.getId(), groupId));
                applyForm.setGroupId(groupId);
                this.applyTerminalService.ApplyTerminal(applyForm);
            }
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(Device device) {
        this.deviceDao.update(device);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Device device) {
        String hardNo = device.getHardNo();
        device.setHardNo("");
        device.setRevocationDate(new Date());
        device.setRevokeFlag("1");
        device.setEnaasDesc(device.getIccid());
        device.setHardNo("");
        device.setIccid("");
        device.setImei("");
        device.setImsi("");
        device.setCertificate("");
        device.setCertificate2("");
        device.setSn("");
        device.setSn2("");
        device.setMobile(null);
        device.setOriginalHardNo(hardNo);
        this.update(device);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Serializable id) {
        Device device = this.get(id);
        this.delete(device);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateState(String state, String[] ids) {
        for (String id : ids) {
            this.deviceDao.updateState(id, state);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateBindingState(String bindingState, String[] personIds) {
        for (String personId : personIds) {
            this.deviceDao.updateBindingState(bindingState, personId);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void updateBindingStateById(String bindingState, String[] ids) {
        for (String id : ids) {
            this.deviceDao.updateBindingStateById(bindingState, id);
        }
    }

    @Override
    public Device get(Serializable id) {
        return this.deviceDao.get(id);
    }

    @Override
    public Device getByCardNO(String cardNO) {
        return this.deviceDao.getByCardNO(cardNO);
    }

    @Override
    public Device getByEnaasUserId(String enaasUserId) {
        return this.deviceDao.getByEnaasUserId(enaasUserId);
    }

    @Override
    public List<Device> getByPersonId(String personId) {
        return this.deviceDao.queryByPersonId(personId);
    }

    @Override
    public List<Device> getAllByPersonId(String personId) {
        return this.deviceDao.queryAllByPersonId(personId);
    }

    @Override
    public void writecard(Device device) {
        this.deviceDao.update(device);
    }

    @Override
    public void reBand(String id) {
        this.deviceDao.reBand(id);
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    @Override
    public TerminalLog cvsDeviceToTerminalLog(Device device, String operation) {
        PersonBean personb = this.userManageService.getPersonById(device.getPersonId());
        TRInfo trInfo = this.systemConfigService.getTRInfo();
        TerminalLog terminalLog = new TerminalLog();
        terminalLog.setSn(device.getSn());
        terminalLog.setOpFlag(operation);
        terminalLog.setCardType(device.getType());
        terminalLog.setName(personb.getNAME());
        terminalLog.setCode(personb.getCODE());
        terminalLog.setIdentifier(personb.getIDENTIFIER());
        terminalLog.setDept(personb.getDEPCODE());
        terminalLog.setArea(terminalLog.getDept().substring(0, 4));
        terminalLog.setTerminalType(TRInfo.getTerminalType(device.getType()));
        if (device.getTerminal() != null) {
            terminalLog.setTerminalName(device.getTerminal().getTerminalname());
            terminalLog.setTerminalOS(device.getTerminal().getTerminalos());
            terminalLog.setTerminalOutlink(TRInfo.getTerminalOutLink(device.getCommType()));
            terminalLog.setTerminalBand(device.getTerminal().getTerminalband());
        }
        terminalLog.setCardNumber(device.getHardNo());
        if (device.getMobile() != null) {
            terminalLog.setMobile(device.getMobile().getMobile());
        }
        terminalLog.setCardName(trInfo.getCardName());
        terminalLog.setCardVersion(trInfo.getCardVersion());
        terminalLog.setPolice(personb.getPOLICE());
        terminalLog.setGrade(personb.getGRADE());
        terminalLog.setOpDate(new Date());
        return terminalLog;
    }

    @Override
    public boolean isWrite(String personId) {
        List<Device> list = this.deviceDao.queryWriteByPersonId(personId);
        return list != null && list.size() > 0;
    }

    @Override
    public void updateBindStateAll(String bindState) {
        this.deviceDao.updateBindStateAll(bindState);
    }

    @Override
    public List<Device> getByMobile(String mobile) {
        return this.deviceDao.getByMobile(mobile);
    }

    @Override
    public List<Device> getUsableByMobile(String mobile) {
        return this.deviceDao.getUsableByMobile(mobile);
    }

    @Override
    public DeviceWorkflow getDeviceWorkFlow(String id) {
        return this.dwd.getDeviceWorkflowByID(id);
    }

    @Override
    @Transactional
    public void deleteDeviceWorkflow(String personId) {
        if (!Util.varCheckEmp(personId)) {
            this.dwd.deleteDeviceWorkflow(personId);
        }
    }

    @Override
    public void saveDeviceForWorkflow(Device device) {
        if (device != null) {
            device.setState("0");
            Date now = new Date();
            device.setBindingDate(now);
            device.setApplyDate(now);
            device.setBindingState(this.userManageService.getBingDingState(device.getType()));
            device.setLockState("0");
            device.setFlag("1");
            this.save(device);
        }
    }

    @Override
    public String writeOffline() {
        DInfo dinfo = this.systemConfigService.getDInfo();
        return "";
    }

    public KeyPair createKeypair() {
        Security.getProviders();
        KeyPair keypair = null;
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            keypair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return keypair;
    }

    @Override
    public List<Device> querySynDeviceList(SynQueryParam synQueryParam, Page page) {
        return this.deviceDao.querySynDeviceList(synQueryParam, page);
    }

    @Override
    public List<DeviceBean> querySynDeviceBeanList(SynQueryParam synQueryParam, Page page) {
        return this.deviceDao.querySynDeviceBeanList(synQueryParam, page);
    }

    @Override
    public void revokeApprove(String[] ids) {
        for (String id : ids) {
            Device device = this.get((Serializable)((Object)id));
            if (!"1".equals(device.getState())) {
                throw new RuntimeException("\u53ea\u80fd\u64a4\u9500\u72b6\u6001\u4e3a\u5df2\u5ba1\u6279\u7684\u5b89\u5168\u5361\uff01");
            }
            device.setRevokeFlag("1");
            device.setImei(null);
            device.setImsi(null);
            device.setState("0");
            device.setMobile(null);
            this.update(device);
        }
    }

    @Override
    public boolean isExistImeiOrImsi(String imeiOrimsi, String flag) {
        boolean isExist = false;
        List<Device> deviceList = this.deviceDao.getImeisOrImsis(imeiOrimsi, flag);
        if (null != deviceList && deviceList.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    @Override
    public List<PersonImei> queryPersonImei(String userIds, String deps) {
        return this.deviceDao.queryPersonImei(userIds, deps);
    }

    @Override
    public Device reSubmitAuthentication(String id) {
        Device device = this.deviceDao.get((Serializable)((Object)id));
        EnaasResponse rst = this.enaasService.approvePersonInfoV2(device);
        if ("1".equals(rst.getFlag())) {
            device.setEnaasState("5");
        } else {
            device.setEnaasState("4");
            device.setEnaasDesc(rst.getDesc());
        }
        this.deviceDao.update(device);
        return device;
    }

    @Override
    public void updateVideoState(String id, String state) {
        Device device = this.deviceDao.get((Serializable)((Object)id));
        device.setVideoDeviceOpenState(state);
        this.deviceDao.update(device);
    }

    @Override
    public List<Device> queryVideoDeviceList(long timestamp, Page page) {
        return this.deviceDao.queryVideoDeviceList(timestamp, page);
    }

    @Override
    @Transactional
    public void addCardMobile(String deviceId, String mobile) {
        Mobile mb = this.userManageService.getMobile(mobile);
        Device device = this.get((Serializable)((Object)deviceId));
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (mb != null) {
            if (!mb.getPerson().getId().equals(device.getPersonId())) {
                throw new RuntimeException("\u624b\u673a\u53f7\u91cd\u590d\uff01");
            }
        } else {
            mb = new Mobile();
            mb.setMobile(mobile);
            mb.setPerson(person);
            String mobiles = person.getMobile();
            mobiles = StringUtils.isBlank((CharSequence)mobiles) ? mobile : mobiles + "," + mobile;
            List<Mobile> mobileList = person.getMobiledList();
            if (mobileList == null) {
                mobileList = new ArrayList<Mobile>();
            }
            mobileList.add(mb);
            person.setMobile(mobiles);
            this.userManageService.updateUser(person);
        }
        device.setState("1");
        device.setMobile(mb);
        this.update(device);
    }

    @Override
    public void updateDeviceWhereMobileNotExist() {
        String sql = "update t_device set mobile_id = null where mobile_id in(select id from t_bims_mobile where person_id is null)";
        this.baseDao.updateBySql(sql, new String[0]);
    }

    @Override
    public Device getByIMEI(String imei) {
        return this.deviceDao.getByIMEI(imei);
    }

    @Override
    public Device getBySn(String sn) {
        return this.deviceDao.getBySn(sn);
    }

    @Override
    public void updateDeviceInfoToNullByPersonId(String personId) {
        List<Device> list = this.getByPersonId(personId);
        if (list != null && !list.isEmpty()) {
            for (Device device : list) {
                if (Strings.isNotEmpty(device.getHardNo())) {
                    CertInAirRtn crtn = null;
                    try {
                        crtn = this.issuingDoubleCertInAirService.revokeForPage(device.getId(), device.getHardNo());
                        if ("0".equals(crtn.getFlag())) continue;
                        throw new RuntimeException("\u3010\u64a4\u9500\u8bc1\u4e66\u5f02\u5e38\u3011" + CertInAirRtn.FLAG_MAP.get(crtn.getFlag()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u3010\u64a4\u9500\u8bc1\u4e66\u5f02\u5e38\u3011" + e.getMessage());
                    }
                }
                String hardNo = device.getHardNo();
                device.setState("11");
                device.setRevocationDate(new Date());
                device.setRevokeFlag("1");
                device.setEnaasDesc(device.getIccid());
                device.setHardNo("");
                device.setIccid("");
                device.setImei("");
                device.setImsi("");
                device.setCertificate("");
                device.setCertificate2("");
                device.setMobile(null);
                device.setSn("");
                device.setSn2("");
                device.setOriginalHardNo(hardNo);
                this.update(device);
            }
        }
        this.deleteTerminDistribut(personId);
    }

    private void deleteTerminDistribut(String personId) {
        CommonCode terminalManage = this.commonCodeService.getByCode("terminal_manage", null);
        if (terminalManage != null) {
            try {
                String sql = "update T_TERMINAL_DISTRIBUTION set STATE = '3' where PERSON_ID = ?";
                this.baseDao.updateBySql(sql, new Object[]{personId});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

