/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.service.impl;

import com.xdja.pams.bims.dao.MobileDao;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.CertAirExt;
import com.xdja.pams.scms.bean.CertInAirForm;
import com.xdja.pams.scms.bean.CertInAirRtn;
import com.xdja.pams.scms.bean.CertValidity;
import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.bean.DInfoCA;
import com.xdja.pams.scms.bean.Pccm;
import com.xdja.pams.scms.dao.CertAirDao;
import com.xdja.pams.scms.dao.PersonSPCAInfoDao;
import com.xdja.pams.scms.entity.CertAir;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.PersonJITInfo;
import com.xdja.pams.scms.entity.PersonKOALInfo;
import com.xdja.pams.scms.entity.PersonSPCAInfo;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.entity.TerminalLog;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.IssuingDoubleCertInAirService;
import com.xdja.pams.scms.service.PersonJITInfoService;
import com.xdja.pams.scms.service.PersonKOALInfoService;
import com.xdja.pams.scms.service.TerminalLogService;
import com.xdja.pams.scms.util.CAType;
import com.xdja.pams.scms.util.CertUserInfoTrans;
import com.xdja.pams.scms.util.CertUtil;
import com.xdja.pams.scms.util.CommonDClientForSimpleCA;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigService;
import com.xdja.pams.webservice.client.CommonDClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IssuingDoubleCertInAirServiceImpl
implements IssuingDoubleCertInAirService {
    private static final Logger log = LoggerFactory.getLogger(IssuingDoubleCertInAirServiceImpl.class);
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigService systemConfigExtService;
    @Autowired
    private PersonSPCAInfoDao personSPCAInfoDao;
    @Autowired
    private PersonJITInfoService personJITInfoService;
    @Autowired
    private PersonKOALInfoService personKOALInfoService;
    @Autowired
    private CertAirDao certAirDao;
    @Autowired
    private MobileDao mobileDao;
    @Autowired
    private TerminalLogService terminalLogService;
    @Autowired
    private CommonCodeService commonCodeService;
    private static volatile Map<String, String> cardTypeName;
    private static final Map<String, String> ERR_CODE_MAP;
    private static final Map<String, String> CERT_STATE_MAP;
    private static final String ISCHINAMOBILE = "^134[0-8]\\d{7}$|^(?:13[5-9]|147|15[0-27-9]|178|1703|1705|1706|18[2-478])\\d{7,8}$";
    private static final String ISCHINAUNIOM = "^(?:13[0-2]|145|15[56]|176|1704|1707|1708|1709|171|18[56])\\d{7,8}|$";
    private static final String ISCHINATELCOM = "^(?:133|153|1700|1701|1702|177|173|18[019])\\d{7,8}$";

    private String getImeiOrImsi(String source) {
        return Strings.isEmpty(source) ? "" : source.split("#")[0];
    }

    private CertInAirRtn applyInner(Person person) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5185\u90e8\u5b9e\u4f53\u8ba4\u8bc1\u5f00\u59cb");
        return CertInAirRtn.rtn_all(this.createDn(person), "1", null);
    }

    private String createDn(Person person) {
        try {
            StringBuffer sb = new StringBuffer("cn=");
            sb.append(person.getName());
            sb.append(" ");
            sb.append(person.getIdentifier());
            String orgCode = person.getDepartment().getCode();
            sb.append(",ou=");
            sb.append(orgCode.substring(10, 12));
            sb.append(",ou=");
            sb.append(orgCode.substring(8, 10));
            sb.append(",o=");
            sb.append(orgCode.substring(6, 8));
            sb.append(",l=");
            sb.append(orgCode.substring(4, 6));
            sb.append(",l=");
            sb.append(orgCode.substring(2, 4));
            sb.append(",ST=");
            sb.append(orgCode.substring(0, 2));
            sb.append(",C=CN");
            return sb.toString();
        }
        catch (Exception e) {
            return "cn=" + person.getName() + " " + person.getIdentifier();
        }
    }

    private CertInAirRtn applyJIT(Person person, String type, DInfoCA dInfoCA, String hardNo, boolean needRemoteJit) {
        if (!needRemoteJit) {
            return CertInAirRtn.rtn_all(this.createDn(person), "1", null);
        }
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5409\u5927\u5b9e\u4f53\u8ba4\u8bc1\u5f00\u59cb");
        type = "6".equals(type) ? "3" : type;
        PersonJITInfo pki = this.personJITInfoService.findByPersonId(person.getId(), type);
        String cardType = DInfo.covCartTypeJIT(type);
        String userInfoId = "";
        if (pki != null) {
            if ("1".equals(pki.getWriteFlag())) {
                log.debug("[JIT]\u6b64\u7528\u6237\u6b64\u7c7b\u578b\u5361\u5df2\u5199\u5361 , ");
            }
            if ("1".equals(pki.getApplyFlag())) {
                // empty if block
            }
            if (pki.getUserInfoId() != null) {
                userInfoId = pki.getUserInfoId();
            }
        } else {
            String userInfoIdExist = this.personJITInfoService.getUserInfoIdByPersonId(person.getId());
            if (userInfoIdExist != null) {
                userInfoId = userInfoIdExist;
            }
        }
        String version = "3.0";
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("xingming", person.getName());
        userMap.put("jinghao", person.getCode());
        userMap.put("kahao", hardNo);
        userMap.put("xingbie", person.getSex());
        userMap.put("shenfenzhenghao", person.getIdentifier());
        userMap.put("jingzhong", person.getPolice());
        userMap.put("renzhi", "0001");
        userMap.put("gongzuogangwei", "0803");
        userMap.put("zhiji", person.getPosition());
        userMap.put("organ_id", person.getDepartment().getCode());
        String userInfo = Util.toJsonStr(userMap);
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.certApplyRAJit(dInfoCA.getUrl(), version, caAlg, cardType, person.getName(), person.getIdentifier(), person.getDepartment().getCode(), userInfo, userInfoId, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.debug("\u5409\u5927\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
        String[] rstArr = rst.split("#");
        if (rstArr[0] != null && rstArr.length >= 2) {
            if (pki != null) {
                pki.setAuthCode(rstArr[0]);
                pki.setRefCode(rstArr[1]);
                pki.setApplyFlag("1");
                this.personJITInfoService.update(pki);
            } else {
                PersonJITInfo jitInfo = new PersonJITInfo();
                jitInfo.setAuthCode(rstArr[0]);
                jitInfo.setRefCode(rstArr[1]);
                if ("".equals(userInfoId) && rstArr.length == 3) {
                    jitInfo.setUserInfoId(rstArr[2]);
                } else {
                    jitInfo.setUserInfoId(userInfoId);
                }
                jitInfo.setPersonId(person.getId());
                jitInfo.setCreateDate(new Date());
                jitInfo.setCardType(type);
                jitInfo.setApplyFlag("1");
                this.personJITInfoService.save(jitInfo);
            }
            return CertInAirRtn.rtn_all(this.createDn(person), "1", null);
        }
        if (rstArr[0] != null) {
            log.debug("[JIT]\u8ba4\u8bc1\u6ce8\u518c\u5931\u8d25 , \u7ed3\u679c: {}, \u539f\u56e0:{}", (Object)rstArr[0], (Object)DInfo.getErrCertApplyRA(rstArr[0]));
            return CertInAirRtn.covRtn(rstArr[0]);
        }
        return null;
    }

    private CertInAirRtn applyJITWhenDownLoadCert(Person person, String type, DInfoCA dInfoCA) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5409\u5927\u5b9e\u4f53\u8ba4\u8bc1\u5f00\u59cb");
        type = "6".equals(type) ? "3" : type;
        PersonJITInfo pki = this.personJITInfoService.findByPersonId(person.getId(), type);
        String cardType = DInfo.covCartTypeJIT(type);
        String userInfoId = "";
        if (pki != null) {
            if ("1".equals(pki.getWriteFlag())) {
                log.debug("[JIT]\u6b64\u7528\u6237\u6b64\u7c7b\u578b\u5361\u5df2\u5199\u5361 , \u4e0d\u5141\u8bb8\u7533\u8bf7");
                return CertInAirRtn.rtn("69");
            }
            if ("1".equals(pki.getApplyFlag())) {
                return CertInAirRtn.rtn_all(this.createDn(person), "1", null);
            }
            if (pki.getUserInfoId() != null) {
                userInfoId = pki.getUserInfoId();
            }
        } else {
            String userInfoIdExist = this.personJITInfoService.getUserInfoIdByPersonId(person.getId());
            if (userInfoIdExist != null) {
                userInfoId = userInfoIdExist;
            }
        }
        String version = "3.0";
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("xingming", person.getName());
        userMap.put("xingbie", person.getSex());
        userMap.put("shenfenzhenghao", person.getIdentifier());
        userMap.put("jingzhong", person.getPolice());
        userMap.put("renzhi", "0001");
        userMap.put("gongzuogangwei", "0803");
        userMap.put("zhiji", person.getPosition());
        userMap.put("organ_id", person.getDepartment().getCode());
        String userInfo = Util.toJsonStr(userMap);
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.certApplyRAJit(dInfoCA.getUrl(), version, caAlg, cardType, person.getName(), person.getIdentifier(), person.getDepartment().getCode(), userInfo, userInfoId, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.debug("\u5409\u5927\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
        String[] rstArr = rst.split("#");
        if (rstArr[0] != null && rstArr.length >= 2) {
            if (pki != null) {
                pki.setAuthCode(rstArr[0]);
                pki.setRefCode(rstArr[1]);
                pki.setApplyFlag("1");
                this.personJITInfoService.update(pki);
            } else {
                PersonJITInfo jitInfo = new PersonJITInfo();
                jitInfo.setAuthCode(rstArr[0]);
                jitInfo.setRefCode(rstArr[1]);
                if ("".equals(userInfoId) && rstArr.length == 3) {
                    jitInfo.setUserInfoId(rstArr[2]);
                } else {
                    jitInfo.setUserInfoId(userInfoId);
                }
                jitInfo.setPersonId(person.getId());
                jitInfo.setCreateDate(new Date());
                jitInfo.setCardType(type);
                jitInfo.setApplyFlag("1");
                this.personJITInfoService.save(jitInfo);
            }
            return CertInAirRtn.rtn("0");
        }
        if (rstArr[0] != null) {
            log.debug("[JIT]\u8ba4\u8bc1\u6ce8\u518c\u5931\u8d25 , \u7ed3\u679c: {}, \u539f\u56e0:{}", (Object)rstArr[0], (Object)DInfo.getErrCertApplyRA(rstArr[0]));
            return CertInAirRtn.covRtn(rstArr[0]);
        }
        return null;
    }

    private CertInAirRtn applyKA(Person person) {
        return CertInAirRtn.rtn_all(this.createDn(person), "1", null);
    }

    private CertInAirRtn applyKAWhenDownloadCert(Person person, DInfoCA dInfoCA, Device device) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u683c\u5c14\u5b9e\u4f53\u8ba4\u8bc1\u5f00\u59cb");
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(device.getId());
        if (pki != null && StringUtils.isNotBlank((CharSequence)pki.getKoalId())) {
            log.debug("[\"success\",\"\u6ce8\u518c\u683c\u5c14\u7528\u6237\u6210\u529f\uff01\"]");
            return this.reviewKA(pki, dInfoCA);
        }
        String version = "3.0";
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("USER_IDNO", person.getIdentifier());
        userMap.put("USER_NAME", person.getName());
        userMap.put("USER_CREY", "00");
        userMap.put("USER_POTYPE", CertUserInfoTrans.getUserPoType(person.getPolice()));
        userMap.put("CERT_TYPE", CertUserInfoTrans.getCertType(person.getPersonType(), device.getType()));
        userMap.put("USER_POSLEVEL", CertUserInfoTrans.getPosLevel(person.getPosition()));
        userMap.put("USER_POS", CertUserInfoTrans.getPos(person.getGrade(), person.getPosition()));
        userMap.put("USER_WORK", CertUserInfoTrans.getWork());
        userMap.put("USER_ORG_CODE", person.getDepartment().getCode());
        String userInfo = Util.toJsonStr(userMap);
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.certApplyRA30(dInfoCA.getUrl(), version, userInfo, caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.debug("\u683c\u5c14\u6ce8\u518c\u63a5\u53e3\u8fd4\u56de:" + rst);
        String[] rstArr = rst.split("#");
        if (rstArr[0] != null && rstArr.length > 1 && "userId".equals(rstArr[0])) {
            log.debug("\u6ce8\u518c\u683c\u5c14\u7528\u6237\u6210\u529f\uff01");
            PersonKOALInfo pk = this.personKOALInfoService.save(person.getId(), device.getId(), rstArr[1], "", device.getType());
            return this.reviewKA(pk, dInfoCA);
        }
        if (rstArr[0] != null) {
            log.debug("[\"" + rstArr[0] + "\",\"" + DInfo.getCertApplyRAKR(rstArr[0]) + "\"]");
            return CertInAirRtn.covRtn(rstArr[0]);
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn reviewKA(PersonKOALInfo pki, DInfoCA dInfoCA) {
        if (pki != null && "1".equals(pki.getState())) {
            log.debug("\u683c\u5c14\u5b9e\u4f53\u8ba4\u8bc1, \u5ba1\u6838\u6210\u529f");
            return CertInAirRtn.rtn("0");
        }
        String version = "3.0";
        String reviewType = "2";
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.reviewRA30(dInfoCA.getUrl(), version, pki.getKoalId(), reviewType, caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.debug("\u683c\u5c14\u5ba1\u6279\u63a5\u53e3\u8fd4\u56de:" + rst);
        if ("1".equals(rst)) {
            this.personKOALInfoService.updateState(pki.getId());
            log.debug("\u683c\u5c14\u5b9e\u4f53\u8ba4\u8bc1, \u5ba1\u6838\u6210\u529f");
            return CertInAirRtn.rtn("0");
        }
        log.debug("\u683c\u5c14\u5b9e\u4f53\u8ba4\u8bc1, \u5ba1\u6838\u5931\u8d25, \u7ed3\u679c\u7801: {}, \u539f\u56e0: {}", (Object)rst, (Object)DInfo.getReviewRAKR(rst));
        return CertInAirRtn.covRtn(rst);
    }

    private CertInAirRtn applySPCA(Person person, String type, String hardNo, DInfoCA dInfoCA) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u7b80\u6613CA\u5b9e\u4f53\u8ba4\u8bc1\u5f00\u59cb");
        PersonSPCAInfo personSPCAInfo = this.personSPCAInfoDao.findByPersonId(person.getId());
        if (personSPCAInfo != null) {
            String state = personSPCAInfo.getState();
            if ("0".equals(state)) {
                log.info("[\u7b80\u6613CA]\u8ba4\u8bc1\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838");
                return CertInAirRtn.rtn("82");
            }
            if ("1".equals(state)) {
                log.info("[\u7b80\u6613CA]\u8ba4\u8bc1\u72b6\u6001\u4e3a\u5df2\u5ba1\u6279");
                String dn = this.createDn(person);
                personSPCAInfo.setDn(dn);
                this.personSPCAInfoDao.updatePersonSPCAInfo(personSPCAInfo);
                return CertInAirRtn.rtn_all(dn, "0", null);
            }
            log.info("[\u7b80\u6613CA]\u5df2\u7ecf\u5b9e\u4f53\u8ba4\u8bc1\u8fc7, \u4f46\u72b6\u6001\u4e3a:[{}] (\u72b6\u6001: 0 \u5f85\u5ba1\u6279\uff0c1\u5df2\u5ba1\u6279)", (Object)state);
            return CertInAirRtn.rtn("83");
        }
        String dn = this.createDn(person);
        log.info("[\u7b80\u6613CA] \u83b7\u53d6\u5230\u7684DN : {}", (Object)dn);
        if (Util.varCheckEmp(dn) || "37".equals(dn) || "-1".equals(dn)) {
            return CertInAirRtn.rtn("80");
        }
        String userInfo = this.createUserInfoCA(person, hardNo, type);
        String result = CommonDClientForSimpleCA.certApplyRA(dInfoCA.getUrl(), dn, userInfo, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), "");
        log.debug("[\u7b80\u6613CA]\u8ba4\u8bc1\u7ed3\u679c:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u5b9e\u4f53\u8ba4\u8bc1\u5931\u8d25, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u5b9e\u4f53\u8ba4\u8bc1\u5931\u8d25, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        personSPCAInfo = new PersonSPCAInfo();
        String[] resultArr = result.split("#");
        personSPCAInfo.setAuthCode(resultArr[0]);
        personSPCAInfo.setRefCode(resultArr[1]);
        personSPCAInfo.setCreateTime(new Date());
        personSPCAInfo.setDn(dn);
        personSPCAInfo.setPersonId(person.getId());
        personSPCAInfo.setState("1");
        personSPCAInfo.setUserId(result);
        personSPCAInfo.setUserInfo(userInfo);
        this.personSPCAInfoDao.addPersonSPCAInfo(personSPCAInfo);
        return CertInAirRtn.rtn_all(dn, "0", null);
    }

    private String createUserInfoCA(Person person, String cardNo, String cardType) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        userInfoMap.put("userName", person.getName());
        userInfoMap.put("sex", this.transSex(person.getSex()));
        userInfoMap.put("identifyNo", person.getIdentifier());
        userInfoMap.put("cardNo", cardNo);
        userInfoMap.put("cardType", DInfo.covCardTypeSimpleCA(cardType));
        userInfoMap.put("orgCode", person.getDepartment().getCode());
        userInfoMap.put("jinghao", person.getCode());
        userInfoMap.put("zhiji", person.getPosition());
        userInfoMap.put("phone", person.getMobile());
        userInfoMap.put("certType", "userCertTemplate_sm2");
        return Util.toJsonStr(userInfoMap);
    }

    private CertInAirRtn certDownLoadInner(String pubkey, String p10, Device device, Person person, DInfoCA dInfoCA, boolean isUpdateDevice, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5185\u90e8\u5f00\u59cb\u4e0b\u8f7d\u8bc1\u4e66");
        String cardtype = DInfo.covCartType(device.getType());
        String version = "3.0";
        String admin = "2.0";
        if ("1".equals(dInfoCA.getAlgType()) || "1.0".equals(dInfoCA.getAlgType())) {
            version = "2.0";
            admin = "admin";
        }
        String strKey = CommonDClient.certIssue(dInfoCA.getUrl(), version, cardtype, device.getHardNo(), pubkey, admin, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.info("\u83b7\u53d6\u5355\u8bc1\u7ed3\u679c:{}", (Object)strKey);
        if (strKey.length() <= 10) {
            log.info("\u83b7\u53d6\u5355\u8bc1\u5931\u8d25, \u7ed3\u679c:{}", (Object)strKey);
            return CertInAirRtn.covRtn(strKey);
        }
        if (isUpdateDevice) {
            log.info("\u5f00\u59cb\u89e3\u6790\u5355\u8bc1");
            String cert = Strings.getCert(strKey);
            String sn = DInfo.getSN(strKey);
            Date now = new Date();
            device.setSn(sn);
            device.setCertificate(cert);
            device.setAlgType(dInfoCA.getAlgType());
            device.setOpenDate(now);
            device.setFlag("1");
            device.setLockState("0");
            device.setState("3");
            device.setWriteCardDate(now);
            device.setRevokeFlag(null);
            device.setRevocationDate(null);
            device.setEnaasDesc(null);
            this.deviceService.update(device);
            this.addDeviceAir(device, p10, person, pubkey, cert, source);
        } else {
            strKey = "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(strKey) + "\"]";
        }
        return CertInAirRtn.rtn_all(null, null, strKey);
    }

    private CertInAirRtn certDownLoadJIT(String pubKey, String p10, Device device, Person person, DInfoCA dInfoCA, boolean isUpdateDevice, String source, boolean needRemoteJIT) {
        CertInAirRtn rtnApply = this.applyJIT(person, device.getType(), dInfoCA, device.getHardNo(), needRemoteJIT);
        if (rtnApply != null) {
            if (!"0".equals(rtnApply.getFlag())) {
                return rtnApply;
            }
        } else {
            return CertInAirRtn.rtn("81");
        }
        if ("6".equals(device.getType())) {
            device.setType("3");
        }
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5409\u5927\u5f00\u59cb\u4e0b\u8f7d\u8bc1\u4e66");
        PersonJITInfo pki = this.personJITInfoService.findByPersonId(person.getId(), device.getType());
        if (pki == null) {
            log.debug("[JIT]\u6ca1\u6709\u5409\u5927\u7528\u6237\u8ba4\u8bc1\u4fe1\u606f");
            return CertInAirRtn.rtn("84");
        }
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String cardType = DInfo.covCartTypeJIT(device.getType());
        String result = CommonDClient.certDownlaodRAJit(dInfoCA.getUrl(), "3.0", cardType, device.getHardNo(), pubKey, caAlg, pki.getAuthCode(), pki.getRefCode(), person.getName(), person.getIdentifier(), person.getDepartment().getCode(), dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        if (result.length() > 10) {
            String org = result.replaceAll("\r|\n", "");
            Date now = new Date();
            String[] cerArr = result.split("#");
            String cert1 = "";
            if (cerArr.length >= 3) {
                cert1 = cerArr[0].replaceAll("\r|\n", "");
                String sn1 = DInfo.getSN(cerArr[0]);
                String cert2 = cerArr[1].replaceAll("\r|\n", "");
                String sn2 = DInfo.getSN(cerArr[1]);
                String privateKey = cerArr[2].replaceAll("\r|\n", "");
                log.debug("[\"success\",\"" + org + "\",\"" + cert1 + "\",\"" + sn1 + "\",\"" + cert2 + "\",\"" + sn2 + "\",\"" + privateKey + "\"]");
                if (isUpdateDevice) {
                    cert1 = cert1.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
                    device.setCertificate(cert1);
                    device.setSn(sn1);
                    device.setCertificate2(cert2.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", ""));
                    device.setSn2(sn2);
                } else {
                    org = "[\"success\",\"" + org + "\",\"" + cert1 + "\",\"" + sn1 + "\",\"" + cert2 + "\",\"" + sn2 + "\",\"" + privateKey + "\"]";
                }
            } else {
                cert1 = result.replaceAll("\r|\n", "");
                String sn = DInfo.getSN(result);
                log.debug("[\"success\",\"" + cert1 + "\",\"" + sn + "\"]");
                if (isUpdateDevice) {
                    cert1 = cert1.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
                    device.setCertificate(cert1);
                    device.setSn(sn);
                } else {
                    org = "[\"success\",\"" + cert1 + "\",\"" + sn + "\"]";
                }
            }
            if (isUpdateDevice) {
                device.setAlgType(dInfoCA.getAlgType());
                device.setBindingDate(now);
                device.setBindingState(this.userManageService.getBingDingState(device.getType()));
                device.setOpenDate(now);
                device.setFlag("1");
                device.setLockState("0");
                device.setState("3");
                device.setWriteCardDate(now);
                device.setRevokeFlag(null);
                device.setRevocationDate(null);
                device.setEnaasDesc(null);
                this.deviceService.update(device);
                pki.setWriteFlag("1");
                this.personJITInfoService.update(pki);
                this.addDeviceAir(device, p10, person, pubKey, cert1, source);
            }
            return CertInAirRtn.rtn_all(null, null, org);
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn certDownLoadKA(String p10, String pubKey, Device device, Person person, DInfoCA dInfoCA, boolean isUpdateDevice, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u683c\u5c14\u5f00\u59cb\u4e0b\u8f7d\u8bc1\u4e66");
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(device.getId());
        if (pki == null) {
            CertInAirRtn r = this.applyKAWhenDownloadCert(person, dInfoCA, device);
            if ("0".equals(r.getFlag())) {
                pki = this.personKOALInfoService.findByDeviceId(device.getId());
            } else {
                return r;
            }
        }
        if (pki == null || !"1".equals(pki.getState())) {
            log.debug("\u683c\u5c14\u5b9e\u4f53\u8ba4\u8bc1\u4fe1\u606f\u5f02\u5e38");
            return CertInAirRtn.rtn("84");
        }
        if (Strings.isEmpty(pki.getDeviceId())) {
            pki.setDeviceId(device.getId());
            this.personKOALInfoService.updatePki(pki);
        }
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("USER_IDNO", person.getIdentifier());
        userMap.put("USER_NAME", person.getName());
        userMap.put("USER_ORG_CODE", person.getDepartment().getCode());
        String userInfo = Util.toJsonStr(userMap);
        String strKey = CommonDClient.certIssueRA30New(dInfoCA.getUrl(), "3.0", device.getType(), device.getHardNo(), pubKey, caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), pki.getKoalId(), userInfo);
        log.debug("\u683c\u5c14\u83b7\u53d6\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + strKey);
        if (strKey.length() > 10) {
            Date now = new Date();
            String org = strKey.replaceAll("\r|\n", "");
            String[] cerArr = strKey.split("#");
            String cert1 = "";
            if (cerArr.length >= 3) {
                cert1 = cerArr[0].replaceAll("\r|\n", "");
                String sn1 = DInfo.getSN(cerArr[0]);
                String cert2 = cerArr[1].replaceAll("\r|\n", "");
                String sn2 = DInfo.getSN(cerArr[1]);
                log.debug("[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + cert1 + "\",\"" + sn1 + "\",\"" + cert2 + "\",\"" + sn2 + "\",\"" + cerArr[2].replaceAll("\r|\n", "") + "\"]");
                if (isUpdateDevice) {
                    cert1 = cert1.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
                    device.setCertificate(cert1);
                    device.setSn(sn1);
                    device.setCertificate2(cert2.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", ""));
                    device.setSn2(sn2);
                } else {
                    org = "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + cert1 + "\",\"" + sn1 + "\",\"" + cert2 + "\",\"" + sn2 + "\",\"" + cerArr[2].replaceAll("\r|\n", "") + "\"]";
                }
            } else {
                cert1 = strKey.replaceAll("\r|\n", "");
                String sn = DInfo.getSN(strKey);
                log.debug("[\"success\",\"" + cert1 + "\",\"" + sn + "\"]");
                if (isUpdateDevice) {
                    cert1 = cert1.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "");
                    device.setCertificate(cert1);
                    device.setSn(sn);
                } else {
                    org = "[\"success\",\"" + cert1 + "\",\"" + sn + "\"]";
                }
            }
            if (isUpdateDevice) {
                device.setAlgType(dInfoCA.getAlgType());
                device.setBindingDate(now);
                device.setBindingState(this.userManageService.getBingDingState(device.getType()));
                device.setOpenDate(now);
                device.setFlag("1");
                device.setLockState("0");
                device.setState("3");
                device.setWriteCardDate(now);
                this.deviceService.update(device);
                this.addDeviceAir(device, p10, person, pubKey, cert1, source);
            }
            return CertInAirRtn.rtn_all(null, null, org);
        }
        log.info("\u683c\u5c14\u7b7e\u53d1\u8bc1\u4e66\u5f02\u5e38,\u9519\u8bef\u7801:{}, \u539f\u56e0:{}", (Object)strKey, (Object)DInfo.getCertIssueErr(strKey));
        return CertInAirRtn.covRtn(strKey);
    }

    private CertInAirRtn certDownloadSPCA(String p10, String pubKey, Device device, Person person, DInfoCA dInfoCA, boolean isUpdateDevice, String source) {
        log.debug("---->>>p10 : {}", (Object)p10);
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u7b80\u6613CA\u4e0b\u8f7d\u8bc1\u4e66");
        PersonSPCAInfo personSPCAInfo = this.personSPCAInfoDao.findByPersonId(device.getPersonId());
        if (personSPCAInfo == null) {
            log.debug("[\u7b80\u6613CA]\u6ca1\u6709\u8ba4\u8bc1\u6ce8\u518c, \u9700\u8981\u5148\u8ba4\u8bc1\u6ce8\u518c");
            return CertInAirRtn.rtn("84");
        }
        HashMap<String, String> otherInfo = new HashMap<String, String>();
        otherInfo.put("cardNo", device.getHardNo());
        otherInfo.put("cardType", DInfo.covCardTypeSimpleCA(device.getType()));
        otherInfo.put("sex", this.transSex(person.getSex()));
        otherInfo.put("certType", "1");
        otherInfo.put("useObject", this.transUseObject(person.getPersonType()));
        otherInfo.put("institutionCode", person.getDepartment().getCode());
        otherInfo.put("identifyNo", person.getIdentifier());
        otherInfo.put("username", person.getName());
        otherInfo.put("policeType", CertUserInfoTrans.getPoliceType(person));
        otherInfo.put("duty", CertUserInfoTrans.getDuty(person));
        otherInfo.put("operatingPost", CertUserInfoTrans.getOperatingPost(person));
        otherInfo.put("rank", CertUserInfoTrans.getRank(person));
        otherInfo.put("certstoragetype", CertUserInfoTrans.getCertstoragetype(person, device.getType()));
        otherInfo.put("email", "");
        String otherString = Util.toJsonStr(otherInfo);
        log.debug("[\u7b80\u6613CA]otherInfo : {}", (Object)otherString);
        p10 = this.covP10(p10);
        String[] args = new String[]{p10, personSPCAInfo.getUserId(), "2", dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), otherString};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_issue, args);
        log.debug("[\u7b80\u6613CA]\u7b7e\u53d1\u8bc1\u4e66:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        Object[] certArr = result.split("#");
        if (certArr.length < 3) {
            log.debug("[\u7b80\u6613CA]\u7b7e\u53d1\u8bc1\u4e66\u5931\u8d25, \u8fd4\u56de\u7ed3\u679c\u4e0d\u5bf9, \u7ed3\u679c\u4e3a:{}", certArr);
            return CertInAirRtn.rtn("100");
        }
        log.debug("[\u7b80\u6613CA]\u8bc1\u4e66\u83b7\u53d6\u6210\u529f .. \u5f00\u59cb\u89e3\u6790\u8bc1\u4e66");
        if (isUpdateDevice) {
            String cert1 = Strings.getCert((String)certArr[0]);
            String sn1 = DInfo.getSN((String)certArr[0]);
            String cert2 = Strings.getCert((String)certArr[1]);
            String sn2 = DInfo.getSN((String)certArr[1]);
            log.info("\nsignCert : {} \nexchangeCert : {}", (Object)cert1, (Object)cert2);
            log.info("\nsn1 : {} \nsn2 : {}", (Object)sn1, (Object)sn2);
            Date now = new Date();
            device.setCertificate(cert1);
            device.setSn(sn1);
            device.setCertificate2(cert2);
            device.setSn2(sn2);
            device.setAlgType(dInfoCA.getAlgType());
            device.setBindingDate(now);
            device.setBindingState(this.userManageService.getBingDingState(device.getType()));
            device.setOpenDate(now);
            device.setFlag("1");
            device.setLockState("0");
            device.setState("3");
            device.setWriteCardDate(now);
            this.deviceService.update(device);
            this.addDeviceAir(device, p10, device.getPersonId(), pubKey, cert1, source);
        } else {
            result = "[\"success\",\"" + result.replaceAll("\r|\n", "") + "\",\"" + ((String)certArr[0]).replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN((String)certArr[0]) + "\",\"" + ((String)certArr[1]).replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN((String)certArr[1]) + "\",\"" + ((String)certArr[2]).replaceAll("\r|\n", "") + "\"]";
        }
        return CertInAirRtn.rtn_all(null, null, result);
    }

    private CertInAirRtn revokeInner(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isRevokeForDelay, boolean isUpdateDevice) {
        String rst;
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5185\u90e8\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        String version = "3.0";
        String admin = "2.0";
        if ("1".equals(dInfoCA.getAlgType()) || "1.0".equals(dInfoCA.getAlgType())) {
            version = "2.0";
            admin = "admin";
        }
        if ("1".equals(rst = CommonDClient.certRevoke(dInfoCA.getUrl(), version, DInfo.covCartType(device.getType()), device.getHardNo(), admin, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword())) || "4".equals(rst) || "15".equals(rst)) {
            if (isUpdateDevice) {
                this.revokeDevice(device);
                certAir.setState("12");
                certAir.setDeleteFlag(isRevokeForDelay ? "2" : "1");
                certAir.setUpdateTime(new Date());
                this.certAirDao.updateCert(certAir);
            }
            return CertInAirRtn.rtn("0");
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn revokeInner4WriteCardFailed(Device device, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice) {
        String rst;
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5185\u90e8\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        String version = "3.0";
        String admin = "2.0";
        if ("1".equals(dInfoCA.getAlgType()) || "1.0".equals(dInfoCA.getAlgType())) {
            version = "2.0";
            admin = "admin";
        }
        if ("1".equals(rst = CommonDClient.certRevoke(dInfoCA.getUrl(), version, DInfo.covCartType(device.getType()), device.getHardNo(), admin, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword())) || "4".equals(rst) || "15".equals(rst)) {
            if (isUpdateDevice) {
                this.revokeDevice4WriteCardFailed(device);
                certAir.setState("12");
                certAir.setDeleteFlag("1");
                certAir.setUpdateTime(new Date());
                this.certAirDao.updateCert(certAir);
            }
            return CertInAirRtn.rtn("0");
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn revokeJIT(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isRevokeForDelay, boolean isUpdateDevice) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5409\u5927\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        String caAlg = "1.0";
        if ("2".equals(device.getAlgType())) {
            caAlg = "2.0";
        }
        if ("6".equals(device.getType())) {
            device.setType("3");
        }
        String cardType = DInfo.covCartTypeJIT(device.getType());
        String result = CommonDClient.certRevokeRAJit(dInfoCA.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.debug("[JIT]\u64a4\u9500\u8bc1\u4e66\u7ed3\u679c: {}", (Object)result);
        if ("1".equals(result) || "4".equals(result) || "15".equals(result)) {
            PersonJITInfo pki;
            log.debug("[JIT] \u64a4\u9500\u8bc1\u4e66\u6210\u529f");
            if (isUpdateDevice) {
                this.revokeDevice(device);
                certAir.setState("12");
                certAir.setDeleteFlag(isRevokeForDelay ? "2" : "1");
                certAir.setUpdateTime(new Date());
                this.certAirDao.updateCert(certAir);
            }
            if ((pki = this.personJITInfoService.findByPersonId(person.getId(), device.getType())) != null) {
                pki.setWriteFlag("0");
                pki.setApplyFlag("0");
                this.personJITInfoService.update(pki);
            }
            return CertInAirRtn.rtn("0");
        }
        log.debug("[JIT]\u64a4\u9500\u8bc1\u4e66\u5931\u8d25");
        return CertInAirRtn.covRtn("101");
    }

    private CertInAirRtn revokeJIT4WriteCardFailed(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5409\u5927\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        String caAlg = "1.0";
        if ("2".equals(device.getAlgType())) {
            caAlg = "2.0";
        }
        if ("6".equals(device.getType())) {
            device.setType("3");
        }
        String cardType = DInfo.covCartTypeJIT(device.getType());
        String result = CommonDClient.certRevokeRAJit(dInfoCA.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        log.debug("[JIT]\u64a4\u9500\u8bc1\u4e66\u7ed3\u679c: {}", (Object)result);
        if ("1".equals(result) || "4".equals(result) || "15".equals(result)) {
            PersonJITInfo pki;
            log.debug("[JIT] \u64a4\u9500\u8bc1\u4e66\u6210\u529f");
            if (isUpdateDevice) {
                this.revokeDevice4WriteCardFailed(device);
                certAir.setState("12");
                certAir.setDeleteFlag("1");
                certAir.setUpdateTime(new Date());
                this.certAirDao.updateCert(certAir);
            }
            if ((pki = this.personJITInfoService.findByPersonId(person.getId(), device.getType())) != null) {
                pki.setWriteFlag("0");
                pki.setApplyFlag("0");
                this.personJITInfoService.update(pki);
            }
            return CertInAirRtn.rtn("0");
        }
        log.debug("[JIT]\u64a4\u9500\u8bc1\u4e66\u5931\u8d25");
        return CertInAirRtn.covRtn("101");
    }

    private CertInAirRtn revokeKA(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u683c\u5c14\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(device.getId());
        if (pki == null) {
            pki = this.personKOALInfoService.findByPerson(person.getId(), device.getType());
        }
        String cardType = DInfoCA.covCartType(device.getType());
        String caAlg = "1.0";
        if ("2".equals(device.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.certRevokeRA30(dInfoCA.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), pki.getKoalId(), "admin");
        log.debug("\u683c\u5c14\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
        if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
            if (pki != null) {
                this.personKOALInfoService.delete(pki);
            }
            if (isUpdateDevice) {
                this.revokeDevice(device);
                certAir.setState("12");
                certAir.setDeleteFlag("1");
                certAir.setUpdateTime(new Date());
                this.certAirDao.updateCert(certAir);
            }
            return CertInAirRtn.rtn("0");
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn revokeKA4WriteCardFailed(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u683c\u5c14\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(device.getId());
        if (pki == null) {
            pki = this.personKOALInfoService.findByPerson(person.getId(), device.getType());
        }
        String cardType = DInfoCA.covCartType(device.getType());
        String caAlg = "1.0";
        if ("2".equals(device.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = CommonDClient.certRevokeRA30(dInfoCA.getUrl(), "3.0", cardType, device.getHardNo(), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), pki.getKoalId(), "admin");
        log.debug("\u683c\u5c14\u64a4\u9500\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + rst);
        if ("1".equals(rst) || "4".equals(rst) || "15".equals(rst)) {
            if (pki != null) {
                this.personKOALInfoService.delete(pki);
            }
            if (isUpdateDevice) {
                this.revokeDevice4WriteCardFailed(device);
                certAir.setState("12");
                certAir.setDeleteFlag("1");
                certAir.setUpdateTime(new Date());
                this.certAirDao.updateCert(certAir);
            }
            return CertInAirRtn.rtn("0");
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn revokeSPCA(Device device, CertAir certAir, DInfoCA dInfoCA, boolean isRevokeForDelay, boolean isUpdateDevice) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u7b80\u6613CA\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        String sn1 = device.getSn();
        if (Util.varCheckEmp(sn1)) {
            log.debug("[\u7b80\u6613CA]\u6ca1\u6709\u83b7\u53d6\u5230sn1");
            return CertInAirRtn.rtn("90");
        }
        String[] args = new String[]{sn1, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), ""};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_revoke, args);
        log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u7ed3\u679c:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u5931\u8d25, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u5931\u8d25, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (CERT_STATE_MAP.get(result) != null && !"15".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u5f02\u5e38, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)CERT_STATE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (!("1".equals(result) || "4".equals(result) || "15".equals(result))) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66: \u672a\u77e5\u5f02\u5e38");
            return CertInAirRtn.rtn("100");
        }
        log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u6210\u529f");
        if (isUpdateDevice) {
            this.revokeDevice(device);
            certAir.setState("12");
            certAir.setDeleteFlag(isRevokeForDelay ? "2" : "1");
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
        }
        return CertInAirRtn.rtn("0");
    }

    private CertInAirRtn revokeSPCA4WriteCardFailed(Device device, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u7b80\u6613CA\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        String sn1 = device.getSn();
        if (Util.varCheckEmp(sn1)) {
            log.debug("[\u7b80\u6613CA]\u6ca1\u6709\u83b7\u53d6\u5230sn1");
            return CertInAirRtn.rtn("90");
        }
        String[] args = new String[]{sn1, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), ""};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_revoke, args);
        log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u7ed3\u679c:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u5931\u8d25, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u5931\u8d25, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (CERT_STATE_MAP.get(result) != null && !"15".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u5f02\u5e38, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)CERT_STATE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (!("1".equals(result) || "4".equals(result) || "15".equals(result))) {
            log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66: \u672a\u77e5\u5f02\u5e38");
            return CertInAirRtn.rtn("100");
        }
        log.debug("[\u7b80\u6613CA]\u64a4\u9500\u8bc1\u4e66\u6210\u529f");
        if (isUpdateDevice) {
            this.revokeDevice4WriteCardFailed(device);
            certAir.setState("12");
            certAir.setDeleteFlag("1");
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
        }
        return CertInAirRtn.rtn("0");
    }

    private String transSex(String sexOrg) {
        if ("1".equals(sexOrg)) {
            return "1";
        }
        if ("0".equals(sexOrg)) {
            return "2";
        }
        return "1";
    }

    private String transUseObject(String personType) {
        if ("1".equals(personType)) {
            return "4";
        }
        if ("2".equals(personType)) {
            return "5";
        }
        if ("3".equals(personType)) {
            return "6";
        }
        return "4";
    }

    private boolean isAllowedManyCard() {
        SystemConfig systemConfig = this.systemConfigExtService.getByCode("cardcount");
        return systemConfig != null && "many".equals(systemConfig.getValue());
    }

    private void revokeDevice(Device device) {
        String hardNo = device.getHardNo();
        device.setState("11");
        device.setRevocationDate(new Date());
        device.setRevokeFlag("1");
        device.setEnaasDesc(device.getIccid());
        device.setHardNo("");
        device.setIccid("");
        device.setImei("");
        device.setImsi("");
        device.setCertificate("");
        device.setCertificate2("");
        device.setMobile(null);
        device.setSn("");
        device.setSn2("");
        device.setOriginalHardNo(hardNo);
        this.deviceService.update(device);
    }

    private void revokeDevice4WriteCardFailed(Device device) {
        Date now = new Date();
        device.setCertificate("");
        device.setSn("");
        device.setCertificate2("");
        device.setSn2("");
        device.setAlgType("");
        device.setBindingDate(now);
        device.setBindingState(this.userManageService.getBingDingState(device.getType()));
        device.setOpenDate(now);
        device.setFlag("1");
        device.setLockState("0");
        device.setState("1");
        this.deviceService.update(device);
    }

    @Override
    @Transactional
    public CertInAirRtn apply2(String type, String hardNo, String identityNo, String phone, boolean needRemote, boolean checkPccm) {
        CertInAirRtn certInAirRtn;
        Mobile m;
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u5b9e\u4f53\u8ba4\u8bc1");
        if (!this.isValidCardType(type)) {
            return CertInAirRtn.rtn("63");
        }
        Person person = null;
        if (identityNo.length() == 11) {
            person = this.userManageService.getUserByMobile(identityNo);
        } else if (identityNo.length() == 18 && (person = this.userManageService.getUserByIdentifer(identityNo.toUpperCase())) == null) {
            person = this.userManageService.getUserByIdentifer(identityNo.toLowerCase());
        }
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        if (Strings.isEmpty(person.getCode())) {
            return CertInAirRtn.rtn("71");
        }
        if (Strings.isNotEmpty(phone) && (m = this.mobileDao.queryMobileByHql("from Mobile where mobile = ?", new String[]{phone})) != null && !person.getId().equalsIgnoreCase(m.getPerson().getId())) {
            log.info("\u624b\u673a\u53f7\u4e0d\u662f\u672c\u4eba");
            return CertInAirRtn.rtn("68");
        }
        if (checkPccm && !(certInAirRtn = this.pccmCheck(person.getId(), type)).getFlag().equals("0")) {
            return certInAirRtn;
        }
        certInAirRtn = this.personCardCertModeCheck(person.getId(), type);
        if (!certInAirRtn.getFlag().equals("0")) {
            return certInAirRtn;
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(null, phone), person.getPersonType());
        if ("1".equals(dInfoCA.getUseThirdCert())) {
            return this.applyJIT(person, type, dInfoCA, hardNo, needRemote);
        }
        if ("2".equals(dInfoCA.getUseThirdCert())) {
            return this.applyKA(person);
        }
        if ("3".equals(dInfoCA.getUseThirdCert())) {
            return this.applySPCA(person, type, hardNo, dInfoCA);
        }
        return this.applyInner(person);
    }

    @Override
    public CertInAirRtn testCardType(String cardType) {
        boolean f = this.isValidCardType(cardType);
        if (!f) {
            return CertInAirRtn.rtn("63");
        }
        return CertInAirRtn.rtn("0");
    }

    private boolean isValidCardType(String type) {
        List<CommonCode> list = this.commonCodeService.queryByType("2000");
        for (CommonCode cc : list) {
            if (!cc.getCode().equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CertInAirRtn personCardCertModeCheck(String personId, String type) {
        List<Device> personDeviceList = this.deviceService.getByPersonId(personId);
        if (personDeviceList == null || personDeviceList.isEmpty()) {
            return CertInAirRtn.rtn("0");
        }
        String pppMode = this.systemConfigExtService.getValueByCode("per_person_per_card_per_cert");
        if (!pppMode.equals("0")) {
            String targetCardType = "6".equals(type) ? "3" : type;
            for (Device d : personDeviceList) {
                if (!"3".equals(d.getState())) continue;
                if (pppMode.equals("1")) {
                    String dCardType = "6".equals(d.getType()) ? "3" : d.getType();
                    if (!targetCardType.equals(dCardType)) continue;
                    return CertInAirRtn.rtn("69");
                }
                if (!pppMode.equals("2")) continue;
                return CertInAirRtn.rtn("217");
            }
        }
        return CertInAirRtn.rtn("0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public CertInAirRtn pccmCheck(String personId, String type) {
        Pccm pccm;
        boolean b;
        List<Device> personDeviceList = this.deviceService.getByPersonId(personId);
        String pccmConfig = this.systemConfigExtService.getValueByCode("person_card_cert_type_mode");
        if (pccmConfig.equals("unlimited")) return CertInAirRtn.rtn("0");
        ArrayList<String> already = new ArrayList<String>();
        if (personDeviceList != null) {
            for (Device d : personDeviceList) {
                if ("11".equals(d.getState())) continue;
                already.add(d.getType());
            }
        }
        if (cardTypeName == null) {
            Class<IssuingDoubleCertInAirServiceImpl> clazz = IssuingDoubleCertInAirServiceImpl.class;
            // MONITORENTER : com.xdja.pams.scms.service.impl.IssuingDoubleCertInAirServiceImpl.class
            if (cardTypeName == null) {
                List<CommonCode> commonCodes = this.commonCodeService.queryByType("2000");
                cardTypeName = new HashMap<String, String>();
                for (CommonCode commonCode : commonCodes) {
                    cardTypeName.put(commonCode.getCode(), commonCode.getName());
                }
            }
            // MONITOREXIT : clazz
        }
        if (b = (pccm = Pccm.init(pccmConfig, cardTypeName)).judgeResult(already.toArray(new String[0]), type)) return CertInAirRtn.rtn("0");
        log.info("\u53d1\u7684\u5361\u7c7b\u578b\u8d85\u51fa\u5141\u8bb8\u6570\u91cf, \u4eba\u5458id:{}, type:{}", (Object)personId, (Object)type);
        return CertInAirRtn.rtn("218");
    }

    @Override
    @Transactional
    public CertInAirRtn certDownload2(String type, String deviceId, String hardNo, String p10, String pubkey, String identityNo, String imsi, String imei, String phone, String commType, String osType, String terminalBand, String terminalType, String source, boolean needRemote, boolean checkPccm) {
        CertInAirRtn r;
        Device device;
        CertInAirRtn certInAirRtn;
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u4e0b\u8f7d\u8bc1\u4e66");
        if (!this.isValidCardType(type)) {
            return CertInAirRtn.rtn("63");
        }
        Person person = null;
        if (identityNo.length() == 11) {
            person = this.userManageService.getUserByMobile(identityNo);
        } else if (identityNo.length() == 18 && (person = this.userManageService.getUserByIdentifer(identityNo.toUpperCase())) == null) {
            person = this.userManageService.getUserByIdentifer(identityNo.toLowerCase());
        }
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        String personId = person.getId();
        if (checkPccm && !(certInAirRtn = this.pccmCheck(personId, type)).getFlag().equals("0")) {
            return certInAirRtn;
        }
        certInAirRtn = this.personCardCertModeCheck(personId, type);
        if (!certInAirRtn.getFlag().equals("0")) {
            return certInAirRtn;
        }
        if (Strings.isNotEmpty(deviceId)) {
            device = this.deviceService.get((Serializable)((Object)deviceId));
        } else if (Strings.isNotEmpty(hardNo)) {
            device = this.deviceService.getByCardNO(hardNo);
        } else {
            return CertInAirRtn.rtn("60");
        }
        if (device == null) {
            device = new Device();
            device.setPersonId(personId);
            device.setHardNo(hardNo);
            device.setIccid(hardNo);
            device.setBindingDate(new Date());
            device.setBindingState(this.userManageService.getBingDingState(type));
            device.setName("\u7a7a\u4e2d\u53d1\u8bc1");
            device.setImei(this.getImeiOrImsi(imei));
            device.setImsi(this.getImeiOrImsi(imsi));
            device.setType(type);
            device.setUseType("0");
            Mobile mobile = null;
            List<Mobile> list = person.getMobiledList();
            if (list != null && !list.isEmpty()) {
                mobile = list.get(0);
            }
            if (Strings.isNotEmpty(phone)) {
                Mobile m = this.mobileDao.queryMobileByHql("from Mobile where mobile = ?", new String[]{phone});
                if (m != null) {
                    if (!person.getId().equalsIgnoreCase(m.getPerson().getId())) {
                        log.info("\u624b\u673a\u53f7\u4e0d\u662f\u672c\u4eba");
                        return CertInAirRtn.rtn("68");
                    }
                    mobile = m;
                }
                if (mobile == null) {
                    mobile = new Mobile();
                    mobile.setPerson(person);
                    mobile.setMobile(phone);
                    this.mobileDao.addMobile(mobile);
                }
            }
            Object mobileFinal = "";
            if (mobile != null) {
                mobileFinal = mobile.getMobile();
                device.setMobile(mobile);
            }
            device.setCommType(Strings.isEmpty(commType) ? this.getComType(null, (String)mobileFinal) : commType);
            Terminal terminal = new Terminal();
            terminal.setTerminalband(Strings.isEmpty(terminalBand) ? "000" : terminalBand);
            terminal.setTerminalname("01010");
            terminal.setTerminalos(Strings.isEmpty(osType) ? "000" : osType);
            terminal.setTerminaltype(Strings.isEmpty(terminalType) ? "0" : terminalType);
            device.setTerminal(terminal);
            this.deviceService.save(device);
        } else {
            String personIdOfDevice = device.getPersonId();
            if (!personId.equalsIgnoreCase(personIdOfDevice)) {
                return CertInAirRtn.rtn("73");
            }
            if ("1".equals(device.getFlag()) && "3".equals(device.getState())) {
                return CertInAirRtn.rtn("78");
            }
        }
        if (Strings.isEmpty(device.getHardNo())) {
            device.setHardNo(hardNo);
            device.setIccid(hardNo);
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        device.setAlgType(dInfoCA.getAlgType());
        List<CertAir> certAirs = this.certAirDao.findByCardId(hardNo);
        if (certAirs != null && !certAirs.isEmpty()) {
            for (CertAir ca : certAirs) {
                if (!"0".equals(ca.getState())) continue;
                ca.setDeleteFlag("3");
                ca.setUpdateTime(new Date());
                this.certAirDao.updateCert(ca);
            }
        }
        if (!"0".equals((r = "1".equals(dInfoCA.getUseThirdCert()) ? this.certDownLoadJIT(pubkey, p10, device, person, dInfoCA, true, source, needRemote) : ("2".equals(dInfoCA.getUseThirdCert()) ? this.certDownLoadKA(p10, pubkey, device, person, dInfoCA, true, source) : ("3".equals(dInfoCA.getUseThirdCert()) ? this.certDownloadSPCA(p10, pubkey, device, person, dInfoCA, true, source) : this.certDownLoadInner(pubkey, p10, device, person, dInfoCA, true, source)))).getFlag())) {
            device.setHardNo("");
            device.setIccid("");
            device.setCertificate("");
            device.setCertificate2("");
            device.setSn("");
            device.setSn2("");
            device.setRevokeFlag(null);
            device.setState("1");
            device.setFlag("1");
            device.setLockState("0");
            this.deviceService.update(device);
        } else {
            try {
                Device d = new Device();
                d.setType(type);
                d.setHardNo(hardNo);
                d.setTerminal(device.getTerminal());
                d.setMobile(device.getMobile());
                d.setName(device.getName());
                d.setSn(device.getSn());
                d.setPersonId(personId);
                TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(d, "0");
                this.terminalLogService.save(terminalLog);
            }
            catch (Exception e) {
                log.error("\u7ea7\u8054\u76d1\u63a7\u65e5\u5fd7\u4fdd\u5b58\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return r;
    }

    @Override
    @Transactional
    public CertAir addDeviceAir(Device device, String p10, Person person, String pubKey, String cert1, String source) {
        try {
            return this.addDeviceAir(device, p10, person.getId(), pubKey, cert1, source);
        }
        catch (Exception e) {
            String hardNo = device == null ? "" : device.getHardNo();
            String sn = device == null ? "" : device.getSn();
            log.error("\u6dfb\u52a0\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55\u5f02\u5e38, \u5361\u53f7 : {}, sn : {}", (Object)hardNo, (Object)sn);
            log.error("\u6dfb\u52a0\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private CertAir addDeviceAir(Device device, String p10, String personId, String pubKey, String cert1, String source) {
        log.info("\u6dfb\u52a0\u8bc1\u4e66\u8bb0\u5f55\u4fe1\u606f \u5361\u53f7:{}, \u4eba\u5458id:{}", (Object)(device == null ? "" : device.getHardNo()), (Object)personId);
        if (device == null || Strings.isEmpty(personId)) {
            return null;
        }
        log.info("=====>\u5f00\u59cb\u6dfb\u52a0\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55");
        Date now = new Date();
        CertAir air = new CertAir();
        air.setCardId(device.getHardNo());
        air.setCreateTime(now);
        air.setDeleteFlag("0");
        air.setFreezeState("0");
        air.setP10(p10);
        air.setPersonId(personId);
        String sn1 = device.getSn();
        air.setSn(sn1);
        air.setState("0");
        air.setUpdateTime(now);
        air.setPubKey(pubKey);
        if ("pams".equals(source)) {
            air.setSource("1");
        } else if ("inair".equals(source)) {
            air.setSource("2");
        }
        if (Strings.isNotEmpty(cert1)) {
            CertValidity certValidity = DInfo.getCertValidity(cert1);
            log.info("\u8bc1\u4e66\u6709\u6548\u671f : {}", (Object)certValidity);
            if (certValidity != null) {
                air.setValidityStart(certValidity.getStart());
                air.setValidityEnd(certValidity.getEnd());
            }
        }
        this.certAirDao.create(air);
        return air;
    }

    @Override
    @Transactional
    public void updateCertAir(CertAir certAir) {
        try {
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
        }
        catch (Exception e) {
            String hardNo = certAir == null ? "" : certAir.getCardId();
            String sn = certAir == null ? "" : certAir.getSn();
            log.error("\u66f4\u6539\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55\u5f02\u5e38 , \u5361\u53f7 : {}, sn : {}", (Object)hardNo, (Object)sn);
        }
    }

    @Override
    @Transactional
    public void deleteCertAirByCardNo(String cardNo, String delteType, String stateType) {
        try {
            List<CertAir> certAirs = this.certAirDao.findNotDeletesByCardId(cardNo);
            if (certAirs != null && !certAirs.isEmpty()) {
                for (CertAir certAir : certAirs) {
                    certAir.setState(stateType);
                    certAir.setDeleteFlag(delteType);
                    certAir.setUpdateTime(new Date());
                    this.certAirDao.updateCert(certAir);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55\u5f02\u5e38 , \u5361\u53f7 : {}", (Object)cardNo);
        }
    }

    @Override
    @Transactional
    public CertInAirRtn revokeApply(String hardNo, String sn, String reason) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u7533\u8bf7\u64a4\u9500\u8bc1\u4e66");
        Device device = this.deviceService.getByCardNO(hardNo);
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        if (!sn.equalsIgnoreCase(device.getSn())) {
            log.info("sn\u4e0e\u5361\u4e2dsn\u4e0d\u4e00\u6837");
            return CertInAirRtn.rtn("79");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<CertAir> certAirs = this.certAirDao.findByCardId(hardNo);
        CertAir certAir = this.getCertAir(certAirs, sn);
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        if (certAir == null) {
            log.error("\u5361\u4fe1\u606f\u6b63\u5e38, \u4f46\u6ca1\u6709\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55, \u5361\u53f7:{}, sn : {}", (Object)device.getHardNo(), (Object)sn);
            return CertInAirRtn.rtn("100");
        }
        String freezeState = certAir.getFreezeState();
        String state = certAir.getState();
        log.info("\u8bc1\u4e66\u51bb\u7ed3\u72b6\u6001:{}, \u8bc1\u4e66\u72b6\u6001:{}", (Object)freezeState, (Object)state);
        if ("1".equalsIgnoreCase(freezeState) || "20".equalsIgnoreCase(state) || "10".equalsIgnoreCase(state) || "30".equalsIgnoreCase(state)) {
            log.info("\u8bc1\u4e66\u88ab\u51bb\u7ed3\u4e2d\u6216\u8005\u5728\u5ba1\u6838\u4e2d,\u64cd\u4f5c\u4e0d\u5408\u6cd5");
            return CertInAirRtn.rtn("213");
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        if ("true".equalsIgnoreCase(dInfoCA.getIsNeedVerify())) {
            certAir.setState("10");
            certAir.setApplyReason(reason);
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.rtn("0");
        }
        certAir.setApplyReason(reason);
        CertInAirRtn rtn = this.revokeCert2(device, person, certAir, dInfoCA);
        if (rtn != null && "0".equals(rtn.getFlag())) {
            rtn.setFlag("214");
        }
        return rtn;
    }

    @Override
    public CertInAirRtn revokeForPage(String deviceId, String cardNo) {
        Device device = this.deviceService.get((Serializable)((Object)deviceId));
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        if (!cardNo.equals(device.getHardNo())) {
            log.debug("\u5361\u53f7\u548c\u8bbe\u5907\u4fe1\u606f\u5361\u53f7\u4e0d\u5bf9\u5e94");
            return CertInAirRtn.rtn("216");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<CertAir> certAirs = this.certAirDao.findNotDeletesByCardId(device.getHardNo());
        if (certAirs == null || certAirs.isEmpty()) {
            log.error("\u5361\u4fe1\u606f\u6b63\u5e38, \u4f46\u6ca1\u6709\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55, \u5361\u53f7:{}, sn : {}", (Object)device.getHardNo(), (Object)device.getSn());
            return CertInAirRtn.rtn("100");
        }
        CertAir certAir = certAirs.get(0);
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        return this.revokeCert2(device, person, certAir, dInfoCA);
    }

    @Override
    @Transactional
    public CertInAirRtn revokeForPage4WriteCardFailed(String deviceId, String cardNo) {
        Device device = this.deviceService.get((Serializable)((Object)deviceId));
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        if (!cardNo.equals(device.getHardNo())) {
            log.debug("\u5361\u53f7\u548c\u8bbe\u5907\u4fe1\u606f\u5361\u53f7\u4e0d\u5bf9\u5e94");
            return CertInAirRtn.rtn("216");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<CertAir> certAirs = this.certAirDao.findNotDeletesByCardId(device.getHardNo());
        if (certAirs == null || certAirs.isEmpty()) {
            log.error("\u5361\u4fe1\u606f\u6b63\u5e38, \u4f46\u6ca1\u6709\u8bc1\u4e66\u4fe1\u606f\u8bb0\u5f55, \u5361\u53f7:{}, sn : {}", (Object)device.getHardNo(), (Object)device.getSn());
            return CertInAirRtn.rtn("100");
        }
        CertAir certAir = certAirs.get(0);
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        return this.revokeCert4WriteCardFailed(device, person, certAir, dInfoCA);
    }

    private CertInAirRtn revokeCert2(Device device, Person person, CertAir certAir, DInfoCA dInfoCA) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        Device d = new Device();
        try {
            d.setSn(device.getSn());
            d.setName(device.getName());
            d.setMobile(device.getMobile());
            d.setTerminal(device.getTerminal());
            d.setHardNo(device.getHardNo());
            d.setPersonId(person.getId());
            d.setType(device.getType());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7ea7\u8054\u76d1\u63a7device\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
        CertInAirRtn rtn = "1".equals(dInfoCA.getUseThirdCert()) ? this.revokeJIT(device, person, certAir, dInfoCA, false, true) : ("2".equals(dInfoCA.getUseThirdCert()) ? this.revokeKA(device, person, certAir, dInfoCA, true) : ("3".equals(dInfoCA.getUseThirdCert()) ? this.revokeSPCA(device, certAir, dInfoCA, false, true) : this.revokeInner(device, person, certAir, dInfoCA, false, true)));
        if ("0".equals(rtn.getFlag())) {
            try {
                TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(d, "1");
                this.terminalLogService.save(terminalLog);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u7ea7\u8054\u76d1\u63a7terminalLog\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return rtn;
    }

    private CertInAirRtn revokeCert4WriteCardFailed(Device device, Person person, CertAir certAir, DInfoCA dInfoCA) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u64a4\u9500\u8bc1\u4e66");
        Device d = new Device();
        try {
            d.setSn(device.getSn());
            d.setName(device.getName());
            d.setMobile(device.getMobile());
            d.setTerminal(device.getTerminal());
            d.setHardNo(device.getHardNo());
            d.setPersonId(person.getId());
            d.setType(device.getType());
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7ea7\u8054\u76d1\u63a7device\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
        }
        CertInAirRtn rtn = "1".equals(dInfoCA.getUseThirdCert()) ? this.revokeJIT4WriteCardFailed(device, person, certAir, dInfoCA, true) : ("2".equals(dInfoCA.getUseThirdCert()) ? this.revokeKA4WriteCardFailed(device, person, certAir, dInfoCA, true) : ("3".equals(dInfoCA.getUseThirdCert()) ? this.revokeSPCA4WriteCardFailed(device, certAir, dInfoCA, true) : this.revokeInner4WriteCardFailed(device, certAir, dInfoCA, true)));
        if ("0".equals(rtn.getFlag())) {
            try {
                TerminalLog terminalLog = this.deviceService.cvsDeviceToTerminalLog(d, "1");
                this.terminalLogService.save(terminalLog);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u7ea7\u8054\u76d1\u63a7terminalLog\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return rtn;
    }

    @Override
    @Transactional
    public CertInAirRtn queryState(String hardNo, String sn) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u67e5\u8be2\u8bc1\u4e66\u72b6\u6001");
        Device device = this.deviceService.getByCardNO(hardNo);
        List<CertAir> certAirs = this.certAirDao.findByCardId(hardNo);
        CertAir certAir = this.getCertAir(certAirs, sn);
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        if (device == null) {
            if (certAir == null) {
                return CertInAirRtn.rtn("74");
            }
            if ("12".equals(certAir.getState())) {
                log.debug("\u8bc1\u4e66\u5df2\u7ecf\u64a4\u9500!!!");
                return CertInAirRtn.covRtn("15");
            }
            log.debug("\u8be5\u5361\u5df2\u7ecf\u64a4\u9500\u8bc1\u4e66, \u5361\u53f7:{}", (Object)hardNo);
            certAir.setState("12");
            certAir.setDeleteFlag("1");
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.covRtn("15");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            CertAir certAir1 = this.certAirDao.getBySn(sn);
            if (certAir1 != null) {
                if (!"0".equals(certAir1.getDeleteFlag())) {
                    log.debug("\u8bc1\u4e66\u5df2\u7ecf\u64a4\u9500!!!");
                    return CertInAirRtn.covRtn("15");
                }
                certAir1.setUpdateTime(new Date());
                certAir1.setDeleteFlag("1");
                certAir1.setUnFreezeReason("\u8be5\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38 , \u5361\u4e2d\u6ca1\u6709sn\u4f46\u8be5\u8bb0\u5f55\u672a\u64a4\u9500 , \u7279\u6b8a\u5904\u7406\u5c06\u5176\u64a4\u9500");
                this.certAirDao.updateCert(certAir1);
            }
            return CertInAirRtn.covRtn("4");
        }
        if (Strings.isEmpty(sn)) {
            sn = device.getSn();
        }
        if (!sn.equalsIgnoreCase(device.getSn())) {
            log.info("sn\u4e0e\u5361\u4e2dsn\u4e0d\u4e00\u6837");
            CertAir certAir1 = this.certAirDao.getBySn(sn);
            if (certAir1 != null) {
                if (!"0".equals(certAir1.getDeleteFlag())) {
                    log.debug("\u8bc1\u4e66\u5df2\u7ecf\u64a4\u9500!!!");
                    return CertInAirRtn.covRtn("15");
                }
                certAir1.setUpdateTime(new Date());
                certAir1.setDeleteFlag("1");
                certAir1.setUnFreezeReason("\u8be5\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38 , device\u4e2dsn\u4e0e\u5361\u4e2dsn\u4e0d\u4e00\u6837\u4f46\u8be5\u8bb0\u5f55\u672a\u64a4\u9500 , \u7279\u6b8a\u5904\u7406\u5c06\u5176\u64a4\u9500");
                this.certAirDao.updateCert(certAir1);
            }
            return CertInAirRtn.rtn("79");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        if (certAir == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u5361\u72b6\u6001\u4fe1\u606f");
            if (Strings.isNotEmpty(device.getSn()) && Strings.isNotEmpty(device.getCertificate()) && "1".equalsIgnoreCase(device.getFlag()) && "3".equalsIgnoreCase(device.getState())) {
                log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u8bc1\u4e66\u72b6\u6001\u4fe1\u606f, \u4f46\u5361\u4e2d\u6709\u8bc1\u4e66, \u4e14\u5df2\u5f00\u901a\u5728\u7528, \u6dfb\u52a0\u4e00\u6761\u8bc1\u4e66\u72b6\u6001\u4fe1\u606f");
                String snInDevice = device.getSn();
                certAir = this.certAirDao.getByCardIdAndSN(device.getHardNo(), snInDevice);
                if (certAir == null) {
                    certAir = this.addDeviceAir(device, null, person.getId(), null, device.getCertificate(), "pams");
                }
            } else {
                log.error("\u5361\u4e2d\u6ca1\u8bc1\u4e66 , \u5361\u4e0d\u5728\u7528, \u6216\u8005\u6ca1\u6709\u5f00\u901a");
                return CertInAirRtn.rtn("100");
            }
        }
        if (certAir == null) {
            log.error("\u5361\u4fe1\u606f\u6b63\u5e38 , \u4f46\u8bc1\u4e66\u4fe1\u606f\u662f\u7a7a, \u5361\u53f7 : {}, sn : {}", (Object)hardNo, (Object)sn);
            return CertInAirRtn.rtn("103");
        }
        if ("1".equalsIgnoreCase(device.getLockState()) && "1".equalsIgnoreCase(certAir.getFreezeState())) {
            log.info("\u5361\u4e0e\u8bc1\u4e66\u5904\u4e8e\u9501\u5b9a\u72b6\u6001");
            return CertInAirRtn.rtn("206");
        }
        if ("1".equalsIgnoreCase(certAir.getFreezeState())) {
            log.info("\u8bc1\u4e66\u5904\u4e8e\u9501\u5b9a\u72b6\u6001");
            return CertInAirRtn.rtn("206");
        }
        String state = certAir.getState();
        String certs = Strings.buildCerts(device.getCertificate(), device.getCertificate2());
        if ("0".equalsIgnoreCase(state) && "0".equals(certAir.getDeleteFlag())) {
            Date validityEnd = certAir.getValidityEnd();
            if (validityEnd.before(new Date())) {
                return CertInAirRtn.covRtn("16");
            }
            return CertInAirRtn.covRtn("17", certs, certAir.getRefuseReason());
        }
        if ("10".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u64a4\u9500\u5ba1\u6838\u4e2d....");
            return CertInAirRtn.rtn("201");
        }
        if ("20".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u5ef6\u671f\u5ba1\u6838\u4e2d....");
            return CertInAirRtn.rtn("202");
        }
        if ("30".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u66f4\u65b0\u5ba1\u6838\u4e2d....");
            return CertInAirRtn.rtn("204");
        }
        if ("40".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u89e3\u51bb\u5ba1\u6838\u4e2d....");
            return CertInAirRtn.rtn("207");
        }
        if ("11".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u64a4\u9500\u5ba1\u6838\u62d2\u7edd!!!");
            certAir.setState("0");
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.rtn("209", certs, certAir.getRefuseReason());
        }
        if ("21".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u5ef6\u671f\u5ba1\u6838\u62d2\u7edd!!!");
            certAir.setState("0");
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.rtn("210", certs, certAir.getRefuseReason());
        }
        if ("31".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u66f4\u65b0\u5ba1\u6838\u62d2\u7edd!!!");
            certAir.setState("0");
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.rtn("211", certs, certAir.getRefuseReason());
        }
        if ("41".equalsIgnoreCase(state)) {
            log.debug("\u8bc1\u4e66\u89e3\u51bb\u5ba1\u6838\u62d2\u7edd!!!");
            return CertInAirRtn.rtn("212");
        }
        if ("12".equalsIgnoreCase(state) || "1".equalsIgnoreCase(device.getRevokeFlag())) {
            log.debug("\u8bc1\u4e66\u5df2\u7ecf\u64a4\u9500!!!");
            return CertInAirRtn.covRtn("15");
        }
        if ("22".equalsIgnoreCase(state)) {
            log.info("\u8bc1\u4e66\u5ef6\u671f\u5ba1\u6838\u901a\u8fc7, \u5f00\u59cb\u4e0b\u8f7d\u65b0\u8bc1\u4e66");
            CertInAirRtn rtn = this.delayCert(device, certAir, person, true, "inair");
            if (rtn == null) {
                return CertInAirRtn.rtn("101");
            }
            rtn.setFlag("203");
            return rtn;
        }
        if ("32".equalsIgnoreCase(state)) {
            log.info("\u8bc1\u4e66\u66f4\u65b0\u5ba1\u6838\u901a\u8fc7, \u5f00\u59cb\u4e0b\u8f7d\u65b0\u8bc1\u4e66");
            CertInAirRtn rtn = this.renewCert(device, certAir, person);
            if (rtn == null) {
                return CertInAirRtn.rtn("101");
            }
            rtn.setFlag("205");
            return rtn;
        }
        if (!"0".equals(certAir.getDeleteFlag())) {
            log.info("\u8bc1\u4e66\u5df2\u7ecf\u5220\u9664");
            return CertInAirRtn.covRtn("4");
        }
        return null;
    }

    private CertInAirRtn delayCert(Device device, CertAir certAir, Person person, boolean isDelay, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6216\u5ef6\u671f\u7684\u8bc1\u4e66");
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        if ("1".equals(dInfoCA.getUseThirdCert())) {
            return this.delayJit(device, person, certAir, dInfoCA, true, source);
        }
        if ("2".equals(dInfoCA.getUseThirdCert())) {
            return this.delayKR(device, person, certAir, dInfoCA, isDelay, true, source);
        }
        if ("3".equals(dInfoCA.getUseThirdCert())) {
            return this.delaySPCA(device, person, certAir, dInfoCA, isDelay, true, source);
        }
        return this.delayInner(device, person, certAir, dInfoCA, true, source);
    }

    private CertInAirRtn renewCert(Device device, CertAir certAir, Person person) {
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        return null;
    }

    private CertInAirRtn delayInner(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5185\u90e8\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6216\u5ef6\u671f\u7684\u8bc1\u4e66");
        String hardNo = device.getHardNo();
        String iccid = device.getIccid();
        String imei = device.getImei();
        String imsi = device.getImsi();
        Mobile mobile = device.getMobile();
        CertInAirRtn rrtn = this.revokeInner(device, person, certAir, dInfoCA, true, isUpdateDevice);
        if ("0".equals(rrtn.getFlag())) {
            device.setHardNo(hardNo);
            device.setImei(imei);
            device.setImsi(imsi);
            device.setMobile(mobile);
            device.setIccid(iccid);
            return this.certDownLoadInner(certAir.getPubKey(), certAir.getP10(), device, person, dInfoCA, isUpdateDevice, source);
        }
        return rrtn;
    }

    private CertInAirRtn delayJit(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isUpdateDevice, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5409\u5927\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6216\u5ef6\u671f\u7684\u8bc1\u4e66");
        String hardNo = device.getHardNo();
        String iccid = device.getIccid();
        String imei = device.getImei();
        String imsi = device.getImsi();
        Mobile mobile = device.getMobile();
        CertInAirRtn rrtn = this.revokeJIT(device, person, certAir, dInfoCA, true, isUpdateDevice);
        if ("0".equals(rrtn.getFlag())) {
            device.setHardNo(hardNo);
            device.setIccid(iccid);
            device.setImei(imei);
            device.setImsi(imsi);
            device.setMobile(mobile);
            return this.certDownLoadJIT(certAir.getPubKey(), certAir.getP10(), device, person, dInfoCA, isUpdateDevice, source, false);
        }
        return rrtn;
    }

    private CertInAirRtn delayKR(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isDelay, boolean isUpDateDevice, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u683c\u5c14\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6216\u5ef6\u671f\u7684\u8bc1\u4e66");
        PersonKOALInfo pki = this.personKOALInfoService.findByDeviceId(device.getId());
        if (pki == null) {
            pki = this.personKOALInfoService.findByPerson(person.getId(), device.getType());
        }
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String rst = null;
        int day = 1825;
        rst = CommonDClient.postponeApplyRA30(dInfoCA.getUrl(), "3.0", caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), pki.getKoalId(), day);
        if (!"1".equals(rst)) {
            String r = "[\"-1\",\"\u7533\u8bf7\u5ef6\u671f\u7528\u6237\u8bc1\u4e66\u5931\u8d25-" + DInfo.getCertRevoke(rst) + "\"]";
            log.debug("\u683c\u5c14\u5ef6\u671f\u7533\u8bf7\u7ed3\u679c: {}", (Object)r);
            return CertInAirRtn.rtn_all(null, null, r);
        }
        rst = CommonDClient.postponeReviewRA30(dInfoCA.getUrl(), "3.0", pki.getKoalId(), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword());
        if (!"1".equals(rst)) {
            String r = "[\"-1\",\"\u5ef6\u671f\u8bc1\u4e66\u5ba1\u6838\u5931\u8d25-" + DInfo.getCertRevoke(rst) + "\"]";
            log.debug("\u683c\u5c14\u5ef6\u671f\u5ba1\u6838\u7ed3\u679c: {}", (Object)r);
            return CertInAirRtn.rtn_all(null, null, r);
        }
        String strKey = CommonDClient.postPoneCertRA30(dInfoCA.getUrl(), "3.0", device.getType(), device.getHardNo(), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), pki.getKoalId());
        log.debug("\u683c\u5c14\u83b7\u53d6\u8bc1\u4e66\u63a5\u53e3\u8fd4\u56de:" + strKey);
        if (strKey.length() > 10) {
            Date now = new Date();
            String org = strKey.replaceAll("\r|\n", "");
            String[] cerArr = strKey.split("#");
            String cert1 = "";
            if (cerArr.length >= 3) {
                cert1 = cerArr[0].replaceAll("\r|\n", "");
                String sn1 = DInfo.getSN(cerArr[0]);
                String cert2 = cerArr[1].replaceAll("\r|\n", "");
                String sn2 = DInfo.getSN(cerArr[1]);
                log.debug("[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + cert1 + "\",\"" + sn1 + "\",\"" + cert2 + "\",\"" + sn2 + "\",\"" + cerArr[2].replaceAll("\r|\n", "") + "\"]");
                if (isUpDateDevice) {
                    device.setCertificate(cert1.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", ""));
                    device.setSn(sn1);
                    device.setCertificate2(cert2.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", ""));
                    device.setSn2(sn2);
                } else {
                    org = "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + cert1 + "\",\"" + sn1 + "\",\"" + cert2 + "\",\"" + sn2 + "\",\"" + cerArr[2].replaceAll("\r|\n", "") + "\"]";
                }
            } else {
                log.debug("[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(strKey) + "\"]");
                String cert = strKey.replaceAll("\r|\n", "");
                if (isUpDateDevice) {
                    device.setCertificate(cert.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", ""));
                    device.setSn(DInfo.getSN(strKey));
                } else {
                    org = "[\"success\",\"" + strKey.replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(strKey) + "\"]";
                }
            }
            if (isUpDateDevice) {
                device.setAlgType(dInfoCA.getAlgType());
                device.setBindingDate(now);
                device.setBindingState(this.userManageService.getBingDingState(device.getType()));
                device.setOpenDate(now);
                device.setFlag("1");
                device.setLockState("0");
                device.setState("2");
                this.deviceService.update(device);
                certAir.setDeleteFlag(isDelay ? "2" : "3");
                this.certAirDao.updateCert(certAir);
                this.addDeviceAir(device, certAir.getP10(), person, certAir.getPubKey(), cert1, source);
            }
            return CertInAirRtn.rtn_all(null, null, org);
        }
        return CertInAirRtn.rtn("101");
    }

    private CertInAirRtn delaySPCA(Device device, Person person, CertAir certAir, DInfoCA dInfoCA, boolean isDelay, boolean isUpdateDevice, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u7b80\u6613CA\u5f00\u59cb\u4e0b\u8f7d\u66f4\u65b0\u6216\u5ef6\u671f\u7684\u8bc1\u4e66");
        String sn = device.getSn();
        String[] args = new String[]{sn, "", dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), "2", ""};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_delay_renew, args);
        log.debug("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (CERT_STATE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613ca]\u66f4\u65b0\u6216\u5ef6\u671f\u5f02\u5e38, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)CERT_STATE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (result.length() < 10) {
            log.error("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f\u5f02\u5e38, \u8fd4\u56de\u7ed3\u679c\u957f\u5ea6\u5c0f\u4e8e10");
            return CertInAirRtn.covRtn("6");
        }
        String[] certArr = result.split("#");
        String cert1 = Strings.getCert(certArr[0]);
        String sn1 = DInfo.getSN(certArr[0]);
        String cert2 = Strings.getCert(certArr[1]);
        String sn2 = DInfo.getSN(certArr[1]);
        log.info("\nsignCert : {} \nexchangeCert : {}", (Object)cert1, (Object)cert2);
        log.info("\nsn1 : {} \nsn2 : {}", (Object)sn1, (Object)sn2);
        if (isUpdateDevice) {
            device.setCertificate(cert1);
            device.setSn(sn1);
            device.setCertificate2(cert2);
            device.setSn2(sn2);
            device.setFlag("1");
            device.setLockState("0");
            device.setState("3");
            device.setRevokeFlag("0");
            this.deviceService.update(device);
            certAir.setDeleteFlag(isDelay ? "2" : "3");
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
            this.addDeviceAir(device, certAir.getP10(), person, certAir.getPubKey(), cert1, source);
        } else {
            this.deleteCertAirByCardNo(device.getHardNo(), "1", "12");
            result = "[\"success\",\"" + result.replaceAll("\r|\n", "") + "\",\"" + certArr[0].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(certArr[0]) + "\",\"" + certArr[1].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(certArr[1]) + "\"]";
        }
        return CertInAirRtn.rtn_all(null, null, result);
    }

    @Override
    @Transactional
    public CertInAirRtn delayOrRenew(String hardNo, String sn, String pubKey, String type, String reason, String source) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u7533\u8bf7\u66f4\u65b0\u6216\u5ef6\u671f\u7684\u8bc1\u4e66");
        Device device = this.deviceService.getByCardNO(hardNo);
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        if (!sn.equalsIgnoreCase(device.getSn())) {
            log.info("sn\u4e0e\u5361\u4e2dsn\u4e0d\u4e00\u6837");
            return CertInAirRtn.rtn("79");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<CertAir> certAirs = this.certAirDao.findByCardId(hardNo);
        CertAir certAir = this.getCertAir(certAirs, sn);
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        if (certAir == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u5361\u72b6\u6001\u4fe1\u606f");
            if (Strings.isNotEmpty(device.getSn()) && Strings.isNotEmpty(device.getCertificate()) && "1".equalsIgnoreCase(device.getFlag()) && "3".equalsIgnoreCase(device.getState())) {
                return CertInAirRtn.rtn("215");
            }
            log.error("\u5361\u4e2d\u6ca1\u8bc1\u4e66 , \u5361\u4e0d\u5728\u7528, \u6216\u8005\u6ca1\u6709\u5f00\u901a");
            return CertInAirRtn.rtn("100");
        }
        if (Strings.isEmpty(certAir.getP10()) || Strings.isEmpty(certAir.getPubKey())) {
            return CertInAirRtn.rtn("215");
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        boolean isDelay = "2".equals(type);
        certAir.setApplyReason(reason);
        certAir.setPubKey(pubKey);
        if ("true".equals(dInfoCA.getIsNeedVerify())) {
            certAir.setState(isDelay ? "20" : "30");
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.rtn("0");
        }
        return this.delayCert(device, certAir, person, isDelay, source);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Transactional
    public CertInAirRtn delayForPage(String deviceId, String pubKey, String cardNo) {
        CertAir certAir;
        Person person;
        Device device;
        block7: {
            device = this.deviceService.get((Serializable)((Object)deviceId));
            if (device == null) {
                return CertInAirRtn.rtn("74");
            }
            if (!cardNo.equals(device.getHardNo())) {
                log.debug("\u5361\u53f7\u548c\u8bbe\u5907\u4fe1\u606f\u5361\u53f7\u4e0d\u5bf9\u5e94");
                return CertInAirRtn.rtn("216");
            }
            if (Strings.isEmpty(device.getSn())) {
                log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
                return CertInAirRtn.covRtn("4");
            }
            person = this.userManageService.queryPersonById(device.getPersonId());
            if (person == null) {
                return CertInAirRtn.rtn("70");
            }
            List<CertAir> certAirs = this.certAirDao.findNotDeletesByCardId(device.getHardNo());
            if (certAirs == null || certAirs.isEmpty()) {
                if (Strings.isNotEmpty(device.getSn()) && Strings.isNotEmpty(device.getCertificate()) && "1".equalsIgnoreCase(device.getFlag()) && "3".equalsIgnoreCase(device.getState())) {
                    log.info("\u5361\u4fe1\u606f\u6b63\u5e38\uff0c\u6709\u8bc1\u4e66\u4e14\u5df2\u5199\u5361\u5728\u7528\uff0c\u4f46\u6ca1\u6709\u5361\u72b6\u6001\u4fe1\u606f\uff0c\u6dfb\u52a0\u4e00\u6761\u5bf9\u5e94\u8bb0\u5f55");
                    certAir = this.addDeviceAir(device, null, person, pubKey, device.getCertificate(), "pams");
                    break block7;
                } else {
                    log.error("\u5361\u4e2d\u6ca1\u8bc1\u4e66 , \u5361\u4e0d\u5728\u7528, \u6216\u8005\u6ca1\u6709\u5f00\u901a");
                    return CertInAirRtn.rtn("100");
                }
            }
            certAir = certAirs.get(0);
        }
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        return this.delayCert(device, certAir, person, true, "pams");
    }

    @Override
    @Transactional
    public CertInAirRtn applyUnfreeze(String hardNo, String sn, String reason) {
        Device device = this.deviceService.getByCardNO(hardNo);
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        if (!sn.equalsIgnoreCase(device.getSn())) {
            log.info("sn\u4e0e\u5361\u4e2dsn\u4e0d\u4e00\u6837");
            return CertInAirRtn.rtn("79");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<CertAir> certAirs = this.certAirDao.findByCardId(hardNo);
        CertAir certAir = this.getCertAir(certAirs, sn);
        log.info("\u5361\u72b6\u6001\u4fe1\u606f:{}", (Object)certAir);
        if (certAir == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u5361\u72b6\u6001\u4fe1\u606f");
            return CertInAirRtn.rtn("100");
        }
        String freezeState = certAir.getFreezeState();
        String state = certAir.getState();
        log.info("\u8bc1\u4e66\u51bb\u7ed3\u72b6\u6001:{}, \u8bc1\u4e66\u72b6\u6001:{}", (Object)freezeState, (Object)state);
        if (!"1".equalsIgnoreCase(freezeState) || "20".equalsIgnoreCase(state) || "10".equalsIgnoreCase(state) || "30".equalsIgnoreCase(state)) {
            log.info("\u8bc1\u4e66\u88ab\u51bb\u7ed3\u4e2d\u6216\u8005\u5728\u5ba1\u6838\u4e2d,\u64cd\u4f5c\u4e0d\u5408\u6cd5");
            return CertInAirRtn.rtn("213");
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        if ("true".equalsIgnoreCase(dInfoCA.getIsNeedVerify())) {
            certAir.setState("40");
            this.certAirDao.updateCert(certAir);
            return CertInAirRtn.rtn("0");
        }
        return this.unfreezeCert2(device, certAir, person, reason, dInfoCA);
    }

    private CertInAirRtn unfreezeCert2(Device device, CertAir certAir, Person person, String reason, DInfoCA dInfoCA) {
        if (!"1".equals(dInfoCA.getUseThirdCert()) && !"2".equals(dInfoCA.getUseThirdCert())) {
            CertInAirRtn rtn = this.freezeCertCA2(device, reason, dInfoCA, true);
            if (rtn == null) {
                return CertInAirRtn.rtn("101");
            }
            if ("0".equalsIgnoreCase(rtn.getFlag())) {
                device.setLockState("1");
                this.deviceService.update(device);
                certAir.setFreezeState("1");
                this.certAirDao.updateCert(certAir);
            }
            return rtn;
        }
        return null;
    }

    private CertInAirRtn freezeCertCA2(Device device, String reason, DInfoCA dInfoCA, boolean isFreeze) {
        String[] args = new String[]{device.getSn(), isFreeze ? "2" : "1", reason, ""};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_freeze_unfreeze, args);
        log.debug("[\u7b80\u6613CA]\u51bb\u7ed3\u6216\u89e3\u51bb\u7ed3\u679c:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u51bb\u7ed3\u6216\u89e3\u51bb\u7ed3\u679c, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u51bb\u7ed3\u6216\u89e3\u51bb\u7ed3\u679c, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if ("1".equalsIgnoreCase(result)) {
            log.debug("[\u7b80\u6613CA]\u51bb\u7ed3\u6216\u89e3\u51bb\u7ed3\u679c 1,\u64cd\u4f5c\u6210\u529f");
            return CertInAirRtn.rtn("0");
        }
        return null;
    }

    @Override
    @Transactional
    public CertInAirRtn reportWriteState(String hardNo, String state) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u4e0a\u62a5\u5199\u5361\u72b6\u6001");
        Device device = this.deviceService.getByCardNO(hardNo);
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<CertAir> certAirs = this.certAirDao.findByCardId(hardNo);
        CertAir certAir = this.getCertAir(certAirs, device.getSn());
        if ("1".equalsIgnoreCase(state)) {
            DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
            return this.revokeCert2(device, person, certAir, dInfoCA);
        }
        return null;
    }

    @Override
    public CertInAirRtn getDNByCardNo(String hardNo) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u3011\u5f00\u59cb\u83b7\u53d6dn");
        Device device = this.deviceService.getByCardNO(hardNo);
        if (device == null) {
            return CertInAirRtn.rtn("74");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        return CertInAirRtn.rtn_all(this.createDn(person), null, null);
    }

    private CertAir getCertAir(List<CertAir> certAirs, String sn) {
        if (certAirs == null) {
            log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u5361\u72b6\u6001\u4fe1\u606f");
            return null;
        }
        for (CertAir ca : certAirs) {
            String[] snArr;
            String sns;
            if (!"0".equals(ca.getDeleteFlag()) || Strings.isEmpty(sns = ca.getSn())) continue;
            for (String s : snArr = sns.split("#")) {
                if (!s.equalsIgnoreCase(sn)) continue;
                return ca;
            }
        }
        return null;
    }

    private List<CertAir> getCertAirNotDelete(List<CertAir> certAirs) {
        if (certAirs == null) {
            return null;
        }
        ArrayList<CertAir> result = new ArrayList<CertAir>();
        for (CertAir ca : certAirs) {
            if (!"0".equals(ca.getState())) continue;
            result.add(ca);
        }
        return result;
    }

    @Override
    public List<CertAirExt> listCertAir(CertInAirForm form, Page page) {
        List<CertAir> list = this.certAirDao.listCertAir(form, page);
        ArrayList<CertAirExt> r = new ArrayList<CertAirExt>();
        if (list != null && !list.isEmpty()) {
            for (CertAir ca : list) {
                r.add(this.extCertAir(ca));
            }
        }
        return r;
    }

    private CertAirExt extCertAir(CertAir certAir) {
        CertAirExt bean = new CertAirExt();
        BeanUtils.copyProperties((Object)certAir, (Object)bean);
        Person person = this.userManageService.queryPersonById(bean.getPersonId());
        bean.setDepCode(person.getDepartment().getCode());
        bean.setDepName(person.getDepartment().getName());
        bean.setIdentityNo(person.getIdentifier());
        bean.setPersonCode(person.getCode());
        bean.setPersonName(person.getName());
        bean.setStateName(this.getStateName(certAir.getState()));
        return bean;
    }

    private String getStateName(String state) {
        String name = "";
        switch (state) {
            case "0": {
                name = "\u6b63\u5e38";
                break;
            }
            case "10": {
                name = "\u7533\u8bf7\u64a4\u9500";
                break;
            }
            case "11": {
                name = "\u64a4\u9500\u62d2\u7edd";
                break;
            }
            case "12": {
                name = "\u5df2\u64a4\u9500";
                break;
            }
            case "20": {
                name = "\u7533\u8bf7\u5ef6\u671f";
                break;
            }
            case "21": {
                name = "\u5ef6\u671f\u62d2\u7edd";
                break;
            }
            case "22": {
                name = "\u7533\u8bf7\u5ef6\u671f\u901a\u8fc7";
                break;
            }
            case "30": {
                name = "\u7533\u8bf7\u66f4\u65b0";
                break;
            }
            case "31": {
                name = "\u66f4\u65b0\u62d2\u7edd";
                break;
            }
            case "32": {
                name = "\u66f4\u65b0\u7533\u8bf7\u901a\u8fc7";
                break;
            }
            case "40": {
                name = "\u7533\u8bf7\u89e3\u51bb";
                break;
            }
            case "41": {
                name = "\u89e3\u51bb\u62d2\u7edd";
            }
        }
        return name;
    }

    @Override
    public CertAirExt getCertAir(CertInAirForm form) {
        String id = form.getId();
        CertAir ca = this.certAirDao.findById(id);
        return this.extCertAir(ca);
    }

    @Override
    @Transactional
    public Map<String, String> changeState(CertInAirForm form) {
        log.info("\u3010\u7a7a\u4e2d\u53d1\u8bc1\u5ba1\u6838\u3011\u5f00\u59cb\u66f4\u6539\u72b6\u6001");
        HashMap<String, String> result = new HashMap<String, String>();
        String id = form.getId();
        CertAir ca = this.certAirDao.findById(id);
        Person person = this.userManageService.queryPersonById(ca.getPersonId());
        Device device = this.deviceService.getByCardNO(ca.getCardId());
        if (device == null) {
            ca.setDeleteFlag("1");
            ca.setState("12");
            ca.setUpdateTime(new Date());
            this.certAirDao.updateCert(ca);
            result.put("state", "0");
            result.put("msg", "\u5df2\u7ecf\u64a4\u9500");
            return result;
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        try {
            if ("true".equalsIgnoreCase(dInfoCA.getIsNeedVerify())) {
                String state = ca.getState();
                String stateTarget = form.getState();
                if ("10".equals(state)) {
                    log.debug("\u64a4\u9500\u76f8\u5173\u64cd\u4f5c");
                    if ("11".equals(stateTarget)) {
                        log.debug("\u62d2\u7edd\u64a4\u9500");
                        ca.setState("11");
                        ca.setRefuseReason(form.getReason());
                        ca.setUpdateTime(new Date());
                        this.certAirDao.updateCert(ca);
                        result.put("state", "0");
                        result.put("msg", "\u62d2\u7edd\u6210\u529f");
                    }
                    if ("12".equals(stateTarget)) {
                        log.debug("\u5f00\u59cb\u64a4\u9500");
                        CertInAirRtn rtn = this.revokeCert2(device, person, ca, dInfoCA);
                        if ("0".equals(rtn.getFlag())) {
                            result.put("state", "0");
                            result.put("msg", "\u64a4\u9500\u6210\u529f");
                        } else {
                            result.put("state", "1");
                            result.put("msg", "\u64a4\u9500\u5931\u8d25");
                        }
                    }
                } else if ("20".equals(state)) {
                    if ("21".equals(stateTarget)) {
                        ca.setState("21");
                        ca.setRefuseReason(form.getReason());
                        ca.setUpdateTime(new Date());
                        this.certAirDao.updateCert(ca);
                        result.put("state", "0");
                        result.put("msg", "\u62d2\u7edd\u6210\u529f");
                    }
                    if ("22".equals(stateTarget)) {
                        ca.setState("22");
                        ca.setRefuseReason(form.getReason());
                        ca.setUpdateTime(new Date());
                        this.certAirDao.updateCert(ca);
                        result.put("state", "0");
                        result.put("msg", "\u64cd\u4f5c\u6210\u529f");
                    }
                } else if ("30".equals(state)) {
                    if ("31".equals(stateTarget)) {
                        ca.setState("31");
                        ca.setRefuseReason(form.getReason());
                        ca.setUpdateTime(new Date());
                        this.certAirDao.updateCert(ca);
                        result.put("state", "0");
                        result.put("msg", "\u62d2\u7edd\u6210\u529f");
                    }
                    if ("32".equals(stateTarget)) {
                        ca.setState("32");
                        ca.setRefuseReason(form.getReason());
                        ca.setUpdateTime(new Date());
                        this.certAirDao.updateCert(ca);
                        result.put("state", "0");
                        result.put("msg", "\u64cd\u4f5c\u6210\u529f");
                    }
                } else {
                    result.put("state", "1");
                    result.put("msg", "\u72b6\u6001\u5f02\u5e38");
                }
            } else {
                result.put("state", "1");
                result.put("msg", "\u540e\u53f0\u4e0d\u5141\u8bb8\u5ba1\u6838 ....");
            }
        }
        catch (Exception e) {
            log.error("\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            result.put("state", "1");
            result.put("msg", "\u7cfb\u7edf\u5f02\u5e38");
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, String> applySPCA4Page(String deviceId, String cardno) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        if (Strings.isEmpty(deviceId)) {
            result.put("msg", "\u5361id\u5f02\u5e38");
            return result;
        }
        Device device = this.deviceService.get((Serializable)((Object)deviceId));
        if (device == null) {
            result.put("msg", "\u5361\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        Person person = this.userManageService.getPersonByPersonId(device.getPersonId());
        if (person == null) {
            result.put("msg", "\u4eba\u5458\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(device.getCommType(), person.getPersonType());
        CertInAirRtn rtn = this.applySPCA(person, device.getType(), cardno, dInfoCA);
        if ("0".equals(rtn.getFlag())) {
            result.put("flag", "0");
            result.put("msg", "\u5b9e\u4f53\u8ba4\u8bc1\u6210\u529f");
            String dn = DInfo.getDnReqBuf(rtn.getDn()).replaceAll(",", "#");
            result.put("dn", dn);
        } else {
            result.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
        }
        return result;
    }

    @Override
    @Transactional
    public Map<String, String> downloadCertSPCA(String deviceId, String pubKey, String p10, String cardno, boolean isDelayCard, String source) {
        String msg;
        CertInAirRtn rtn;
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        Device deviceOrg = this.deviceService.get((Serializable)((Object)deviceId));
        if (deviceOrg == null) {
            result.put("msg", "\u5361\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        Person person = this.userManageService.getPersonByPersonId(deviceOrg.getPersonId());
        if (person == null) {
            result.put("msg", "\u4eba\u5458\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        PersonSPCAInfo personSPCAInfo = this.personSPCAInfoDao.findByPersonId(person.getId());
        if (personSPCAInfo == null) {
            result.put("msg", "\u6ca1\u6709\u5b9e\u4f53\u8ba4\u8bc1\u4fe1\u606f");
            return result;
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(deviceOrg.getCommType(), person.getPersonType());
        Device device = new Device();
        device.setSn(deviceOrg.getSn());
        device.setType(deviceOrg.getType());
        device.setHardNo(cardno);
        device.setPersonId(deviceOrg.getPersonId());
        if (isDelayCard) {
            CertAir certAir = this.certAirDao.getBySn(device.getSn());
            Date validityEnd = certAir.getValidityEnd();
            int days = dInfoCA.getValidityBeforeLimitDays();
            if (days != -1 && this.isValidityDate(validityEnd, days)) {
                rtn = this.delaySPCA(device, person, certAir, dInfoCA, true, false, source);
                msg = CertInAirRtn.FLAG_MAP.get(rtn.getFlag());
                msg = Strings.isEmpty(msg) ? "\u5ef6\u671f\u8bc1\u4e66\u5931\u8d25" : msg;
            } else {
                rtn = CertInAirRtn.rtn("-1");
                msg = "\u5ef6\u671f\u5931\u8d25 : \u8bc1\u4e66\u5931\u6548\u524d" + days + "\u5929\u5185\u5141\u8bb8\u5ef6\u671f";
            }
        } else {
            this.deleteOldCertAirOfCard(cardno);
            rtn = this.certDownloadSPCA(Strings.isEmpty(p10) ? this.getP10(personSPCAInfo.getDn(), pubKey) : this.covP10(p10), pubKey, device, person, dInfoCA, false, source);
            msg = CertInAirRtn.FLAG_MAP.get(rtn.getFlag());
            String string = msg = Strings.isEmpty(msg) ? "\u4e0b\u8f7d\u8bc1\u4e66\u5931\u8d25" : msg;
        }
        if ("0".equals(rtn.getFlag())) {
            result.put("flag", "0");
            result.put("certs", rtn.getCerts());
        } else {
            result.put("msg", msg);
        }
        return result;
    }

    @Override
    @Transactional
    public void deleteOldCertAirOfCard(String cardNo) {
        List<CertAir> certAirs = this.certAirDao.findByCardId(cardNo);
        if (certAirs != null && !certAirs.isEmpty()) {
            for (CertAir ca : certAirs) {
                if (!"0".equals(ca.getState())) continue;
                ca.setDeleteFlag("3");
                ca.setUpdateTime(new Date());
                this.certAirDao.updateCert(ca);
            }
        }
    }

    @Override
    public CertInAirRtn getPersonInfoBySn(String sn) {
        Device device = this.deviceService.getBySn(sn);
        if (device == null) {
            log.debug("\u5361\u4fe1\u606f\u4e0d\u5b58\u5728");
            return CertInAirRtn.rtn("74");
        }
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", person.getName());
        map.put("gender", person.getSex());
        List<Mobile> list = person.getMobiledList();
        StringBuilder sb = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(list.get(i).getMobile());
            }
        }
        map.put("mobile", sb.toString());
        map.put("identifier", person.getIdentifier());
        map.put("personId", person.getId());
        CertInAirRtn rtn = CertInAirRtn.rtn("0");
        rtn.setExt(map);
        return rtn;
    }

    @Override
    public CertInAirRtn getDeviceInfoByIdentifier(String identifier, String mobile) {
        Person person = null;
        if (Strings.isNotEmpty(mobile)) {
            person = this.userManageService.getUserByMobile(mobile);
        } else if (Strings.isEmpty(mobile) && Strings.isNotEmpty(identifier) && (person = this.userManageService.getUserByIdentifer(identifier.toUpperCase())) == null) {
            person = this.userManageService.getUserByIdentifer(identifier.toLowerCase());
        }
        if (person == null) {
            return CertInAirRtn.rtn("70");
        }
        List<Device> list = this.deviceService.getByPersonId(person.getId());
        HashMap<String, Object> ext = new HashMap<String, Object>();
        if (list != null && !list.isEmpty()) {
            ArrayList infos = new ArrayList();
            for (Device d : list) {
                if (!"3".equals(d.getState()) || Strings.isEmpty(d.getSn()) || Strings.isEmpty(d.getHardNo())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                if (Strings.isNotEmpty(d.getSn())) {
                    map.put("sn", d.getSn());
                }
                if (Strings.isNotEmpty(d.getHardNo())) {
                    map.put("cardId", d.getHardNo());
                }
                if (Strings.isNotEmpty(d.getType())) {
                    map.put("type", d.getType());
                }
                if (map.size() <= 0) continue;
                infos.add(map);
            }
            ext.put("infos", infos);
        }
        ext.put("mode", this.systemConfigExtService.getValueByCode("per_person_per_card_per_cert"));
        CertInAirRtn rtn = CertInAirRtn.rtn("0");
        rtn.setExt(ext);
        return rtn;
    }

    private boolean isValidityDate(Date validityEnd, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        Date future = calendar.getTime();
        return future.after(validityEnd);
    }

    private String covP10(String p10org) {
        if (Strings.isEmpty(p10org)) {
            return "";
        }
        p10org = p10org.replace("-----BEGIN CERTIFICATE REQUEST-----", "");
        p10org = p10org.replace("-----END CERTIFICATE REQUEST-----", "");
        p10org = p10org.replaceAll("\n", "");
        p10org = p10org.replaceAll("\\\\n", "");
        return p10org;
    }

    @Override
    @Transactional
    public Map<String, String> revokeCertSPCA(Device deviceRecord) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("flag", "1");
        Device device = this.deviceService.get((Serializable)((Object)deviceRecord.getId()));
        if (device == null) {
            result.put("msg", "\u5361\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        device.setSn(deviceRecord.getSn());
        Person person = this.userManageService.getPersonByPersonId(device.getPersonId());
        if (person == null) {
            result.put("msg", "\u4eba\u5458\u4fe1\u606f\u5f02\u5e38");
            return result;
        }
        String sn1 = device.getSn();
        if (Util.varCheckEmp(sn1)) {
            log.debug("[\u7b80\u6613CA]\u6ca1\u6709\u83b7\u53d6\u5230sn1");
            result.put("msg", "\u5361\u4fe1\u606f\u5f02\u5e38:\u6ca1\u6709sn1");
            return result;
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(device.getCommType(), person.getPersonType());
        CertInAirRtn rtn = this.revokeSPCA(device, null, dInfoCA, false, false);
        if ("0".equals(rtn.getFlag())) {
            result.put("flag", "0");
            result.put("msg", "\u64a4\u9500\u6210\u529f");
        } else {
            result.put("msg", CertInAirRtn.FLAG_MAP.get(rtn.getFlag()));
        }
        return result;
    }

    private String getP10(String dn, String pubKey) {
        return CertUtil.getP10ReqestBC(pubKey, dn);
    }

    @Override
    @Transactional
    public CertInAirRtn renew(String hardNo, String pubkey, String p10, String isUpdateKey, boolean isUpdateDevice, String source) {
        log.debug("\u5f00\u59cb\u8fdb\u884c\u8bc1\u4e66\u66f4\u65b0");
        Device device = this.deviceService.getByCardNO(hardNo);
        if (device == null) {
            log.debug("\u5361\u4fe1\u606f\u4e0d\u5b58\u5728");
            return CertInAirRtn.rtn("74");
        }
        Person person = this.userManageService.getPersonByPersonId(device.getPersonId());
        if (person == null) {
            log.debug("\u4eba\u5458\u4e0d\u5b58\u5728");
            return CertInAirRtn.rtn("70");
        }
        if (Strings.isEmpty(device.getSn())) {
            log.debug("\u8bc1\u4e66\u4e0d\u5b58\u5728");
            return CertInAirRtn.covRtn("4");
        }
        CertAir certAir = this.certAirDao.getBySn(device.getSn());
        boolean isUpdateKeyB = "1".equals(isUpdateKey);
        if (isUpdateKeyB && Strings.isEmpty(pubkey) && Strings.isEmpty(p10)) {
            log.debug("pubkey \u548c p10\u5fc5\u4f20\u4e00\u4e2a");
            return CertInAirRtn.rtn("60");
        }
        DInfoCA dInfoCA = this.systemConfigExtService.getDInfoCAByYYS(this.getComType(device, null), person.getPersonType());
        if ("1".equals(dInfoCA.getUseThirdCert())) {
            return this.renewJit(device, person, certAir, pubkey, p10, dInfoCA, isUpdateKeyB, isUpdateDevice, source);
        }
        if ("2".equals(dInfoCA.getUseThirdCert())) {
            return this.renewKR(device, person, certAir, pubkey, p10, dInfoCA, isUpdateKeyB, isUpdateDevice, source);
        }
        if ("3".equals(dInfoCA.getUseThirdCert())) {
            return this.renewSPCA(device, person, certAir, pubkey, p10, dInfoCA, isUpdateKeyB, isUpdateDevice, source);
        }
        return this.renewInner(device, person, certAir, pubkey, p10, dInfoCA, isUpdateKeyB, isUpdateDevice, source);
    }

    private CertInAirRtn renewJit(Device device, Person person, CertAir certAir, String pubkey, String p10, DInfoCA dInfoCA, boolean isUpdateKey, boolean isUpdateDevice, String source) {
        return null;
    }

    private CertInAirRtn renewKR(Device device, Person person, CertAir certAir, String pubkey, String p10, DInfoCA dInfoCA, boolean isUpdateKey, boolean isUpdateDevice, String source) {
        PersonKOALInfo kpi;
        log.debug("\u5f00\u59cb\u683c\u5c14\u8bc1\u4e66\u66f4\u65b0...");
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("USER_IDNO", person.getIdentifier());
        userMap.put("USER_NAME", person.getName());
        userMap.put("USER_CREY", "00");
        userMap.put("USER_POTYPE", CertUserInfoTrans.getUserPoType(person.getPolice()));
        userMap.put("CERT_TYPE", CertUserInfoTrans.getCertType(person.getPersonType(), device.getType()));
        userMap.put("USER_POSLEVEL", CertUserInfoTrans.getPosLevel(person.getPosition()));
        userMap.put("USER_POS", CertUserInfoTrans.getPos(person.getGrade(), person.getPosition()));
        userMap.put("USER_WORK", CertUserInfoTrans.getWork());
        userMap.put("USER_ORG_CODE", person.getDepartment().getCode());
        String caAlg = "1.0";
        if ("2".equals(dInfoCA.getAlgType())) {
            caAlg = "2.0";
        }
        String userInfo = Util.toJsonStr(userMap);
        log.debug("userInfo: {}", (Object)userInfo);
        String cardType = device.getType();
        if ("2".equals(cardType)) {
            cardType = "4";
        }
        if ((kpi = this.personKOALInfoService.findByDeviceId(device.getId())) == null) {
            kpi = this.personKOALInfoService.findByPerson(person.getId(), device.getType());
        }
        String[] args = new String[]{"3.0", cardType, device.getHardNo(), DInfo.getPubKey(device.getCertificate()), caAlg, dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), kpi.getKoalId(), userInfo};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_renew, args);
        log.debug("[\u683c\u5c14]\u66f4\u65b0\u65b0\u8bc1\u4e66\u4fe1\u606f:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u683c\u5c14]\u66f4\u65b0\u65b0\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u683c\u5c14]\u66f4\u65b0\u65b0\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        Object[] certArr = result.split("#");
        if (result.length() < 10 || certArr.length == 0) {
            log.debug("[\u683c\u5c14]\u66f4\u65b0\u65b0\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25, \u8fd4\u56de\u7ed3\u679c\u4e0d\u5bf9, \u7ed3\u679c\u4e3a:{}", certArr);
            return CertInAirRtn.rtn("100");
        }
        log.debug("[\u683c\u5c14]\u66f4\u65b0\u65b0\u8bc1\u4e66\u4fe1\u606f\u6210\u529f .. \u5f00\u59cb\u89e3\u6790\u8bc1\u4e66");
        if (certAir != null) {
            certAir.setState("3");
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
        }
        if (isUpdateDevice) {
            String cert1 = Strings.getCert((String)certArr[0]);
            String sn1 = DInfo.getSN((String)certArr[0]);
            String cert2 = Strings.getCert((String)certArr[1]);
            String sn2 = DInfo.getSN((String)certArr[1]);
            log.info("\nsignCert : {} \nexchangeCert : {}", (Object)cert1, (Object)cert2);
            log.info("\nsn1 : {} \nsn2 : {}", (Object)sn1, (Object)sn2);
            Date now = new Date();
            device.setCertificate(cert1);
            device.setSn(sn1);
            device.setCertificate2(cert2);
            device.setSn2(sn2);
            device.setAlgType(dInfoCA.getAlgType());
            device.setBindingDate(now);
            device.setBindingState(this.userManageService.getBingDingState(device.getType()));
            device.setOpenDate(now);
            device.setFlag("1");
            device.setLockState("0");
            device.setState("3");
            this.deviceService.update(device);
            this.addDeviceAir(device, p10, device.getPersonId(), "", cert1, source);
        } else {
            result = "[\"success\",\"" + result.replaceAll("\r|\n", "") + "\",\"" + ((String)certArr[0]).replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN((String)certArr[0]) + "\",\"" + ((String)certArr[1]).replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN((String)certArr[1]) + "\"]";
        }
        return CertInAirRtn.rtn_all(null, null, result);
    }

    private CertInAirRtn renewSPCA(Device device, Person person, CertAir certAir, String pubkey, String p10, DInfoCA dInfoCA, boolean isUpdateKey, boolean isUpdateDevice, String source) {
        log.info("\u7b80\u6613CA\u5f00\u59cb\u66f4\u65b0\u8bc1\u4e66");
        String sn = device.getSn();
        String[] args = new String[]{sn, isUpdateKey ? p10 : "", dInfoCA.getDevCardNo(), dInfoCA.getDevPassword(), "2", ""};
        String result = CommonDClientForSimpleCA.connectCA(dInfoCA.getUrl(), CAType.cert_delay_renew, args);
        log.debug("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f:{}", (Object)result);
        if ("-1".equals(result)) {
            log.debug("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f, \u7ed3\u679c:-1");
            return CertInAirRtn.rtn("100");
        }
        if (ERR_CODE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)ERR_CODE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (CERT_STATE_MAP.get(result) != null) {
            log.debug("[\u7b80\u6613ca]\u66f4\u65b0\u6216\u5ef6\u671f\u5f02\u5e38, \u9519\u8bef\u7801:{}, \u9519\u8bef\u4fe1\u606f:{}", (Object)result, (Object)CERT_STATE_MAP.get(result));
            return CertInAirRtn.covRtn(result);
        }
        if (result.length() < 10) {
            log.error("[\u7b80\u6613CA]\u66f4\u65b0\u6216\u5ef6\u671f\u5f02\u5e38, \u8fd4\u56de\u7ed3\u679c\u957f\u5ea6\u5c0f\u4e8e10");
            return CertInAirRtn.covRtn("6");
        }
        String[] certArr = result.split("#");
        String cert1 = Strings.getCert(certArr[0]);
        String sn1 = DInfo.getSN(certArr[0]);
        String cert2 = Strings.getCert(certArr[1]);
        String sn2 = DInfo.getSN(certArr[1]);
        log.info("\nsignCert : {} \nexchangeCert : {}", (Object)cert1, (Object)cert2);
        log.info("\nsn1 : {} \nsn2 : {}", (Object)sn1, (Object)sn2);
        if (isUpdateDevice) {
            device.setCertificate(cert1);
            device.setSn(sn1);
            device.setCertificate2(cert2);
            device.setSn2(sn2);
            device.setFlag("1");
            device.setLockState("0");
            device.setState("3");
            device.setRevokeFlag("0");
            this.deviceService.update(device);
            certAir.setDeleteFlag("3");
            certAir.setUpdateTime(new Date());
            this.certAirDao.updateCert(certAir);
            this.addDeviceAir(device, certAir.getP10(), person, certAir.getPubKey(), cert1, source);
        } else {
            this.deleteCertAirByCardNo(device.getHardNo(), "1", "12");
            result = "[\"success\",\"" + result.replaceAll("\r|\n", "") + "\",\"" + certArr[0].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(certArr[0]) + "\",\"" + certArr[1].replaceAll("\r|\n", "") + "\",\"" + DInfo.getSN(certArr[1]) + "\"]";
        }
        return CertInAirRtn.rtn_all(null, null, result);
    }

    private CertInAirRtn renewInner(Device device, Person person, CertAir certAir, String pubkey, String p10, DInfoCA dInfoCA, boolean isUpdateKey, boolean isUpdateDevice, String source) {
        return null;
    }

    private String getComType(Device device, String phone) {
        if (device != null) {
            if (Strings.isNotEmpty(device.getCommType())) {
                return device.getCommType();
            }
            Mobile mobile = device.getMobile();
            if (mobile != null) {
                phone = mobile.getMobile();
            }
        }
        if (Strings.isNotEmpty(phone)) {
            if (phone.matches(ISCHINAUNIOM)) {
                return "2";
            }
            if (phone.matches(ISCHINATELCOM)) {
                return "3";
            }
        }
        return "";
    }

    static {
        ERR_CODE_MAP = new HashMap<String, String>();
        CERT_STATE_MAP = new HashMap<String, String>();
        ERR_CODE_MAP.put("-1", "\u8bf7\u6c42-D\u63a5\u53e3\u5f02\u5e38");
        ERR_CODE_MAP.put("33", "\u7528\u6237ID\u4e0d\u5b58\u5728");
        ERR_CODE_MAP.put("34", "\u7528\u6237\u8bc1\u4e66\u5df2\u7ecf\u4e0b\u8f7d");
        ERR_CODE_MAP.put("35", "\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        ERR_CODE_MAP.put("36", "\u6a21\u677f\u540d\u79f0\u4e0d\u6b63\u786e");
        ERR_CODE_MAP.put("37", "DN\u91cd\u590d");
        ERR_CODE_MAP.put("38", "\u8eab\u4efd\u8bc1\u91cd\u590d");
        ERR_CODE_MAP.put("0", "\u4e3a\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        ERR_CODE_MAP.put("2", "\u5931\u8d25");
        ERR_CODE_MAP.put("3", "\u8bc1\u4e66\u5df2\u5b58\u5728");
        ERR_CODE_MAP.put("4", "\u8bc1\u4e66\u4e0d\u5b58\u5728");
        ERR_CODE_MAP.put("5", "\u4e0d\u652f\u6301\u7684CA\u7c7b\u578b");
        ERR_CODE_MAP.put("6", "CA\u9519\u8bef");
        ERR_CODE_MAP.put("7", "\u5361\u7c7b\u578b\u9519\u8bef");
        ERR_CODE_MAP.put("8", "\u5361\u53f7\u4e3a\u7a7a");
        ERR_CODE_MAP.put("9", "\u64cd\u4f5c\u8005\u4e3a\u7a7a");
        ERR_CODE_MAP.put("10", "\u516c\u94a5\u9519\u8bef");
        ERR_CODE_MAP.put("11", "\u751f\u6210p10\u9519\u8bef");
        ERR_CODE_MAP.put("12", "\u4ecep7\u83b7\u53d6\u8bc1\u4e66\u9519\u8bef");
        ERR_CODE_MAP.put("13", "\u6570\u636e\u5e93\u9519\u8bef");
        ERR_CODE_MAP.put("19", "\u5176\u4ed6\u9519\u8bef");
        ERR_CODE_MAP.put("23", "\u751f\u6210\u5361\u8bc1\u4e66\u5931\u8d25\uff0c\u8bc1\u4e66\u6570\u91cf\u8d85\u8fc7license\u6587\u4ef6\u9650\u5236");
        ERR_CODE_MAP.put("30", "\u8bbe\u5907\u786c\u4ef6\u7f16\u53f7\u6216\u8bbe\u5907imei\u4e0d\u5728\u767d\u540d\u5355\u4e2d");
        CERT_STATE_MAP.put("14", "\u8bc1\u4e66\u5df2\u88ab\u51bb\u7ed3");
        CERT_STATE_MAP.put("15", "\u8bc1\u4e66\u5df2\u88ab\u64a4\u9500");
        CERT_STATE_MAP.put("16", "\u8bc1\u4e66\u5df2\u8fc7\u671f");
        CERT_STATE_MAP.put("17", "\u6b63\u5e38\u72b6\u6001\u7684\u8bc1\u4e66");
        CERT_STATE_MAP.put("18", "\u65e0\u6548\u7684\u8bc1\u4e66");
        CERT_STATE_MAP.put("39", "\u51bb\u7ed3\u9700\u8981\u5ba1\u6838");
        CERT_STATE_MAP.put("40", "\u51bb\u7ed3\u5ba1\u6838\u901a\u8fc7");
        CERT_STATE_MAP.put("41", "\u51bb\u7ed3\u5ba1\u6838\u62d2\u7edd");
        CERT_STATE_MAP.put("42", "\u89e3\u51bb\u9700\u8981\u5ba1\u6838");
        CERT_STATE_MAP.put("43", "\u89e3\u51bb\u5ba1\u6838\u901a\u8fc7");
        CERT_STATE_MAP.put("44", "\u89e3\u51bb\u5ba1\u6838\u62d2\u7edd");
        CERT_STATE_MAP.put("45", "\u5ef6\u671f\u9700\u8981\u5ba1\u6838");
        CERT_STATE_MAP.put("46", "\u5ef6\u671f\u5ba1\u6838\u901a\u8fc7");
        CERT_STATE_MAP.put("47", "\u5ef6\u671f\u5ba1\u6838\u62d2\u7edd");
        CERT_STATE_MAP.put("48", "\u66f4\u65b0\u9700\u8981\u5ba1\u6838");
        CERT_STATE_MAP.put("49", "\u66f4\u65b0\u5ba1\u6838\u901a\u8fc7");
        CERT_STATE_MAP.put("50", "\u66f4\u65b0\u5ba1\u6838\u62d2\u7edd");
        CERT_STATE_MAP.put("51", "\u64a4\u9500\u5ba1\u6838");
        CERT_STATE_MAP.put("52", "\u64a4\u9500\u5ba1\u6838\u901a\u8fc7");
        CERT_STATE_MAP.put("53", "\u64a4\u9500\u5ba1\u6838\u62d2\u7edd");
    }
}

