/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.sms.entity.Message;
import com.xdja.pams.sms.service.MessageService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class MessageController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(MessageController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DepManageService depService;

    @RequestMapping(value={"sms/messagecontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"sms/messagecontroller/query.do"})
    public void query(Message msg, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        operator = this.getOperator(request);
        person = operator.getPerson();
        ArrayList listmap = new ArrayList();
        Page page = new Page();
        try {
            page.setRp(Integer.parseInt(pageParam.getRows()));
            page.setPage(Integer.parseInt(pageParam.getPage()));
            msg.setCby(person.getCode());
            List<Message> list = this.messageService.query(msg, page);
            for (Message mg : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", mg.getId());
                map.put("mc", mg.getMc());
                map.put("nr", mg.getNr());
                map.put("sjh", mg.getSjh());
                map.put("cby", mg.getCby());
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u56fa\u5b9a\u77ed\u4fe1\u51fa\u9519", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"sms/messagecontroller/add.do"})
    public String add(String id, ModelMap map) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            map.put((Object)"id", (Object)id);
        }
        return "sms/message/default/add";
    }

    @RequestMapping(value={"sms/messagecontroller/save.do"})
    public void save(Message msg, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        operator = this.getOperator(request);
        person = operator.getPerson();
        msg.setSjh("1");
        msg.setCby(person.getCode());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.messageService.save(msg);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"sms/messagecontroller/update.do"})
    public void update(Message msg, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        operator = this.getOperator(request);
        person = operator.getPerson();
        msg.setSjh("1");
        msg.setCby(person.getCode());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.messageService.update(msg);
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"sms/messagecontroller/del.do"})
    public void del(String id, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 0;
        Operator operator = null;
        Person person = null;
        operator = this.getOperator(request);
        person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.messageService.delete((Serializable)((Object)id));
            map.put("flag", "1");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put("flag", "0");
            map.put("message", MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"sms/messagecontroller/getById.do"})
    public void get(String id, HttpServletResponse response) {
        try {
            Message msg = this.messageService.get((Serializable)((Object)id));
            HashMap<String, String> mapMsg = new HashMap<String, String>();
            mapMsg.put("id", msg.getId());
            mapMsg.put("mc", msg.getMc());
            mapMsg.put("nr", msg.getNr());
            mapMsg.put("cby", msg.getCby());
            Util.writeUtf8JSON(response, Util.toJsonStr(mapMsg));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"sms/messagecontroller/checkMc.do"})
    public void checkMc(String mc, String id, HttpServletResponse response) {
        boolean flag = this.messageService.checkMessage(mc, id);
        Util.writeUtf8JSON(response, Boolean.toString(!flag));
    }

    @RequestMapping(value={"/sms/messagecontroller/queryMessageListForSelect.do"})
    public void queryMessageListForSelect(HttpServletRequest request, HttpServletResponse response) {
        Operator operator = null;
        Person person = null;
        operator = this.getOperator(request);
        person = operator.getPerson();
        Message msg = new Message();
        msg.setCby(person.getCode());
        String jsonlist = "";
        try {
            List<Map<String, Object>> listmap = this.messageService.queryMessageListForSelect(msg);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + person.getId() + "\u3011\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text(response, jsonlist);
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

