/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.service;

import com.xdja.model.mtsms.SendSmsResponse;
import com.xdja.model.smsstatus.ArrayOfSmsStatus;
import com.xdja.model.smsstatus.GeSmsStatusResponse;
import com.xdja.pams.sms.bean.MtSms;
import com.xdja.pams.sms.bean.SendSmsRequest;
import com.xdja.pams.sms.bean.SendSmsResult;
import com.xdja.pams.sms.bean.SmsStatus;
import com.xdja.pams.sms.bean.SmsStatusRequest;
import com.xdja.pams.sms.util.ObjectConverterUtil;
import com.xdja.service.ServiceException;
import com.xdja.service.XdjaGwWbs;
import com.xdja.service.XdjaGwWbsPortType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsOperator {
    private static final QName SERVICE_NAME = new QName("http://www.xdja.com/service", "xdja_gw_wbs");
    private static XdjaGwWbsPortType client = null;
    private static final Logger log = LoggerFactory.getLogger(SmsOperator.class);

    public static List<SendSmsResult> sendSms(List<MtSms> smsList) throws Exception {
        if (null != smsList && smsList.size() > 0) {
            SendSmsRequest localRequest = new SendSmsRequest();
            localRequest.setVersion("1.0");
            localRequest.setMtSmsList(smsList);
            SendSmsResponse sendSmsResponse = null;
            try {
                sendSmsResponse = client.sendSms(ObjectConverterUtil.converteToRemoteSendSmsRequest(localRequest));
            }
            catch (Exception e) {
                try {
                    XdjaGwWbs s2 = new XdjaGwWbs(new URL("aURL"), SERVICE_NAME);
                    client = s2.getXdjaGwWbsHttpPort();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            if (null != sendSmsResponse) {
                try {
                    return ObjectConverterUtil.converToLocalSendSmsResponse(sendSmsResponse).getSendSmsResultList();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    public static List<SmsStatus> getSmsStatus(SmsStatusRequest localRequest) {
        try {
            GeSmsStatusResponse remoteResponse;
            if (localRequest != null && null != client && (remoteResponse = client.getSmsStatus(ObjectConverterUtil.converteToRemoteSmsStatusRequest(localRequest))) != null) {
                return ObjectConverterUtil.convereteToLocalSmsStatusList(((ArrayOfSmsStatus)remoteResponse.getSmsStatusList().getValue()).getSmsStatus());
            }
        }
        catch (ServiceException e) {
            try {
                XdjaGwWbs s2 = new XdjaGwWbs(new URL("aURL"), SERVICE_NAME);
                client = s2.getXdjaGwWbsHttpPort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            XdjaGwWbs ss = new XdjaGwWbs(new URL("aURL"), SERVICE_NAME);
            client = ss.getXdjaGwWbsHttpPort();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

