/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.control;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.healthcheck.bean.CheckResult;
import com.xdja.healthcheck.bean.ServerCheckInfo;
import com.xdja.healthcheck.handler.DBCheckHandler;
import com.xdja.healthcheck.handler.RedisCheckHandler;
import com.xdja.pams.common.util.Util;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/sys/health"})
@Controller
public class CheckController {
    private static final Logger log = LoggerFactory.getLogger(CheckController.class);

    @RequestMapping(value={"/check.do"}, method={RequestMethod.GET})
    public void check(String is_check, HttpServletResponse response) {
        if (log.isDebugEnabled()) {
            log.debug("\u68c0\u6d4b\u670d\u52a1\u5f00\u59cb......");
        }
        if (!"1".equals(is_check)) {
            ServerCheckInfo serverCheckInfo = new ServerCheckInfo();
            ArrayList<ServerCheckInfo.CheckDataBean> list = new ArrayList<ServerCheckInfo.CheckDataBean>();
            long startTime = System.currentTimeMillis();
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(System.getProperty("datasource.properties")));
                ServerCheckInfo.CheckDataBean dbCheckInfo = this.dbCheck(properties);
                list.add(dbCheckInfo);
                if ("1".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
                    ServerCheckInfo.CheckDataBean redisCheckInfo = this.redisCheck(properties);
                    list.add(redisCheckInfo);
                }
                serverCheckInfo.setFlag("1");
                serverCheckInfo.setMessage("success");
            }
            catch (Exception e) {
                log.error("\u68c0\u6d4b\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)e.getMessage(), (Object)e);
                serverCheckInfo.setFlag("2");
                serverCheckInfo.setMessage(e.getMessage());
            }
            long endTime = System.currentTimeMillis();
            serverCheckInfo.setSystem("pams");
            serverCheckInfo.setDuration(endTime - startTime);
            serverCheckInfo.setData(list);
            Util.writeUtf8JSON(response, Util.toJsonStr(serverCheckInfo));
        }
        if (log.isDebugEnabled()) {
            log.debug("\u68c0\u6d4b\u670d\u52a1\u7ed3\u675f......");
        }
    }

    private ServerCheckInfo.CheckDataBean dbCheck(Properties properties) {
        ServerCheckInfo.CheckDataBean dbCheckInfo = new ServerCheckInfo.CheckDataBean();
        String dbUrl = properties.getProperty("db.url");
        String dbUser = properties.getProperty("db.username");
        String dbPassword = properties.getProperty("db.password");
        CheckResult checkData = DBCheckHandler.connCheck((String)dbUrl, (String)dbUser, (String)dbPassword, (DBCheckHandler.DBType)DBCheckHandler.DBType.ORACLE);
        dbCheckInfo.setCheckTitle("pams\u6570\u636e\u5e93");
        dbCheckInfo.setCheckType("oracle");
        dbCheckInfo.setAddress(dbUrl);
        dbCheckInfo.setConfigName("datasource.properties");
        dbCheckInfo.setDuration(checkData.getDuration());
        if (checkData.getFlag().equals("1")) {
            dbCheckInfo.setCheckStatus(1);
        } else {
            dbCheckInfo.setErrorMsg(checkData.getMsg());
            dbCheckInfo.setCheckStatus(2);
            ArrayList<String> tips = new ArrayList<String>();
            switch (checkData.getState()) {
                case DBURL_ERROR: {
                    tips.add("1. \u8bf7\u6392\u67e5pams\u670d\u52a1\u4e2d" + System.getProperty("datasource.properties") + "\u914d\u7f6e\u6587\u4ef6\u4e2d\u6570\u636e\u5e93URL\u6b63\u786e\u6027");
                    break;
                }
                case TELNET_FAIL: {
                    tips.add("1. \u8bf7\u6392\u67e5pams\u670d\u52a1\u4e2d" + System.getProperty("datasource.properties") + "\u914d\u7f6e\u6587\u4ef6\u4e2dIP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e\u3002");
                    tips.add("2. \u6392\u67e5" + dbUrl + "\u673a\u5668oracle\u6570\u636e\u5e93\u662f\u5426\u6b63\u5e38\u8fd0\u884c\u3002");
                    tips.add("3. \u6392\u67e5pams\u5230oracle\u670d\u52a1\u7f51\u7edc\u662f\u5426\u53ef\u901a\u3002");
                    tips.add("4. \u6392\u67e5oracle\u6240\u5728\u670d\u52a1\u5668\u8be5\u7aef\u53e3\u662f\u5426\u5904\u4e8e\u9632\u706b\u5899\u62e6\u622a\u72b6\u6001\u3002");
                    break;
                }
                default: {
                    tips.add("1. \u8bf7\u6392\u67e5pams\u670d\u52a1\u4e2d" + System.getProperty("datasource.properties") + "\u914d\u7f6e\u6587\u4ef6\u4e2d\u7528\u6237\u540d\u3001\u5bc6\u7801\u662f\u5426\u6b63\u786e");
                    tips.add("2. \u6392\u67e5oracle\u6570\u636e\u5e93\u670d\u52a1\u5668\u662f\u5426\u5df2\u8fbe\u5230\u6700\u5927\u8fde\u63a5\u6570");
                }
            }
            dbCheckInfo.setTips(tips);
        }
        return dbCheckInfo;
    }

    private ServerCheckInfo.CheckDataBean redisCheck(Properties properties) {
        ServerCheckInfo.CheckDataBean redisCheckInfo = new ServerCheckInfo.CheckDataBean();
        String redisIp = properties.getProperty("redis.host");
        String redisPort = properties.getProperty("redis.port");
        String redisPass = properties.getProperty("redis.pass");
        CheckResult checkResult = StringUtils.isBlank((CharSequence)redisPass) ? RedisCheckHandler.connCheck((String)redisIp, (int)Integer.parseInt(redisPort)) : RedisCheckHandler.connCheck((String)redisIp, (int)Integer.parseInt(redisPort), (String)redisPass);
        BeanUtils.copyProperties((Object)checkResult, (Object)redisCheckInfo);
        redisCheckInfo.setConfigName("datasource.properties");
        if (checkResult.getFlag().equals("1")) {
            redisCheckInfo.setCheckStatus(1);
        } else {
            ArrayList<String> tips = new ArrayList<String>();
            redisCheckInfo.setErrorMsg(checkResult.getMsg());
            redisCheckInfo.setCheckStatus(2);
            switch (checkResult.getState()) {
                case IP_ERROR: {
                    tips.add("1. \u8fde\u63a5\u7684redis\u670d\u52a1IP\u6709\u8bef\uff0c\u8bf7\u4fee\u6539");
                    break;
                }
                case PORT_ERROR: {
                    tips.add("1. \u8fde\u63a5\u7684redis\u670d\u52a1Port\u6709\u8bef\uff0c\u8bf7\u4fee\u6539");
                    break;
                }
                case TELNET_FAIL: {
                    tips.add("1. \u6392\u67e5pams\u670d\u52a1\u4e2d" + System.getProperty("datasource.properties") + "\u914d\u7f6e\u6587\u4ef6\u4e2dIP\u548c\u7aef\u53e3\u662f\u5426\u6b63\u786e\u3002");
                    tips.add("2. \u6392\u67e5redis\u670d\u52a1\u662f\u5426\u6b63\u5e38\u8fd0\u884c\u3002");
                    tips.add("3. \u6392\u67e5pams\u7cfb\u7edf\u5230redis\u670d\u52a1\u7684\u7f51\u7edc\u662f\u5426\u53ef\u901a\u3002");
                    tips.add("4. \u6392\u67e5pams\u6240\u5728\u670d\u52a1\u5668\u8be5\u7aef\u53e3\u662f\u5426\u5904\u4e8e\u9632\u706b\u5899\u62e6\u622a\u72b6\u6001\u3002");
                    break;
                }
                default: {
                    tips.add("1. \u6392\u67e5redis\u914d\u7f6e\u6587\u4ef6\u4e2d\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002");
                    tips.add("2. \u6392\u67e5redis\u670d\u52a1\u662f\u5426\u5df2\u8fbe\u5230\u6700\u5927\u8fde\u63a5\u6570\u3002");
                }
            }
            redisCheckInfo.setTips(tips);
        }
        return redisCheckInfo;
    }
}

