/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.service.impl;

import com.xdja.pams.bims.bean.QueryGroupBean;
import com.xdja.pams.bims.bean.QueryGroupMemberSynBean;
import com.xdja.pams.bims.dao.PersonExtraDao;
import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.GroupMemberSyn;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.entity.PersonExtra;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.GroupManageService;
import com.xdja.pams.bims.service.GroupMemberSynManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.PinYin4j;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.scms.bean.DeviceBean;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.sso.bean.SynDepartment;
import com.xdja.pams.sso.bean.SynDepartmentV3;
import com.xdja.pams.sso.bean.SynDevice;
import com.xdja.pams.sso.bean.SynDeviceDblCert;
import com.xdja.pams.sso.bean.SynGroup;
import com.xdja.pams.sso.bean.SynGroupMemberSyn;
import com.xdja.pams.sso.bean.SynPerson;
import com.xdja.pams.sso.bean.SynPersonV2;
import com.xdja.pams.sso.bean.SynPersonV3;
import com.xdja.pams.sso.bean.SynPersonpwd;
import com.xdja.pams.sso.bean.SynQueryParam;
import com.xdja.pams.sso.bean.SynRst;
import com.xdja.pams.sso.service.BasicInfoSynchronizeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BasicInfoSynchronizeServiceImpl
implements BasicInfoSynchronizeService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private GroupManageService groupManageService;
    @Autowired
    private PersonExtraDao personExtraDao;
    @Autowired
    private GroupMemberSynManageService groupMemberSynManageService;
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    private static Logger log = LoggerFactory.getLogger(BasicInfoSynchronizeServiceImpl.class);

    @Override
    public SynRst basicInfoSyn(SynQueryParam synQueryParam, String type) {
        log.debug("\u540c\u6b65\u5165\u53e3:" + Util.toJsonStr(synQueryParam) + " type:" + type);
        SynRst<Object> synRst = new SynRst<Object>();
        if (synQueryParam == null) {
            log.error("\u540c\u6b65\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror"));
            return synRst;
        }
        String lastTime = synQueryParam.getLastTime();
        String endLastTime = synQueryParam.getEndLastTime();
        String pageNo = synQueryParam.getPageNo();
        String pageSize = synQueryParam.getPageSize();
        synRst.setTime(new Date().getTime());
        int i_pageNo = 0;
        int i_pageSize = 0;
        try {
            i_pageNo = Integer.parseInt(pageNo);
        }
        catch (NumberFormatException e) {
            log.error("\u540c\u6b65\u5931\u8d25\uff0c\u9875\u7801\u6709\u8bef\uff0c\u6700\u5c0f\u4e3a1", (Throwable)e);
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.pageno") + ":" + pageNo);
            return synRst;
        }
        if (i_pageNo < 1) {
            i_pageNo = 1;
        }
        try {
            i_pageSize = Integer.parseInt(pageSize);
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int i_configPageSize = 0;
        String configPageSize = this.systemConfigService.getValueByCode("syninfo_pagesize");
        try {
            i_configPageSize = Integer.parseInt(configPageSize);
        }
        catch (NumberFormatException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (i_pageSize > i_configPageSize) {
            i_pageSize = i_configPageSize;
        }
        if (i_pageSize < 1) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.pagesize"));
            log.error("\u540c\u6b65\u5931\u8d25\uff0c\u6bcf\u9875\u6570\u91cf\u914d\u7f6e\u6709\u8bef");
            return synRst;
        }
        Page page = new Page();
        page.setPage(i_pageNo);
        page.setRp(i_pageSize);
        long l_lastTime = 0L;
        long l_endLastTime = 0L;
        try {
            l_lastTime = Long.parseLong(lastTime);
        }
        catch (NumberFormatException e) {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.updatetime") + ":" + lastTime);
            log.error("\u540c\u6b65\u5931\u8d25\uff0c\u66f4\u65b0\u65f6\u95f4\u6233\u975e\u6570\u5b57\u683c\u5f0f\uff1a" + lastTime, (Throwable)e);
            return synRst;
        }
        if (StringUtils.isNotBlank((CharSequence)endLastTime)) {
            try {
                l_endLastTime = Long.parseLong(endLastTime);
            }
            catch (NumberFormatException e) {
                l_endLastTime = 0L;
            }
        }
        if ("0".equals(type)) {
            List<SynPerson> list = this.querySynPerson(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("00".equals(type)) {
            List<SynPersonpwd> list = this.querySynPersonpwd(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
        } else if ("1".equals(type)) {
            List<SynDepartment> list = this.querySynDep(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("12".equals(type)) {
            List<SynDepartment> list = this.querySynDepV2(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("13".equals(type)) {
            List<SynDepartmentV3> list = this.querySynDepV3(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("2".equals(type)) {
            List<SynDevice> list = this.querySynDevice(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("4".equals(type)) {
            List<SynDeviceDblCert> list = this.querySynDeviceDblCert(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("02".equals(type)) {
            List<SynPersonV2> list = this.querySynPersonV2(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("03".equals(type)) {
            List<SynPersonV3> list = this.querySynPersonV3(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getN_last_update_time());
            }
        } else if ("5".equals(type)) {
            List<SynGroup> list = this.queryGroup(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getLastUpdateTime());
            }
        } else if ("6".equals(type)) {
            List<SynGroupMemberSyn> list = this.queryGroupMemberSyn(synQueryParam, page);
            synRst.setList(list);
            synRst.setCount(page.getTotal());
            if (list != null && !list.isEmpty()) {
                synRst.setTime(list.get(list.size() - 1).getLastUpdateTime());
            }
        } else {
            synRst.setResult("1", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.paramerror.datatype"));
        }
        synRst.setResult("0", MessageManager.getProMessage(this.message, "syn.basicinfosynservice.success"));
        log.debug("\u540c\u6b65\u51fa\u53e3:" + Util.toJsonStr(synRst));
        return synRst;
    }

    private List<SynDepartment> querySynDepV2(SynQueryParam synQueryParam, Page page) {
        List<Department> list = this.depManageService.querySynDepList(synQueryParam, page);
        ArrayList<SynDepartment> synlist = new ArrayList<SynDepartment>();
        for (Department dep : list) {
            SynDepartment synDep = new SynDepartment();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synDep.setDisplay_flag(dep.getDisplayState());
            Department parentDep = dep.getParentDep();
            if (parentDep != null) {
                synDep.setParent_code(parentDep.getCode());
            }
            synlist.add(synDep);
        }
        return synlist;
    }

    private List<SynDepartmentV3> querySynDepV3(SynQueryParam synQueryParam, Page page) {
        List<Department> list = this.depManageService.querySynDepList(synQueryParam, page);
        ArrayList<SynDepartmentV3> synlist = new ArrayList<SynDepartmentV3>();
        for (Department dep : list) {
            SynDepartmentV3 synDep = new SynDepartmentV3();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synDep.setDisplay_flag(dep.getDisplayState());
            Department parentDep = dep.getParentDep();
            if (parentDep != null) {
                synDep.setParent_code(parentDep.getCode());
            }
            synDep.setTreeCode(dep.getTreeCode());
            synDep.setTreeId(dep.getTreeId());
            synlist.add(synDep);
        }
        return synlist;
    }

    private List<SynGroupMemberSyn> queryGroupMemberSyn(SynQueryParam synQueryParam, Page page) {
        QueryGroupMemberSynBean queryBean = new QueryGroupMemberSynBean();
        queryBean.setLastUpdateTime(synQueryParam.getLastTime());
        queryBean.setGroupId(synQueryParam.getGroupId());
        List<GroupMemberSyn> list = this.groupMemberSynManageService.queryList(queryBean, page);
        return this.setGroupMemberSynList(list);
    }

    private List<SynGroup> queryGroup(SynQueryParam synQueryParam, Page page) {
        QueryGroupBean queryGroupBean = new QueryGroupBean();
        queryGroupBean.setLastUpdateTime(synQueryParam.getLastTime());
        List<BimsGroup> list = this.groupManageService.queryGroup(queryGroupBean, page);
        List<SynGroup> result = this.setGroupList(list);
        return result;
    }

    private List<SynGroup> setGroupList(List<BimsGroup> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<SynGroup>();
        }
        ArrayList<SynGroup> result = new ArrayList<SynGroup>();
        SynGroup synGroup = null;
        for (BimsGroup bimsGroup : list) {
            synGroup = new SynGroup();
            synGroup.setDepId(bimsGroup.getDepId());
            synGroup.setId(bimsGroup.getId());
            synGroup.setFlag(bimsGroup.getFlag());
            synGroup.setName(bimsGroup.getName());
            synGroup.setNote(bimsGroup.getNote());
            synGroup.setOrderField(bimsGroup.getOrderField());
            synGroup.setType(bimsGroup.getType());
            synGroup.setLastUpdateTime(bimsGroup.getTimestamp());
            synGroup.setCreateDate(bimsGroup.getCreateDate().getTime());
            synGroup.setCreatorId(bimsGroup.getCreatorID());
            result.add(synGroup);
        }
        return result;
    }

    private List<SynGroupMemberSyn> setGroupMemberSynList(List<GroupMemberSyn> list) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<SynGroupMemberSyn>();
        }
        ArrayList<SynGroupMemberSyn> result = new ArrayList<SynGroupMemberSyn>();
        SynGroupMemberSyn synGroupMemberSyn = null;
        for (GroupMemberSyn groupMemberSyn : list) {
            synGroupMemberSyn = new SynGroupMemberSyn();
            BeanUtils.copyProperties((Object)groupMemberSyn, (Object)synGroupMemberSyn);
            synGroupMemberSyn.setLastUpdateTime(groupMemberSyn.getTimestamp());
            result.add(synGroupMemberSyn);
        }
        return result;
    }

    private List<SynPersonV2> querySynPersonV2(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonList(synQueryParam, page);
        return this.setPersonList(list);
    }

    private List<SynPersonV3> querySynPersonV3(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonList(synQueryParam, page);
        return this.setPersonListV3(list);
    }

    private List<SynPersonV2> setPersonList(List<Person> list) {
        ArrayList<SynPersonV2> synlist = new ArrayList<SynPersonV2>();
        for (Person person : list) {
            SynPersonV2 synPerson2 = new SynPersonV2();
            synPerson2.setId(person.getId());
            synPerson2.setName(person.getName());
            synPerson2.setMobile(person.getMobiledList());
            synPerson2.setComm_type(person.getCommType());
            synPerson2.setSmobile(person.getsMobile());
            synPerson2.setCode(person.getCode());
            synPerson2.setIdentifier(person.getIdentifier());
            synPerson2.setDep_code(person.getDepartment().getCode());
            synPerson2.setDep_id(person.getDepId());
            synPerson2.setGrade(person.getGrade());
            synPerson2.setPosition(person.getPosition());
            synPerson2.setSeq(Long.toString(person.getOrderField()));
            synPerson2.setNote(person.getNote());
            synPerson2.setN_last_update_time(Long.toString(person.getTimestamp()));
            synPerson2.setDelete_flag(person.getFlag());
            synPerson2.setSex(person.getSex());
            synPerson2.setPolice(person.getPolice());
            synPerson2.setOffice_phone(person.getOfficePhone());
            String nbs = null;
            try {
                nbs = person.getNameBriefSpell();
                if (StringUtils.isBlank((CharSequence)nbs)) {
                    nbs = PinYin4j.getNameSimplicityWithPolyphone(person.getName());
                }
            }
            catch (Exception e) {
                log.error(person.getId() + ":" + person.getName(), (Throwable)e);
                throw new RuntimeException(e);
            }
            synPerson2.setLeaderLevel(person.getLeaderLevel());
            synPerson2.setName_brief_spell(nbs);
            synPerson2.setPersonType(person.getPersonType());
            synPerson2.setJxFlag(person.getJxFlag());
            synPerson2.setDisplay_flag(person.getDisplayState());
            synPerson2.setPassword(person.getPassword());
            synlist.add(synPerson2);
        }
        return synlist;
    }

    private List<SynPersonV3> setPersonListV3(List<Person> list) {
        ArrayList<SynPersonV3> synlist = new ArrayList<SynPersonV3>();
        for (Person person : list) {
            SynPersonV3 synPersonV3 = new SynPersonV3();
            synPersonV3.setId(person.getId());
            synPersonV3.setName(person.getName());
            synPersonV3.setMobile(person.getMobiledList());
            synPersonV3.setComm_type(person.getCommType());
            synPersonV3.setSmobile(person.getsMobile());
            synPersonV3.setCode(person.getCode());
            synPersonV3.setIdentifier(person.getIdentifier());
            synPersonV3.setDep_code(person.getDepartment().getCode());
            synPersonV3.setDep_id(person.getDepId());
            synPersonV3.setGrade(person.getGrade());
            synPersonV3.setPosition(person.getPosition());
            synPersonV3.setSeq(Long.toString(person.getOrderField()));
            synPersonV3.setNote(person.getNote());
            synPersonV3.setN_last_update_time(Long.toString(person.getTimestamp()));
            synPersonV3.setDelete_flag(person.getFlag());
            synPersonV3.setSex(person.getSex());
            synPersonV3.setPolice(person.getPolice());
            synPersonV3.setOffice_phone(person.getOfficePhone());
            String nbs = null;
            try {
                nbs = person.getNameBriefSpell();
                if (StringUtils.isBlank((CharSequence)nbs)) {
                    nbs = PinYin4j.getNameSimplicityWithPolyphone(person.getName());
                }
            }
            catch (Exception e) {
                log.error(person.getId() + ":" + person.getName(), (Throwable)e);
                throw new RuntimeException(e);
            }
            synPersonV3.setLeaderLevel(person.getLeaderLevel());
            synPersonV3.setName_brief_spell(nbs);
            synPersonV3.setPersonType(person.getPersonType());
            synPersonV3.setJxFlag(person.getJxFlag());
            synPersonV3.setDisplay_flag(person.getDisplayState());
            synPersonV3.setPassword(person.getPassword());
            PersonExtra extra = this.personExtraDao.getPersonExtraByPersonId(person.getId());
            synPersonV3.setExtraColumns(extra == null ? "" : extra.getData());
            synlist.add(synPersonV3);
        }
        return synlist;
    }

    private List<SynPerson> querySynPerson(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonList(synQueryParam, page);
        return this.setPersongList(list);
    }

    private List<SynPerson> querySynPersonWithoutFujing(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonListWithoutFuJing(synQueryParam, page);
        return this.setPersongList(list);
    }

    private List<SynPerson> setPersongList(List<Person> list) {
        ArrayList<SynPerson> synlist = new ArrayList<SynPerson>();
        for (Person person : list) {
            SynPerson synPerson = new SynPerson();
            synPerson.setId(person.getId());
            synPerson.setName(person.getName());
            synPerson.setMobile(person.getMobiledList());
            synPerson.setComm_type(person.getCommType());
            synPerson.setSmobile(person.getsMobile());
            synPerson.setCode(person.getCode());
            synPerson.setIdentifier(person.getIdentifier());
            synPerson.setDep_code(person.getDepartment().getCode());
            synPerson.setDep_id(person.getDepId());
            synPerson.setGrade(person.getGrade());
            synPerson.setPosition(person.getPosition());
            synPerson.setSeq(Long.toString(person.getOrderField()));
            synPerson.setNote(person.getNote());
            synPerson.setN_last_update_time(Long.toString(person.getTimestamp()));
            synPerson.setDelete_flag(person.getFlag());
            synPerson.setSex(person.getSex());
            synPerson.setPolice(person.getPolice());
            synPerson.setOffice_phone(person.getOfficePhone());
            String nbs = null;
            try {
                nbs = person.getNameBriefSpell();
                if (StringUtils.isBlank((CharSequence)nbs)) {
                    nbs = PinYin4j.getNameSimplicityWithPolyphone(person.getName());
                }
            }
            catch (Exception e) {
                log.error(person.getId() + ":" + person.getName(), (Throwable)e);
                throw new RuntimeException(e);
            }
            synPerson.setName_brief_spell(nbs);
            synPerson.setPersonType(person.getPersonType());
            synPerson.setJxFlag(person.getJxFlag());
            synPerson.setDisplay_flag(person.getDisplayState());
            synlist.add(synPerson);
        }
        return synlist;
    }

    private List<SynPersonpwd> querySynPersonpwdWithoutFujing(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonListWithoutFuJing(synQueryParam, page);
        return this.setPersonpwdList(list);
    }

    private List<SynPersonpwd> querySynPersonpwd(SynQueryParam synQueryParam, Page page) {
        List<Person> list = this.userManageService.querySynPersonList(synQueryParam, page);
        return this.setPersonpwdList(list);
    }

    private List<SynPersonpwd> setPersonpwdList(List<Person> list) {
        ArrayList<SynPersonpwd> synlist = new ArrayList<SynPersonpwd>();
        for (Person person : list) {
            SynPersonpwd synPerson = new SynPersonpwd();
            synPerson.setId(person.getId());
            synPerson.setName(person.getName());
            synPerson.setMobile(person.getMobiledList());
            synPerson.setComm_type(person.getCommType());
            synPerson.setSmobile(person.getsMobile());
            synPerson.setCode(person.getCode());
            synPerson.setIdentifier(person.getIdentifier());
            synPerson.setDep_code(person.getDepartment().getCode());
            synPerson.setDep_id(person.getDepId());
            synPerson.setGrade(person.getGrade());
            synPerson.setPosition(person.getPosition());
            synPerson.setSeq(Long.toString(person.getOrderField()));
            synPerson.setNote(person.getNote());
            synPerson.setN_last_update_time(Long.toString(person.getTimestamp()));
            synPerson.setDelete_flag(person.getFlag());
            synPerson.setSex(person.getSex());
            synPerson.setPolice(person.getPolice());
            synPerson.setOffice_phone(person.getOfficePhone());
            String nbs = person.getNameBriefSpell();
            if (StringUtils.isBlank((CharSequence)nbs)) {
                nbs = PinYin4j.getNameSimplicityWithPolyphone(person.getName());
            }
            synPerson.setName_brief_spell(nbs);
            synPerson.setPersonType(person.getPersonType());
            synPerson.setPassword(person.getPassword());
            synPerson.setJxFlag(person.getJxFlag());
            synlist.add(synPerson);
        }
        return synlist;
    }

    public List<SynDepartment> querySynDep(SynQueryParam synQueryParam, Page page) {
        List<Department> list = this.depManageService.querySynDepList(synQueryParam, page);
        ArrayList<SynDepartment> synlist = new ArrayList<SynDepartment>();
        for (Department dep : list) {
            SynDepartment synDep = new SynDepartment();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synlist.add(synDep);
        }
        return synlist;
    }

    @Override
    public List<SynDepartment> querySynDep(long lastTime, String rootDepId, Page page) {
        List<Department> list = this.depManageService.querySynDepList(lastTime, rootDepId, page);
        ArrayList<SynDepartment> synlist = new ArrayList<SynDepartment>();
        for (Department dep : list) {
            SynDepartment synDep = new SynDepartment();
            synDep.setId(dep.getId());
            synDep.setName(dep.getName());
            synDep.setCode(dep.getCode());
            synDep.setContact(dep.getLinkman());
            synDep.setPhone(dep.getPhone());
            synDep.setGrage(dep.getLevel());
            synDep.setParent_id(dep.getParentID());
            synDep.setSeq(Long.toString(dep.getOrderField()));
            synDep.setDep_abb(dep.getNameAbbr());
            synDep.setNote(dep.getNote());
            synDep.setAmount(Integer.toString(dep.getCount()));
            synDep.setN_last_update_time(Long.toString(dep.getTimestamp()));
            synDep.setDelete_flag(dep.getFlag());
            synlist.add(synDep);
        }
        return synlist;
    }

    public List<SynDevice> querySynDevice(SynQueryParam synQueryParam, Page page) {
        List<Device> list = this.deviceService.querySynDeviceList(synQueryParam, page);
        ArrayList<SynDevice> synList = new ArrayList<SynDevice>();
        for (Device device : list) {
            SynDevice synDevice = new SynDevice();
            synDevice.setId(device.getId());
            synDevice.setCard_id(device.getIccid());
            synDevice.setName(device.getName());
            synDevice.setFlag(device.getFlag());
            synDevice.setState(device.getState());
            synDevice.setType(device.getType());
            synDevice.setImei(device.getImei());
            synDevice.setImsi(device.getImsi());
            synDevice.setLock_state(device.getLockState());
            synDevice.setExamine_date(device.getExamineDate());
            synDevice.setOpen_date(device.getOpenDate());
            synDevice.setPause_date(device.getPauseDate());
            synDevice.setRevocation_date(device.getRevocationDate());
            synDevice.setWrite_card_date(device.getWriteCardDate());
            synDevice.setSn(device.getSn());
            synDevice.setAlg_type(device.getAlgType());
            synDevice.setCertificate(device.getCertificate());
            if (null != device.getMobile()) {
                synDevice.setMobile(device.getMobile().getMobile());
            }
            synDevice.setPerson_id(device.getPersonId());
            synDevice.setN_last_update_time(device.getTimestamp());
            synDevice.setDelete_flag("1".equals(device.getRevokeFlag()) ? "1" : "0");
            synDevice.setUseType(device.getUseType());
            synList.add(synDevice);
        }
        return synList;
    }

    public List<SynDeviceDblCert> querySynDeviceDblCert(SynQueryParam synQueryParam, Page page) {
        List<DeviceBean> list = this.deviceService.querySynDeviceBeanList(synQueryParam, page);
        ArrayList<SynDeviceDblCert> synList = new ArrayList<SynDeviceDblCert>();
        for (DeviceBean device : list) {
            SynDeviceDblCert synDevice = new SynDeviceDblCert();
            synDevice.setId(device.getId());
            synDevice.setCard_id(device.getIccid());
            synDevice.setName(device.getName());
            synDevice.setFlag(device.getFlag());
            synDevice.setState(device.getState());
            synDevice.setType(device.getType());
            synDevice.setImei(device.getImei());
            synDevice.setImsi(device.getImsi());
            synDevice.setLock_state(device.getLockState());
            synDevice.setExamine_date(device.getExamineDate());
            synDevice.setOpen_date(device.getOpenDate());
            synDevice.setPause_date(device.getPauseDate());
            synDevice.setRevocation_date(device.getRevocationDate());
            synDevice.setWrite_card_date(device.getWriteCardDate());
            synDevice.setSn(device.getSn());
            synDevice.setAlg_type(device.getAlgType());
            synDevice.setCertificate(device.getCertificate());
            synDevice.setMobile(device.getMobileStr());
            synDevice.setPerson_id(device.getPersonId());
            synDevice.setN_last_update_time(device.getLastUpdateTime().longValue());
            synDevice.setDelete_flag("1".equals(device.getRevokeFlag()) ? "1" : "0");
            synDevice.setUseType(device.getUseType());
            synDevice.setSn2(device.getSn2());
            synDevice.setCertificate2(device.getCertificate2());
            synList.add(synDevice);
        }
        return synList;
    }

    public UserManageService getUserManageService() {
        return this.userManageService;
    }

    public void setUserManageService(UserManageService userManageService) {
        this.userManageService = userManageService;
    }

    public DepManageService getDepManageService() {
        return this.depManageService;
    }

    public void setDepManageService(DepManageService depManageService) {
        this.depManageService = depManageService;
    }

    public SystemConfigPbService getSystemConfigService() {
        return this.systemConfigService;
    }

    public void setSystemConfigService(SystemConfigPbService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
}

