/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sso.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Base64Encrypt;
import com.xdja.pams.common.util.EncryptDeciphering;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.service.LoginService;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.sso.bean.AppLimitQueryOut;
import com.xdja.pams.sso.bean.Bill;
import com.xdja.pams.sso.bean.LoginParam;
import com.xdja.pams.sso.bean.LoginRst;
import com.xdja.pams.sso.bean.Result;
import com.xdja.pams.sso.bean.UpdatePasswordParam;
import com.xdja.pams.sso.bean.UserInfo;
import com.xdja.pams.sso.dao.SingleSignOnDao;
import com.xdja.pams.sso.entity.UserBill;
import com.xdja.pams.sso.service.AppPlatformService;
import com.xdja.pams.sso.service.SingleSignOnService;
import com.xdja.pams.sso.util.CertUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SingleSignOnServiceImpl
implements SingleSignOnService {
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private AppPlatformService appPlatFormService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private SingleSignOnDao singleSignOnDao;
    @Autowired
    private ResourceBundleMessageSource message;
    private static Logger log = LoggerFactory.getLogger(SingleSignOnServiceImpl.class);

    @Override
    public String getLoginType() throws Exception {
        String loginType = this.systemConfigService.getValueByCode("sso_logintype");
        if (loginType == null) {
            throw new Exception(MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.logintype.geterror"));
        }
        return loginType;
    }

    @Override
    public LoginRst login(LoginParam loginParam) {
        Person person;
        long startTime = new Date().getTime();
        if (loginParam == null) {
            return new LoginRst("5", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.paramerror"));
        }
        String loginType = loginParam.getLoginType();
        String userName = loginParam.getUserName();
        String passWord = loginParam.getPassWord();
        String cardNo = loginParam.getCardNo();
        String imsi = loginParam.getImsi();
        String imei = loginParam.getImei();
        String thridId = loginParam.getThirdId();
        String personId = null;
        String systemLoginType = this.systemConfigService.getValueByCode("sso_logintype");
        if (loginType == null || systemLoginType.indexOf(loginType) < 0) {
            LoginRst loginRst = new LoginRst("5", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.logintype.logintypeerror"));
            loginRst.setLoginType(systemLoginType);
            return loginRst;
        }
        Device device = null;
        try {
            device = this.deviceService.getByCardNO(cardNo);
        }
        catch (Exception e1) {
            log.error("\u672a\u67e5\u8be2\u5230\u5b89\u5168\u5361\u4fe1\u606f", (Throwable)e1);
        }
        if ("1".equals(loginType)) {
            person = this.userManagerService.getUserByCode(userName);
            if (person == null || StringUtils.isBlank((CharSequence)passWord) || !Md5PwdEncoder.getInstance().encodePassword(passWord).equals(person.getPassword())) {
                return new LoginRst("2", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.userorpwerror"));
            }
            if (this.loginService.judgeIslock2(person)) {
                return new LoginRst("7", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.userlock"));
            }
            personId = person.getId();
        } else if ("0".equals(loginType)) {
            if (device != null && this.loginService.judgeIslock2(person = this.userManagerService.queryPersonById(device.getPersonId()))) {
                return new LoginRst("7", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.userlock"));
            }
        } else {
            return new LoginRst("5", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.logintype.logintypeerror"));
        }
        boolean isCheckDeivce = Boolean.parseBoolean(this.systemConfigService.getValueByCode("ifCheckDeivce"));
        if ((isCheckDeivce || "0".equals(loginType)) && device == null) {
            return new LoginRst("3", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.unfindecarderror"), personId);
        }
        if (!"1".equals(loginType)) {
            personId = device.getPersonId();
        }
        try {
            if (isCheckDeivce && !this.checkBindingState(personId, device, imei, imsi)) {
                return new LoginRst("4", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.bindcheckfail"), personId);
            }
        }
        catch (Exception e) {
            log.error("\u9a8c\u8bc1\u5b89\u5168\u5361\u7ed1\u5b9a\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return new LoginRst("4", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.login.bindcheckerror") + ":" + e.getMessage(), personId);
        }
        log.info("service\u767b\u5f55\u9a8c\u8bc1\u8017\u65f6\uff1a" + (new Date().getTime() - startTime));
        LoginRst loginRst = this.createBill(personId);
        log.info("service\u521b\u5efa\u7968\u636e\u8017\u65f6\uff1a" + (new Date().getTime() - startTime));
        if (StringUtils.isBlank((CharSequence)loginRst.getResult().getId())) {
            loginRst.getResult().setId(personId);
        }
        return loginRst;
    }

    public boolean checkBindingState(String personId, Device device, String imei, String imsi) throws Exception {
        if (!("3".equals(device.getState()) && "1".equals(device.getFlag()) && "0".equals(device.getLockState()))) {
            throw new Exception(MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.card.stateerror"));
        }
        String bindingState = device.getBindingState();
        if (StringUtils.isBlank((CharSequence)bindingState)) {
            bindingState = this.systemConfigService.getValueByCode("terminalbindtype");
            if (StringUtils.isBlank((CharSequence)bindingState)) {
                return true;
            }
            device.setBindingState(bindingState);
        }
        if ("0".equals(bindingState)) {
            return true;
        }
        if (bindingState.indexOf("1") >= 0 && !personId.equals(device.getPersonId())) {
            throw new Exception(MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.card.binderror"));
        }
        if (bindingState.indexOf("3") >= 0) {
            if (StringUtils.isBlank((CharSequence)imei)) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.isBlank"));
            }
            if (imei.length() > 32) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.tooLong"));
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                log.info("\u9996\u6b21\u4f7f\u7528\uff0c\u5199\u5165\u4fe1\u606f:" + imei);
                device.setImei(imei);
                this.deviceService.update(device);
                log.info("imei\u4fe1\u606f\u5199\u5165\u6210\u529f");
            } else if (!imei.equals(device.getImei())) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.notMatch"));
            }
        }
        if (bindingState.indexOf("2") >= 0) {
            if (StringUtils.isBlank((CharSequence)imsi)) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.isBlank"));
            }
            if ("000000000000000".equals(imsi)) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.test15Zero"));
            }
            if (imsi.length() > 32) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.tooLong"));
            }
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                log.info("\u9996\u6b21\u4f7f\u7528\uff0c\u5199\u5165\u4fe1\u606f:" + imsi);
                device.setImsi(imsi);
                this.deviceService.update(device);
                log.info("imsi\u4fe1\u606f\u5199\u5165\u6210\u529f");
            } else if (!imsi.equals(device.getImsi())) {
                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.notMatch"));
            }
        }
        return true;
    }

    @Override
    public LoginRst delayBill(String jsonBill) {
        Result result = this.checkBill(jsonBill);
        if (!"0".equals(result.getFlag())) {
            return new LoginRst("1", result.getMessage(), result.getId());
        }
        Bill bill = Util.readValue(jsonBill, Bill.class);
        LoginRst loginRst = this.createBill(bill.getUserInfo().getId());
        loginRst.getResult().setId(result.getId());
        return loginRst;
    }

    @Override
    public LoginRst createBill(String userId) {
        long startTime = new Date().getTime();
        LoginRst loginRst = new LoginRst();
        Person person = this.userManagerService.queryPersonById(userId);
        List<String> limits = null;
        try {
            limits = this.appPlatFormService.getLimit(userId);
        }
        catch (Exception e2) {
            log.error("\u83b7\u53d6\u7528\u6237\u6743\u9650\u5931\u8d25:" + e2.getMessage(), (Throwable)e2);
        }
        log.info("service\u83b7\u53d6\u7528\u6237\u6743\u9650\u8017\u65f6\uff1a" + (new Date().getTime() - startTime));
        startTime = new Date().getTime();
        String privateKeyGetType = this.systemConfigService.getValueByCode("sso_privatekey_gettype");
        log.debug("\u79c1\u94a5\u751f\u6210\u65b9\u5f0f\uff1a" + privateKeyGetType);
        String algorithm = this.systemConfigService.getValueByCode("sso_algorithm");
        log.debug("\u52a0\u5bc6\u7b97\u6cd5\uff1a" + algorithm);
        PrivateKey privateKey = null;
        if ("0".equals(privateKeyGetType)) {
            String passWord = this.systemConfigService.getValueByCode("sso_keystory_password");
            String alias = this.systemConfigService.getValueByCode("sso_cer_alias");
            String keyStoryPath = this.systemConfigService.getValueByCode("sso_keystory_filepath");
            try {
                privateKey = CertUtil.getPrivateKeyFromKeyKeyStory(keyStoryPath, passWord, alias);
            }
            catch (Exception e) {
                log.error("\u7edf\u4e00\u8ba4\u8bc1\u83b7\u53d6\u8bc1\u4e66\u79c1\u94a5\u5f02\u5e38", (Throwable)e);
                return new LoginRst("8", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.privatekey.createerror") + ":" + e.getMessage());
            }
        } else if ("1".equals(privateKeyGetType)) {
            String priKey = this.systemConfigService.getValueByCode("sso_privatekey_str");
            try {
                privateKey = CertUtil.getPrivateKey(priKey, algorithm);
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u7968\u636e\u5931\u8d25\uff0c\u83b7\u53d6\u8bc1\u4e66\u79c1\u94a5\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                return new LoginRst("8", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.privatekey.createerror") + ":" + e.getMessage());
            }
        } else {
            return new LoginRst("8", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.privatekey.configerror"));
        }
        String str_BillInDate = this.systemConfigService.getValueByCode("sso_bill_indate");
        loginRst.setEffectivetime(str_BillInDate);
        int i_BillInDate = 0;
        try {
            i_BillInDate = Integer.parseInt(str_BillInDate);
        }
        catch (NumberFormatException e1) {
            log.error("\u7968\u636e\u6709\u6548\u65f6\u957f\u8bbe\u7f6e\u6709\u8bef", (Throwable)e1);
            i_BillInDate = 120;
        }
        Date date = new Date();
        long l_BillIndat = date.getTime() + (long)(i_BillInDate * 60 * 1000);
        UserInfo userInfo = new UserInfo(person, Long.toString(l_BillIndat));
        if (limits != null) {
            userInfo.setLimits(limits.toArray(new String[0]));
        }
        String json_UserInfo = Util.toJsonStr(userInfo);
        String sign = null;
        try {
            sign = CertUtil.getSignature(json_UserInfo, privateKey, algorithm);
        }
        catch (NoSuchAlgorithmException e1) {
            log.error("\u751f\u6210\u7968\u636e\u7b7e\u540d\u5f02\u5e38\uff1a" + e1.getMessage(), (Throwable)e1);
            return new LoginRst("8", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.signatureerror") + ":" + e1.getMessage());
        }
        log.info("\u7968\u636e\u7b7e\u540d\uff1a" + sign);
        log.info("service\u7968\u636e\u7b7e\u540d\u8017\u65f6\uff1a" + (new Date().getTime() - startTime));
        startTime = new Date().getTime();
        Bill bill = new Bill(userInfo, sign);
        UserBill userBill = new UserBill();
        userBill.setBill(Util.toJsonStr(bill));
        userBill.setSign(sign);
        userBill.setEffectivedate(userInfo.getEffectivedate());
        try {
            this.singleSignOnDao.save(userBill);
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u7968\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return new LoginRst("8", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.savebillerror"));
        }
        log.info("service\u4fdd\u5b58\u7968\u636e\u8017\u65f6\uff1a" + (new Date().getTime() - startTime));
        startTime = new Date().getTime();
        String billStr = Util.toJsonStr(bill);
        String billCiphertext = EncryptDeciphering.getInstance().encrypt(billStr);
        loginRst.setBillStr(billCiphertext);
        loginRst.setResult("0", MessageManager.getProMessage(this.message, "sso.signlesignonservice.checksuccess"));
        log.info("service\u7ec4\u88c5\u7968\u636e\u8017\u65f6\uff1a" + (new Date().getTime() - startTime));
        return loginRst;
    }

    @Override
    public Result checkBill(String jsonBill) {
        Date now;
        Bill bill = Util.readValue(jsonBill, Bill.class);
        String person_id = null;
        if (bill == null) {
            return new Result("4", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.receivebillerror"), person_id);
        }
        if (bill.getUserInfo() != null) {
            person_id = bill.getUserInfo().getId();
        }
        String billSign = bill.getSign();
        String str_BillInDate = bill.getUserInfo().getEffectivedate();
        long l_BillInDate = Long.parseLong(str_BillInDate);
        if (l_BillInDate < (now = new Date()).getTime()) {
            return new Result("1", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.billoutdateerror"), person_id);
        }
        UserBill userBill = this.singleSignOnDao.getBySign(billSign);
        if (userBill == null) {
            log.error("\u7968\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a\u7968\u636e\u4e0d\u5c5e\u4e8e\u8be5\u5e73\u53f0\u53d1\u653e");
            return new Result("3", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.unbillerror"), person_id);
        }
        String algorithm = this.systemConfigService.getValueByCode("sso_algorithm");
        String certFilePath = this.systemConfigService.getValueByCode("sso_cer_filepath");
        PublicKey publicKey = null;
        try {
            X509Certificate cert = CertUtil.getCertFromStandFile(new File(certFilePath));
            publicKey = cert.getPublicKey();
        }
        catch (Exception e1) {
            log.error("\u751f\u6210\u516c\u94a5\u5931\u8d25\uff1a" + e1.getMessage(), (Throwable)e1);
            return new Result("4", MessageManager.getProMessage(this.message, "sso.signlesignonservice.error.publickey.createerror"), person_id);
        }
        try {
            byte[] billSignDigest = CertUtil.publicKeyDecrypt(new Base64Encrypt().decode(billSign), publicKey, algorithm);
            String json_UserInfo = Util.toJsonStr(bill.getUserInfo());
            log.info("\u7968\u636e\u4e2d\u7528\u6237\u4fe1\u606f\u7684json\u4e32\uff1a" + json_UserInfo);
            byte[] userInfoDigest = CertUtil.getDigest(json_UserInfo, "SHA");
            if (new Base64Encrypt().encodeStr(billSignDigest).equals(new Base64Encrypt().encodeStr(userInfoDigest))) {
                return new Result("0", MessageManager.getProMessage(this.message, "sso.signlesignonservice.checksuccess"), person_id);
            }
            return new Result("2", MessageManager.getProMessage(this.message, "sso.signlesignonservice.checkerror"), person_id);
        }
        catch (Exception e) {
            log.error("\u7968\u636e\u9a8c\u8bc1\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return new Result("4", e.getMessage(), person_id);
        }
    }

    @Override
    public Result updatePassword(UpdatePasswordParam param) {
        String code = param.getCode();
        String oldPassword = param.getOldPassword();
        String newPassword = param.getNewPassword();
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)oldPassword) || StringUtils.isBlank((CharSequence)newPassword)) {
            return new Result("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + MessageManager.getProMessage(this.message, "sso.updatepassword.error.paramerror"));
        }
        if (newPassword.length() < 6) {
            return new Result("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + MessageManager.getProMessage(this.message, "sso.updatepassword.error.newpwdlengtherror"));
        }
        try {
            Person person = this.userManagerService.getUserByCode(code);
            if (null == person) {
                return new Result("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + MessageManager.getProMessage(this.message, "sso.updatepassword.error.notfindperson"));
            }
            if (!person.getPassword().equals(Md5PwdEncoder.getInstance().encodePassword(oldPassword))) {
                return new Result("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + MessageManager.getProMessage(this.message, "sso.updatepassword.error.passwordwrong"));
            }
            person.setPassword(Md5PwdEncoder.getInstance().encodePassword(newPassword));
            this.userManagerService.updateUser(person);
        }
        catch (Exception e) {
            log.error("\u5bc6\u7801\u4fee\u6539\u5931\u8d25", (Throwable)e);
            return new Result("1", MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
        }
        return new Result("0", MessageManager.getProMessage(this.message, "common.message.operate.success"));
    }

    @Override
    public UserInfo getUserInfoFromBillJson(String jsonBill) {
        Bill bill = Util.readValue(jsonBill, Bill.class);
        UserInfo userinfo = bill.getUserInfo();
        return userinfo;
    }

    public SystemConfigPbService getSystemConfigService() {
        return this.systemConfigService;
    }

    public void setSystemConfigService(SystemConfigPbService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }

    public UserManageService getUserManagerService() {
        return this.userManagerService;
    }

    public void setUserManagerService(UserManageService userManagerService) {
        this.userManagerService = userManagerService;
    }

    public DeviceService getDeviceService() {
        return this.deviceService;
    }

    public void setDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    public AppPlatformService getAppPlatFormService() {
        return this.appPlatFormService;
    }

    public void setAppPlatFormService(AppPlatformService appPlatFormService) {
        this.appPlatFormService = appPlatFormService;
    }

    public SingleSignOnDao getSingleSignOnDao() {
        return this.singleSignOnDao;
    }

    public void setSingleSignOnDao(SingleSignOnDao singleSignOnDao) {
        this.singleSignOnDao = singleSignOnDao;
    }

    public ResourceBundleMessageSource getMessage() {
        return this.message;
    }

    public void setMessage(ResourceBundleMessageSource message) {
        this.message = message;
    }

    public static void main(String[] args) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId("123123123");
        userInfo.setCode("code");
        userInfo.setName("name");
        userInfo.setSex("sex");
        userInfo.setDepcode("depcode");
        userInfo.setDepid("depId");
        userInfo.setMobile("");
        userInfo.setPolice("police");
        userInfo.setPosition("position");
        userInfo.setEffectivedate("effectivedate");
        String str_UserInfo = Util.toJsonStr(userInfo);
        System.out.println(str_UserInfo);
        String param = "{\"userInfo\":{\"id\":\"40208df84448f8820144493b55810054\",\"code\":\"222222\",\"name\":\"\u674e\u56db\",\"sex\":\"1\",\"depcode\":null,\"depid\":\"0\",\"identifier\":\"410105198107134414\",\"mobile\":[\"18603869911\"],\"police\":\"11\",\"position\":\"11\",\"effectivedate\":\"1395736563031\"},\"sign\":\"aV66Iexu1P0vMb9I2gnqMwBAhHznN1J8UxiLSJcDBvN93nN4w2mlgtareOHKsl5RwIzj1HAVmlCPyxLb+ajiaBoVgVpNFIBvu4cXp3sRN7NJiBvcpF3dQ1bwJN6Cql3+d9IcgDowWxxN9WkdJHtSY5C93pE7c3U1vZY6FqjFjQs=\"}";
        Bill bill = Util.readValue(param, Bill.class);
        System.out.println(bill);
        param = "[\"aaaa\",\"bbbb\",\"cccc\"]";
        List list = Util.readValue(param, ArrayList.class);
        System.out.println(list);
        String str = "{\"error\":{\"code\":0,\"message\":\"\u7528\u6237\u672a\u767b\u5f55\u3002\"},\"jsonrpc\":\"2.0\",\"id\":\"1\"}";
        AppLimitQueryOut limit = Util.readValue(str, AppLimitQueryOut.class);
        System.out.println(limit);
    }
}

