/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.service.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.strategy.bean.StrategyMainBean;
import com.xdja.pams.strategy.dao.StrategyInfoDao;
import com.xdja.pams.strategy.dao.StrategyMainDao;
import com.xdja.pams.strategy.entity.StrategyMain;
import com.xdja.pams.strategy.service.StrategyMainService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class StrategyMainServiceImpl
implements StrategyMainService {
    @Autowired
    private StrategyMainDao strategyMainDao;
    @Autowired
    private StrategyInfoDao strategyInfoDao;
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<StrategyMain> queryList(StrategyMainBean bean, Page page) {
        List<StrategyMain> list = this.strategyMainDao.queryList(bean, page);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<StrategyMain>();
        }
        return list;
    }

    @Override
    @Transactional
    public void add(StrategyMainBean queryBean) {
        if (!StringUtils.hasText((String)queryBean.getName())) {
            throw new RuntimeException("\u7b56\u7565\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        Long currentTime = System.currentTimeMillis();
        StrategyMain strategyMain = new StrategyMain();
        strategyMain.setCreateTime(currentTime);
        strategyMain.setLastUpdateTime(currentTime);
        strategyMain.setType(queryBean.getType());
        strategyMain.setState(queryBean.getState());
        strategyMain.setName(queryBean.getName());
        this.baseDao.create(strategyMain);
    }

    @Override
    @Transactional
    public void remove(String id) {
        StrategyMain main = (StrategyMain)this.baseDao.getObjectById(StrategyMain.class, (Serializable)((Object)id));
        if (main == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        this.baseDao.delete(main);
        this.strategyInfoDao.deleteBatch(id);
    }

    @Override
    @Transactional
    public void changeState(StrategyMainBean queryBean) {
        StrategyMain main = (StrategyMain)this.baseDao.getObjectById(StrategyMain.class, (Serializable)((Object)queryBean.getId()));
        if (main == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        main.setState(queryBean.getState());
        this.baseDao.update(main);
    }

    @Override
    public StrategyMain queryById(String id) {
        StrategyMain main = (StrategyMain)this.baseDao.getObjectById(StrategyMain.class, (Serializable)((Object)id));
        if (main == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        return main;
    }

    @Override
    @Transactional
    public void update(StrategyMainBean queryBean) {
        StrategyMain main = (StrategyMain)this.baseDao.getObjectById(StrategyMain.class, (Serializable)((Object)queryBean.getId()));
        if (main == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        main.setName(queryBean.getName());
        main.setLastUpdateTime(System.currentTimeMillis());
        this.baseDao.update(main);
    }
}

