/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.dao.CommonCodeDao;
import com.xdja.pams.syms.entity.CommonCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CommonCodeDaoImpl
implements CommonCodeDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public CommonCode save(CommonCode commonCode) {
        this.baseDao.create(commonCode);
        return commonCode;
    }

    @Override
    public void update(CommonCode commonCode) {
        this.baseDao.update(commonCode);
    }

    @Override
    public void delete(CommonCode commonCode) {
        this.baseDao.delete(commonCode);
    }

    @Override
    public CommonCode get(Serializable id) {
        return (CommonCode)this.baseDao.getObjectById(CommonCode.class, id);
    }

    @Override
    public CommonCode getByTypeAndCode(String type, String code) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String select = "select b from CommonCode a,CommonCode b where  a.code=? and b.code=? and a.id=b.pCode.id and a.status =1 and b.status =1";
            Object[] values = new String[]{type, code};
            return (CommonCode)this.baseDao.getObjectByHQLAsCache(select, values);
        }
        String select = "from CommonCode where type is null and code=? and status =1";
        Object[] values = new String[]{code};
        return (CommonCode)this.baseDao.getObjectByHQLAsCache(select, values);
    }

    @Override
    public CommonCode getByCodeUnderType(String code, String pcode, String type) {
        String hql = "select a from CommonCode a, CommonCode b, CommonCode c where a.code = ? and b.code = ? and c.code = ? and a.pCode.id = b.id and b.pCode.id = c.id and a.status = 1 and b.status = 1 and c.status = 1";
        return (CommonCode)this.baseDao.getObjectByHQLAsCache(hql, new Object[]{code, pcode, type});
    }

    @Override
    public CommonCode getByTypeAndName(String type, String name) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            String select = "select b from CommonCode a,CommonCode b where a.code=? and  b.name=? and a.id=b.pCode.id and a.status =1 and b.status =1";
            Object[] values = new String[]{type, name};
            return (CommonCode)this.baseDao.getObjectByHQLAsCache(select, values);
        }
        String select = "from CommonCode where type is null and name=? and status =1";
        Object[] values = new String[]{name};
        return (CommonCode)this.baseDao.getObjectByHQLAsCache(select, values);
    }

    @Override
    public List<CommonCode> queryByType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return this.baseDao.getListByHQLAsCache("from CommonCode where type is null and status =1 order by orderField", null);
        }
        return this.baseDao.getListByHQLAsCache("select b from CommonCode a,CommonCode b where a.code=? and a.status =1 and b.status=1 and a.id=b.pCode.id order by b.orderField", new String[]{type});
    }

    @Override
    public List<CommonCode> queryByTypeId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.baseDao.getListByHQLAsCache("from CommonCode where type is  null and status =1 order by orderField", null);
        }
        return this.baseDao.getListByHQLAsCache("from CommonCode where type=? and status =1  order by orderField", new String[]{id});
    }

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void deleteByType(String type) {
        this.baseDao.updateBySql("delete t_commoncode where type=?", new String[]{type});
    }

    @Override
    public List<CommonCode> queryByName(CommonCode commonCode, Page page) {
        StringBuilder selectb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        selectb.append("from t_commoncode a where 1=1 and type is null and status =1 ");
        if (StringUtils.isNotBlank((CharSequence)commonCode.getName())) {
            selectb.append(" and  a.name like ? ");
            list.add("%" + StringUtils.trim((String)commonCode.getName()) + "%");
        }
        String selectCount = "select count(*) " + selectb.toString();
        String select = "select  a.* " + selectb.toString() + " ";
        return this.baseDao.getListBySQL(selectCount, select, list.toArray(), page, CommonCode.class);
    }

    @Override
    public void updDictStatus(CommonCode code) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("update t_commoncode a set a.STATUS=? WHERE A.ID IN (SELECT T.ID  FROM T_COMMONCODE T where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)code.getStatus())) {
            list.add(code.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)code.getId())) {
            sb.append("  START WITH T.ID = ? CONNECT BY PRIOR T.ID = T.TYPE");
            list.add(code.getId());
        }
        sb.append(" )");
        Object[] values = list.toArray(new String[0]);
        this.baseDao.updateBySql(sb.toString(), values);
    }

    @Override
    public boolean queryExistDisableParentType(CommonCode code) throws Exception {
        List<?> listCode = null;
        String selSql = "SELECT t.*  FROM T_COMMONCODE t where t.id <> ? start with t.id = ? connect by t.id = prior t.type and t.status = 0";
        listCode = this.baseDao.getListBySQL(selSql.toString(), new String[]{code.getId(), code.getId()}, CommonCode.class);
        return listCode != null && listCode.size() > 0;
    }

    @Override
    public List<CommonCode> queryByNameDictManage(CommonCode commonCode, Page page) {
        StringBuilder selectb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        selectb.append("from t_commoncode a where 1=1 and type is null ");
        if (StringUtils.isNotBlank((CharSequence)commonCode.getName())) {
            selectb.append(" and  a.name like ? ");
            list.add("%" + StringUtils.trim((String)commonCode.getName()) + "%");
        }
        String selectCount = "select count(*) " + selectb.toString();
        String select = "select  a.* " + selectb.toString() + " ";
        return this.baseDao.getListBySQL(selectCount, select, list.toArray(), page, CommonCode.class);
    }

    @Override
    public List<CommonCode> queryByTypeIdDictManage(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return this.baseDao.getListByHQLAsCache("from CommonCode where type is  null  order by orderField", null);
        }
        return this.baseDao.getListByHQLAsCache("from CommonCode where type=?  order by orderField", new String[]{id});
    }

    @Override
    public boolean queryExistDisableParentTypeBatch(String ids) {
        List<?> listCode = null;
        String selSql = "SELECT t.*  FROM T_COMMONCODE t where t.status = 0 start with t.id in( ? ) connect by t.id = prior t.type ";
        listCode = this.baseDao.getListBySQL(selSql.toString(), new String[]{ids}, CommonCode.class);
        return listCode != null && listCode.size() > 0;
    }

    @Override
    public void updDictStatusBatch(String ids, String status) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer sb = new StringBuffer("update t_commoncode a set a.STATUS=? WHERE A.ID IN (SELECT T.ID  FROM T_COMMONCODE T where 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)status)) {
            list.add(status);
        }
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            sb.append("  START WITH T.ID in( ? )CONNECT BY PRIOR T.ID = T.TYPE");
            list.add(ids);
        }
        sb.append(" )");
        Object[] values = list.toArray(new String[0]);
        this.baseDao.updateBySql(sb.toString(), values);
    }

    @Override
    public List<?> getListBySqlDynamic(String selectCount, String select, String[] values, Page page, List listKeys, String className) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)className)) {
            return this.baseDao.getListBySQL(selectCount, select, values, page, Class.forName(className), listKeys);
        }
        return this.baseDao.getListBySQL(selectCount, select, values, page, null, listKeys);
    }

    @Override
    public CommonCode getByPCodeAndCIDInScopeCode(String pcode, String cid, String scope) {
        String hql = "select b from CommonCode a, CommonCode b where a.id = b.pCode.id and a.code = ? and b.id = ? and a.code in (select bb.code from  CommonCode aa, CommonCode bb where aa.code = ? and aa.id = bb.pCode.id)";
        Object objectByHQL = this.baseDao.getObjectByHQL(hql, new Object[]{pcode, cid, scope});
        return (CommonCode)objectByHQL;
    }
}

