/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.bean.QueryForm;
import com.xdja.pams.syms.dao.CardRegisterDao;
import com.xdja.pams.syms.entity.CardRegister;
import com.xdja.pams.syms.service.CardRegisterService;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CardRegisterServiceImpl
implements CardRegisterService {
    @Autowired
    private CardRegisterDao cardRegisterDao;

    @Override
    public List<CardRegister> query(QueryForm form, Page page) throws Exception {
        return this.cardRegisterDao.queryPage(form, page);
    }

    @Override
    public boolean checkCardNumber(String cardNumber, Serializable id) {
        cardNumber = cardNumber.toLowerCase();
        CardRegister cardRegister = this.cardRegisterDao.getByCardNumber(cardNumber);
        if (id == null || StringUtils.isBlank((CharSequence)((String)((Object)id)))) {
            return cardRegister != null;
        }
        return cardRegister != null && !cardRegister.getId().equals((String)((Object)id));
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public CardRegister save(CardRegister cardRegister) {
        cardRegister.setCardNumber(cardRegister.getCardNumber().toLowerCase());
        return this.cardRegisterDao.save(cardRegister);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(CardRegister cardRegister) throws BatchUpdateException {
        cardRegister.setCardNumber(cardRegister.getCardNumber().toLowerCase());
        this.cardRegisterDao.update(cardRegister);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(Serializable id) {
        CardRegister cardRegister = this.get(id);
        if (cardRegister == null) {
            // empty if block
        }
        this.cardRegisterDao.delete(cardRegister);
    }

    @Override
    public CardRegister get(Serializable id) {
        return this.cardRegisterDao.get(id);
    }

    public CardRegisterDao getCardRegisterDao() {
        return this.cardRegisterDao;
    }

    public void setCardRegisterDao(CardRegisterDao cardRegisterDao) {
        this.cardRegisterDao = cardRegisterDao;
    }
}

