/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.service.impl;

import com.xdja.pams.scms.bean.DInfo;
import com.xdja.pams.scms.bean.DInfoCA;
import com.xdja.pams.scms.bean.TRInfo;
import com.xdja.pams.scms.dao.DeviceDao;
import com.xdja.pams.scms.util.Strings;
import com.xdja.pams.syms.dao.SystemConfigDao;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.syms.service.SystemConfigService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SystemConfigServiceImpl
implements SystemConfigService,
SystemConfigPbService {
    private static final Logger log = LoggerFactory.getLogger(SystemConfigServiceImpl.class);
    @Autowired
    private SystemConfigDao systemConfigDao;
    @Autowired
    private DeviceDao deviceDao;
    private static final String NOTDIVERSION = "0";
    private static final String DIVERSION = "1";
    private static final String _LT = "_LT";
    private static final String _DX = "_DX";
    private static final String _FJ = "_FJ";
    private static final String _THIRD = "_THIRD";

    @Override
    public List<SystemConfig> getByType(String type) {
        return this.systemConfigDao.getByType(type);
    }

    @Override
    public String getValueByCode(String code) {
        SystemConfig sys = this.systemConfigDao.getByCode(code);
        if (sys != null) {
            return sys.getValue();
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(SystemConfig systemConfig) {
        if (systemConfig != null) {
            String[] types;
            if ("terminalbindtype".equals(systemConfig.getCode())) {
                this.deviceDao.updateBindStateAll(systemConfig.getValue());
            }
            if ("addPersonDevice".equals(systemConfig.getCode()) && StringUtils.isNotBlank((CharSequence)systemConfig.getValue()) && (types = systemConfig.getValue().split(",")).length > 1) {
                SystemConfig onePersonCards = this.getByCode("cardcount");
                onePersonCards.setValue("many");
                this.systemConfigDao.update(onePersonCards);
            }
            if ("cardcount".equals(systemConfig.getCode())) {
                SystemConfig addPersonDeviceTypes = this.getByCode("addPersonDevice");
                String[] types2 = null;
                String typeStr = addPersonDeviceTypes.getValue();
                if (null != typeStr) {
                    types2 = typeStr.split(",");
                }
                if (types2 != null && types2.length > 1 && "one".equals(systemConfig.getValue())) {
                    throw new RuntimeException("\u6dfb\u52a0\u4eba\u5458\u9ed8\u8ba4\u6dfb\u52a0\u5b89\u5168\u5361\u914d\u7f6e\u4e3a\u591a\u5361\uff0c\u53d1\u5361\u6570\u91cf\u53ea\u80fd\u914d\u7f6e\u4e3a\u4e00\u4eba\u591a\u5361");
                }
            }
        }
        this.systemConfigDao.update(systemConfig);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(String id, String value) {
        SystemConfig systemConfig = this.systemConfigDao.getById(id);
        if (systemConfig != null) {
            systemConfig.setValue(value);
            this.update(systemConfig);
        }
    }

    @Override
    @Transactional
    public void updateBatch(List<SystemConfig> systemConfigs) {
        for (SystemConfig systemConfig : systemConfigs) {
            this.update(systemConfig.getId(), systemConfig.getValue());
        }
    }

    @Override
    public void updateLogo() {
    }

    public SystemConfigDao getSystemConfigDao() {
        return this.systemConfigDao;
    }

    public void setSystemConfigDao(SystemConfigDao systemConfigDao) {
        this.systemConfigDao = systemConfigDao;
    }

    @Override
    public void save(SystemConfig systemConfig) {
        this.systemConfigDao.save(systemConfig);
    }

    @Override
    public DInfo getDInfo() {
        DInfo dInfo = new DInfo(this.getValueByCode("D_URL"), "", this.getValueByCode("D_devCardNo"), this.getValueByCode("D_devPassword"), this.getValueByCode("D_gateCardNo"), this.getValueByCode("D_algType"), this.getValueByCode("D_isSM2"), "new", this.getValueByCode("D_isImsi"), this.getValueByCode("D_getGWCertSwitch"), this.getValueByCode("d_isWritePersonInfo"));
        String ctnId = this.getValueByCode("D_container_id");
        try {
            dInfo.setContainerid(Strings.isEmpty(ctnId) ? 0 : Integer.parseInt(ctnId));
        }
        catch (Exception e) {
            dInfo.setContainerid(0);
        }
        return dInfo;
    }

    @Override
    public TRInfo getTRInfo() {
        TRInfo trInfo = new TRInfo();
        trInfo.setUrl(this.getValueByCode("tr_tURL"));
        trInfo.setTrSwitch(this.getValueByCode("tr_switch"));
        trInfo.setMmcode(this.getValueByCode("tr_mmpcode"));
        trInfo.setCardName(this.getValueByCode("tr_cardName"));
        trInfo.setCardVersion(this.getValueByCode("tr_cardVersion"));
        return trInfo;
    }

    @Override
    public SystemConfig getByCode(String code) {
        return this.systemConfigDao.getByCode(code);
    }

    @Override
    public SystemConfig getById(String id) {
        return this.systemConfigDao.getById(id);
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    @Override
    public DInfo getDInfoByYYS(String yys, String personType) {
        String yysType = this.getyysType(yys, personType);
        DInfo dInfo = new DInfo(this.getValueByCode("D_URL" + yysType), "", this.getValueByCode("D_devCardNo" + yysType), this.getValueByCode("D_devPassword" + yysType), this.getValueByCode("D_gateCardNo" + yysType), this.getValueByCode("D_algType" + yysType), this.getValueByCode("D_isSM2" + yysType), "new", this.getValueByCode("D_isImsi" + yysType), this.getValueByCode("D_getGWCertSwitch" + yysType), this.getValueByCode("d_isWritePersonInfo" + yysType));
        dInfo.setUseThirdCert(this.getValueByCode("d_useThirdCert" + yysType));
        dInfo.setIsEmpowerKey(this.getValueByCode("d_isEmpowerKey" + yysType));
        dInfo.setProTag(this.getValueByCode("pro_tag"));
        String ctnId = this.getValueByCode("D_container_id" + yysType);
        try {
            dInfo.setContainerid(Strings.isEmpty(ctnId) ? 0 : Integer.parseInt(ctnId));
        }
        catch (Exception e) {
            dInfo.setContainerid(0);
        }
        return dInfo;
    }

    @Override
    public DInfoCA getDInfoCAByYYS(String yys, String personType) {
        String yysType = this.getyysType(yys, personType);
        DInfoCA dInfoCA = new DInfoCA(this.getValueByCode("D_URL" + yysType), "", this.getValueByCode("D_devCardNo" + yysType), this.getValueByCode("D_devPassword" + yysType), this.getValueByCode("D_gateCardNo" + yysType), this.getValueByCode("D_algType" + yysType), this.getValueByCode("D_isSM2" + yysType), "new", this.getValueByCode("D_isImsi" + yysType), this.getValueByCode("D_getGWCertSwitch" + yysType), this.getValueByCode("d_isWritePersonInfo" + yysType), this.getValueByCode("D_isUseSimple_CA") + yysType);
        dInfoCA.setUseThirdCert(this.getValueByCode("d_useThirdCert" + yysType));
        dInfoCA.setIsEmpowerKey(this.getValueByCode("d_isEmpowerKey" + yysType));
        dInfoCA.setIsNeedVerify(this.getValueByCode("D_isNeedVeryfi_cert" + yysType));
        String days = this.getValueByCode("D_validityBeforeLimitDays" + yysType);
        dInfoCA.setValidityBeforeLimitDays(Strings.isEmpty(days) ? -1 : Integer.parseInt(days));
        dInfoCA.setProTag(this.getValueByCode("pro_tag"));
        String ctnId = this.getValueByCode("D_container_id" + yysType);
        try {
            dInfoCA.setContainerid(Strings.isEmpty(ctnId) ? 0 : Integer.parseInt(ctnId));
        }
        catch (Exception e) {
            dInfoCA.setContainerid(0);
        }
        return dInfoCA;
    }

    protected String getyysType(String yys, String personType) {
        String yysType = "";
        if ("2".equals(yys)) {
            yysType = _LT;
        }
        if ("3".equals(yys)) {
            yysType = _DX;
        }
        if ("2".equals(personType)) {
            yysType = yysType + _FJ;
        }
        return yysType;
    }

    @Override
    public DInfo getDInfoThird() {
        DInfo dInfo = new DInfo(this.getValueByCode("D_URL_THIRD"), this.getValueByCode("D_devCardNo_THIRD"), this.getValueByCode("D_devPassword_THIRD"));
        return dInfo;
    }

    @Override
    @Transactional
    public Map<String, String> updateDInfoConfig(List<SystemConfig> list, String isDiversionCom, String isDiversionPersonType) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (list != null && list.size() > 0) {
            for (SystemConfig systemConfig : list) {
                SystemConfig o_fj;
                if (StringUtils.isBlank((CharSequence)systemConfig.getCode()) || StringUtils.isBlank((CharSequence)systemConfig.getName()) || StringUtils.isBlank((CharSequence)systemConfig.getId())) {
                    throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
                }
                SystemConfig oldConfig = this.getById(systemConfig.getId());
                this.setNewValue(oldConfig, systemConfig);
                String sufix = this.getSufix(oldConfig.getCode());
                if (_THIRD.equals(sufix)) {
                    this.setThirdConfigInfo(oldConfig, systemConfig);
                    continue;
                }
                String targetCode = this.getTargetCode(oldConfig.getCode());
                String comType = this.getComType(oldConfig.getCode());
                String personType = this.getPersonType(oldConfig.getCode());
                if (Strings.isEmpty(targetCode)) {
                    throw new RuntimeException("\u4fee\u6539\u5931\u8d25");
                }
                if (NOTDIVERSION.equals(isDiversionCom)) {
                    SystemConfig o_dx;
                    SystemConfig o_lt;
                    SystemConfig o;
                    if (NOTDIVERSION.equals(isDiversionPersonType)) {
                        o = this.getByCode(targetCode);
                        o_lt = this.getByCode(targetCode + _LT);
                        o_dx = this.getByCode(targetCode + _DX);
                        SystemConfig o_fj2 = this.getByCode(targetCode + _FJ);
                        SystemConfig o_lt_fj = this.getByCode(targetCode + _LT + _FJ);
                        SystemConfig o_dx_fj = this.getByCode(targetCode + _DX + _FJ);
                        this.setNewValue(o, systemConfig);
                        this.setNewValue(o_dx, systemConfig);
                        this.setNewValue(o_lt, systemConfig);
                        this.setNewValue(o_fj2, systemConfig);
                        this.setNewValue(o_lt_fj, systemConfig);
                        this.setNewValue(o_dx_fj, systemConfig);
                        continue;
                    }
                    if (_FJ.equals(personType)) {
                        o_fj = this.getByCode(targetCode + _FJ);
                        SystemConfig o_lt_fj = this.getByCode(targetCode + _LT + _FJ);
                        SystemConfig o_dx_fj = this.getByCode(targetCode + _DX + _FJ);
                        this.setNewValue(o_fj, systemConfig);
                        this.setNewValue(o_lt_fj, systemConfig);
                        this.setNewValue(o_dx_fj, systemConfig);
                        continue;
                    }
                    o = this.getByCode(targetCode);
                    o_lt = this.getByCode(targetCode + _LT);
                    o_dx = this.getByCode(targetCode + _DX);
                    this.setNewValue(o, systemConfig);
                    this.setNewValue(o_dx, systemConfig);
                    this.setNewValue(o_lt, systemConfig);
                    continue;
                }
                if (!NOTDIVERSION.equals(isDiversionPersonType)) continue;
                if (_LT.equals(comType)) {
                    SystemConfig o_lt_fj = this.getByCode(targetCode + _LT + _FJ);
                    this.setNewValue(o_lt_fj, systemConfig);
                    continue;
                }
                if (_DX.equals(comType)) {
                    SystemConfig o_dx_fj = this.getByCode(targetCode + _DX + _FJ);
                    this.setNewValue(o_dx_fj, systemConfig);
                    continue;
                }
                o_fj = this.getByCode(targetCode + _FJ);
                this.setNewValue(o_fj, systemConfig);
            }
            map.put("flag", DIVERSION);
            map.put("message", "\u4fee\u6539\u6210\u529f");
        }
        return map;
    }

    @Override
    public List<SystemConfig> queryByCodeLike(String codeLike) {
        return this.systemConfigDao.queryByCodeLike(codeLike);
    }

    private void setNewValue(SystemConfig oldConfig, SystemConfig systemConfig) {
        if (oldConfig == null || systemConfig == null) {
            return;
        }
        oldConfig.setCode(oldConfig.getCode());
        oldConfig.setName(oldConfig.getName());
        oldConfig.setNote(systemConfig.getNote());
        oldConfig.setValue(systemConfig.getValue());
        this.update(oldConfig);
    }

    private String getTargetCode(String sourceCode) {
        String sufix = this.getSufix(sourceCode);
        if (Strings.isNotEmpty(sufix)) {
            return sourceCode.substring(0, sourceCode.indexOf(sufix));
        }
        return sourceCode;
    }

    private String getSufix(String sourceCode) {
        if (!Strings.isEmpty(sourceCode)) {
            Pattern pattern = Pattern.compile("(_DX_FJ)|(_LT_FJ)|(_DX)|(_LT)|(_FJ)|(_THIRD)");
            Matcher matcher = pattern.matcher(sourceCode);
            String sufix = "";
            if (matcher.find()) {
                sufix = matcher.group();
            }
            return sufix;
        }
        return "";
    }

    private String getComType(String sourceCode) {
        String sufix = this.getSufix(sourceCode);
        if (sufix.contains(_DX)) {
            return _DX;
        }
        if (sufix.contains(_LT)) {
            return _LT;
        }
        return "";
    }

    private String getPersonType(String sourceCode) {
        String sufix = this.getSufix(sourceCode);
        if (sufix.contains(_FJ)) {
            return _FJ;
        }
        return "";
    }

    private void setThirdConfigInfo(SystemConfig old, SystemConfig systemConfig) {
        String targetCode = this.getTargetCode(old.getCode());
        String sufix = this.getSufix(old.getCode());
        if (("D_URL".equals(targetCode) || "D_devCardNo".equals(targetCode) || "D_devPassword".equals(targetCode)) && Strings.isEmpty(sufix)) {
            SystemConfig o_third = this.getByCode(targetCode + _THIRD);
            this.setNewValue(o_third, systemConfig);
        }
    }
}

