/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.synjly.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.synjly.dao.JlySynDao;
import com.xdja.pams.synjly.entity.JlyDepartment;
import com.xdja.pams.synjly.entity.JlyPerson;
import com.xdja.pams.synjly.entity.JlySynRecord;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JlySynDaoImpl
implements JlySynDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public void saveJlyPerson(JlyPerson entity) {
        this.baseDao.create(entity);
    }

    @Override
    public void updateJlyPerson(JlyPerson entity) {
        this.baseDao.update(entity);
    }

    @Override
    public JlyPerson getJlyPersonByUuid(String uuid) {
        String sql = "from JlyPerson where uuid=?";
        return (JlyPerson)this.baseDao.getObjectByHQL(sql, new Object[]{uuid});
    }

    @Override
    public void saveJlyDepartment(JlyDepartment entity) {
        this.baseDao.create(entity);
    }

    @Override
    public void updateJlyDepartment(JlyDepartment entity) {
        this.baseDao.update(entity);
    }

    @Override
    public JlyDepartment getJlyDepByUuid(String uuid) {
        String sql = " from JlyDepartment where uuid = ?";
        return (JlyDepartment)this.baseDao.getObjectByHQL(sql, new Object[]{uuid});
    }

    @Override
    public List<JlyDepartment> getUnRelationJlyDep() {
        String sql = "select *  from T_JLY_DEPARTMENT where DEP_ID is null ";
        return this.baseDao.getListBySQL(sql, null, JlyDepartment.class);
    }

    @Override
    public List<JlyPerson> getUnRelationJlyPerson() {
        String sql = " from JlyPerson where personId is null";
        return this.baseDao.getListByHQL(sql, null);
    }

    @Override
    public JlySynRecord getLastSynRecord(String type) {
        String sql = "select * from (select * from T_JLY_SYN_RECORD where type = ? order by create_date desc)\u3000where rownum=1 ";
        List<?> listBySQL = this.baseDao.getListBySQL(sql, new String[]{type}, JlySynRecord.class);
        if (listBySQL != null && !listBySQL.isEmpty()) {
            return (JlySynRecord)listBySQL.get(0);
        }
        return null;
    }

    @Override
    public void saveJlySynRecord(JlySynRecord entity) {
        this.baseDao.create(entity);
    }
}

