/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.synthird.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.synthird.dao.SynThirdDao;
import com.xdja.pams.synthird.entity.ThirdDepartment;
import com.xdja.pams.synthird.entity.ThirdPerson;
import com.xdja.pams.synthird.service.SynThirdService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SynThirdServiceImpl
implements SynThirdService {
    @Autowired
    private SynThirdDao dao;
    @Autowired
    private DepManageService depManageService;
    @Autowired
    private UserManageService userManageService;
    private static Logger log = LoggerFactory.getLogger(SynThirdServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synThird() {
        SynThirdServiceImpl synThirdServiceImpl = this;
        synchronized (synThirdServiceImpl) {
            this.synDep();
            this.synPerson();
        }
    }

    public void synDep() {
        List<Department> querySynDepDelete = this.dao.querySynDepDelete();
        log.info("\u5355\u4f4d\u540c\u6b65\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
        int i = 0;
        int i_s = 0;
        for (Department department : querySynDepDelete) {
            try {
                this.depManageService.deleteDepById(department.getId());
                ++i_s;
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5220\u9664\u5355\u4f4d\u5931\u8d25\uff1aid={}", (Object)department.getId(), (Object)e);
            }
            ++i;
        }
        log.info("\u540c\u6b65\u5220\u9664\u5355\u4f4d,\u5171\u3010{}\u3011\uff0c\u6210\u529f\u3010{}\u3011", (Object)i, (Object)i_s);
        i = 0;
        i_s = 0;
        List<ThirdDepartment> querySynDepChange = this.dao.querySynDepChange();
        for (ThirdDepartment depT : querySynDepChange) {
            try {
                Department dep = this.depManageService.getDepartmentByCode(depT.getCode());
                dep.setName(depT.getName());
                dep.setNameAbbr(depT.getNameAbbr());
                ++i_s;
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u53d8\u66f4\u5355\u4f4d\u5931\u8d25:code={}", (Object)depT.getCode(), (Object)e);
            }
            ++i;
        }
        log.info("\u540c\u6b65\u53d8\u66f4\u5355\u4f4d,\u5171\u3010{}\u3011\uff0c\u6210\u529f\u3010{}\u3011", (Object)i, (Object)i_s);
        i = 0;
        i_s = 0;
        List<ThirdDepartment> list = this.dao.querySynDepAddData();
        for (ThirdDepartment depT : list) {
            try {
                Department dep = new Department();
                dep.setCode(depT.getCode());
                dep.setName(depT.getName());
                dep.setNameAbbr(depT.getNameAbbr());
                String parentDepCode = this.getParentCode(dep.getCode());
                Department parentDep = this.depManageService.getDepartmentByCode(parentDepCode);
                if (parentDep == null) {
                    parentDep = this.getDefaultParentDep();
                }
                dep.setParentDep(parentDep);
                String pLevel = parentDep.getLevel();
                String level = "";
                try {
                    level = Integer.toString(Integer.parseInt(pLevel) + 1);
                }
                catch (NumberFormatException e) {
                    level = "2";
                }
                dep.setLevel(level);
                dep.setDepType("dept");
                dep.setFlag("0");
                this.depManageService.addDep(dep);
                ++i_s;
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u65b0\u589e\u5355\u4f4d\u5931\u8d25\uff1acode={}", (Object)depT.getCode(), (Object)e);
            }
            ++i;
        }
        log.info("\u540c\u6b65\u65b0\u589e\u5355\u4f4d,\u5171\u3010{}\u3011\uff0c\u6210\u529f\u3010{}\u3011", (Object)i, (Object)i_s);
        log.info("\u5355\u4f4d\u540c\u6b65\u7ed3\u675f\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a");
    }

    private Department getDefaultParentDep() {
        Department dep = this.depManageService.getDepartmentByCode("999999999990");
        if (dep != null) {
            return dep;
        }
        dep = new Department();
        dep.setCode("999999999990");
        dep.setName("\u65e0\u4e0a\u7ea7\u5355\u4f4d\u6570\u636e");
        dep.setLevel("2");
        dep.setDepType("dept");
        Department parentDep = new Department();
        parentDep.setId("8888888888");
        dep.setParentDep(parentDep);
        this.depManageService.addDep(dep);
        return dep;
    }

    private Department getDefaultPersonDep() {
        Department dep = this.depManageService.getDepartmentByCode("999999999900");
        if (dep != null) {
            return dep;
        }
        dep = new Department();
        dep.setCode("999999999900");
        dep.setName("\u65e0\u5355\u4f4d\u4eba\u5458\u6570\u636e");
        dep.setLevel("2");
        dep.setDepType("dept");
        Department parentDep = new Department();
        parentDep.setId("8888888888");
        dep.setParentDep(parentDep);
        this.depManageService.addDep(dep);
        return dep;
    }

    private String getParentCode(String code) {
        if ("".equals(code)) {
            return "";
        }
        boolean do_while = true;
        while (do_while) {
            int idx = code.lastIndexOf("00");
            if (idx > 0) {
                if (code.length() - idx > 2) {
                    code = code.substring(0, code.length() - 2);
                    do_while = false;
                    continue;
                }
                code = code.substring(0, idx);
                continue;
            }
            code = code.substring(0, code.length() - 2);
            do_while = false;
        }
        StringBuffer sb = new StringBuffer(code);
        while (sb.length() < 12) {
            sb.append("00");
        }
        return sb.toString();
    }

    public void synPerson() {
        HashSet<String> errTypeSet = new HashSet<String>();
        log.info("\u4eba\u5458\u540c\u6b65\u5f00\u59cb\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
        int i = 0;
        int i_s = 0;
        List<Person> querySynPersonDelete = this.dao.querySynPersonDelete();
        for (Person person : querySynPersonDelete) {
            try {
                this.userManageService.delete(person.getId());
                ++i_s;
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u5220\u9664\u4eba\u5458\u5931\u8d25\uff1aid={}", (Object)person.getId(), (Object)e);
            }
            ++i;
        }
        log.info("\u540c\u6b65\u5220\u9664\u4eba\u5458,\u5171\u3010{}\u3011\uff0c\u6210\u529f\u3010{}\u3011", (Object)i, (Object)i_s);
        i = 0;
        i_s = 0;
        List<ThirdPerson> querySynPersonChange = this.dao.querySynPersonChange();
        for (ThirdPerson personT : querySynPersonChange) {
            block13: {
                try {
                    Person person = this.userManageService.getUserByCode(personT.getCode());
                    person.setName(personT.getName());
                    person.setIdentifier(personT.getIdentifier());
                    List<Mobile> mobiledList = person.getMobiledList();
                    String mobileStr = personT.getMobile();
                    if (StringUtils.isBlank((CharSequence)mobileStr)) {
                        mobileStr = personT.getCode() + "00000000000".substring(0, 11);
                    }
                    if (StringUtils.isBlank((CharSequence)(mobileStr = mobileStr.replaceAll("\\D", "")))) {
                        mobileStr = personT.getCode() + "00000000000".substring(0, 11);
                    }
                    if (mobileStr.length() > 11) {
                        mobileStr = mobileStr.substring(0, 11);
                    }
                    mobiledList.get(0).setMobile(mobileStr);
                    person.setMobile(mobileStr);
                    Department dep = this.depManageService.getDepartmentByCode(personT.getDepCode());
                    if (dep == null) {
                        dep = this.getDefaultPersonDep();
                    }
                    person.setDepCode(dep.getCode());
                    person.setDepartment(dep);
                    this.userManageService.updateUser(person);
                    ++i_s;
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u53d8\u66f4\u4eba\u5458\u5931\u8d25\uff1aid={}", (Object)personT.getCode());
                    String errClass = e.getClass().getName();
                    if (errTypeSet.contains(errClass)) break block13;
                    errTypeSet.add(errClass);
                    log.error("------", (Throwable)e);
                }
            }
            ++i;
        }
        log.info("\u540c\u6b65\u53d8\u66f4\u4eba\u5458,\u5171\u3010{}\u3011\uff0c\u6210\u529f\u3010{}\u3011", (Object)i, (Object)i_s);
        i = 0;
        i_s = 0;
        errTypeSet.clear();
        List<ThirdPerson> list = this.dao.querySynPersonAdd();
        for (ThirdPerson personT : list) {
            block14: {
                try {
                    Person person = this.getPerosn(personT);
                    this.userManageService.addUser(person);
                    ++i_s;
                }
                catch (Exception e) {
                    log.error("\u540c\u6b65\u65b0\u589e\u4eba\u5458\u5931\u8d25:{}", (Object)personT.getCode());
                    String errClass = e.getClass().getName();
                    if (errTypeSet.contains(errClass)) break block14;
                    errTypeSet.add(errClass);
                    log.error("------", (Throwable)e);
                }
            }
            ++i;
        }
        log.info("\u540c\u6b65\u65b0\u589e\u4eba\u5458,\u5171\u3010{}\u3011\uff0c\u6210\u529f\u3010{}\u3011", (Object)i, (Object)i_s);
        log.info("\u4eba\u5458\u540c\u6b65\u7ed3\u675f\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a\u300a");
    }

    public Person getPerosn(ThirdPerson tPerson) {
        Person person = new Person();
        person.setName(tPerson.getName());
        person.setCode(tPerson.getCode());
        person.setIdentifier(tPerson.getIdentifier());
        person.setSex("1");
        person.setPosition("28");
        person.setPolice("22");
        person.setOfficePhone(tPerson.getMobile());
        person.setMobileMultimediaMessage(null);
        person.setMobilePersonal(null);
        String mobileStr = tPerson.getMobile();
        if (StringUtils.isBlank((CharSequence)mobileStr)) {
            mobileStr = tPerson.getCode() + "00000000000".substring(0, 11);
        }
        if (StringUtils.isBlank((CharSequence)(mobileStr = mobileStr.replaceAll("\\D", "")))) {
            mobileStr = tPerson.getCode() + "00000000000".substring(0, 11);
        }
        if (mobileStr.length() > 11) {
            mobileStr = mobileStr.substring(0, 11);
        }
        ArrayList<Mobile> mobileList = new ArrayList<Mobile>();
        Mobile mobile = new Mobile();
        mobile.setMobile(mobileStr);
        mobileList.add(mobile);
        person.setMobiledList(mobileList);
        person.setMobile(mobileStr);
        person.setOrderField(999L);
        Department dep = this.depManageService.getDepartmentByCode(tPerson.getDepCode());
        if (dep == null) {
            dep = this.getDefaultPersonDep();
        }
        person.setDepartment(dep);
        person.setDepCode(dep.getCode());
        person.setPersonState("1");
        person.setDisplayState("1");
        person.setLeaderLevel("3");
        person.setPersonType("1");
        person.setDepCode(person.getDepartment().getCode());
        person.setCreatorId("0");
        person.setLastChangePwDate(new Date());
        return person;
    }
}

