/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.synthirdcomm.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.synthirdcomm.dao.SynDao;
import com.xdja.pams.synthirdcomm.entity.ThirdDepartmentC;
import com.xdja.pams.synthirdcomm.entity.ThirdDeviceC;
import com.xdja.pams.synthirdcomm.entity.ThirdPersonC;
import com.xdja.pams.synthirdcomm.entity.ThirdSynRecordC;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SynDaoImpl
implements SynDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public void saveThirdPerson(ThirdPersonC entity) {
        this.baseDao.create(entity);
    }

    @Override
    public void updateThirdPerson(ThirdPersonC entity) {
        this.baseDao.update(entity);
    }

    @Override
    public ThirdPersonC getThirdPersonByThirdId(String thirdId) {
        String sql = "from ThirdPersonC where thirdId=?";
        return (ThirdPersonC)this.baseDao.getObjectByHQL(sql, new Object[]{thirdId});
    }

    @Override
    public void saveThirdDepartment(ThirdDepartmentC entity) {
        this.baseDao.create(entity);
    }

    @Override
    public void updateThirdDepartment(ThirdDepartmentC entity) {
        this.baseDao.update(entity);
    }

    @Override
    public ThirdDepartmentC getThirdDepByThirdId(String thirdId) {
        String sql = " from ThirdDepartmentC where thirdId = ?";
        return (ThirdDepartmentC)this.baseDao.getObjectByHQL(sql, new Object[]{thirdId});
    }

    @Override
    public List<ThirdDepartmentC> getUnRelationThirdDep() {
        String sql = "select *  from T_Third_DEPARTMENT where DEP_ID is null order by last_update_time asc ";
        return this.baseDao.getListBySQL(sql, null, ThirdDepartmentC.class);
    }

    @Override
    public List<ThirdPersonC> getUnRelationThirdPerson() {
        String sql = " from ThirdPersonC where personId is null order by timestamp asc  ";
        return this.baseDao.getListByHQL(sql, null);
    }

    @Override
    public ThirdSynRecordC getLastSynRecord(String type) {
        String sql = "select * from (select * from T_Third_SYN_RECORD where type = ? order by create_date desc)\u3000where rownum=1 ";
        List<?> listBySQL = this.baseDao.getListBySQL(sql, new String[]{type}, ThirdSynRecordC.class);
        if (listBySQL != null && !listBySQL.isEmpty()) {
            return (ThirdSynRecordC)listBySQL.get(0);
        }
        return null;
    }

    @Override
    public void saveThirdSynRecord(ThirdSynRecordC entity) {
        this.baseDao.create(entity);
    }

    @Override
    public ThirdDepartmentC getThirdDepByThirdCode(String code) {
        String sql = " from ThirdDepartmentC where code = ? and flag = '0'";
        return (ThirdDepartmentC)this.baseDao.getObjectByHQL(sql, new Object[]{code});
    }

    @Override
    public void saveThirdDevice(ThirdDeviceC entity) {
        this.baseDao.create(entity);
    }

    @Override
    public void updateThirdDevice(ThirdDeviceC entity) {
        this.baseDao.update(entity);
    }

    @Override
    public ThirdDeviceC getThirdDeviceByThirdId(String thirdId) {
        String sql = " from ThirdDeviceC where thirdId = ? ";
        return (ThirdDeviceC)this.baseDao.getObjectByHQL(sql, new Object[]{thirdId});
    }

    @Override
    public List<ThirdDeviceC> getUnRelationThirdDevice() {
        String sql = "from ThirdDeviceC where deviceId is null order by timestamp asc ";
        return this.baseDao.getListByHQL(sql, null);
    }
}

