/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.tims.control;

import com.xdja.agreement.config.SystemConfig;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.FastDfsUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.tims.bean.QueryFileBean;
import com.xdja.pams.tims.entity.FileEntity;
import com.xdja.pams.tims.service.FileUploadService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class FileUploadController
extends BaseControler {
    @Autowired
    private FileUploadService fileUploadService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private FastDfsUtils fastDfsUtils;
    private static final Logger log = LoggerFactory.getLogger(FileUploadController.class);

    @RequestMapping(value={"/tims/fileuploadcontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = "tims/fileupload/default/index";
            map.put((Object)"currentPersonID", (Object)this.person.getId());
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/query.do"})
    public void query(QueryFileBean queryBean, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 1;
        ArrayList listmap = new ArrayList();
        Page page = new Page(pageParam.getPage(), pageParam.getRows());
        try {
            List<QueryFileBean> list = this.fileUploadService.query(queryBean, page);
            for (FileEntity fileEntity : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", fileEntity.getId());
                map.put("wjmc", fileEntity.getWjmc());
                map.put("wjms", fileEntity.getWjms());
                long ll = Long.parseLong(fileEntity.getFilesize());
                map.put("filesize", ll / 1024L);
                map.put("scr", fileEntity.getScr());
                map.put("scrName", this.userManageService.queryPersonById(fileEntity.getScr()).getName());
                map.put("scsj", Util.getDate("yyyy-MM-dd", fileEntity.getScsj()));
                listmap.add(map);
            }
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/toAdd.do"})
    public String toAdd(String id, ModelMap map) {
        try {
            String suffixLimited = this.scps.getValueByCode("timsShareFileSuffixLimited");
            map.put((Object)"suffixLimited", (Object)suffixLimited);
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        return "tims/fileupload/default/add";
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/toEdit.do"})
    public String toEdit(String id, ModelMap map) {
        map.put((Object)"id", (Object)id);
        return "tims/fileupload/default/edit";
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/upload.do"})
    public void upload(@RequestParam MultipartFile file, String wjmc, String wjms, HttpServletRequest request, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        FileEntity fileEntity = new FileEntity();
        try {
            fileEntity.setScsj(new Date());
            fileEntity.setScr(this.person.getId());
            wjmc = URLDecoder.decode(wjmc, "utf-8");
            fileEntity.setWjmc(wjmc);
            wjms = URLDecoder.decode(wjms, "utf-8");
            fileEntity.setWjms(wjms);
            long fileSize = file.getSize();
            fileEntity.setFilesize(String.valueOf(fileSize));
            int fizeSizeMB = 0;
            int timsShareFileMaxSize = Integer.parseInt(this.scps.getValueByCode("timsShareFileMaxSize"));
            if (fileSize / 0x100000L >= (long)timsShareFileMaxSize) {
                throw new Exception("\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7" + timsShareFileMaxSize + "MB\uff0c\u4e0a\u4f20\u5931\u8d25");
            }
            fizeSizeMB = (int)fileSize;
            String exportDir = "download";
            String fileName = file.getOriginalFilename();
            String extension = FilenameUtils.getExtension((String)fileName);
            fileEntity.setPostfix(extension);
            if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
                StringBuffer path = new StringBuffer();
                path.append(request.getSession().getServletContext().getRealPath(exportDir));
                path.append(File.separator).append(this.person.getCode()).append("_");
                path.append(System.currentTimeMillis()).append('.');
                path.append(extension);
                fileEntity.setFilepath(path.toString());
                InputStream is = file.getInputStream();
                FileOutputStream fos = new FileOutputStream(new File(path.toString()));
                byte[] temp = new byte[fizeSizeMB];
                while (is.read(temp) != -1) {
                    fos.write(temp);
                }
                is.close();
                fos.close();
                log.info(path + ":" + fileSize);
            } else {
                String fileId = this.fastDfsUtils.uploadToFASTDFS(file.getBytes(), file.getOriginalFilename());
                fileEntity.setFilepath(fileId);
                log.info(fileId + ":" + fileSize);
            }
            this.fileUploadService.save(fileEntity);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + e.getMessage());
        }
        Util.writeUtf8Text1(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/getById.do"})
    public void getById(String id, HttpServletResponse response) {
        FileEntity file = this.fileUploadService.getFileEntity((Serializable)((Object)id));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", file.getId());
        map.put("wjmc", file.getWjmc());
        map.put("wjms", file.getWjms());
        map.put("filepath", file.getFilepath());
        map.put("filesize", file.getFilesize());
        map.put("postfix", file.getPostfix());
        map.put("scr", file.getScr());
        map.put("scsj", Util.getDate("yyyy-MM-dd", file.getScsj()));
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/update.do"})
    public void update(FileEntity fileEntity, String scr, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 1;
        ReturnResult rtnResult = new ReturnResult();
        try {
            if (!scr.equals(this.person.getId())) {
                throw new Exception("\u7981\u6b62\u4fee\u6539\u4ed6\u4eba\u5171\u4eab\u8d44\u6e90\uff01");
            }
            this.fileUploadService.update(fileEntity);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            operateResult = 0;
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/del.do"})
    public void del(String id, String scr, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 1;
        File file = null;
        ReturnResult rtnResult = new ReturnResult();
        try {
            String filePath;
            String downloadPath;
            if (!scr.equals(this.person.getId())) {
                throw new Exception("\u7981\u6b62\u5220\u9664\u4ed6\u4eba\u5171\u4eab\u8d44\u6e90\uff01");
            }
            FileEntity f = this.fileUploadService.getFileEntity((Serializable)((Object)id));
            if ("0".equals(SystemConfig.getInstance().getString("cluster.switch")) && (file = new File(downloadPath = (filePath = f.getFilepath()))).exists()) {
                file.delete();
            }
            this.fileUploadService.delete((Serializable)((Object)id));
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("common.message.operate.success");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/checkSuffix.do"})
    public void checkSuffix(String fileSuffix, HttpServletResponse response) {
        boolean flag = this.fileUploadService.checkSuffix(fileSuffix);
        Util.writeUtf8Text(response, Boolean.toString(!flag));
    }

    @RequestMapping(value={"/tims/fileuploadcontroller/downloadById.do"})
    public void downloadById(String id, HttpServletResponse response, HttpServletRequest request) {
        FileEntity f = this.fileUploadService.getFileEntity((Serializable)((Object)id));
        String fileName = Util.toUtf8String(f.getWjmc()) + "." + f.getPostfix();
        String filePath = f.getFilepath();
        this.download(fileName, filePath, response, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String fileName, String filePath, HttpServletResponse response, HttpServletRequest request) {
        File file = null;
        OutputStream os = null;
        BufferedInputStream fin = null;
        try {
            fileName = new String(fileName.getBytes("gbk"), "iso-8859-1");
            response.setContentType("application/x-msdownload");
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            os = response.getOutputStream();
            if ("0".equals(SystemConfig.getInstance().getString("cluster.switch"))) {
                String downloadPath = filePath;
                file = new File(downloadPath);
                if (file.exists()) {
                    fin = new BufferedInputStream(new FileInputStream(file));
                    if (fin != null) {
                        byte[] b = new byte[2048];
                        int i = 0;
                        while ((i = fin.read(b)) > 0) {
                            os.write(b, 0, i);
                        }
                    }
                    os.flush();
                    os.close();
                    fin.close();
                    os = null;
                    fin = null;
                } else {
                    response.setContentType("text/plain;charset=UTF-8");
                    os.write("<script type=text/javascript>alert('\u60a8\u4e0b\u8f7d\u7684\u6587\u4ef6\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u4e0a\u4f20\uff0c\\n\u8bf7\u70b9\u51fb\u786e\u5b9a\u7ee7\u7eed\u4e0b\u8f7d\uff01');window.location.href='index.do';</script>".getBytes("UTF-8"));
                }
            } else {
                try {
                    byte[] bytes = this.fastDfsUtils.downloadFromFASTDFS(filePath);
                    os.write(bytes);
                }
                catch (Exception e) {
                    response.setContentType("text/plain;charset=UTF-8");
                    os.write("<script type=text/javascript>alert('\u60a8\u4e0b\u8f7d\u7684\u6587\u4ef6\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u91cd\u65b0\u4e0a\u4f20\uff0c\\n\u8bf7\u70b9\u51fb\u786e\u5b9a\u7ee7\u7eed\u4e0b\u8f7d\uff01');window.location.href='index.do';</script>".getBytes("UTF-8"));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (fin != null) {
                    fin.close();
                }
                file = null;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

