/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.upms.service.impl;

import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.upms.bean.QueryGprsConfigBean;
import com.xdja.pams.upms.bean.QueryTerminalPowerBean;
import com.xdja.pams.upms.dao.TerminalPowerDao;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.entity.Role;
import com.xdja.pams.upms.service.TerminalPowerService;
import com.xdja.pams.upms.service.TerminalRoleService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalPowerServiceImpl
implements TerminalPowerService {
    private static final Logger log = LoggerFactory.getLogger(TerminalPowerServiceImpl.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private TerminalRoleService terminalRoleService;
    @Autowired
    private TerminalPowerDao terminalPowerDao;

    @Override
    public List<GprsMenu> queryTerminalPowerList(QueryTerminalPowerBean bean, Page page) {
        return this.terminalPowerDao.queryTerminalPowerList(bean, page);
    }

    @Override
    public QueryTerminalPowerBean queryById(String id) {
        QueryTerminalPowerBean bean = new QueryTerminalPowerBean();
        GprsMenu power = this.terminalPowerDao.queryById(id);
        if (power == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)power, (Object)bean);
        return bean;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void update(QueryTerminalPowerBean bean) {
        GprsMenu power = this.terminalPowerDao.queryById(bean.getN_id());
        if (power == null) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.noSuchPower"));
        }
        QueryTerminalPowerBean tmpBean = new QueryTerminalPowerBean();
        tmpBean.setC_mc(bean.getC_mc());
        tmpBean.setC_fjcd(bean.getC_fjcd());
        List<GprsMenu> menus = this.terminalPowerDao.queryTerminalPowerList(tmpBean, null);
        if (menus != null) {
            for (GprsMenu menu : menus) {
                if (menu.getN_id().equals(bean.getN_id())) continue;
                throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.hasSamePower"));
            }
        }
        QueryTerminalPowerBean tmpBeanForQx = new QueryTerminalPowerBean();
        tmpBeanForQx.setC_qx(bean.getC_qx());
        List<GprsMenu> menusQx = this.terminalPowerDao.queryTerminalPowerList(tmpBeanForQx, null);
        if (menusQx != null && menusQx.size() > 0) {
            for (GprsMenu menu : menusQx) {
                if (menu.getN_id().equals(bean.getN_id())) continue;
                throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.hasSameQx"));
            }
        }
        power.setC_fjcd(bean.getC_fjcd());
        power.setC_mc(bean.getC_mc());
        power.setC_clct(bean.getC_clct());
        power.setC_jc(bean.getC_jc());
        power.setC_ljdz(bean.getC_ljdz());
        power.setC_qqlb(bean.getC_qqlb());
        power.setC_qx(bean.getC_qx());
        power.setC_tbbh(bean.getC_tbbh());
        power.setSeq(bean.getSeq());
        power.setC_zt(bean.getC_zt());
        this.terminalPowerDao.update(power);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public GprsMenu save(QueryTerminalPowerBean bean) {
        QueryTerminalPowerBean tmpBean = new QueryTerminalPowerBean();
        tmpBean.setC_mc(bean.getC_mc());
        tmpBean.setC_fjcd(bean.getC_fjcd());
        List<GprsMenu> menus = this.terminalPowerDao.queryTerminalPowerList(tmpBean, null);
        if (menus != null && menus.size() > 0) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.hasSamePower"));
        }
        QueryTerminalPowerBean tmpBeanForQx = new QueryTerminalPowerBean();
        tmpBeanForQx.setC_qx(bean.getC_qx());
        List<GprsMenu> menusQx = this.terminalPowerDao.queryTerminalPowerList(tmpBeanForQx, null);
        if (menusQx != null && menusQx.size() > 0) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.hasSameQx"));
        }
        GprsMenu power = new GprsMenu();
        BeanUtils.copyProperties((Object)bean, (Object)power);
        power.setC_zt("1");
        return this.terminalPowerDao.save(power);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void delete(QueryTerminalPowerBean bean) {
        boolean flag = false;
        GprsMenu tmpBean = this.terminalPowerDao.queryById(bean.getN_id());
        if (tmpBean == null) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.noSuchPower"));
        }
        Role roleBean = new Role();
        List<Role> rolelist = this.terminalRoleService.queryRoleList(roleBean, null);
        block0: for (Role role : rolelist) {
            List<GprsMenu> gprslist = role.getGprsMenuSet();
            for (GprsMenu g : gprslist) {
                if (!g.getN_id().equals(tmpBean.getN_id())) continue;
                flag = true;
                continue block0;
            }
        }
        if (flag) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.terminalpower.hasRole"));
        }
        QueryTerminalPowerBean power = new QueryTerminalPowerBean();
        power.setC_fjcd(tmpBean.getN_id());
        List<GprsMenu> childlist = this.queryTerminalPowerList(power, null);
        if (childlist != null && childlist.size() > 0) {
            throw new RuntimeException(MessageManager.getProMessage(this.message, "upms.page.error.power.haschild"));
        }
        this.terminalPowerDao.delete(tmpBean);
    }

    @Override
    @Transactional
    public void updateStatus(QueryTerminalPowerBean bean) {
        GprsMenu menu = this.terminalPowerDao.queryById(bean.getN_id());
        menu.setC_zt(bean.getC_zt());
        this.terminalPowerDao.update(menu);
    }

    @Override
    public List<QueryGprsConfigBean> queryGprsConfigByQqlb(String q, Page page) {
        return this.terminalPowerDao.queryTerminalPowerListBySql(q, page);
    }
}

