/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.webservice.client;

import com.xdja.pams.webservice.client.WebserviceClient;
import com.xdja.pams.webservice.meta.CardInfoSyncResult;
import com.xdja.pams.webservice.meta.MoSms;
import com.xdja.pams.webservice.meta.MtSms;
import com.xdja.pams.webservice.meta.SendSmsResult;
import com.xdja.pams.webservice.meta.SmsStatus;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.methods.HttpPost;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAClient
extends WebserviceClient {
    private static final Logger log = LoggerFactory.getLogger(CommonAClient.class);
    private static Namespace NS_NS1 = Namespace.getNamespace((String)"ns1", (String)"http://www.xdja.com/service");
    private static Namespace NS_MTSMS = Namespace.getNamespace((String)"", (String)"http://mtsms.model.xdja.com");
    private static Namespace NS_STATUS = Namespace.getNamespace((String)"", (String)"http://smsstatus.model.xdja.com");
    private static Namespace NS_MOSMS = Namespace.getNamespace((String)"", (String)"http://mosms.model.xdja.com");
    private static Namespace NS_CARD = Namespace.getNamespace((String)"", (String)"http://cardinfosync.model.xdja.com");
    private static String VERSION_1 = "1.0";

    public static List<SendSmsResult> sendSms(String url, List<MtSms> smsList) {
        if (null != smsList && smsList.size() > 0) {
            log.debug("Start send sms, the number of sms is " + smsList.size() + ".");
            try {
                HttpPost httpPost = CommonAClient.getHttpPost(url);
                String soapRequestData = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://www.xdja.com/service\" xmlns:mts=\"http://mtsms.model.xdja.com\"><soapenv:Header/><soapenv:Body><ser:sendSms><ser:in0><mts:mtSmsList>";
                for (MtSms mtSms : smsList) {
                    soapRequestData = soapRequestData + CommonAClient.generateSoapInfo(mtSms);
                }
                soapRequestData = soapRequestData + "</mts:mtSmsList><mts:version>" + VERSION_1 + "</mts:version></ser:in0></ser:sendSms></soapenv:Body></soapenv:Envelope>";
                log.debug("soapRequestData:" + soapRequestData);
                return CommonAClient.parseSendSmsSoapInfo(CommonAClient.getResponseBody(httpPost, soapRequestData), "sendSms");
            }
            catch (Exception e) {
                log.error("Invoke new sqy42-a webservice send sms error!");
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        log.debug("The number of sms is 0.");
        return null;
    }

    private static String generateSoapInfo(MtSms mtSms) {
        String result = "<mts:MtSms><mts:ID>" + mtSms.getId() + "</mts:ID><mts:SMSIdentifier>" + mtSms.getUuid() + "</mts:SMSIdentifier><mts:deliveryResultRequest>" + mtSms.getDeliveryResultRequest() + "</mts:deliveryResultRequest><mts:destAddress>" + mtSms.getDestAddress() + "</mts:destAddress><mts:encryptFlag>" + mtSms.getEncryptFlag() + "</mts:encryptFlag><mts:feeCode>" + mtSms.getFeeCode() + "</mts:feeCode><mts:feeTerminalId>" + mtSms.getFeeTerminalId() + "</mts:feeTerminalId><mts:feeTerminalType>" + mtSms.getFeeTerminalType() + "</mts:feeTerminalType><mts:feeType>" + mtSms.getFeeType() + "</mts:feeType><mts:feeUserType>" + mtSms.getFeeUserType() + "</mts:feeUserType><mts:fixedFee>" + mtSms.getFixedFee() + "</mts:fixedFee><mts:gatewayType>" + mtSms.getGatewayType() + "</mts:gatewayType><mts:linkId>" + mtSms.getLinkId() + "</mts:linkId><mts:message>" + mtSms.getMessage() + "</mts:message><mts:messageType>" + mtSms.getMessageType() + "</mts:messageType><mts:sendTime>" + mtSms.getSendTime() + "</mts:sendTime><mts:senderAddress>" + mtSms.getSenderAddress() + "</mts:senderAddress><mts:servieId>" + mtSms.getServieId() + "</mts:servieId></mts:MtSms>";
        return result;
    }

    private static List<SendSmsResult> parseSendSmsSoapInfo(String soapInfo, String method) throws Exception {
        ArrayList<SendSmsResult> list = new ArrayList<SendSmsResult>();
        Document doc = saxb.build((Reader)new StringReader(soapInfo));
        log.debug("response soap info:" + soapInfo);
        List elementList = doc.getRootElement().getChild("Body", NS_SOAP).getChild(method + "Response", NS_NS1).getChild("out", NS_NS1).getChild("sendSmsResultList", NS_MTSMS).getChildren("SendSmsResult", NS_MTSMS);
        for (Element element : elementList) {
            SendSmsResult sendSmsResult = new SendSmsResult();
            String ack = element.getChildText("ACK", NS_MTSMS);
            String id = element.getChildText("ID", NS_MTSMS);
            String message = element.getChildText("MESSAGE", NS_MTSMS);
            sendSmsResult.setAck(Integer.parseInt(ack));
            sendSmsResult.setId(Long.parseLong(id));
            sendSmsResult.setMessage(message == null ? "" : message);
            list.add(sendSmsResult);
        }
        return list;
    }

    public static List<SmsStatus> getSmsStatus(String url, String type, String smsIdentifier, String reqCount) {
        try {
            HttpPost httpPost = CommonAClient.getHttpPost(url);
            String soapRequestData = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://www.xdja.com/service\" xmlns:sms=\"http://smsstatus.model.xdja.com\"><soapenv:Header/><soapenv:Body><ser:getSmsStatus><ser:in0><sms:SMSIdentifier>" + smsIdentifier + "</sms:SMSIdentifier><sms:reqCount>" + reqCount + "</sms:reqCount><sms:type>" + type + "</sms:type><sms:version>" + VERSION_1 + "</sms:version></ser:in0></ser:getSmsStatus></soapenv:Body></soapenv:Envelope>";
            log.debug("soapRequestData:" + soapRequestData);
            return CommonAClient.parseGetSmsStatusSoapInfo(CommonAClient.getResponseBody(httpPost, soapRequestData), "getSmsStatus");
        }
        catch (Exception e) {
            log.error("Invoke new sqy42-a webservice get sms status error!");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static List<SmsStatus> parseGetSmsStatusSoapInfo(String soapInfo, String method) throws Exception {
        ArrayList<SmsStatus> list = new ArrayList<SmsStatus>();
        Document doc = saxb.build((Reader)new StringReader(soapInfo));
        log.debug("response soap info:" + soapInfo);
        List elementList = doc.getRootElement().getChild("Body", NS_SOAP).getChild(method + "Response", NS_NS1).getChild("out", NS_NS1).getChild("smsStatusList", NS_STATUS).getChildren("SmsStatus", NS_STATUS);
        for (Element element : elementList) {
            SmsStatus smsStatus = new SmsStatus();
            String smsIdentifier = element.getChildText("SMSIdentifier", NS_STATUS);
            String destAddress = element.getChildText("destAddress", NS_STATUS);
            String doneTime = element.getChildText("doneTime", NS_STATUS);
            String gatewayType = element.getChildText("gatewayType", NS_STATUS);
            String messageId = element.getChildText("messageId", NS_STATUS);
            String messageType = element.getChildText("messageType", NS_STATUS);
            String reportStatus = element.getChildText("reportStatus", NS_STATUS);
            String senderAddress = element.getChildText("senderAddress", NS_STATUS);
            String submitTime = element.getChildText("submitTime", NS_STATUS);
            smsStatus.setSmsIdentifier(smsIdentifier);
            smsStatus.setDestAddress(destAddress);
            smsStatus.setDoneTime(Long.parseLong(doneTime));
            smsStatus.setGatewayType(Integer.parseInt(gatewayType));
            smsStatus.setMessageId(messageId);
            smsStatus.setMessageType(Integer.parseInt(messageType));
            smsStatus.setReportStatus(reportStatus);
            smsStatus.setSenderAddress(senderAddress);
            smsStatus.setSubmitTime(Long.parseLong(submitTime));
            list.add(smsStatus);
        }
        return list;
    }

    public static List<MoSms> getMoSms(String url, String reqCount) {
        try {
            HttpPost httpPost = CommonAClient.getHttpPost(url);
            String soapRequestData = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://www.xdja.com/service\" xmlns:mos=\"http://mosms.model.xdja.com\"><soapenv:Header/><soapenv:Body><ser:getMoSms><ser:in0><mos:reqCount>" + reqCount + "</mos:reqCount><mos:version>" + VERSION_1 + "</mos:version></ser:in0></ser:getMoSms></soapenv:Body></soapenv:Envelope>";
            log.debug("soapRequestData:" + soapRequestData);
            return CommonAClient.parseGetMoSmsSoapInfo(CommonAClient.getResponseBody(httpPost, soapRequestData), "getMoSms");
        }
        catch (Exception e) {
            log.error("Invoke new sqy42-a webservice get request sms error!");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static List<MoSms> parseGetMoSmsSoapInfo(String soapInfo, String method) throws Exception {
        ArrayList<MoSms> list = new ArrayList<MoSms>();
        Document doc = saxb.build((Reader)new StringReader(soapInfo));
        log.debug("response soap info:" + soapInfo);
        List elementList = doc.getRootElement().getChild("Body", NS_SOAP).getChild(method + "Response", NS_NS1).getChild("out", NS_NS1).getChild("moSmsList", NS_MOSMS).getChildren("MoSms", NS_MOSMS);
        for (Element element : elementList) {
            MoSms moSms = new MoSms();
            String destAddress = element.getChildText("destAddress", NS_MOSMS);
            String encryFlag = element.getChildText("encryFlag", NS_MOSMS);
            String gatewayType = element.getChildText("gatewayType", NS_MOSMS);
            String linkId = element.getChildText("linkId", NS_MOSMS);
            String message = element.getChildText("message", NS_MOSMS);
            String messageFormat = element.getChildText("messageFormat", NS_MOSMS);
            String receiveTime = element.getChildText("receiveTime", NS_MOSMS);
            String senderAddress = element.getChildText("senderAddress", NS_MOSMS);
            moSms.setDestAddress(destAddress);
            moSms.setEncryFlag(encryFlag);
            moSms.setGatewayType(gatewayType);
            moSms.setLinkId(linkId == null ? "" : linkId);
            moSms.setMessage(message);
            moSms.setMessageFormat(messageFormat);
            moSms.setDate(new Date(Long.parseLong(receiveTime)));
            moSms.setSenderAddress(senderAddress);
            list.add(moSms);
        }
        return list;
    }

    public static List<CardInfoSyncResult> cardInfoSync(String url, String reqCount) {
        try {
            HttpPost httpPost = CommonAClient.getHttpPost(url);
            String soapRequestData = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://www.xdja.com/service\" xmlns:car=\"http://cardinfosync.model.xdja.com\"><soapenv:Header/><soapenv:Body><ser:cardInfoSync><ser:in0><car:reqCount>" + reqCount + "</car:reqCount><car:version>" + VERSION_1 + "</car:version></ser:in0></ser:cardInfoSync></soapenv:Body></soapenv:Envelope>";
            log.debug("soapRequestData:" + soapRequestData);
            return CommonAClient.parseCardInfoSyncSoapInfo(CommonAClient.getResponseBody(httpPost, soapRequestData), "cardInfoSync");
        }
        catch (Exception e) {
            log.error("Invoke new sqy42-a webservice synchronize authenticate card info error!");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static List<CardInfoSyncResult> parseCardInfoSyncSoapInfo(String soapInfo, String method) throws Exception {
        ArrayList<CardInfoSyncResult> list = new ArrayList<CardInfoSyncResult>();
        Document doc = saxb.build((Reader)new StringReader(soapInfo));
        log.debug("response soap info:" + soapInfo);
        List elementList = doc.getRootElement().getChild("Body", NS_SOAP).getChild(method + "Response", NS_NS1).getChild("out", NS_NS1).getChild("cardInfoList", NS_CARD).getChildren("CardInfo", NS_CARD);
        for (Element element : elementList) {
            CardInfoSyncResult cardInfoSyncResult = new CardInfoSyncResult();
            String iccId = element.getChildText("iccId", NS_CARD);
            String mobile = element.getChildText("mobile", NS_CARD);
            String state = element.getChildText("state", NS_CARD);
            String type = element.getChildText("type", NS_CARD);
            cardInfoSyncResult.setIccId(iccId);
            cardInfoSyncResult.setMobile(mobile);
            cardInfoSyncResult.setState(state);
            cardInfoSyncResult.setType(Integer.parseInt(type));
            list.add(cardInfoSyncResult);
        }
        return list;
    }

    public static void main(String[] args) {
        String url = "http://192.168.12.251/GSGW/services/xdja_gw_wbs?wsdl";
        List<CardInfoSyncResult> resultList = CommonAClient.cardInfoSync(url, "0");
        if (resultList == null) {
            System.out.println("Invoke new sqy42-a webservice get synchronize authenticate card info error!");
        } else {
            System.out.println("-----------------------------");
            for (CardInfoSyncResult cardInfoSyncResult : resultList) {
                System.out.println(cardInfoSyncResult.getIccId());
                System.out.println(cardInfoSyncResult.getMobile());
                System.out.println(cardInfoSyncResult.getState());
                System.out.println(cardInfoSyncResult.getType());
                System.out.println("*************************");
            }
        }
    }
}

