/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.webservice.client;

import com.xdja.pams.webservice.client.WebserviceClient;
import com.xdja.pams.webservice.meta.TerminalBean;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpPost;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCascadeClient
extends WebserviceClient {
    private static final Logger log = LoggerFactory.getLogger(CommonCascadeClient.class);
    private static Namespace NS_NS = Namespace.getNamespace((String)"ns", (String)"http://www.xdja.com/xsd");

    public static List<String> terminalReport(String url, List<TerminalBean> beans) throws Exception {
        if (null != beans && beans.size() > 0) {
            log.debug("Start report terminal info, the number of terminal info is " + beans.size() + ".");
            try {
                HttpPost httpPost = CommonCascadeClient.getHttpPost(url);
                String soapRequestData = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.xdja.com/xsd\" xmlns:xsd1=\"http://bean.services.xdja.com/xsd\"><soapenv:Header/><soapenv:Body><xsd:terminalReport>";
                for (TerminalBean terminal : beans) {
                    soapRequestData = soapRequestData + CommonCascadeClient.generateSoapInfo(terminal);
                }
                soapRequestData = soapRequestData + "</xsd:terminalReport></soapenv:Body></soapenv:Envelope>";
                log.debug("soapRequestData:" + soapRequestData);
                return CommonCascadeClient.parseTerminalReportSoapInfo(CommonCascadeClient.getResponseBody(httpPost, soapRequestData), "terminalReport");
            }
            catch (ConnectException e) {
                log.error("Invoke cascade monitor webservice report terminal info error!");
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (HttpResponseException e) {
                log.error("Invoke cascade monitor webservice report terminal info error!");
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Invoke cascade monitor webservice report terminal info error!");
                log.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        log.debug("The number of terminal info is 0.");
        return null;
    }

    private static String generateSoapInfo(TerminalBean terminal) {
        String result = "<xsd:bean><xsd1:areaCode>" + terminal.getAreaCode() + "</xsd1:areaCode><xsd1:cardId>" + terminal.getCardId() + "</xsd1:cardId><xsd1:cardName>" + terminal.getCardName() + "</xsd1:cardName><xsd1:cardType>" + terminal.getCardType() + "</xsd1:cardType><xsd1:cardVersion>" + terminal.getCardVersion() + "</xsd1:cardVersion><xsd1:code>" + terminal.getCode() + "</xsd1:code><xsd1:deptCode>" + terminal.getDeptCode() + "</xsd1:deptCode><xsd1:grade>" + terminal.getGrade() + "</xsd1:grade><xsd1:id>" + terminal.getId() + "</xsd1:id><xsd1:identifier>" + terminal.getIdentifier() + "</xsd1:identifier><xsd1:mmpCode>" + terminal.getMmpCode() + "</xsd1:mmpCode><xsd1:mobile>" + terminal.getMobile() + "</xsd1:mobile><xsd1:name>" + terminal.getName() + "</xsd1:name><xsd1:operation>" + terminal.getOperation() + "</xsd1:operation><xsd1:police>" + terminal.getPolice() + "</xsd1:police><xsd1:sn>" + terminal.getSn() + "</xsd1:sn><xsd1:terminalBand>" + terminal.getTerminalBand() + "</xsd1:terminalBand><xsd1:terminalName>" + terminal.getTerminalName() + "</xsd1:terminalName><xsd1:terminalOs>" + terminal.getTerminalOs() + "</xsd1:terminalOs><xsd1:terminalOutLink>" + terminal.getTerminalOutLink() + "</xsd1:terminalOutLink><xsd1:terminalType>" + terminal.getTerminalType() + "</xsd1:terminalType></xsd:bean>";
        return result;
    }

    private static List<String> parseTerminalReportSoapInfo(String soapInfo, String method) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Document doc = saxb.build((Reader)new StringReader(soapInfo));
        log.debug("response soap info:" + soapInfo);
        List elementList = doc.getRootElement().getChild("Body", NS_SOAP).getChild(method + "Response", NS_NS).getChildren("return", NS_NS);
        for (Element element : elementList) {
            String result = new String();
            result = element.getText();
            list.add(result);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        String url = "http://192.168.12.128:6688/mmp/services/IBasicInfoWs?wsdl";
        List<TerminalBean> list = CommonCascadeClient.getTerminalBeanList();
        List<String> resultList = CommonCascadeClient.terminalReport(url, list);
        if (resultList == null) {
            System.out.println("Invoke cascade monitor webservice report terminal info error!");
        } else {
            for (String result : resultList) {
                System.out.println(result);
                System.out.println("*************************");
            }
        }
    }

    private static List<TerminalBean> getTerminalBeanList() {
        ArrayList<TerminalBean> list = new ArrayList<TerminalBean>();
        TerminalBean terminalBean = new TerminalBean();
        list.add(terminalBean);
        return list;
    }
}

