/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.webservice.service.impl;

import com.xdja.pams.bims.entity.Mobile;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Md5PwdEncoder;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.login.service.LoginService;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.bean.TerminalBean;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.entity.Terminal;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.scms.service.TerminalService;
import com.xdja.pams.strategy.bean.StrategyMainBean;
import com.xdja.pams.strategy.bean.StrategyTerminalBean;
import com.xdja.pams.strategy.entity.StrategyInfo;
import com.xdja.pams.strategy.entity.StrategyLog;
import com.xdja.pams.strategy.entity.StrategyMain;
import com.xdja.pams.strategy.entity.StrategyTerminal;
import com.xdja.pams.strategy.service.StrategyInfoService;
import com.xdja.pams.strategy.service.StrategyLogService;
import com.xdja.pams.strategy.service.StrategyMainService;
import com.xdja.pams.strategy.service.StrategyTerminalService;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.upms.entity.GprsMenu;
import com.xdja.pams.upms.service.UserPowerService;
import com.xdja.pams.webservice.service.IRequestPowerService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RequestPowerService
implements IRequestPowerService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserPowerService userPowerService;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private TerminalService terminalService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CommonCodePbService commonCodePbService;
    @Autowired
    private StrategyMainService strategyMainService;
    @Autowired
    private StrategyInfoService strategyInfoService;
    @Autowired
    private StrategyTerminalService strategyTerminalService;
    @Autowired
    private StrategyLogService strategyLogService;
    private static Logger log = LoggerFactory.getLogger(RequestPowerService.class);

    @Override
    @Transactional
    public String validateUser(String loginXml) {
        StringBuilder returnXml = new StringBuilder();
        returnXml.append("<?xml version='1.0' encoding='UTF-8'?>");
        returnXml.append("<Root>");
        try {
            log.info("parseXml.......");
            Map<String, String> parseResultMap = this.parseXml(loginXml);
            String idType = parseResultMap.get("idType");
            String idCode = parseResultMap.get("idCode");
            String password = parseResultMap.get("password");
            String currentVersion = parseResultMap.get("currentVersion");
            String iccid = parseResultMap.get("iccid");
            String imei = parseResultMap.get("imei");
            String imsi = parseResultMap.get("imsi");
            log.info("checkNull.......");
            this.checkNull(idType, idCode, password, currentVersion);
            log.info("checkUser.......");
            Person person = this.checkUser(idType, idCode, password);
            boolean ifCheckDeivce = Boolean.parseBoolean(this.scps.getValueByCode("ifCheckDeivce"));
            if (ifCheckDeivce) {
                log.info("checkDrivceBinding.......");
                Device device = this.checkDrivceBinding(person, iccid, imsi, imei, currentVersion);
            }
            log.info("updateClientLoginTime byPersonId:" + person.getId());
            person.setClientLoginTime(new Date());
            this.userManageService.updateClientLoginTime(person);
            StringBuffer powerStr = new StringBuffer("#");
            log.info("queryPersonTerminalPowerList.......");
            log.info("personID:" + person.getId());
            Map<String, GprsMenu> gprspower = this.userPowerService.queryPersonTerminalPowerList(person.getId());
            for (GprsMenu code : gprspower.values()) {
                if (!StringUtils.isNotBlank((CharSequence)code.getC_qx())) continue;
                powerStr.append(code.getC_qx()).append("#");
            }
            log.info("PersonTerminalPowerList:" + powerStr);
            int ifChange = 1;
            int pwd_modify_month = 3;
            try {
                pwd_modify_month = Integer.parseInt(this.scps.getValueByCode("pwdModifyMonthBetween"));
            }
            catch (Exception e) {
                pwd_modify_month = 3;
                log.error("\u5bc6\u7801\u53d8\u52a8\u9650\u5236\u914d\u7f6e\u9879\u9519\u8bef");
            }
            Date lastChangePwdDate = person.getLastChangePwDate();
            if (lastChangePwdDate == null) {
                ifChange = 1;
            } else {
                Calendar calender = Calendar.getInstance();
                calender.add(2, -pwd_modify_month);
                ifChange = lastChangePwdDate.before(calender.getTime()) ? 1 : 0;
            }
            List<Mobile> mobileList = person.getMobiledList();
            if (mobileList != null && mobileList.size() > 0) {
                person.setMobile(mobileList.get(0).getMobile());
            }
            returnXml.append("<ErrMsg/>");
            returnXml.append("<PoliceID>").append(person.getId()).append("</PoliceID>");
            returnXml.append("<PoliceNum>").append(person.getCode()).append("</PoliceNum>");
            returnXml.append("<PoliceName>").append(person.getName()).append("</PoliceName>");
            returnXml.append("<IDCard>").append(person.getIdentifier()).append("</IDCard>");
            returnXml.append("<MobileNum>").append(person.getMobile()).append("</MobileNum>");
            returnXml.append("<DeptID>").append(person.getDepId()).append("</DeptID>");
            returnXml.append("<UnitCode>").append(person.getDepartment().getCode()).append("</UnitCode>");
            returnXml.append("<UnitName>").append(person.getDepartment().getName()).append("</UnitName>");
            returnXml.append("<Month3Pwd>").append(ifChange).append("</Month3Pwd>");
            returnXml.append("<Password>").append(person.getPassword()).append("</Password>");
            returnXml.append("<Power>").append(powerStr).append("</Power>");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnXml.append("<ErrMsg>").append(MessageManager.getProMessage(this.message, "webservice.rp.error.badLogin")).append(e.getMessage()).append("</ErrMsg>");
        }
        returnXml.append("</Root>");
        log.info("validateUser returnXML\uff1a" + returnXml.toString());
        return returnXml.toString();
    }

    private Map<String, String> parseXml(String inputXml) throws Exception {
        HashMap<String, String> parseResultMap = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)inputXml)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.inputXml.isBlank"));
        }
        try {
            log.info("inputXml:" + inputXml);
            Document doc = DocumentHelper.parseText((String)inputXml);
            parseResultMap.put("idType", doc.selectSingleNode("/Root/IDType").getText());
            parseResultMap.put("idCode", doc.selectSingleNode("/Root/IDCode").getText());
            parseResultMap.put("password", doc.selectSingleNode("/Root/Password").getText());
            parseResultMap.put("currentVersion", doc.selectSingleNode("/Root/CurrentVersion").getText());
            parseResultMap.put("iccid", doc.selectSingleNode("/Root/Iccid").getText());
            parseResultMap.put("imei", doc.selectSingleNode("/Root/Imei").getText());
            parseResultMap.put("imsi", doc.selectSingleNode("/Root/Imsi").getText());
        }
        catch (DocumentException e) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.inputXml.parseErr"));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.inputXml.noteNotExit"));
        }
        return parseResultMap;
    }

    private void checkNull(String idType, String idCode, String password, String currentVersion) throws Exception {
        if (StringUtils.isBlank((CharSequence)idType)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.idType.isBlank"));
        }
        if (StringUtils.isBlank((CharSequence)idCode)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.idCode.isBlank"));
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.password.isBlank"));
        }
        if (StringUtils.isBlank((CharSequence)currentVersion)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.currentVersion.isBlank"));
        }
        if (currentVersion.length() > 32) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.currentVersion.tooLong"));
        }
    }

    private Person checkUser(String idType, String idCode, String password) throws Exception {
        Person person = null;
        if ("0".equals(idType)) {
            person = this.userManageService.getUserByCode(idCode);
        } else if ("1".equals(idType)) {
            person = this.userManageService.getUserByIdentifer(idCode);
        } else if ("2".equals(idType)) {
            person = this.userManageService.getUserByMobile(idCode);
        }
        if (person == null) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.person.notExit"));
        }
        if (!Md5PwdEncoder.getInstance().encodePassword(password).equals(person.getPassword())) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.person.passwordErr"));
        }
        if (this.loginService.judgeIslock2(person)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.person.isLock"));
        }
        return person;
    }

    private Device checkDrivceBinding(Person person, String iccid, String imsi, String imei, String currentVersion) throws Exception {
        if (StringUtils.isBlank((CharSequence)iccid)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.iccid.isBlank"));
        }
        Device device = this.deviceService.getByCardNO(iccid);
        if (device == null) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.iccid.notExit"));
        }
        Terminal terminal = device.getTerminal();
        log.info("updateTerminal.......");
        terminal.setPoliceAppVersion(currentVersion);
        TerminalBean terminalBean = new TerminalBean();
        BeanUtils.copyProperties((Object)terminal, (Object)terminalBean);
        this.terminalService.update(terminalBean);
        log.info("get Device....");
        log.info(device.getType() + ":" + device.getState() + ":" + device.getFlag() + ":" + device.getLockState());
        if ("3".equals(device.getState()) && "1".equals(device.getFlag()) && "0".equals(device.getLockState())) {
            String scBindType = device.getBindingState();
            if (StringUtils.isBlank((CharSequence)scBindType)) {
                log.info("has not bingType");
                try {
                    scBindType = this.scps.getValueByCode("terminalbindtype");
                }
                catch (Exception e) {
                    throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.config.codeBanding"));
                }
                device.setBindingState(scBindType);
            }
            if ("0".equals(scBindType)) {
                log.info("type=0 \u4e0d\u7ed1\u5b9a");
            } else {
                String[] bingTypes;
                for (String bingType : bingTypes = scBindType.split(",")) {
                    boolean isExist;
                    if ("1".equals(bingType)) {
                        if (person.getId().equals(device.getPersonId())) continue;
                        throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.person.IdnotMatch"));
                    }
                    if ("3".equals(bingType)) {
                        if (StringUtils.isBlank((CharSequence)imei)) {
                            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.isBlank"));
                        }
                        if (imei.length() > 32) {
                            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.tooLong"));
                        }
                        if (StringUtils.isBlank((CharSequence)device.getImei())) {
                            log.info("\u9996\u6b21\u4f7f\u7528\uff0c\u5199\u5165\u4fe1\u606f:" + imei);
                            isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                            if (isExist) {
                                throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.isExist"));
                            }
                            device.setImei(imei);
                            this.deviceService.update(device);
                            log.info("imei\u4fe1\u606f\u5199\u5165\u6210\u529f");
                            continue;
                        }
                        if (imei.equals(device.getImei())) continue;
                        throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imei.notMatch"));
                    }
                    if (!"2".equals(bingType)) continue;
                    if (StringUtils.isBlank((CharSequence)imsi)) {
                        throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.isBlank"));
                    }
                    if ("000000000000000".equals(imsi)) {
                        throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.test15Zero"));
                    }
                    if (imsi.length() > 32) {
                        throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.tooLong"));
                    }
                    if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                        log.info("\u9996\u6b21\u4f7f\u7528\uff0c\u5199\u5165\u4fe1\u606f:" + imsi);
                        isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                        if (isExist) {
                            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.isExist"));
                        }
                        device.setImsi(imsi);
                        this.deviceService.update(device);
                        log.info("imsi\u4fe1\u606f\u5199\u5165\u6210\u529f");
                        continue;
                    }
                    if (imsi.equals(device.getImsi())) continue;
                    throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.imsi.notMatch"));
                }
            }
        } else {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.iccid.unActive"));
        }
        return device;
    }

    private boolean checkVersion(String currentVersion, String terminalOS) throws Exception {
        HashMap map = new HashMap();
        String islimit = this.scps.getValueByCode(terminalOS + ".islimit");
        String appVersion = this.scps.getValueByCode(terminalOS + ".appVersion");
        if (islimit == null || appVersion == null || appVersion.lastIndexOf(".") < 0) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.config.version"));
        }
        String patternString = appVersion.substring(0, appVersion.lastIndexOf(".")) + ".\\d+";
        log.info("compare>" + currentVersion + ":" + appVersion);
        if (islimit.equals("0")) {
            return true;
        }
        if (currentVersion.matches(patternString)) {
            int limit;
            int curr = Integer.valueOf(currentVersion.substring(currentVersion.lastIndexOf(".") + 1));
            return curr >= (limit = Integer.valueOf(appVersion.substring(appVersion.lastIndexOf(".") + 1)).intValue());
        }
        return false;
    }

    @Override
    public String onlineadd(String jh) {
        try {
            Person person = this.userManageService.getUserByCode(jh);
            person.setClientLoginTime(new Date());
            this.userManageService.updateClientLoginTime(person);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageManager.getProMessage(this.message, "webservice.rp.error.onlineadd");
        }
        return "00";
    }

    @Override
    public String onlineremove(String jh) {
        try {
            Person person = this.userManageService.getUserByCode(jh);
            person.setClientLoginTime(null);
            this.userManageService.updateClientLoginTime(person);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageManager.getProMessage(this.message, "webservice.rp.error.onlineremove");
        }
        return "00";
    }

    @Override
    public String changeUserPassword(String strName, String strPass, String strType) {
        if (!"0".equals(strType)) {
            return MessageManager.getProMessage(this.message, "webservice.rp.error.changeUserPassword.onlypolice");
        }
        try {
            Person person = this.userManageService.getUserByCode(strName);
            person.setPassword(Md5PwdEncoder.getInstance().encodePassword(strPass));
            this.userManageService.updateUser(person);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageManager.getProMessage(this.message, "webservice.rp.error.changeUserPassword");
        }
        return "11";
    }

    @Override
    public String pwdUpdate(String strName, String strPass, String strType, String oldPwd) {
        if (!"0".equals(strType)) {
            return MessageManager.getProMessage(this.message, "webservice.rp.error.pwdUpdate.onlypolice");
        }
        if (oldPwd == null) {
            return MessageManager.getProMessage(this.message, "webservice.rp.error.pwdUpdate.noOldPwd");
        }
        try {
            Person person = this.userManageService.getUserByCode(strName);
            if (!person.getPassword().equals(Md5PwdEncoder.getInstance().encodePassword(oldPwd))) {
                return MessageManager.getProMessage(this.message, "webservice.rp.error.pwdUpdate.oldPwdNotRight");
            }
            person.setPassword(Md5PwdEncoder.getInstance().encodePassword(strPass));
            this.userManageService.updateUser(person);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageManager.getProMessage(this.message, "webservice.rp.error.pwdUpdate");
        }
        return "11";
    }

    @Override
    @Transactional
    public String useBillValidateUser(String loginXml) {
        StringBuilder returnXml = new StringBuilder();
        returnXml.append("<?xml version='1.0' encoding='UTF-8'?>");
        returnXml.append("<Root>");
        try {
            log.info("parseXml.......");
            Map<String, String> parseResultMap = this.parseXml(loginXml);
            String idType = parseResultMap.get("idType");
            String idCode = parseResultMap.get("idCode");
            String password = parseResultMap.get("password");
            String currentVersion = parseResultMap.get("currentVersion");
            String iccid = parseResultMap.get("iccid");
            String imei = parseResultMap.get("imei");
            String imsi = parseResultMap.get("imsi");
            log.info("checkNull.......");
            this.checkNull(idType, idCode, currentVersion);
            log.info("checkUser.......");
            Person person = this.checkUser(idType, idCode);
            boolean ifCheckDeivce = Boolean.parseBoolean(this.scps.getValueByCode("ifCheckDeivce"));
            if (ifCheckDeivce) {
                log.info("checkDrivceBinding.......");
                Device device = this.checkDrivceBinding(person, iccid, imsi, imei, currentVersion);
            }
            log.info("updateClientLoginTime byPersonId:" + person.getId());
            person.setClientLoginTime(new Date());
            this.userManageService.updateClientLoginTime(person);
            StringBuffer powerStr = new StringBuffer();
            log.info("queryPersonTerminalPowerList.......");
            log.info("personID:" + person.getId());
            Map<String, GprsMenu> gprspower = this.userPowerService.queryPersonTerminalPowerList(person.getId());
            for (GprsMenu code : gprspower.values()) {
                powerStr.append(code.getC_qx()).append("#");
            }
            if (powerStr.indexOf("#") > 0) {
                powerStr = new StringBuffer(powerStr.substring(0, powerStr.lastIndexOf("#")));
            }
            log.info("PersonTerminalPowerList:" + powerStr);
            int ifChange = 1;
            int pwd_modify_month = 3;
            try {
                pwd_modify_month = Integer.parseInt(this.scps.getValueByCode("pwdModifyMonthBetween"));
            }
            catch (Exception e) {
                pwd_modify_month = 3;
                log.error("\u5bc6\u7801\u53d8\u52a8\u9650\u5236\u914d\u7f6e\u9879\u9519\u8bef");
            }
            Date lastChangePwdDate = person.getLastChangePwDate();
            if (lastChangePwdDate == null) {
                ifChange = 1;
            } else {
                Calendar calender = Calendar.getInstance();
                calender.add(2, -pwd_modify_month);
                ifChange = lastChangePwdDate.before(calender.getTime()) ? 1 : 0;
            }
            List<Mobile> mobileList = person.getMobiledList();
            if (mobileList != null && mobileList.size() > 0) {
                person.setMobile(mobileList.get(0).getMobile());
            }
            returnXml.append("<ErrMsg/>");
            returnXml.append("<PoliceID>").append(person.getId()).append("</PoliceID>");
            returnXml.append("<PoliceNum>").append(person.getCode()).append("</PoliceNum>");
            returnXml.append("<PoliceName>").append(person.getName()).append("</PoliceName>");
            returnXml.append("<IDCard>").append(person.getIdentifier()).append("</IDCard>");
            returnXml.append("<MobileNum>").append(person.getMobile()).append("</MobileNum>");
            returnXml.append("<DeptID>").append(person.getDepId()).append("</DeptID>");
            returnXml.append("<UnitCode>").append(person.getDepartment().getCode()).append("</UnitCode>");
            returnXml.append("<UnitName>").append(person.getDepartment().getName()).append("</UnitName>");
            returnXml.append("<Month3Pwd>").append(ifChange).append("</Month3Pwd>");
            returnXml.append("<Password>").append(person.getPassword()).append("</Password>");
            returnXml.append("<Power>").append(powerStr).append("</Power>");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnXml.append("<ErrMsg>").append(MessageManager.getProMessage(this.message, "webservice.rp.error.badLogin")).append(e.getMessage()).append("</ErrMsg>");
        }
        returnXml.append("</Root>");
        log.info("validateUser returnXML\uff1a" + returnXml.toString());
        return returnXml.toString();
    }

    private Person checkUser(String idType, String idCode) throws Exception {
        Person person = null;
        person = this.userManageService.getUserByCode(idCode);
        if (person == null) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.person.notExit"));
        }
        if (this.loginService.judgeIslock2(person)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.person.isLock"));
        }
        return person;
    }

    private void checkNull(String idType, String idCode, String currentVersion) throws Exception {
        if (StringUtils.isBlank((CharSequence)idType)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.idType.isBlank"));
        }
        if (StringUtils.isBlank((CharSequence)idCode)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.idCode.isBlank"));
        }
        if (StringUtils.isBlank((CharSequence)currentVersion)) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.currentVersion.isBlank"));
        }
        if (currentVersion.length() > 32) {
            throw new Exception(MessageManager.getProMessage(this.message, "webservice.rp.error.currentVersion.tooLong"));
        }
    }

    @Override
    public int clientVerify(String clientInfo) {
        log.debug("\u8f93\u5165\u53c2\u6570:" + clientInfo);
        if (StringUtils.isBlank((CharSequence)clientInfo) || clientInfo.indexOf(";") == -1) {
            return 5;
        }
        String[] info = clientInfo.split(";");
        if (info.length < 2) {
            return 5;
        }
        String iccid = info[1];
        String imei = null;
        if (info.length > 2) {
            imei = info[2];
        }
        String imsi = null;
        if (info.length > 3) {
            imsi = info[3];
        }
        if (StringUtils.isBlank((CharSequence)iccid)) {
            return 1;
        }
        if (StringUtils.isBlank((CharSequence)imei)) {
            // empty if block
        }
        if (StringUtils.isBlank((CharSequence)imsi)) {
            // empty if block
        }
        return this.checkBind(iccid, imei, imsi);
    }

    private int checkBind(String iccid, String imei, String imsi) {
        Device device = this.deviceService.getByCardNO(iccid);
        String verifyType = this.scps.getValueByCode("_B_CheckDeivce");
        QueryForm form = null;
        if ("0".equals(verifyType)) {
            return 0;
        }
        if ("1".equals(verifyType)) {
            if (device != null) {
                return 0;
            }
            return 1;
        }
        if (device == null) {
            return 1;
        }
        if ("2".equals(device.getType())) {
            return 0;
        }
        if ("2".equals(verifyType)) {
            form = new QueryForm();
            form.setImei(imei);
            if (this.checkDeviceExit(form)) {
                return 0;
            }
            return 2;
        }
        if ("3".equals(verifyType)) {
            form = new QueryForm();
            form.setImsi(imsi);
            if (this.checkDeviceExit(form)) {
                return 0;
            }
            return 3;
        }
        if ("4".equals(verifyType)) {
            if (null == device) {
                return 1;
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                boolean isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                if (isExist) {
                    return 2;
                }
                try {
                    device.setImei(imei);
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return 6;
                }
                return 0;
            }
            if (device.getImei().equals(imei)) {
                return 0;
            }
            return 2;
        }
        if ("5".equals(verifyType)) {
            if (null == device) {
                return 1;
            }
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                boolean isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                if (isExist) {
                    return 3;
                }
                try {
                    device.setImsi(imsi);
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return 6;
                }
                return 0;
            }
            if (device.getImsi().equals(imsi)) {
                return 0;
            }
            return 3;
        }
        if ("6".equals(verifyType)) {
            form = new QueryForm();
            form.setImsi(imsi);
            form.setImei(imei);
            if (this.checkDeviceExit(form)) {
                return 0;
            }
            return 3;
        }
        if ("7".equals(verifyType)) {
            boolean isExist;
            if (null == device) {
                return 1;
            }
            boolean isSaveInfo = false;
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                if (isExist) {
                    return 3;
                }
                isSaveInfo = true;
                device.setImsi(imsi);
            } else if (!device.getImsi().equals(imsi)) {
                return 3;
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                if (isExist) {
                    return 2;
                }
                isSaveInfo = true;
                device.setImei(imei);
            } else if (!device.getImei().equals(imei)) {
                return 2;
            }
            if (isSaveInfo) {
                try {
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return 6;
                }
            }
            return 0;
        }
        return 0;
    }

    private boolean checkDeviceExit(QueryForm form) {
        Page page = new Page();
        page.setPage(1);
        page.setRp(1);
        List<Device> list = this.deviceService.queryDeviceByImeiImsiIccid(form, page);
        return list != null && list.size() > 0;
    }

    @Override
    @Transactional
    public String clientVerifyStr(String clientInfo) {
        log.debug("\u8f93\u5165\u53c2\u6570:" + clientInfo);
        if (StringUtils.isBlank((CharSequence)clientInfo) || clientInfo.indexOf(";") == -1) {
            return "5:\u5176\u5b83\u9519\u8bef";
        }
        String[] info = clientInfo.split(";");
        if (info.length < 2) {
            return "5:\u5176\u5b83\u9519\u8bef";
        }
        String iccid = info[1];
        String imei = null;
        if (info.length > 2) {
            imei = info[2];
        }
        String imsi = null;
        if (info.length > 3) {
            imsi = info[3];
        }
        if (StringUtils.isBlank((CharSequence)iccid)) {
            return "1:\u5b89\u5168\u5361\u9a8c\u8bc1\u5931\u8d25";
        }
        if (StringUtils.isBlank((CharSequence)imei)) {
            // empty if block
        }
        if (StringUtils.isBlank((CharSequence)imsi)) {
            // empty if block
        }
        String checkStrategy = this.scps.getValueByCode("strategy_check");
        boolean validPass = true;
        if ("1".equals(checkStrategy)) {
            log.debug("\u5f00\u542f\u7b56\u7565\u6821\u9a8c:" + clientInfo);
            if (this.validTerminalList(info, "1")) {
                validPass = true;
            } else if (this.validStrategy(info)) {
                if (this.validTerminalList(info, "2")) {
                    validPass = false;
                }
            } else {
                validPass = false;
            }
        }
        if (!validPass) {
            log.debug("\u7b56\u7565\u9a8c\u8bc1\u5931\u8d25,\u8bb0\u5f55\u62e6\u622a\u65e5\u5fd7");
            this.saveStragegyLog(info);
            return "8:\u7b56\u7565\u9a8c\u8bc1\u5931\u8d25";
        }
        return this.checkBindStr(iccid, imei, imsi);
    }

    private void saveStragegyLog(String[] info) {
        String[] osArr;
        StrategyLog entity = new StrategyLog();
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 5; i < info.length; ++i) {
            String[] arr;
            if (!StringUtils.isNotBlank((CharSequence)info[i]) || (arr = info[i].split(":")).length < 1) continue;
            params.put(arr[0], arr.length > 1 ? arr[1] : "");
        }
        entity.setCardId(info[1]);
        entity.setImei(info[2]);
        entity.setImsi(info[3]);
        entity.setTerminalType(info[0]);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("OS"))) && (osArr = ((String)params.get("OS")).split(",")).length > 1) {
            entity.setOsVersion(osArr[1]);
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("CT")))) {
            entity.setCardType((String)params.get("CT"));
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("DEVICE")))) {
            entity.setDeviceType((String)params.get("DEVICE"));
        }
        this.strategyLogService.add(entity);
    }

    private boolean validTerminalList(String[] info, String type) {
        List<StrategyTerminal> list;
        StrategyTerminalBean queryBean = new StrategyTerminalBean();
        queryBean.setState("1");
        queryBean.setType(type);
        if (info.length > 1) {
            queryBean.setCardId(info[1]);
        }
        if (info.length > 2) {
            queryBean.setImei(info[2]);
        }
        if (info.length > 3) {
            queryBean.setImsi(info[3]);
        }
        return !CollectionUtils.isEmpty(list = this.strategyTerminalService.queryList(queryBean, null));
    }

    private boolean validStrategy(String[] info) {
        String[] osArr;
        ArrayList<String> interceptStrategyList = new ArrayList<String>();
        ArrayList<String> releaseStrategyList = new ArrayList<String>();
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 5; i < info.length; ++i) {
            String[] arr;
            if (!StringUtils.isNotBlank((CharSequence)info[i]) || (arr = info[i].split(":")).length < 1) continue;
            params.put(arr[0], arr.length > 1 ? arr[1] : "");
        }
        if ("ANDROID".equals(info[0]) && info.length < 9 && !params.containsKey("PRJTAG")) {
            log.debug("\u672a\u5347\u7ea7\u5b89\u5168\u63a5\u5165\u4e0d\u8fdb\u884c\u6821\u9a8c");
            return true;
        }
        if (!"ANDROID".equals(info[0]) && !params.containsKey("PRJTAG")) {
            log.debug("\u672a\u5347\u7ea7\u5b89\u5168\u63a5\u5165\u4e0d\u8fdb\u884c\u6821\u9a8c");
            return true;
        }
        releaseStrategyList.add("TERMINAL_TYPE=" + info[0]);
        interceptStrategyList.add("TERMINAL_TYPE<>" + info[0]);
        params.put("TERMINAL_TYPE", info[0]);
        String cardId = info[1];
        Device device = this.deviceService.getByCardNO(cardId);
        if (device != null) {
            Person p = this.userManageService.queryPersonById(device.getPersonId());
            releaseStrategyList.add("PERSON_TYPE=" + p.getPersonType());
            interceptStrategyList.add("PERSON_TYPE<>" + p.getPersonType());
            params.put("PERSON_TYPE", p.getPersonType());
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("CT")))) {
            releaseStrategyList.add("CARD_TYPE=" + (String)params.get("CT"));
            interceptStrategyList.add("CARD_TYPE<>" + (String)params.get("CT"));
            params.put("CARD_TYPE", (String)params.get("CT"));
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("DEVICE")))) {
            releaseStrategyList.add("DEVICE_TYPE=" + (String)params.get("DEVICE"));
            interceptStrategyList.add("DEVICE_TYPE<>" + (String)params.get("DEVICE"));
            params.put("DEVICE_TYPE", (String)params.get("DEVICE"));
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)params.get("OS"))) && (osArr = ((String)params.get("OS")).split(",")).length > 1) {
            releaseStrategyList.add("OS_VERSION=" + osArr[1]);
            interceptStrategyList.add("OS_VERSION<>" + osArr[1]);
            params.put("OS_VERSION", osArr[1]);
        }
        StrategyMainBean queryBean = new StrategyMainBean();
        queryBean.setReleaseStrategyList(releaseStrategyList);
        queryBean.setInterceptStrategyList(interceptStrategyList);
        queryBean.setState("1");
        List<StrategyMain> list = this.strategyMainService.queryList(queryBean, null);
        if (CollectionUtils.isEmpty(list)) {
            log.debug("\u65e0\u53ef\u7528\u7684\u901a\u884c\u7b56\u7565");
            return false;
        }
        List<StrategyInfo> infoList = null;
        block1: for (StrategyMain strategyMain : list) {
            infoList = this.strategyInfoService.queryList(strategyMain.getId());
            StringBuffer strategyOp = null;
            for (int i = 0; i < infoList.size(); ++i) {
                if (params.containsKey(infoList.get(i).getType())) {
                    strategyOp = new StringBuffer();
                    strategyOp.append(infoList.get(i).getType()).append(infoList.get(i).getOperator()).append(infoList.get(i).getStrategy());
                    if ("=".equals(infoList.get(i).getOperator()) && !releaseStrategyList.contains(strategyOp.toString()) || !releaseStrategyList.contains(strategyOp.toString()) && interceptStrategyList.contains(strategyOp.toString())) continue block1;
                }
                if (i != infoList.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    private String checkBindStr(String iccid, String imei, String imsi) {
        String verifyType = this.scps.getValueByCode("_B_CheckDeivce");
        Device device = this.deviceService.getByCardNO(iccid);
        if (null == device) {
            String supportThird = this.scps.getValueByCode("_B_SUPPROT_THIRD");
            if ("1".equals(supportThird) || "0".equals(verifyType)) {
                return "0:\u9a8c\u8bc1\u6210\u529f";
            }
            return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
        }
        QueryForm form = null;
        Person person = this.userManageService.queryPersonById(device.getPersonId());
        String personStr = this.transPersonStr(person);
        if ("0".equals(verifyType)) {
            return "0:" + personStr;
        }
        if ("1".equals(verifyType)) {
            if (device != null) {
                return "0:" + personStr;
            }
            return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("2".equals(device.getType())) {
            return "0:" + personStr;
        }
        if ("2".equals(verifyType)) {
            form = new QueryForm();
            form.setImei(imei);
            if (this.checkDeviceExit(form)) {
                return "0:" + personStr;
            }
            return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("3".equals(verifyType)) {
            form = new QueryForm();
            form.setImsi(imsi);
            if (this.checkDeviceExit(form)) {
                return "0:" + personStr;
            }
            return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("4".equals(verifyType)) {
            if (null == device) {
                return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                boolean isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                if (isExist) {
                    return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
                }
                try {
                    device.setImei(imei);
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return "6:\u6821\u9a8c\u5931\u8d25\uff0c\u4fdd\u5b58\u4fe1\u606f\u65f6\u51fa\u9519";
                }
                return "0:" + personStr;
            }
            if (device.getImei().equals(imei)) {
                return "0:" + personStr;
            }
            return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("5".equals(verifyType)) {
            if (null == device) {
                return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
            }
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                boolean isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                if (isExist) {
                    return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
                }
                try {
                    device.setImsi(imsi);
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return "6:\u6821\u9a8c\u5931\u8d25\uff0c\u4fdd\u5b58\u4fe1\u606f\u65f6\u51fa\u9519";
                }
                return "0:" + personStr;
            }
            if (device.getImsi().equals(imsi)) {
                return "0:" + personStr;
            }
            return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("6".equals(verifyType)) {
            form = new QueryForm();
            form.setImsi(imsi);
            form.setImei(imei);
            if (this.checkDeviceExit(form)) {
                return "0:" + personStr;
            }
            return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
        }
        if ("7".equals(verifyType)) {
            boolean isExist;
            if (null == device) {
                return "1:\u5b89\u5168TF\u5361\u9a8c\u8bc1\u5931\u8d25";
            }
            boolean isSaveInfo = false;
            if (StringUtils.isBlank((CharSequence)device.getImsi())) {
                isExist = this.deviceService.isExistImeiOrImsi(imsi, "imsi");
                if (isExist) {
                    return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
                }
                isSaveInfo = true;
                device.setImsi(imsi);
            } else if (!device.getImsi().equals(imsi)) {
                return "3:SIM\u5361IMSI\u9a8c\u8bc1\u5931\u8d25";
            }
            if (StringUtils.isBlank((CharSequence)device.getImei())) {
                isExist = this.deviceService.isExistImeiOrImsi(imei, "imei");
                if (isExist) {
                    return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
                }
                isSaveInfo = true;
                device.setImei(imei);
            } else if (!device.getImei().equals(imei)) {
                return "2:\u624b\u673aIMEI\u9a8c\u8bc1\u5931\u8d25";
            }
            if (isSaveInfo) {
                try {
                    this.deviceService.update(device);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58imei\u4fe1\u606f\u51fa\u9519", (Throwable)e);
                    return "6:\u6821\u9a8c\u5931\u8d25\uff0c\u4fdd\u5b58\u4fe1\u606f\u65f6\u51fa\u9519";
                }
            }
            return "0:" + personStr;
        }
        return "0:" + personStr;
    }

    private String transPersonStr(Person person) {
        String showInfo = "<html>\n<head>\n<meta charset=\"utf-8\">\n<title>\u7528\u6237\u4fe1\u606f</title>\n\n<style>\n.infolist ul {\n    padding: 0;\n    margin: 0;\n    margin-top: 0.3ex;\n}\n\n.infolist ul li {\n    list-style-type: none; \n    display: inline;\n}\n\nli.key {\n    float: left;\n    width: 5em;\n    color: #606060;\n}\n\nli.key:after {\n    content: \"\uff1a\";\n}\n\nli.value {\n    color: #303030;\n}\n</style>\n\n</head>\n\n<body>\n<div class=\"infolist\">\n<ul>\n<li class=\"key\">\u59d3\u540d</li>\n<li class=\"value\">" + person.getName() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u8b66\u53f7</li>\n<li class=\"value\">" + person.getCode() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u804c\u52a1</li>\n<li class=\"value\">" + this.commonCodePbService.getCodeNameByCode(person.getPosition(), "2011") + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u624b\u673a\u53f7</li>\n<li class=\"value\">" + person.getMobile() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u8eab\u4efd\u8bc1\u53f7</li>\n<li class=\"value\">" + person.getIdentifier() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u8b66\u79cd</li>\n<li class=\"value\">" + this.commonCodePbService.getCodeNameByCode(person.getPolice(), "2012") + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u5355\u4f4d\u540d\u79f0</li>\n<li class=\"value\">" + person.getDepartment().getName() + "</li>\n</ul>\n<ul>\n<li class=\"key\">\u5355\u4f4d\u7f16\u53f7</li>\n<li class=\"value\">" + person.getDepCode() + "</li>\n</ul>\n</div>\n</body>\n</html>\n";
        return showInfo;
    }
}

