/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.wfms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.FileUtil;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.wfms.bean.WorkflowDeployParam;
import com.xdja.pams.wfms.bean.WorkflowDeployParamIn;
import com.xdja.pams.wfms.service.WorkflowManagerService;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Scope(value="session")
public class WorkflowDeployControler
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(WorkflowDeployControler.class);
    @Autowired
    private IdentityService identityService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private WorkflowManagerService wms;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigPbService scps;

    @RequestMapping(value={"/wfms/workflowDeployControler/workflowDeployManager.do"})
    public String workflowDeployManager(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/wfms/workflowDeployControler/showAddWorkflowPage.do"})
    public String showAddWorkflowPage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = null;
        try {
            sendUrl = page.getSendUrl();
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return "wfms/default/addWorkflow";
    }

    @RequestMapping(value={"/wfms/workflowDeployControler/getWorkflowDeployList.do"})
    public void getWorkflowDeployList(WorkflowDeployParamIn paramIn, PageParam p, HttpServletRequest request, HttpServletResponse response) {
        int operateResult = 1;
        String jsonStr = "";
        try {
            ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
            if (!Util.varCheckEmp(paramIn.getId())) {
                processDefinitionQuery = processDefinitionQuery.processDefinitionId(paramIn.getId());
            }
            if (!Util.varCheckEmp(paramIn.getKey())) {
                processDefinitionQuery = processDefinitionQuery.processDefinitionKeyLike("%" + paramIn.getKey() + "%");
            }
            if (!Util.varCheckEmp(paramIn.getName())) {
                processDefinitionQuery = processDefinitionQuery.processDefinitionNameLike("%" + paramIn.getName() + "%");
            }
            if (!Util.varCheckEmp(paramIn.getSuspended())) {
                processDefinitionQuery = "true".equals(paramIn.getSuspended()) ? processDefinitionQuery.suspended() : processDefinitionQuery.active();
            }
            if (!"true".equals(paramIn.getLatestVersion())) {
                processDefinitionQuery = processDefinitionQuery.latestVersion();
            }
            Page page = new Page(p.getPage(), p.getRows());
            List processDefinitionList = ((ProcessDefinitionQuery)processDefinitionQuery.orderByProcessDefinitionVersion().desc()).listPage(page.getFirstResult(), page.getRp());
            page.setTotal((int)processDefinitionQuery.count());
            ArrayList<WorkflowDeployParam> rtnList = new ArrayList<WorkflowDeployParam>();
            for (ProcessDefinition processDefinition : processDefinitionList) {
                String deploymentId = processDefinition.getDeploymentId();
                Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
                WorkflowDeployParam wdp = new WorkflowDeployParam();
                BeanUtils.copyProperties((Object)wdp, (Object)processDefinition);
                wdp.setDeployDate(Util.getDate("yyyy-MM-dd HH:mm:ss", deployment.getDeploymentTime()));
                rtnList.add(wdp);
            }
            HashMap<String, Serializable> rtnMap = new HashMap<String, Serializable>();
            rtnMap.put("total", Integer.valueOf(page.getTotal()));
            rtnMap.put("rows", rtnList == null ? new ArrayList<WorkflowDeployParam>() : rtnList);
            jsonStr = Util.toJsonStr(rtnMap);
        }
        catch (Exception e1) {
            log.error("\u83b7\u53d6\u6d41\u7a0b\u90e8\u7f72\u5b9a\u4e49\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
            jsonStr = "";
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, jsonStr);
    }

    @RequestMapping(value={"/wfms/workflowDeployControler/deleteWorkflowDeploy.do"})
    public void deleteWorkflowDeploy(HttpServletRequest request, HttpServletResponse response, String deploymentId) {
        ReturnResult rr = new ReturnResult();
        int operateResult = 1;
        try {
            if (!Util.varCheckEmp(deploymentId)) {
                this.wms.deleteWorkflowDeploy(deploymentId, this.getWorkFlowFilePath(request));
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e) {
            operateResult = 0;
            log.info("\u5220\u9664\u6d41\u7a0b\u5931\u8d25\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 4, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/wfms/workflowDeployControler/uploadWordflowFile.do"})
    public void deploy(HttpServletRequest request, HttpServletResponse response, String wftId, @RequestParam(value="wofkflowFile", required=false) MultipartFile wofkflowFile) {
        ReturnResult rr = new ReturnResult();
        int operateResult = 1;
        try {
            String fileName = wofkflowFile.getOriginalFilename();
            long fileSize = FileUtil.FormetFileSizeToMLong(wofkflowFile.getSize());
            Long maxSize = Long.parseLong(this.scps.getValueByCode("workflowMaxSize"));
            if (maxSize < fileSize) {
                operateResult = 0;
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "device.apply.page.msg.maxsize", new String[]{String.valueOf(maxSize)}));
            } else {
                InputStream fileInputStream = wofkflowFile.getInputStream();
                boolean rtn = this.wms.uploadWordflowFile(fileInputStream, this.getWorkFlowFilePath(request), fileName);
                if (rtn) {
                    rr.setRtnCode("0");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
                } else {
                    operateResult = 0;
                    rr.setRtnCode("1");
                    rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
                }
            }
        }
        catch (Exception e) {
            operateResult = 0;
            log.error("\u4e0a\u4f20\u6d41\u7a0b\u6587\u4ef6\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 2, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text1(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"/wfms/workflowDeployControler/wordflowResource.do"})
    public void loadByDeployment(String processDefinitionId, String resourceType, HttpServletResponse response) throws Exception {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        String resourceName = "";
        if ("image".equals(resourceType)) {
            resourceName = processDefinition.getDiagramResourceName();
        } else if ("xml".equals(resourceType)) {
            resourceName = processDefinition.getResourceName();
        }
        InputStream resourceAsStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), resourceName);
        byte[] b = new byte[1024];
        int len = -1;
        while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
    }

    @RequestMapping(value={"/wfms/workflowDeployControler/workflowActiveAndSuspend.do"})
    public void updateState(String action, String processDefinitionId, HttpServletResponse response) {
        ReturnResult rr = new ReturnResult();
        try {
            if ("active".equals(action)) {
                this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else if ("suspend".equals(action)) {
                this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
            }
        }
        catch (Exception e) {
            log.info("\u6d41\u7a0b\u6302\u8d77\u6216\u6fc0\u6d3b\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    private String getWorkFlowFilePath(HttpServletRequest request) {
        return request.getSession().getServletContext().getRealPath(this.scps.getValueByCode("workFlowFilePath"));
    }
}

