/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.entity;

import com.xdja.pams.bims.entity.BimsGroup;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.excel.ExcelCell;
import com.xdja.pams.upms.entity.Role;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.Where;

@Entity
@Table(name="t_department")
public class Department
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    @Column(name="CODE", length=12)
    @ExcelCell
    private String code;
    @Column(name="NAME", length=128)
    @ExcelCell
    private String name;
    @ExcelCell
    private String nameAbbr;
    private String parentID;
    private Department parentDep;
    private String parentID2;
    @ExcelCell
    private String linkman;
    @ExcelCell
    private String phone;
    private String isDirectDep;
    private String level;
    private int count;
    private long timestamp = System.currentTimeMillis();
    private String note;
    private long orderField = 999L;
    private String flag;
    private String displayState = "1";
    private List<Person> personList;
    private List<BimsGroup> groupList;
    @JsonIgnore
    private List<Role> roleList;
    private List<Person> controlDepPersonList;
    private List<Department> childDeps;
    private String depType;
    private String treeId;
    private String treeCode;

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @Column(name="ID", length=32)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="name", length=128, nullable=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="DEP_ABB", length=128)
    public String getNameAbbr() {
        return this.nameAbbr;
    }

    public void setNameAbbr(String nameAbbr) {
        this.nameAbbr = nameAbbr;
    }

    @Column(name="code", length=12, nullable=false)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="PARENT_ID", length=255, updatable=false, insertable=false)
    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    @Column(name="PARENT_ID2", length=255)
    public String getParentID2() {
        return this.parentID2;
    }

    public void setParentID2(String parentID2) {
        this.parentID2 = parentID2;
    }

    @Column(name="phone", length=20)
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Column(name="contact", length=16)
    public String getLinkman() {
        return this.linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    @Column(name="direct", length=1)
    public String getIsDirectDep() {
        return this.isDirectDep;
    }

    public void setIsDirectDep(String isDirectDep) {
        this.isDirectDep = isDirectDep;
    }

    @Column(name="grade", length=1)
    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    @Column(name="amount", length=6)
    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Column(name="N_LAST_UPDATE_TIME", length=20)
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Column(name="note", length=100)
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Column(name="order_field", length=6, nullable=false)
    public long getOrderField() {
        return this.orderField;
    }

    public void setOrderField(long orderField) {
        this.orderField = orderField;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    @OneToMany
    @JoinColumn(name="dep_id")
    @Where(clause="flag=0")
    @OrderBy(clause="order_field")
    public List<Person> getPersonList() {
        return this.personList;
    }

    public void setPersonList(List<Person> personList) {
        this.personList = personList;
    }

    @ManyToMany
    @JoinTable(name="T_BIMS_PERSON_CONTROLDEP", joinColumns={@JoinColumn(name="dep_id")}, inverseJoinColumns={@JoinColumn(name="PERSON_ID")})
    public List<Person> getControlDepPersonList() {
        return this.controlDepPersonList;
    }

    public void setControlDepPersonList(List<Person> controlDepPersonList) {
        this.controlDepPersonList = controlDepPersonList;
    }

    @OneToMany
    @JoinColumn(name="dep_id")
    @Where(clause="flag=0")
    public List<BimsGroup> getGroupList() {
        return this.groupList;
    }

    public void setGroupList(List<BimsGroup> groupList) {
        this.groupList = groupList;
    }

    @ManyToOne
    @JoinColumn(name="parent_id")
    public Department getParentDep() {
        return this.parentDep;
    }

    public void setParentDep(Department parentDep) {
        this.parentDep = parentDep;
    }

    @OneToMany(mappedBy="parentDep", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    @Where(clause="flag=0")
    @OrderBy(clause="order_field,code")
    public List<Department> getChildDeps() {
        return this.childDeps;
    }

    public void setChildDeps(List<Department> childDeps) {
        this.childDeps = childDeps;
    }

    @ManyToMany(mappedBy="departmentSet", cascade={CascadeType.ALL})
    public List<Role> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<Role> roleList) {
        this.roleList = roleList;
    }

    @Column(name="DISPLAY_STATE", length=256)
    public String getDisplayState() {
        return this.displayState;
    }

    public void setDisplayState(String displayState) {
        this.displayState = displayState;
    }

    @Column(name="deptype", length=4)
    public String getDepType() {
        return this.depType;
    }

    public void setDepType(String depType) {
        this.depType = depType;
    }

    @Column(name="TREE_ID")
    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    @Column(name="TREE_CODE")
    public String getTreeCode() {
        return this.treeCode;
    }

    public void setTreeCode(String treeCode) {
        this.treeCode = treeCode;
    }
}

