/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.service.impl;

import com.xdja.pams.bims.bean.ImpDepExcelBean;
import com.xdja.pams.bims.bean.QueryDepBean;
import com.xdja.pams.bims.bean.TreeDep;
import com.xdja.pams.bims.dao.DepartmentDao;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.DepManageService;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.bims.util.DepCompare;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.report.bean.QueryForm;
import com.xdja.pams.scms.entity.WorkFlowControlDept;
import com.xdja.pams.sso.bean.SynQueryParam;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DepManageServiceImpl
implements DepManageService {
    @Autowired
    private DepartmentDao depDao;
    @Autowired
    private SystemConfigPbService scps;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private TokenFactory tokenFactory;
    private static final Logger log = LoggerFactory.getLogger(DepManageServiceImpl.class);

    @Override
    @Transactional
    public String addDep(Department dep) {
        if (StringUtils.isBlank((CharSequence)(dep.getOrderField() + ""))) {
            dep.setOrderField(999L);
        }
        dep.setFlag("0");
        String depId = this.depDao.addDepartment(dep);
        dep.setTreeId(dep.getParentDep().getTreeId() + depId + "-");
        dep.setTreeCode(dep.getParentDep().getTreeCode() + dep.getCode() + "-");
        this.depDao.updateDepartment(dep);
        this.syncWorkFlowControlDept(dep);
        return depId;
    }

    @Override
    @Transactional
    public String addDept(Department department) {
        if (StringUtils.isBlank((CharSequence)(department.getOrderField() + ""))) {
            department.setOrderField(999L);
        }
        department.setFlag("0");
        String depId = this.depDao.addDepartment(department);
        return depId;
    }

    @Override
    @Transactional
    public void deleteDepById(String id) {
        Department dep = this.depDao.queryDepartmentById(id);
        dep.setFlag("1");
        dep.setTimestamp(System.currentTimeMillis());
        this.depDao.deleteWorkFlowControlDeptByDepId(dep.getId());
        this.depDao.updateDepartment(dep);
    }

    @Override
    @Transactional
    public void updateDep(Department dep, boolean parentDepEditFlag) {
        dep.setTimestamp(System.currentTimeMillis());
        this.depDao.updateDepartment(dep);
        if (parentDepEditFlag) {
            this.changeChildDepsLevel(dep);
            QueryDepBean queryDepBean = new QueryDepBean();
            queryDepBean.setId(dep.getId());
            Page page = new Page();
            page.setPage(1);
            page.setRp(Integer.MAX_VALUE);
            List<Department> depList = this.queryDepList(queryDepBean, null, page);
            this.depDao.deleteWorkFlowControlDeptByDepId(dep.getId());
            this.syncWorkFlowControlDept(dep);
            if (depList != null && !depList.isEmpty()) {
                for (Department tmpDep : depList) {
                    if (dep.getId().equals(tmpDep.getId())) continue;
                    this.depDao.deleteWorkFlowControlDeptByDepId(tmpDep.getId());
                    this.syncWorkFlowControlDept(tmpDep);
                }
            }
        }
    }

    @Override
    @Transactional
    public void updateSingleDep(Department dep, boolean parentDepEditFlag) {
        log.debug("\u5f00\u59cb\u66f4\u65b0\u5355\u4f4d");
        dep.setTimestamp(System.currentTimeMillis());
        this.depDao.updateDepartment(dep);
        log.debug("\u66f4\u65b0\u5355\u4f4d\u6210\u529f");
        if (parentDepEditFlag) {
            QueryDepBean queryDepBean = new QueryDepBean();
            queryDepBean.setId(dep.getId());
            List<Department> depList = this.queryDepList(queryDepBean, null, null);
            log.debug("\u5f00\u59cb\u4fee\u6539\u7ba1\u8f96\u5173\u7cfb(\u6d41\u7a0b)");
            this.depDao.deleteWorkFlowControlDeptByDepId(dep.getId());
            this.syncWorkFlowControlDept(dep);
            if (depList != null && !depList.isEmpty()) {
                for (Department tmpDep : depList) {
                    log.debug("\u66f4\u65b0\u5355\u4f4d\u7ba1\u8f96\u8303\u56f4");
                    if (dep.getId().equals(tmpDep.getId())) continue;
                    this.depDao.deleteWorkFlowControlDeptByDepId(tmpDep.getId());
                    this.syncWorkFlowControlDept(tmpDep);
                }
            }
        }
    }

    @Transactional
    public void changeChildDepsLevel(Department dep) {
        List<Department> depList = dep.getChildDeps();
        if (depList == null || depList.size() == 0) {
            return;
        }
        for (Department department : depList) {
            department.setLevel(Integer.parseInt(dep.getLevel()) + 1 + "");
            department.setTreeId(dep.getTreeId() + department.getId() + "-");
            department.setTreeCode(dep.getTreeCode() + department.getCode() + "-");
            department.setTimestamp(System.currentTimeMillis());
            this.depDao.updateDepartment(department);
            this.changeChildDepsLevel(department);
        }
    }

    @Override
    public Department queryDepById(String depId) {
        return this.depDao.queryDepartmentById(depId);
    }

    @Override
    public Department getDepartmentByCode(String code) {
        String selectHql = "from Department as department where department.code=? and flag=0 ";
        String[] values = new String[]{code};
        return this.depDao.queryDepartmentByHql(selectHql, values);
    }

    @Override
    public List<Department> queryDepList(QueryDepBean queryDepBean, String controlDepIds, Page page) {
        StringBuilder selectHql = new StringBuilder("select * from t_department  department where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from t_department  department where 1=1 ");
        ArrayList<String> paramList = new ArrayList<String>();
        selectHql.append("and department.flag = ? ");
        countHql.append("and department.flag = ? ");
        paramList.add("0");
        if (StringUtils.isNotBlank((CharSequence)queryDepBean.getName())) {
            selectHql.append("and department.name like ? ");
            countHql.append("and department.name like ? ");
            paramList.add("%" + StringUtils.trim((String)queryDepBean.getName()) + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)queryDepBean.getCode())) {
            selectHql.append("and department.code like ? ");
            countHql.append("and department.code like ? ");
            paramList.add("%" + StringUtils.trim((String)queryDepBean.getCode()) + "%");
        }
        if (queryDepBean.getIsContain() != null && queryDepBean.getIsContain().contains("true")) {
            if (StringUtils.isNotBlank((CharSequence)queryDepBean.getId())) {
                selectHql.append("and department.Id in (" + BimsUtil.getChildDepsSql() + ")");
                countHql.append("and department.Id in (" + BimsUtil.getChildDepsSql() + ")");
                paramList.add(queryDepBean.getId());
            } else {
                selectHql.append("and department.Id  in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
                countHql.append("and department.Id  in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
            }
        } else if (StringUtils.isNotBlank((CharSequence)queryDepBean.getId())) {
            selectHql.append("and (department.Id = ? or department.Id in (" + BimsUtil.getChildDepsSql3() + "))");
            countHql.append("and (department.Id = ? or department.Id in (" + BimsUtil.getChildDepsSql3() + "))");
            paramList.add(queryDepBean.getId());
            paramList.add(queryDepBean.getId());
        } else {
            selectHql.append("and department.Id  in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
            countHql.append("and department.Id  in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
        }
        selectHql.append(" order by order_field,code asc ");
        BigDecimal total = (BigDecimal)this.baseDao.getObjectBySQL(countHql.toString(), paramList.toArray());
        page.setTotal(total.intValue());
        StringBuffer pagingSelect = new StringBuffer("select * from ( select row_.*, rownum rownum_ from ( ");
        pagingSelect.append((CharSequence)selectHql);
        pagingSelect.append(" ) row_ ) where rownum_ <= ? and rownum_ > ?");
        paramList.add(page.getPage() * page.getRp() + "");
        paramList.add((page.getPage() - 1) * page.getRp() + "");
        return this.baseDao.getListBySQL(pagingSelect.toString(), paramList.toArray(), Department.class);
    }

    @Override
    public List<Department> queryChildDepListByParentId(String parentId) {
        String hqlStr = "from Department d where d.parentID = ? and flag = ?";
        Object[] values = new String[]{parentId, "0"};
        return this.baseDao.getListByHQL(hqlStr, values);
    }

    @Override
    @Transactional
    public void importDep(MultipartFile file, Set<ImpDepExcelBean> wellList, List<ImpDepExcelBean> noParentList, List<ImpDepExcelBean> errorList, List<ImpDepExcelBean> codeExitList, Map totalCount, String depId, HttpServletRequest request) throws Exception {
        HashSet<ImpDepExcelBean> oldSet = new HashSet();
        HashSet<ImpDepExcelBean> newSet = new HashSet<ImpDepExcelBean>();
        String ticket = CookieUtils.getCookie(request, "operator", String.class);
        this.tokenFactory.getOperator().add("upload:dep:rate:" + ticket, "0");
        String[] colsName = new String[]{MessageManager.getProMessage(this.message, "bims.dep.page.info.depcode"), MessageManager.getProMessage(this.message, "bims.dep.page.info.depname"), MessageManager.getProMessage(this.message, "bims.dep.page.info.depnameabbr"), MessageManager.getProMessage(this.message, "bims.dep.page.info.linkman"), MessageManager.getProMessage(this.message, "bims.dep.page.info.phone")};
        log.info("parseExcel....");
        this.parseExcel(file, colsName, newSet, codeExitList);
        totalCount.put("totalCount", newSet.size() + codeExitList.size());
        oldSet = newSet;
        newSet = new HashSet();
        log.info("checkNull....");
        this.checkNull(oldSet, newSet, errorList);
        HashMap<String, String> codeIDMap = new HashMap<String, String>();
        HashMap<String, String> codeLevelMap = new HashMap<String, String>();
        HashMap<String, String> parentCodeNotExit = new HashMap<String, String>();
        oldSet = newSet;
        newSet = new HashSet();
        log.info("check....");
        this.check(oldSet, newSet, codeExitList, codeIDMap, codeLevelMap, parentCodeNotExit);
        oldSet = newSet;
        newSet = null;
        log.info("saveExcel....");
        this.saveExcel(oldSet, wellList, noParentList, errorList, codeIDMap, codeLevelMap, parentCodeNotExit, depId, request);
        this.tokenFactory.getOperator().add("upload:dep:rate:" + ticket, "1");
        this.initTreeId();
        this.initTreeCode();
    }

    private void initTreeId() {
        this.baseDao.flushSession();
        String sql = "update t_department d    set d.tree_id =        (select '-' || listagg(t.id, '-') within GROUP(order by t.grade) || '-' as ids           from t_department t          where t.flag = '0'          start with t.id = d.id         connect by prior t. parent_id = t.id)  where d.flag = '0'";
        this.baseDao.updateBySql(sql, null);
    }

    private void initTreeCode() {
        this.baseDao.flushSession();
        String sql = "update t_department d    set d.tree_code =        (select '-' || listagg(t.code, '-') within GROUP(order by t.grade) || '-' as ids           from t_department t          where t.flag = '0'          start with t.id = d.id         connect by prior t. parent_id = t.id)  where d.flag = '0'";
        this.baseDao.updateBySql(sql, null);
    }

    private void parseExcel(MultipartFile file, String[] colsName, Set<ImpDepExcelBean> newList, List<ImpDepExcelBean> codeExitList) throws Exception {
        if (file == null) {
            throw new Exception(MessageManager.getProMessage(this.message, "bims.dep.imp.error.parseExcel.notFile"));
        }
        Sheet sheet = ExcelUtil.parseExcel(file, 0);
        if (sheet != null) {
            int i;
            int colLens = sheet.getRow(0).getPhysicalNumberOfCells();
            if (colLens != colsName.length) {
                throw new Exception(MessageManager.getProMessage(this.message, "bims.person.imp.error.parseExcel.colNotMatch"));
            }
            for (i = 0; i < colLens; ++i) {
                String cloumnName = sheet.getRow(0).getCell(i).getStringCellValue();
                if (colsName[i].equals(cloumnName)) continue;
                throw new Exception(MessageManager.getProMessage(this.message, "bims.person.imp.error.parseExcel.badColName") + "[" + cloumnName + ":" + colsName[i] + "]");
            }
            for (i = 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                boolean ifExit;
                ImpDepExcelBean excel = new ImpDepExcelBean();
                Row row = sheet.getRow(i);
                if (row.getCell(0) != null) {
                    row.getCell(0).setCellType(1);
                    excel.setCode(Util.lrTrim(row.getCell(0).getStringCellValue()));
                    excel.setParentCode(this.getParentCode(Util.lrTrim(row.getCell(0).getStringCellValue())));
                }
                if (row.getCell(1) != null) {
                    row.getCell(1).setCellType(1);
                    excel.setName(Util.lrTrim(row.getCell(1).getStringCellValue()));
                }
                if (row.getCell(2) != null) {
                    row.getCell(2).setCellType(1);
                    excel.setNameAbbr(Util.lrTrim(row.getCell(2).getStringCellValue()));
                }
                if (row.getCell(3) != null) {
                    excel.setLinkman(Util.lrTrim(row.getCell(3).getStringCellValue()));
                }
                if (row.getCell(4) != null) {
                    excel.setPhone(Util.lrTrim(row.getCell(4).getStringCellValue()));
                }
                if (ifExit = newList.add(excel)) continue;
                codeExitList.add(excel);
            }
        }
    }

    private String getParentCode(String code) {
        if ("".equals(code)) {
            return "";
        }
        boolean do_while = true;
        while (do_while) {
            int idx = code.lastIndexOf("00");
            if (idx > 0) {
                if (code.length() - idx > 2) {
                    code = code.substring(0, code.length() - 2);
                    do_while = false;
                    continue;
                }
                code = code.substring(0, idx);
                continue;
            }
            code = code.substring(0, code.length() - 2);
            do_while = false;
        }
        StringBuffer sb = new StringBuffer(code);
        while (sb.length() < 12) {
            sb.append("00");
        }
        return sb.toString();
    }

    private void checkNull(Set<ImpDepExcelBean> oldSet, Set<ImpDepExcelBean> newSet, List<ImpDepExcelBean> errorList) {
        for (ImpDepExcelBean tmp : oldSet) {
            if (StringUtils.isBlank((CharSequence)tmp.getCode())) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.noCode"));
                errorList.add(tmp);
                continue;
            }
            if (tmp.getCode().length() > 12) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.codeError"));
                errorList.add(tmp);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)tmp.getName())) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.noName"));
                errorList.add(tmp);
                continue;
            }
            if (tmp.getName().length() > 128) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.nameError"));
                errorList.add(tmp);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)tmp.getNameAbbr()) && tmp.getNameAbbr().length() > 128) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.nameAbbrError"));
                errorList.add(tmp);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)tmp.getLinkman()) && tmp.getLinkman().length() > 16) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.linkManError"));
                errorList.add(tmp);
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)tmp.getPhone()) && tmp.getPhone().length() > 20) {
                tmp.setErrorMsg(MessageManager.getProMessage(this.message, "bims.dep.imp.error.checkNull.phoneError"));
                errorList.add(tmp);
                continue;
            }
            newSet.add(tmp);
        }
    }

    private void check(Set<ImpDepExcelBean> oldList, Set<ImpDepExcelBean> newSet, List<ImpDepExcelBean> codeExitList, Map<String, String> codeIDMap, Map<String, String> codeLevelMap, Map<String, String> parentCodeNotExit) {
        HashSet<String> codeSet = new HashSet<String>();
        HashSet<String> parentCodeSet = new HashSet<String>();
        ArrayList<ImpDepExcelBean> tmp = new ArrayList<ImpDepExcelBean>(oldList);
        Collections.sort(tmp, new DepCompare());
        for (ImpDepExcelBean excel : tmp) {
            Department deparment = this.getDepartmentByCode(excel.getCode());
            if (deparment != null) {
                codeExitList.add(excel);
                continue;
            }
            codeSet.add(excel.getCode());
            parentCodeSet.add(excel.getParentCode());
            newSet.add(excel);
        }
        Object depList = null;
        for (String str : parentCodeSet) {
            if (codeSet.contains(str)) continue;
            Department deparment = this.getDepartmentByCode(str);
            if (deparment != null) {
                codeIDMap.put(str, deparment.getId());
                codeLevelMap.put(str, deparment.getLevel());
                continue;
            }
            parentCodeNotExit.put(str, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    private void saveExcel(Set<ImpDepExcelBean> oldList, Set<ImpDepExcelBean> newSet, List<ImpDepExcelBean> noParentList, List<ImpDepExcelBean> errorList, Map<String, String> codeIDMap, Map<String, String> codeLevelMap, Map<String, String> parentCodeNotExit, String depId, HttpServletRequest request) {
        ArrayList<ImpDepExcelBean> tmp = new ArrayList<ImpDepExcelBean>(oldList);
        Collections.sort(tmp, new DepCompare());
        String ticket = CookieUtils.getCookie(request, "operator", String.class);
        double execelCount = oldList.size();
        String curentUserDepId = depId;
        String curentUserDepCode = "";
        String curentUserDepLevel = "";
        if ("9999999999".equals(curentUserDepId)) {
            curentUserDepId = "8888888888";
            curentUserDepLevel = "1";
        } else {
            Department tmp_dep = this.queryDepById(curentUserDepId);
            curentUserDepCode = tmp_dep.getCode();
            curentUserDepLevel = tmp_dep.getLevel();
        }
        if (!codeLevelMap.containsKey(curentUserDepCode)) {
            codeLevelMap.put(curentUserDepCode, curentUserDepLevel);
        }
        String impDepLevel = "";
        String impDepId = "";
        String impNoParentDepId = "";
        Object noParentDep = null;
        if (parentCodeNotExit.size() > 0) {
            Department dep = new Department();
            String depCode = "" + System.currentTimeMillis();
            depCode = "T" + depCode.substring(depCode.length() - 11);
            dep.setCode(depCode);
            dep.setName(MessageManager.getProMessage(this.message, "bims.dep.imp.error.saveExcel.noparment"));
            impDepLevel = String.valueOf(Integer.parseInt(curentUserDepLevel) + 1);
            dep.setLevel(impDepLevel);
            dep.setDepType("dept");
            Department parentDep = new Department();
            parentDep.setId(curentUserDepId);
            dep.setParentDep(parentDep);
            impNoParentDepId = this.addDep(dep);
            codeIDMap.put(depCode, impNoParentDepId);
            codeLevelMap.put(depCode, impDepLevel);
        }
        double n = 0.0;
        ArrayList<Department> saveDepList = new ArrayList<Department>();
        for (ImpDepExcelBean excel : tmp) {
            try {
                Department dep = new Department();
                dep.setCode(excel.getCode());
                dep.setName(excel.getName());
                dep.setNameAbbr(excel.getNameAbbr());
                dep.setLinkman(excel.getLinkman());
                dep.setPhone(excel.getPhone());
                Department parentDep = new Department();
                if (parentCodeNotExit.containsKey(excel.getParentCode())) {
                    dep.setDepType("dept");
                    parentDep.setId(impNoParentDepId);
                    dep.setParentDep(parentDep);
                    impDepLevel = String.valueOf(Integer.parseInt(impDepLevel) + 1);
                    dep.setLevel(impDepLevel);
                    impDepId = this.addDep(dep);
                    saveDepList.add(dep);
                    codeIDMap.put(excel.getCode(), impDepId);
                    codeLevelMap.put(dep.getCode(), dep.getLevel());
                    noParentList.add(excel);
                    continue;
                }
                if (codeIDMap.containsKey(excel.getParentCode())) {
                    parentDep.setId(codeIDMap.get(excel.getParentCode()));
                    dep.setParentDep(parentDep);
                    impDepLevel = String.valueOf(Integer.parseInt(codeLevelMap.get(excel.getParentCode())) + 1);
                    dep.setLevel(impDepLevel);
                    dep.setDepType("dept");
                    impDepId = this.addDep(dep);
                    saveDepList.add(dep);
                    codeIDMap.put(excel.getCode(), impDepId);
                    codeLevelMap.put(dep.getCode(), dep.getLevel());
                    newSet.add(excel);
                    continue;
                }
                parentDep.setId(curentUserDepId);
                dep.setParentDep(parentDep);
                impDepLevel = String.valueOf(Integer.parseInt(curentUserDepLevel) + 1);
                dep.setLevel(impDepLevel);
                dep.setDepType("dept");
                impDepId = this.addDep(dep);
                saveDepList.add(dep);
                codeIDMap.put(excel.getCode(), impDepId);
                codeLevelMap.put(dep.getCode(), dep.getLevel());
                noParentList.add(excel);
            }
            catch (Exception e) {
                excel.setErrorMsg(e.getMessage());
                errorList.add(excel);
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                double d = n;
                n = d + 1.0;
                this.tokenFactory.getOperator().add("upload:dep:rate:" + ticket, String.valueOf(d / execelCount));
            }
        }
    }

    @Override
    public boolean isCanDelete(String depId) {
        Department dep = this.depDao.queryDepartmentById(depId);
        List<Department> depList = dep.getChildDeps();
        if (depList != null && depList.size() > 0) {
            return false;
        }
        List<Person> personList = dep.getPersonList();
        return personList == null || personList.size() <= 0;
    }

    @Override
    public boolean checkDepCode(String code) {
        Department dep = this.getDepartmentByCode(code);
        return dep != null;
    }

    @Override
    public List<Department> getAllDepartments(String depId) {
        String select = "select * from t_department connect by prior id = parent_id start with id = ? ";
        Object[] values = new String[]{depId};
        return this.baseDao.getListBySQL(select, values, Department.class);
    }

    @Override
    public List<TreeDep> getTreeDep(String depId) {
        String[] depIdArr = depId.split(",");
        ArrayList list = new ArrayList();
        ArrayList<String> nameKeys = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : depIdArr) {
            ids.add(id);
        }
        nameKeys.add("ids");
        list.add(ids);
        String select = "select id,code,parent_id,name,flag,order_Field from t_department where  flag ='0'   connect by prior id = parent_id  start with id in ( :ids ) order by order_field,code asc ";
        String selectCount = "select count(id) from t_department where  flag ='0' connect by prior id = parent_id start with id in ( :ids ) ";
        return this.baseDao.getListBySQL(selectCount, select, list.toArray(), null, TreeDep.class, nameKeys);
    }

    @Override
    public List<Department> getHLDep(String depId) {
        String select = "select * from t_department connect by prior  parent_id = id  start with id = ? ";
        Object[] values = new String[]{depId};
        return this.baseDao.getListBySQL(select, values, Department.class);
    }

    @Override
    public boolean queryControlDeptByPerson(String deptid, String personid) {
        boolean flag = false;
        String select = "select * from t_bims_person_controldep where PERSON_ID=? and DEP_ID=?";
        Object[] values = new String[]{deptid, personid};
        List<?> list = this.baseDao.getListBySQL(select, values, Department.class);
        if (list.size() > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public boolean judgeDepIsControlDep(String controlDeps, String depIds) {
        String[] controlArray;
        for (String controlDep : controlArray = controlDeps.split(",")) {
            List<Department> list = this.getAllDepartments(controlDep);
            for (Department dep : list) {
                if (!dep.getId().equals(depIds)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean judgeDepIsChildDep(String parentDepId, String childDepId) {
        List<Department> deps = this.getAllDepartments(parentDepId);
        for (Department dep : deps) {
            if (!childDepId.equals(dep.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Department> queryChildDepListByParentId(QueryForm queryForm, Page page) {
        String parentId = queryForm.getDepId();
        String controlDepIds = queryForm.getCtlDepStr();
        String operateDateFrom = queryForm.getOperateDateFrom();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        long startTime = 0L;
        try {
            startTime = f.parse(operateDateFrom).getTime();
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        StringBuilder selectHql = new StringBuilder("select * from t_department  department where 1=1  and (flag='0' or (flag='1' and N_LAST_UPDATE_TIME >" + startTime + ")) ");
        StringBuilder countHql = new StringBuilder("select count(*) from t_department  department where 1=1 and (flag='0' or (flag='1' and N_LAST_UPDATE_TIME >" + startTime + ")) ");
        ArrayList<String> paramList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            selectHql.append(" and department.parent_id  = ? ");
            countHql.append(" and department.parent_id  = ? ");
            paramList.add(parentId);
        }
        selectHql.append("and department.Id  in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
        countHql.append("and department.Id  in (" + BimsUtil.getChildDepsSql(controlDepIds) + ")");
        selectHql.append(" order by code");
        return this.depDao.queryDepartmentListBySql(countHql.toString(), selectHql.toString(), paramList.toArray(), page);
    }

    @Override
    @Transactional
    public void deleteWorkFlowControlDept(String personId) {
        this.depDao.deleteWorkFlowControlDept(personId);
    }

    @Transactional
    public void syncWorkFlowControlDept(Department dept) {
        String pId = dept.getParentDep().getId();
        List<WorkFlowControlDept> wfcdList = this.depDao.getWorkFlowControlDept(pId, null);
        if (wfcdList != null) {
            for (WorkFlowControlDept wfcd : wfcdList) {
                log.debug("\u8bbe\u7f6e\u4e3a\u5176\u7236\u7ea7\u7ba1\u8f96\u5355\u4f4d");
                WorkFlowControlDept entity = new WorkFlowControlDept();
                entity.setPersonId(wfcd.getPersonId());
                entity.setDepId(dept.getId());
                this.addWorkFlowControlDept(entity);
            }
        }
    }

    @Override
    @Transactional
    public void addWorkFlowControlDept(WorkFlowControlDept wfcd) {
        this.depDao.addWorkFlowControlDept(wfcd);
    }

    @Override
    public List<Department> querySynDepList(SynQueryParam synQueryParam, Page page) {
        StringBuffer selecttab = new StringBuffer("from t_department where id <>'9999999999' ");
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getLastTime()) && Long.valueOf(synQueryParam.getLastTime()) > 0L) {
            selecttab.append(" and N_LAST_UPDATE_TIME>?");
            list.add(synQueryParam.getLastTime());
        }
        if (StringUtils.isNotBlank((CharSequence)synQueryParam.getDepCode())) {
            if (StringUtils.isNotBlank((CharSequence)synQueryParam.getIsContains()) && "1".equals(synQueryParam.getIsContains())) {
                selecttab.append(" and id in (select id from t_department connect by prior id = parent_id start with id = (select id from t_department where code= ? and flag='0'))");
                list.add(synQueryParam.getDepCode());
            } else {
                selecttab.append(" and id = (select id from t_department where code= ? and flag='0') ");
                list.add(synQueryParam.getDepCode());
            }
        }
        String selectCount = "select count(*) " + selecttab.toString();
        String select = "select * " + selecttab.toString() + " order by N_LAST_UPDATE_TIME asc,id";
        return this.depDao.queryDepartmentListBySql(selectCount, select, list.toArray(), page);
    }

    @Override
    public List<Department> querySynDepList(long lastTime, String rootDepId, Page page) {
        StringBuffer selecttab = new StringBuffer("from t_department where 1 = 1 ");
        ArrayList<String> list = new ArrayList<String>();
        if (lastTime > 0L) {
            selecttab.append(" and N_LAST_UPDATE_TIME > ?");
            list.add(Long.toString(lastTime));
        }
        if (rootDepId != null && !"".equals(rootDepId)) {
            selecttab.append(" connect by prior id = parent_id start with id=? ");
            list.add(rootDepId);
        }
        String selectCount = "select count(*) " + selecttab.toString();
        String select = "select * " + selecttab.toString() + " order by N_LAST_UPDATE_TIME asc";
        return this.depDao.queryDepartmentListBySql(selectCount, select, list.toArray(), page);
    }

    @Override
    @Transactional
    public void updateDepLevel(Department department) {
        department.setTimestamp(System.currentTimeMillis());
        this.depDao.updateDepartment(department);
    }

    @Override
    @Transactional
    public void updateChildDepTreeCode(Department department) {
        List<Department> depList = department.getChildDeps();
        if (depList == null || depList.size() == 0) {
            return;
        }
        for (Department child : depList) {
            child.setTreeCode(department.getTreeCode() + child.getCode() + "-");
            child.setTimestamp(System.currentTimeMillis());
            this.depDao.updateDepartment(child);
            this.updateChildDepTreeCode(child);
        }
    }
}

