/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.service.impl;

import com.xdja.pams.bims.bean.FieldConfigBean;
import com.xdja.pams.bims.dao.FieldConfigDao;
import com.xdja.pams.bims.entity.FieldConfig;
import com.xdja.pams.bims.service.FieldConfigService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FieldConfigServiceImpl
implements FieldConfigService {
    @Autowired
    private FieldConfigDao dao;

    @Override
    @Transactional
    public void save(FieldConfig entity) {
        this.dao.save(entity);
    }

    @Override
    @Transactional
    public void update(FieldConfig entity) {
        this.dao.update(entity);
    }

    @Override
    @Transactional
    public void updateField(FieldConfig fc) {
        FieldConfig config = this.dao.getById(fc.getId());
        config.setName(fc.getName());
        config.setSeq(fc.getSeq());
        config.setFieldName(fc.getFieldName());
        this.dao.update(config);
    }

    @Override
    @Transactional
    public void deleteField(FieldConfig fc) {
        this.dao.delete(fc.getId());
    }

    @Override
    public List<FieldConfig> queryList() {
        return this.dao.queryList();
    }

    @Override
    @Transactional
    public void updateDisplayState(List<FieldConfigBean> fcbs) {
        if (fcbs == null || fcbs.isEmpty()) {
            return;
        }
        for (FieldConfigBean fcb : fcbs) {
            FieldConfig fc = this.dao.getById(fcb.getId());
            fc.setDisplayStateDetail(fcb.getDisplayStateDetail());
            fc.setDisplayStateList(fcb.getDisplayStateList());
            fc.setCanEdit(fcb.getCanEdit());
            this.dao.update(fc);
        }
    }

    @Override
    public List<FieldConfig> queryCustomList() {
        return this.dao.queryCunstomList();
    }

    @Override
    public List<FieldConfig> queryDefaultList() {
        return this.dao.queryDefaultList();
    }

    @Override
    public FieldConfig getById(String id) {
        return this.dao.getById(id);
    }

    @Override
    public boolean checkFieldIfExisted(String field, String name, String id) {
        List<FieldConfig> list = this.dao.getByFieldOrName(field, name);
        if (list != null && !list.isEmpty()) {
            if (StringUtils.isBlank((CharSequence)id)) {
                return true;
            }
            return list.size() != 1 || !list.get(0).getId().equals(id);
        }
        return false;
    }
}

