/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.bims.service.impl;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.OnlineUserService;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.ServiceResultOut;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.Constants;
import org.apache.axis.client.Call;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnlineUserServiceImpl
implements OnlineUserService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private SystemConfigPbService systemConfigPbService;

    @Override
    public List<Person> queryOnlineUser(QueryPersonBean queryBean, String controlDepIds, String controlPolices, Page page) {
        queryBean.setClientLoginTime(new Date());
        return this.userManageService.queryPersonList(queryBean, controlDepIds, controlPolices, page);
    }

    @Override
    public ServiceResultOut forceOffline(String code, String reason) throws Exception {
        ServiceResultOut serviceResult = new ServiceResultOut();
        String url = this.systemConfigPbService.getValueByCode("gprsServerUrl");
        if (url == null) {
            serviceResult.setRtnFlag("error");
            serviceResult.setRtnMsg("\u65ad\u5f00\u5931\u8d25,\u672a\u914d\u7f6egprsServer\u7684\u5730\u5740");
            return serviceResult;
        }
        String funcName = "forceDisconnect";
        int flag = 1;
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        Call call = (Call)service.createCall();
        call.setTimeout(Integer.valueOf(3000));
        call.setTargetEndpointAddress(new URL(url));
        call.setOperationName(funcName);
        call.addParameter("policeNumber", Constants.XSD_STRING, ParameterMode.IN);
        call.addParameter("offLine", Constants.XSD_STRING, ParameterMode.IN);
        call.addParameter("reason", Constants.XSD_STRING, ParameterMode.IN);
        call.setReturnType(Constants.XSD_INT);
        Object[] params = new Object[]{code, false, reason};
        flag = (Integer)call.invoke(params);
        if (flag == 0) {
            Person person = this.userManageService.getUserByCode(code);
            person.setClientLoginTime(null);
            this.userManageService.updateUser(person);
            serviceResult.setRtnFlag("succ");
        } else if (flag == 101) {
            serviceResult.setRtnFlag("error");
            serviceResult.setRtnMsg("gprsserver\u8fd4\u56de\u4ee3\u7801\uff1a" + flag + ",\u65ad\u5f00\u7528\u6237\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff01");
        } else if (flag == 102) {
            serviceResult.setRtnFlag("error");
            serviceResult.setRtnMsg("gprsserver\u8fd4\u56de\u4ee3\u7801\uff1a" + flag + ",\u65ad\u5f00\u7528\u6237\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u8be5\u8b66\u53f7\u76f8\u5173\u7684\u4f1a\u8bdd\u4fe1\u606f\uff01");
            Person person = this.userManageService.getUserByCode(code);
            person.setClientLoginTime(null);
            this.userManageService.updateUser(person);
        } else if (flag == 103) {
            serviceResult.setRtnFlag("error");
            serviceResult.setRtnMsg("gprsserver\u8fd4\u56de\u4ee3\u7801\uff1a" + flag + ",\u65ad\u5f00\u7528\u6237\u5931\u8d25\uff0c\u5176\u5b83\u9519\u8bef\uff01");
        } else {
            serviceResult.setRtnFlag("error");
            serviceResult.setRtnMsg("\u65ad\u5f00\u5931\u8d25,\u4ee3\u7801\uff1a" + flag);
        }
        return serviceResult;
    }
}

