/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.filter;

import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.upms.entity.SysPower;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolePowerFilters
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RolePowerFilters.class);
    private String[] fireURLList;
    private String[] ROLEURLList;
    private TokenFactory tokenFactory;

    public void destroy() {
        this.fireURLList = null;
        this.ROLEURLList = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String fireURL = "";
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.tokenFactory = (TokenFactory)BeanUtils.getBean(TokenFactory.class);
        try {
            String url = httpRequest.getRequestURI();
            for (int i = 0; i < this.fireURLList.length; ++i) {
                if (!url.contains(this.fireURLList[i])) continue;
                chain.doFilter(request, response);
                return;
            }
            String key = CookieUtils.getCookie(httpRequest, "operator", String.class);
            Operator operator = (Operator)this.tokenFactory.getOperator().get(key);
            List<SysPower> powerlist = operator.getTopFunctions();
            for (SysPower p : powerlist) {
                List<SysPower> childrenlist = p.getChildrenList();
                for (SysPower child : childrenlist) {
                    fireURL = fireURL + child.getLink() + ";";
                }
            }
            this.ROLEURLList = fireURL.split(";");
            String[] strs = url.split("/");
            if (StringUtils.isNotBlank((CharSequence)strs[2]) && StringUtils.isNotBlank((CharSequence)strs[3])) {
                url = "/" + strs[2] + "/" + strs[3] + "/";
            }
            boolean flag = false;
            for (int i = 0; i < this.ROLEURLList.length; ++i) {
                if (!url.equals(this.ROLEURLList[i])) continue;
                flag = true;
                chain.doFilter(request, response);
                return;
            }
            if (!flag) {
                log.error("#\u65e0\u6743\u9650:" + url);
                httpResponse.sendRedirect(httpRequest.getContextPath() + "/view/error/noPower.html");
            }
        }
        catch (Exception e) {
            log.error("#\u6743\u9650\u62e6\u622a\u5931\u8d25 ", (Throwable)e);
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/" + "/view/error/error.html");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        log.info("##########\u6743\u9650\u62e6\u622a\u5668\u542f\u52a8<\u5f00\u59cb> ##########");
        Util util = new Util();
        this.fireURLList = util.getProFile("common.roleurl");
        log.info("##########\u6743\u9650\u62e6\u622a\u5668\u542f\u52a8<\u5b8c\u6210>##########");
    }
}

