/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.filter;

import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.context.support.ResourceBundleMessageSource;

public class SafeFilters
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SafeFilters.class);
    public static String[] fireURLList;

    public void destroy() {
        fireURLList = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        TokenFactory tokenFactory = (TokenFactory)BeanUtils.getBean(TokenFactory.class);
        String url = httpRequest.getRequestURI();
        try {
            for (int i = 0; i < fireURLList.length; ++i) {
                if (!url.contains(fireURLList[i])) continue;
                chain.doFilter(request, response);
                return;
            }
            String key = CookieUtils.getCookie(httpRequest, "operator", String.class);
            Operator operator = (Operator)tokenFactory.getOperator().get(key);
            if (operator != null) {
                tokenFactory.getOperator().delay(key);
                chain.doFilter(request, response);
                return;
            }
            String ajaxSubmit = ((HttpServletRequest)request).getHeader("X-Requested-With");
            if (ajaxSubmit != null && ajaxSubmit.equals("XMLHttpRequest")) {
                log.debug("#session\u5df2\u7ecf\u8fc7\u671f!");
                ResourceBundleMessageSource rbm = (ResourceBundleMessageSource)org.springframework.beans.BeanUtils.instantiate(ResourceBundleMessageSource.class);
                rbm.setBasename("messageInfo");
                String msg = MessageManager.getProMessage(rbm, "safefilter.error.sessionOut");
                ReturnResult returnResult = new ReturnResult();
                returnResult.setRtnCode("1");
                returnResult.setRtnMsg(msg);
                if (request.getParameter("rtnDataType") != null && "page".equals(request.getParameter("rtnDataType"))) {
                    httpResponse.sendRedirect(httpRequest.getContextPath() + "/view/error/timeOutError.html");
                    return;
                }
                httpResponse.sendError(512);
                return;
            }
            log.debug("#\u65e0session\u4fe1\u606f!");
            httpResponse.sendRedirect(httpRequest.getContextPath() + "/login/loginControler/login.do");
            return;
        }
        catch (BeanInstantiationException e) {
            log.error("#\u8d44\u6e90\u62e6\u622a\u5931\u8d25", (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        Util util = new Util();
        fireURLList = util.getProFile("common.filter.fireURL");
    }
}

