/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.common.util;

import com.xdja.pams.common.bean.TimeTaskBean;
import com.xdja.pams.common.util.Util;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuartzUtil {
    protected static final Logger log = LoggerFactory.getLogger(QuartzUtil.class);
    private static Scheduler scheduler;

    private QuartzUtil() {
    }

    public static void startAllJob(List<TimeTaskBean> tasks) {
        log.debug("$$$$$$$$$$\u5b9a\u65f6\u4efb\u52a1<\u5f00\u59cb>$$$$$$$$$$");
        try {
            QuartzUtil.startScheduler();
            for (TimeTaskBean task : tasks) {
                JobDataMap dataMap = new JobDataMap();
                dataMap.put("timerTaskId", task.getId());
                try {
                    if ("1".equals(task.getTimerType())) {
                        QuartzUtil.startSimpleJob(task.getId(), task.getStarttime(), Class.forName(task.getClasspath()), task.getInterval(), task.getFreqtype(), dataMap);
                    }
                    if (!"2".equals(task.getTimerType())) continue;
                    QuartzUtil.startCronJob(task.getId(), task.getStarttime(), Class.forName(task.getClasspath()), task.getCron(), dataMap);
                }
                catch (Exception e) {
                    log.error("$\u542f\u52a8\u5b9a\u65f6\u62a5\u8868\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("$\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1\u8c03\u5ea6\u5668\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1\u8c03\u5ea6\u5668\u5931\u8d25" + e.getMessage());
        }
        log.debug("$$$$$$$$$$\u5b9a\u65f6\u4efb\u52a1<\u7ed3\u675f>$$$$$$$$$$");
    }

    public static void startJob(String jobKey, Class<? extends Job> jobClazz, JobDataMap dataMap) throws SchedulerException {
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule());
        if (dataMap != null && !dataMap.isEmpty()) {
            builder.usingJobData(dataMap);
        }
        SimpleTrigger trigger = (SimpleTrigger)builder.build();
        if (QuartzUtil.checkExists(jobKey)) {
            scheduler.rescheduleJob(trigger.getKey(), (Trigger)trigger);
        } else {
            JobDetail job = JobBuilder.newJob(jobClazz).withIdentity(jobKey).build();
            scheduler.scheduleJob(job, (Trigger)trigger);
        }
    }

    public static void startSimpleJob(String jobKey, Date starttime, Class<? extends Job> jobClazz, int interval, int freqtype, JobDataMap dataMap) throws SchedulerException {
        log.info("$SimpleJob\u542f\u52a8>>>");
        log.info("#jobKey\uff1a" + jobKey);
        log.info("#starttime:" + starttime);
        log.info("#jobClazz:" + jobClazz.getName());
        log.info("#interval:" + interval);
        log.info("#freqtype:" + freqtype);
        Date now = new Date();
        int i = Util.compare(starttime, now);
        if (i < 0) {
            starttime = now;
        }
        TriggerBuilder<SimpleTrigger> builder = QuartzUtil.generateSimpleBuilder(jobKey, starttime, interval, freqtype);
        if (dataMap != null && !dataMap.isEmpty()) {
            builder.usingJobData(dataMap);
        }
        SimpleTrigger trigger = (SimpleTrigger)builder.build();
        if (QuartzUtil.checkExists(jobKey)) {
            log.info("$SimpleJob\u5df2\u5b58\u5728");
            scheduler.rescheduleJob(trigger.getKey(), (Trigger)trigger);
        } else {
            log.info("$SimpleJob\u4e0d\u5b58\u5728");
            JobDetail job = JobBuilder.newJob(jobClazz).withIdentity(jobKey).build();
            scheduler.scheduleJob(job, (Trigger)trigger);
        }
        log.info("$SimpleJob\u542f\u52a8<<<");
    }

    public static void startCronJob(String jobKey, Date starttime, Class<? extends Job> jobClazz, String cronExpression, JobDataMap dataMap) throws SchedulerException, ParseException {
        log.info("$CronJob\u542f\u52a8>>>");
        log.info("#jobKey\uff1a" + jobKey);
        log.info("#starttime:" + starttime);
        log.info("#jobClazz:" + jobClazz.getName());
        log.info("#cronExpression:" + cronExpression);
        Date now = new Date();
        int i = Util.compare(starttime, now);
        if (i < 0) {
            starttime = now;
        }
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").startAt(starttime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
        if (dataMap != null && !dataMap.isEmpty()) {
            builder.usingJobData(dataMap);
        }
        CronTrigger trigger = (CronTrigger)builder.build();
        if (QuartzUtil.checkExists(jobKey)) {
            log.info("$CronJob\u5df2\u5b58\u5728");
            scheduler.rescheduleJob(trigger.getKey(), (Trigger)trigger);
        } else {
            log.info("$CronJob\u4e0d\u5b58\u5728");
            JobDetail job = JobBuilder.newJob(jobClazz).withIdentity(jobKey).build();
            scheduler.scheduleJob(job, (Trigger)trigger);
        }
        log.info("$CronJob\u542f\u52a8<<<");
    }

    public static String getNextFireTime(String jobKey) throws SchedulerException {
        if (QuartzUtil.checkExists(jobKey)) {
            TriggerKey key = new TriggerKey(jobKey + "_trigger");
            return Util.getDate("yyyy-MM-dd HH:mm:ss", scheduler.getTrigger(key).getNextFireTime());
        }
        return "";
    }

    public static void stopJob(String jobKey) throws SchedulerException {
        JobKey key = new JobKey(jobKey);
        if (scheduler.checkExists(key)) {
            scheduler.deleteJob(key);
            log.info("\u5220\u9664Job\u6210\u529f:" + key);
        }
    }

    public static void changeCycle(Map<String, Class> jobMap, int frequency, JobDataMap dataMap) throws SchedulerException, ParseException {
        TriggerBuilder builder = null;
        CronTrigger trigger = null;
        Date now = new Date();
        Set<String> jobKeys = jobMap.keySet();
        String cron = "0 0 0/" + frequency + " * * ?";
        if (dataMap != null && !dataMap.isEmpty()) {
            for (String jobKey : jobKeys) {
                builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").startAt(now).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
                builder.usingJobData(dataMap);
                trigger = (CronTrigger)builder.build();
                if (scheduler.checkExists(new JobKey(jobKey))) {
                    scheduler.rescheduleJob(trigger.getKey(), (Trigger)trigger);
                    continue;
                }
                JobDetail job = JobBuilder.newJob((Class)jobMap.get(jobKey)).withIdentity(jobKey).build();
                scheduler.scheduleJob(job, (Trigger)trigger);
            }
        } else {
            for (String jobKey : jobKeys) {
                builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").startAt(now).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron));
                trigger = (CronTrigger)builder.build();
                if (scheduler.checkExists(new JobKey(jobKey))) {
                    scheduler.rescheduleJob(trigger.getKey(), (Trigger)trigger);
                    continue;
                }
                JobDetail job = JobBuilder.newJob((Class)jobMap.get(jobKey)).withIdentity(jobKey).build();
                scheduler.scheduleJob(job, (Trigger)trigger);
            }
        }
    }

    private static TriggerBuilder<SimpleTrigger> generateSimpleBuilder(String jobKey, Date starttime, int interval, int freqtype) {
        TriggerBuilder builder = null;
        switch (freqtype) {
            case 1: {
                builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").startAt(starttime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(interval).repeatForever());
                break;
            }
            case 2: {
                builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").startAt(starttime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(interval).repeatForever());
                break;
            }
            case 3: {
                builder = TriggerBuilder.newTrigger().withIdentity(jobKey + "_trigger").startAt(starttime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInHours(interval).repeatForever());
            }
        }
        return builder;
    }

    private static boolean checkExists(String jobKey) throws SchedulerException {
        if (scheduler == null) {
            try {
                scheduler = StdSchedulerFactory.getDefaultScheduler();
                scheduler.start();
            }
            catch (SchedulerException e) {
                log.error("\u5b9a\u65f6\u4efb\u52a1\u8c03\u5ea6\u5668\u521d\u59cb\u542f\u52a8\u5931\u8d25", (Throwable)e);
            }
        }
        if (scheduler != null && scheduler.isShutdown()) {
            scheduler.start();
        }
        return scheduler.checkExists(new JobKey(jobKey));
    }

    private static void startScheduler() throws SchedulerException {
        if (scheduler != null && scheduler.isShutdown()) {
            scheduler.start();
        }
    }

    private static void stopScheduler() throws SchedulerException {
        if (scheduler != null && scheduler.isStarted()) {
            scheduler.shutdown();
        }
    }

    static {
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u8c03\u5ea6\u5668\u521d\u59cb\u542f\u52a8\u5931\u8d25", (Throwable)e);
        }
    }
}

