/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.report.service.impl;

import com.xdja.pams.common.util.Page;
import com.xdja.pams.report.bean.GPRSReportQueryFrom;
import com.xdja.pams.report.dao.GPRSReportDao;
import com.xdja.pams.rptms.bean.ReportBean;
import com.xdja.pams.rptms.bean.ViewReportConditionBean;
import com.xdja.pams.rptms.service.BReportService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SMSReportServiceImpl
implements BReportService {
    @Autowired
    private GPRSReportDao dao;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @Override
    public List<ViewReportConditionBean> getReportConditionList(String reportId) {
        return null;
    }

    public List<Map<String, Object>> query(GPRSReportQueryFrom queryForm, Page page) {
        List<Map<String, Object>> list = this.dao.querySMS(queryForm, page);
        String[] powerCodes = queryForm.getPowers().split(",");
        String[] powerNames = new String[powerCodes.length];
        List<CommonCode> gprsCodes = this.commonCodePbService.queryByType("GPRSPOWER");
        HashMap<String, String> gprsCodeMap = new HashMap<String, String>();
        for (CommonCode gprsCode : gprsCodes) {
            for (CommonCode commonCode : gprsCode.getcCode()) {
                gprsCodeMap.put(commonCode.getCode(), commonCode.getName());
            }
        }
        for (int i = 0; i < powerCodes.length; ++i) {
            String powerName = (String)gprsCodeMap.get(powerCodes[i]);
            powerNames[i] = powerName != null && powerName.length() > 0 ? powerName : powerCodes[i];
        }
        ArrayList<Map<String, Object>> reportList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : list) {
            LinkedHashMap<String, Object> reportrow = new LinkedHashMap<String, Object>();
            if ("DEP".equals(queryForm.getReportType())) {
                reportrow.put("\u5355\u4f4d\u540d\u79f0", "<a href=\"javascript:openSubReport('" + row.get("ID") + "','" + queryForm.getStartDate() + "','" + queryForm.getEndDate() + "','" + queryForm.getPowers() + "')\">" + row.get("NAME") + "</a>");
            } else {
                reportrow.put("\u59d3\u540d", row.get("NAME"));
                reportrow.put("\u8b66\u53f7", row.get("CODE"));
            }
            String gprsbs = (String)row.get("GPRS");
            String[] gprsbsArr = gprsbs.split(",");
            int zs = 0;
            for (int i = 0; i < powerNames.length; ++i) {
                String tmp = gprsbsArr[i];
                zs += Integer.parseInt(tmp);
                reportrow.put(powerNames[i], tmp);
            }
            reportrow.put("\u603b\u6570", zs);
            reportList.add(reportrow);
        }
        return reportList;
    }

    @Override
    public List<Map<String, Object>> getReportData(ReportBean reportBean, Map<String, Object> allParams, Page page) {
        String depId = (String)allParams.get("DEP_ID");
        String powers = (String)allParams.get("GPRSPOWER");
        String auxName = (String)allParams.get("NAME");
        String star_date = (String)allParams.get("STAR_DATE");
        String end_date = (String)allParams.get("END_DATE");
        String reportType = (String)allParams.get("REPORT_TYPE");
        GPRSReportQueryFrom queryForm = new GPRSReportQueryFrom();
        queryForm.setStartDate(star_date);
        queryForm.setEndDate(end_date);
        queryForm.setDepId(depId);
        queryForm.setPowers(powers);
        queryForm.setReportType(reportType);
        return this.query(queryForm, page);
    }

    @Override
    public Page getReportDataPagination(ReportBean reportBean, Map<String, Object> allParams, Page page) {
        String depId = (String)allParams.get("DEP_ID");
        String powers = (String)allParams.get("GPRSPOWER");
        String auxName = (String)allParams.get("NAME");
        String star_date = (String)allParams.get("STAR_DATE");
        String end_date = (String)allParams.get("END_DATE");
        String reportType = (String)allParams.get("REPORT_TYPE");
        GPRSReportQueryFrom queryForm = new GPRSReportQueryFrom();
        queryForm.setStartDate(star_date);
        queryForm.setEndDate(end_date);
        queryForm.setDepId(depId);
        queryForm.setPowers(powers);
        queryForm.setReportType(reportType);
        page.setTotal(this.dao.getCountSMS(queryForm));
        return page;
    }
}

