/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodePbService;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class AddMobileController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AddMobileController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @RequestMapping(value={"scms/deviceaddmobilecontroller/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/deviceaddmobilecontroller/query.do"})
    public void query(QueryForm form, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        Operator operator = this.getOperator(request);
        Person person = operator.getPerson();
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)form.getDepId())) {
                form.setControlDeps(operator.getControlDeps());
            }
            form.setControlPolice(operator.getControlPolices());
            form.setCardState("6");
            List<Device> list = this.deviceService.query(form, page);
            for (Device device : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                Person personb = this.userManagerService.queryPersonById(device.getPersonId());
                map.put("id", device.getId());
                map.put("name", Util.cvNameByPersonType(personb.getName(), personb.getPersonType()));
                map.put("code", personb.getCode());
                map.put("depname", personb.getDepartment().getName());
                map.put("identifier", personb.getIdentifier());
                map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                map.put("cardtype", cardtype != null ? cardtype.getName() : "");
                CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
                map.put("usetype", usetype != null ? usetype.getName() : "");
                CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
                map.put("commType", commType != null ? commType.getName() : "");
                map.put("devicename", device.getName());
                map.put("videoState", device.getVideoDeviceOpenState());
                map.put("personTypeName", this.commonCodePbService.getCodeNameByCode(personb.getPersonType(), "PERSON_TYPE"));
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/deviceaddmobilecontroller/toCardInfo.do"})
    public String toCardInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String id) {
        Device device = this.deviceService.get((Serializable)((Object)id));
        HashMap<String, String> map = new HashMap<String, String>();
        Person personb = this.userManagerService.queryPersonById(device.getPersonId());
        map.put("id", device.getId());
        map.put("name", Util.cvNameByPersonType(personb.getName(), personb.getPersonType()));
        map.put("code", personb.getCode());
        map.put("depname", personb.getDepartment().getName());
        map.put("identifier", personb.getIdentifier());
        map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
        CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
        map.put("cardtype", cardtype != null ? cardtype.getName() : "");
        CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
        map.put("usetype", usetype != null ? usetype.getName() : "");
        CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
        map.put("commType", commType != null ? commType.getName() : "");
        map.put("devicename", device.getName());
        map.put("videoState", device.getVideoDeviceOpenState());
        modelMap.put((Object)"device", map);
        return "scms/addmobile/default/cardInfo";
    }

    @RequestMapping(value={"scms/deviceaddmobilecontroller/cardAddMobile.do"})
    public void cardAddMobile(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String deviceId, String mobile) {
        ReturnResult rr = new ReturnResult();
        int operateResult = 0;
        try {
            this.deviceService.addCardMobile(deviceId, mobile);
            rr.setRtnCode("0");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            operateResult = 1;
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u5b89\u5168\u5361\u5165\u7f51\u624b\u673a\u53f7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 3, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }
}

