/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.enaas.bean.EnaasResponse;
import com.xdja.pams.enaas.service.EnaasService;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.bean.QueryForm;
import com.xdja.pams.scms.entity.Device;
import com.xdja.pams.scms.service.DeviceService;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class AuthenticationController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private UserManageService userManagerService;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private EnaasService enaasService;

    @RequestMapping(value={"scms/AuthenticationController/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage(this.message, "common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"scms/AuthenticationController/query.do"})
    public void query(QueryForm form, PageParam pageParam, HttpServletResponse response, HttpServletRequest request) {
        Page page = new Page();
        page.setRp(Integer.parseInt(pageParam.getRows()));
        page.setPage(Integer.parseInt(pageParam.getPage()));
        ArrayList listmap = new ArrayList();
        Operator operator = this.getOperator(request);
        Person person = operator.getPerson();
        int operateResult = 0;
        try {
            if (StringUtils.isBlank((CharSequence)form.getDepId())) {
                form.setControlDeps(operator.getControlDeps());
            }
            form.setControlPolice(operator.getControlPolices());
            List<Device> list = this.deviceService.query(form, page);
            for (Device device : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                Person personb = this.userManagerService.queryPersonById(device.getPersonId());
                map.put("id", device.getId());
                map.put("name", Util.cvNameByPersonType(personb.getName(), personb.getPersonType()));
                map.put("code", personb.getCode());
                map.put("depname", personb.getDepartment().getName());
                map.put("identifier", personb.getIdentifier());
                map.put("mobile", device.getMobile() != null ? device.getMobile().getMobile() : "");
                CommonCode cardtype = this.commonCodeService.getByCode(device.getType(), "2000");
                map.put("cardtype", cardtype != null ? cardtype.getName() : "");
                CommonCode usetype = this.commonCodeService.getByCode(device.getUseType(), "useType");
                map.put("usetype", usetype != null ? usetype.getName() : "");
                CommonCode commType = this.commonCodeService.getByCode(device.getCommType(), "2015");
                map.put("commType", commType != null ? commType.getName() : "");
                map.put("devicename", device.getName());
                map.put("enaasState", device.getEnaasState());
                CommonCode neaasState = this.commonCodeService.getByCode(device.getEnaasState(), "enaasState");
                map.put("enaasStateName", neaasState != null ? neaasState.getName() : "");
                map.put("enaasUserId", device.getEnaasUserId());
                map.put("enaasDesc", device.getEnaasDesc());
                listmap.add(map);
            }
            operateResult = 1;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(page.getTotal()));
        map.put("rows", listmap);
        Util.writeUtf8Text(response, Util.toJsonStr(map));
    }

    @RequestMapping(value={"scms/AuthenticationController/reSubmit.do"})
    public void reSubmit(String id, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        ReturnResult rr = new ReturnResult();
        try {
            Device device = this.deviceService.reSubmitAuthentication(id);
            if ("5".equals(device.getEnaasState())) {
                operateResult = 1;
                rr.setRtnCode("0");
                rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
            } else {
                rr.setRtnCode("1");
                rr.setRtnMsg(device.getEnaasDesc());
            }
        }
        catch (Exception e) {
            log.error("\u91cd\u65b0\u63d0\u4ef7\u8eab\u4efd\u8ba4\u8bc1\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }

    @RequestMapping(value={"scms/AuthenticationController/reCardNotify.do"})
    public void cardNotify(String id, HttpServletResponse response, HttpServletRequest request) {
        log.info("\u5199\u5361\u901a\u77e5\u65b9\u6cd5");
        int operateResult = 0;
        ReturnResult rr = new ReturnResult();
        try {
            Device device = this.deviceService.get((Serializable)((Object)id));
            EnaasResponse enaasResponse = this.enaasService.cardNotify(device);
        }
        catch (Exception e) {
            log.error("\u91cd\u65b0\u63d0\u4ea4\u5199\u5361\u901a\u77e5\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            rr.setRtnCode("1");
            rr.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail"));
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), 1, operateResult, "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text(response, Util.toJsonStr(rr));
    }
}

