/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.scms.util;

import com.xdja.pams.scms.util.CAType;
import com.xdja.pams.webservice.client.CommonDClient;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDClientForSimpleCA
extends CommonDClient {
    private static final Logger log = LoggerFactory.getLogger(CommonDClientForSimpleCA.class);
    public static final String ERR = "-1";
    public static final String SUCESS = "1";

    private static String linkCA(String url, String interfaceName, String[] params) throws Exception {
        try {
            HttpPost httpPost = CommonDClientForSimpleCA.getHttpPost(url);
            StringBuilder sb = new StringBuilder();
            sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:int=\"http://interfaces.services.xdja.com\">");
            sb.append("<soapenv:Header/>");
            sb.append("<soapenv:Body>");
            sb.append("<int:").append(interfaceName).append(">");
            for (int i = 0; i < params.length; ++i) {
                sb.append("<int:in").append(i).append(">").append(params[i]).append("</int:in").append(i).append(">");
            }
            sb.append("</int:").append(interfaceName).append(">");
            sb.append("</soapenv:Body>");
            sb.append("</soapenv:Envelope>");
            String soapRequestData = sb.toString();
            log.debug("soapRequestData:" + soapRequestData);
            return CommonDClientForSimpleCA.parseSoapInfo(CommonDClientForSimpleCA.getResponseBody(httpPost, soapRequestData), interfaceName);
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA]\u63a5\u53e3\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public static String connectCA(String url, CAType caType, String[] args) {
        try {
            log.debug("\u8bf7\u6c42\u540d\u79f0:{}, \u65b9\u6cd5\u540d:{}", (Object)caType.getDecription(), (Object)caType.getFunctionName());
            return CommonDClientForSimpleCA.linkCA(url, caType.getFunctionName(), args);
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA]" + caType.getDecription() + "\u5f02\u5e38");
            return ERR;
        }
    }

    public static String getDnByUserInfo(String url, String cardNo, String idetityId, String name, String orgCode) {
        try {
            return CommonDClientForSimpleCA.linkCA(url, "getDnByUserInfo", new String[]{cardNo, idetityId, name, orgCode});
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA] \u83b7\u53d6DN\u5f02\u5e38");
            return ERR;
        }
    }

    public static String certApplyRA(String url, String dn, String userInfo, String deCardNo, String password, String other) {
        try {
            return CommonDClientForSimpleCA.linkCA(url, "certApplyRA", new String[]{dn, userInfo, deCardNo, password, other});
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA] \u6ce8\u518c\u8ba4\u8bc1\u5f02\u5e38");
            return ERR;
        }
    }

    public static String certDownloadRA(String url, String p10, String userId, String returnType, String deCardNo, String password, String other) {
        try {
            return CommonDClientForSimpleCA.linkCA(url, "certDownloadRA", new String[]{p10, userId, returnType, deCardNo, password, other});
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA] \u7b7e\u53d1\u8bc1\u4e66\u5f02\u5e38");
            return ERR;
        }
    }

    public static String certRevokeRA(String url, String sn, String deCardNo, String password) {
        try {
            return CommonDClientForSimpleCA.linkCA(url, "certRevokeRA", new String[]{sn, deCardNo, password});
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA] \u64a4\u9500\u8bc1\u4e66\u5f02\u5e38");
            return ERR;
        }
    }

    public static String certQuerybySn(String url, String sn, String deCardNo, String password) {
        try {
            return CommonDClientForSimpleCA.linkCA(url, "certStatusQuerybySn", new String[]{sn, deCardNo, password});
        }
        catch (Exception e) {
            log.error("[\u7b80\u6613CA] \u67e5\u8be2\u8bc1\u4e66\u72b6\u6001\u5f02\u5e38");
            return ERR;
        }
    }

    private static String getResponse(String url, String mothdName, String[] paramNames, String[] params) {
        if (url.indexOf("?") > 0) {
            url = url.substring(0, url.indexOf("?"));
        }
        Service service = new Service();
        try {
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(url);
            call.setOperationName(new QName("http://interfaces.services.xdja.com", mothdName));
            if (paramNames != null && paramNames.length > 0) {
                for (String paramName : paramNames) {
                    call.addParameter(paramName, XMLType.XSD_STRING, ParameterMode.IN);
                }
                call.setReturnType(XMLType.XSD_STRING);
                Object[] objects = null;
                if (params != null && params.length > 0) {
                    objects = new Object[params.length];
                    for (int i = 0; i < params.length; ++i) {
                        objects[i] = params[i];
                    }
                }
                String result = (String)call.invoke(objects);
                return result;
            }
        }
        catch (Exception e) {
            log.error("\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

