/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.sms.bean.KeyBean;
import com.xdja.pams.sms.bean.QueryForm;
import com.xdja.pams.sms.dao.SmsDao;
import com.xdja.pams.sms.entity.Sms;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SmsDaoImpl
implements SmsDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<Sms> query(QueryForm form, Page page) {
        StringBuilder select = new StringBuilder("from Sms where 1=1 ");
        ArrayList<String> list = new ArrayList<String>();
        if (form != null) {
            if (StringUtils.isNotBlank((CharSequence)form.getContent())) {
                select.append(" and dxnr like ?");
                list.add("%" + form.getContent() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getReceiver())) {
                select.append(" and sjh like ?");
                list.add("%" + form.getReceiver() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getSender())) {
                select.append(" and jh like ?");
                list.add("%" + form.getSender() + "%");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getStartDate())) {
                select.append(" and scsj >= to_date(?, 'YYYY-MM-DD hh24miss')");
                list.add(form.getStartDate().trim() + " 000000");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getEndDate())) {
                select.append(" and scsj <= to_date(?, 'YYYY-MM-DD hh24miss')");
                list.add(form.getEndDate().trim() + " 235959");
            }
            if (StringUtils.isNotBlank((CharSequence)form.getState())) {
                select.append(" and fsbz = ?");
                list.add(form.getState());
            }
        }
        String selectCount = "select count(*) " + select.toString();
        Object[] values = null;
        if (list.size() > 0) {
            values = list.toArray(new String[0]);
        }
        select.append(" order by scsj desc ");
        return this.baseDao.getListByHQL(selectCount, select.toString(), values, page);
    }

    @Override
    public List<String> querySjhByPersonId(String personId) {
        StringBuffer sb = new StringBuffer("select mobile from t_bims_mobile where person_id = ?");
        ArrayList<String> list = new ArrayList<String>();
        list.add(personId);
        Object[] values = list.toArray(new String[0]);
        return this.baseDao.getListBySQL(sb.toString(), values, null);
    }

    @Override
    public void save(Sms sms) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("insert into sms_t_khdx(c_fsbz,d_scsj,c_dxnr,c_sjh,c_jh,c_dkh,c_yysbh) values('0',sysdate,?,?,?,?,?)");
        list.add(sms.getDxnr());
        list.add(sms.getSjh());
        list.add(sms.getJh());
        list.add(sms.getDkh());
        list.add(sms.getYysbh());
        Object[] values = list.toArray(new String[0]);
        this.baseDao.updateBySql(sb.toString(), values);
    }

    @Override
    public List<String> queryPersonIdByDepId(String depId) {
        String sql = "select p.id from t_person p where p.flag = '0' and p.dep_id in (select id from t_department connect by prior id = parent_id start with id = ?)";
        return this.baseDao.getListBySQL(sql, new String[]{depId}, null);
    }

    @Override
    public String[] getKeyWord() {
        String sql = "SELECT * FROM SMS_T_FFGJZ";
        ArrayList list = (ArrayList)this.baseDao.getListBySQL(sql, null, KeyBean.class);
        if (null != list) {
            String[] strKeyWord = new String[list.size()];
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                KeyBean Temp = (KeyBean)list.get(i);
                strKeyWord[i] = Temp.getC_FFGJZ();
            }
            return strKeyWord;
        }
        return null;
    }
}

