/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.sms.service.impl;

import com.xdja.pams.sms.bean.MtSms;
import com.xdja.pams.sms.bean.SendSmsResult;
import com.xdja.pams.sms.bean.SmsTempBean;
import com.xdja.pams.sms.dao.SendSmsDao;
import com.xdja.pams.sms.service.SendSmsService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.List;
import org.jfree.util.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendSmsServiceImpl
implements SendSmsService {
    @Autowired
    private SendSmsDao sendSmsDao;
    @Autowired
    private SystemConfigPbService scps;

    @Override
    public void updateSmsStatus(List<SendSmsResult> resultList, boolean isEncry) {
        ArrayList<MtSms> smsList = new ArrayList<MtSms>();
        if (resultList != null && resultList.size() > 0) {
            SendSmsResult result = null;
            MtSms sms = null;
            for (int i = 0; i < resultList.size(); ++i) {
                result = resultList.get(i);
                sms = new MtSms();
                sms.setId(result.getId());
                if (result.getAck() == 0) {
                    sms.setStatus("6");
                } else {
                    sms.setStatus("0");
                }
                smsList.add(sms);
            }
        }
        this.updateSmsStatusByList(isEncry, smsList);
    }

    private void updateSmsStatusByList(boolean isEncry, List<MtSms> smsList) {
        if (smsList != null && smsList.size() > 0) {
            if (isEncry) {
                this.sendSmsDao.updateSmsDXFSStatusByList(smsList);
            } else {
                this.sendSmsDao.updateSmsKHDXStatusByList(smsList);
            }
        }
    }

    @Override
    public List<MtSms> getSmsList(boolean isEncry) {
        ArrayList<MtSms> list = new ArrayList<MtSms>();
        List<SmsTempBean> listSms = null;
        if (isEncry) {
            this.sendSmsDao.updateSmsDXFSStatus("-1", 100);
            listSms = this.sendSmsDao.queryDXFSForList();
            this.sendSmsDao.updateSmsDXFSStatus("-2", 100);
        } else {
            Log.debug((Object)"\u8bfb\u53d6\u660e\u6587\u77ed\u4fe1");
            this.sendSmsDao.updateSmsKHDXStatus("-1", 100);
            listSms = this.sendSmsDao.queryKHDXForSend(100);
            this.sendSmsDao.updateSmsKHDXStatus("-2", 100);
        }
        if (null != listSms && listSms.size() > 0) {
            for (SmsTempBean stb : listSms) {
                MtSms mtsms = new MtSms();
                mtsms.setId(stb.getN_XLH().longValue());
                mtsms.setMessage(stb.getC_DXNR());
                mtsms.setDestAddress(stb.getC_SJH());
                mtsms.setGatewayNumber(stb.getC_YYSBH());
                mtsms.setStatus(stb.getC_FSBZ());
                mtsms.setSendTime(stb.getD_SCSJ().longValue());
                if (Integer.parseInt(this.scps.getValueByCode("mobileFlag")) == mtsms.getGatewayNumber()) {
                    mtsms.setGatewayType(Integer.parseInt(this.scps.getValueByCode("mobileGateway")));
                } else if (Integer.parseInt(this.scps.getValueByCode("unicomFlag")) == mtsms.getGatewayNumber()) {
                    mtsms.setGatewayType(Integer.parseInt(this.scps.getValueByCode("unicomGateway")));
                } else if (Integer.parseInt(this.scps.getValueByCode("telecomFlag")) == mtsms.getGatewayNumber()) {
                    mtsms.setGatewayType(Integer.parseInt(this.scps.getValueByCode("telecomGateway")));
                }
                list.add(mtsms);
            }
        } else {
            list = null;
        }
        return list;
    }
}

