/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.controller;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.strategy.bean.StrategyMainBean;
import com.xdja.pams.strategy.entity.StrategyInfo;
import com.xdja.pams.strategy.entity.StrategyMain;
import com.xdja.pams.strategy.service.StrategyInfoService;
import com.xdja.pams.strategy.service.StrategyMainService;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
@RequestMapping(value={"/strategy/StrategyController"})
public class StrategyController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(StrategyController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private StrategyMainService strategyMainService;
    @Autowired
    private StrategyInfoService strategyInfoService;

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/queryList.do"})
    public void queryList(HttpServletRequest request, HttpServletResponse response, ModelMap map, StrategyMainBean queryBean) {
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryBean.getPage()), Integer.parseInt(queryBean.getRows()));
            List<StrategyMain> list = this.strategyMainService.queryList(queryBean, page);
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }

    @RequestMapping(value={"/toAddMain.do"})
    public String toAddMain(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "strategy/writeList/default/addMain";
    }

    @RequestMapping(value={"/addMain.do"})
    public void addMain(HttpServletRequest request, HttpServletResponse response, ModelMap map, StrategyMainBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            queryBean.setType("1");
            queryBean.setStatus("1");
            this.strategyMainService.add(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u6dfb\u52a0\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/toEditMain.do"})
    public String toEditMain(HttpServletRequest request, HttpServletResponse response, String id, ModelMap map) {
        try {
            StrategyMain main = this.strategyMainService.queryById(id);
            map.put((Object)"main", (Object)main);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u4fee\u6539\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "strategy/writeList/default/editMain";
    }

    @RequestMapping(value={"/toEditStrategy.do"})
    public String toEditStrategy(HttpServletRequest request, HttpServletResponse response, String id, ModelMap map) {
        try {
            StrategyMain main = this.strategyMainService.queryById(id);
            map.put((Object)"main", (Object)main);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u4fee\u6539\u9875\u9762\u5931\u8d25" + e.getMessage());
        }
        return "strategy/writeList/default/editStrategy";
    }

    @RequestMapping(value={"/editMain.do"})
    public void editMain(HttpServletRequest request, HttpServletResponse response, ModelMap map, StrategyMainBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyMainService.update(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u4fee\u6539\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/delete.do"})
    public void delete(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyMainService.remove(id);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u5220\u9664\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/changeStatus.do"})
    public void changeStatus(HttpServletRequest request, HttpServletResponse response, ModelMap map, StrategyMainBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyMainService.changeStatus(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u4fee\u6539\u7b56\u7565\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/addStrategyInfo.do"})
    public void addStrategyInfo(HttpServletRequest request, HttpServletResponse response, ModelMap map, StrategyMainBean queryBean) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.strategyInfoService.add(queryBean);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage(this.message, "common.message.operate.fail") + ":" + e.getMessage());
            log.error("\u6dfb\u52a0\u7b56\u7565\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8JSON(response, Util.toJsonStr(rtnResult));
    }

    @RequestMapping(value={"/queryStrategyList.do"})
    public void queryStrategyList(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            List<StrategyInfo> list = this.strategyInfoService.queryList(id);
            result.put("total", list.size());
            result.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7b56\u7565\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text(response, Util.toJsonStr(result));
    }
}

