/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.strategy.service.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.strategy.bean.StrategyInfoBean;
import com.xdja.pams.strategy.bean.StrategyMainBean;
import com.xdja.pams.strategy.dao.StrategyInfoDao;
import com.xdja.pams.strategy.entity.StrategyInfo;
import com.xdja.pams.strategy.entity.StrategyMain;
import com.xdja.pams.strategy.service.StrategyInfoService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class StrategyInfoServiceImpl
implements StrategyInfoService {
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private StrategyInfoDao strategyInfoDao;

    @Override
    @Transactional
    public void add(StrategyMainBean queryBean) {
        if (queryBean == null || CollectionUtils.isEmpty(queryBean.getInfoList())) {
            throw new RuntimeException("\u65e0\u53ef\u7528\u6570\u636e");
        }
        StrategyMain strategyMain = (StrategyMain)this.baseDao.getObjectById(StrategyMain.class, (Serializable)((Object)queryBean.getId()));
        if (strategyMain == null) {
            throw new RuntimeException("\u975e\u6cd5\u7684ID");
        }
        this.strategyInfoDao.deleteBatch(queryBean.getId());
        List<StrategyInfo> list = queryBean.getInfoList();
        StringBuffer stragegy = new StringBuffer();
        String stragegyStr = "";
        if (!CollectionUtils.isEmpty(list)) {
            this.baseDao.createBatch(list);
            for (StrategyInfo strategyInfo : list) {
                stragegy.append(strategyInfo.getType()).append(strategyInfo.getOperator()).append(strategyInfo.getStrategy()).append(" and ");
            }
            if (stragegy.length() >= 4) {
                stragegyStr = stragegy.substring(0, stragegy.length() - 4);
            }
        }
        strategyMain.setStrategy(stragegyStr);
        strategyMain.setLastUpdateTime(System.currentTimeMillis());
        this.baseDao.update(strategyMain);
    }

    @Override
    public List<StrategyInfo> queryList(String mainId) {
        StrategyInfoBean queryBean = new StrategyInfoBean();
        queryBean.setStrategyMainId(mainId);
        List<StrategyInfo> list = this.strategyInfoDao.queryList(queryBean, null);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<StrategyInfo>();
        }
        return list;
    }
}

