/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pams.syms.control;

import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@Scope(value="session")
public class SysConfigDController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(SysConfigDController.class);
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;

    @RequestMapping(value={"syms/sysconfigcontroller/index-D.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            SystemConfig sysCfgTheme = this.systemConfigService.getByCode("systemTheme");
            if (sysCfgTheme != null) {
                map.put((Object)"sysCfgTheme", (Object)sysCfgTheme);
            }
            String theme = this.operator.getPerson().getTheme();
            map.put((Object)"theme", (Object)theme);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage(this.message, "common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"syms/sysconfigcontroller/queryD.do"})
    public void query(HttpServletResponse response, String name) {
        SystemConfig dInfo = this.systemConfigService.getByCode("-Dinfo");
        SystemConfig dInfoDX = this.systemConfigService.getByCode("-Dinfo_DX");
        SystemConfig dInfoLT = this.systemConfigService.getByCode("-Dinfo_LT");
        ArrayList<SystemConfig> list = new ArrayList<SystemConfig>();
        list.add(dInfo);
        list.add(dInfoDX);
        list.add(dInfoLT);
        try {
            for (SystemConfig pSC : list) {
                List<SystemConfig> list2 = pSC.getcSystemConfig();
                for (int i = 0; i < list2.size(); ++i) {
                    for (int j = i + 1; j < list2.size(); ++j) {
                        if (list2.get(i).getCode().compareTo(list2.get(j).getCode()) <= 0) continue;
                        SystemConfig temp = list2.get(i);
                        list2.set(i, list2.get(j));
                        list2.set(j, temp);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ArrayList listmap = new ArrayList();
        for (SystemConfig pSC : list) {
            String id = "";
            List<SystemConfig> listMatch = null;
            if (!Util.varCheckEmp(name)) {
                if (pSC.getName().contains(name)) {
                    id = pSC.getId();
                } else {
                    for (SystemConfig cSC : pSC.getcSystemConfig()) {
                        if (!cSC.getName().contains(name)) continue;
                        id = pSC.getId();
                        break;
                    }
                }
                if (!Util.varCheckEmp(id)) {
                    listMatch = this.systemConfigService.getById(id).getcSystemConfig();
                }
            } else {
                listMatch = pSC.getcSystemConfig();
            }
            if (null == listMatch) continue;
            for (SystemConfig cSC : listMatch) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", cSC.getId());
                map.put("name", cSC.getName());
                map.put("code", cSC.getCode());
                map.put("value", cSC.getValue());
                map.put("note", cSC.getNote());
                map.put("group", pSC.getName());
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("type", "validatebox");
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("validType", "length[0,128]");
                editor.put("options", options);
                map.put("editor", editor);
                map.put("type", pSC.getId());
                listmap.add(map);
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(listmap.size()));
        map.put("rows", listmap);
        String sr = Util.toJsonStr(map);
        Util.writeUtf8JSON(response, Util.toJsonStr(map));
    }
}

